<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ContractDetail;
use App\TraderContract;
use Log;

class ContractDetailController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
           
            
        $arr = explode("/", $request->produce_item_id, 2);
      
        $contract_detail = ContractDetail::updateOrCreate(
            ['id' => $request->id],
            ['contract_id' => $request->contract_id, 'produce_item_id' => $arr[0], 'tonnage' => $request->tonnage]
        );
        //update the Fo attached
        TraderContract::where('id',$request->contract_id)->update(['fo_id'=>$arr[1]]);

        return response()->json($contract_detail->load('contract', 'produce_item', 'produce_item.trader', 'produce_item.produce', 'produce_item.produce_unit'));
    }

    /**
     * Show the form for editing the specified contract_detail.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $contract_detail = ContractDetail::findOrFail($id);

        return response()->json($contract_detail);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $contract_detail = ContractDetail::where('id', $id)->delete();
        return response()->json($contract_detail);
    }
}
