<?php

namespace App\Http\Controllers;

use App\ChatCategory;
use App\Trader;
use Illuminate\Http\Request;

class ChatCategoryController extends Controller {

   /*  public function __construct()
	{
	    $this->middleware('auth');
	} */
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        //$this->authorize('viewAny', ProductCategory::class);

        $chat_categories = ChatCategory::paginate(env('LIST_SIZE', 10));
        // $productCategories = ProductCategory::whereNull('parent_id')
        //     ->with('childrenCategories')
        //     ->get();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('chat-categories.index', compact('chat_categories','dashboard'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       // $this->authorize('create', ProductCategory::class);
        //fetch existing product categories for purposes of filling parent_id
        $chatCategories = ChatCategory::all();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('chat-categories.create', compact('chatCategories','dashboard'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
       // $this->authorize('create', ProductCategory::class);
        $request->validate([
            'name' => 'required|unique:chat,name',
            'description' => 'nullable',
            //'parent_id' => 'nullable|exists:product_categories,id'
        ]);
        $record = new ChatCategory();
        $record->fill($request->all());
        if ($record->save()) {
            return redirect()->route('chat-categories.index')->with('success', 'Chat category created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ChatCategory  $productCategory
     * @return \Illuminate\Http\Response
     */
    public function show(ChatCategory $chatCategory) {
       // $this->authorize('view', $productCategory);
       
       $dashboard['verified_traders'] = Trader::where('status','=',0)->count(); 
       return view('chat-categories.show', compact('chatCategory','dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ChatCategory  $productCategory
     * @return \Illuminate\Http\Response
     */
    public function edit(ChatCategory $chatCategory) {
       // $this->authorize('update', $productCategory);
        //fetch existing product categories for purposes of filling parent_id
        $chatCategories = ChatCategory::paginate(env('LIST_SIZE', 10));
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('chat-categories.edit', compact('chatCategory', 'chatCategories','dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ChatCategory  $productCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ChatCategory $chatCategory) {
        //$this->authorize('update', $productCategory);
        $request->validate([
            'name' => 'required|unique:chat,name,' . $chatCategory->id,
            'description' => 'nullable',
            //'parent_id' => 'nullable|exists:product_categories,id'
        ]);
        if ($chatCategory->update($request->all())) {
            return redirect()->route('chat-categories.index')->with('success', 'Chat category updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ChatCategory  $productCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy(ChatCategory $chatCategory) {
        //$this->authorize('delete', $productCategory);
        //check associations
        if ($chatCategory->chats()->count() > 0) {
            return redirect()->route('chat-categories.index')->with('failure', 'Cannot delete category because it has related chat.');
        }
        //attempt to delete
        if ($chatCategory->delete()) {
            return redirect()->route('chat-categories.index')->with('success', 'Chat category deleted.');
        } else {
            return redirect()->route('chat-categories.index')->with('failure', 'Delete failed.');
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $chat_category = ChatCategory::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'description' => $request->description, 'parent_id' => $request->parent_id]
        );

        return response()->json($chat_category->load('parent'));
    }

    /**
     * Show the form for editing the specified input_category.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $chat_category = ChatCategory::findOrFail($id);

        return response()->json($chat_category);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $chat_category = ChatCategory::where('id', $id)->delete();
        return response()->json($chat_category);
    }

}
