<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\CropSetting;
use App\FarmerBusinessPlan;
use App\ProduceItem;
use EloquentBuilder;

class BusinessPlanController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    //test businessplans api
    public function allBPlans(){
         $trader = Auth::user()->traderMember->trader_id;
        $produceitems = ProduceItem::where('trader_id', $trader)->with('produce')->get();
        return response()->json($produceitems);
    }
    public function index()
    {
        $trader = Auth::user()->traderMember->trader_id;
        $produceitems = ProduceItem::where('trader_id', $trader)->with('produce')->get();
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('business-plans.index',compact('produceitems','dashboard'));
    }
    //return settings data
    public function getPlans()
    {
        $query = CropSetting::where('id','!=',NULL);
        $settings = EloquentBuilder::to($query,request()->all())->get();
        return $settings;
    }
    
}
