<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\inputOrders;
use App\inputOrderItems;
use App\Trader;
use App\User;
use App\TraderMember;
use App\Input;
use App\Invoice;
use App\UserWallet;
use App\InputOrderItemsRelease;
use App\CreditTransaction;
use App\Credits;
use App\ForwardedInputOrderItem;

class BulkSellerController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $user_id = Auth::user()->id;
        
        $trader = Auth::user()->getRelatedTrader()->id;
        $items = inputOrderItems::all()->where('directed_to',$trader)->pluck('order_id');
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        $inputs = inputOrders::all()->whereIn('id',$items)->where('approved', ">", 0)->sortByDesc('id');
        return view('bulk-seller.index', compact('inputs','dashboard'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $trader = Auth::user()->getRelatedTrader()->id;
        if(isset($_POST['approveitem']))
        {
         $id = $request->get('id');
        $item = inputOrderItems::find($id);
        
        ///get the orderid
        $orderid=$item->order_id;
        //then get the traderid in the input orders
        $inputorder = inputOrders::where('id',$orderid)->first();
        $trader_from_order=$inputorder->trader_id;
        $item->approved = $request->get('approved');



        //invoice
        $invoice = new Invoice();
        $invoice->input_item_id = $id;
        $invoice->posted_by = $trader;
        $invoice->number = $request->get('order_id');
        //$invoice->date = date('Y-m-d H:i:s');
        $invoice->direction = "in";
        $invoice->fo_id= $trader_from_order;
        $invoice->type = "input";
        $invoice->total = $request->get('amount');
        $invoice->balance = $request->get('amount');
        $invoice->status = "0";

        //end invoice

        //userWallet reduce
        $financing = $request->get('financing');
        if($financing == "wallet")
        {
        $uid = $request->get('uid');
        $userWallet = UserWallet::find($uid);
        $userWallet->balance -= $request->get('amount');
        $userWallet->save();
        }
        else if($financing == "credit")
        {
            $id = $request->get('id');
            $credited = Credits::where('input_order_item_id',$id)->pluck('id');
            $credit = Credits::find($credited[0]);
            $credit->credited_amount -= $request->get('amount');

            $credit->save();
            //credit transactions
            $transacts = new CreditTransaction();
            $transacts->credit_id = $credit->id;
            $transacts->amount = $request->get('amount');
            $transacts->save();
        }

        $invoice->save();
        $item->save();
        return redirect()->back()
        ->with("success","Input Order Item Has Been Completed.");
        }
        else
        {
        request()->validate([
            'recipient' => 'required',
            'means' => 'required',
            'date' => 'required'
        ]);
        $delivery = new InputOrderItemsRelease();
        $delivery->recipient = $request->get('recipient');
        $delivery->means = $request->get('means');
        $delivery->date = $request->get('date');
        $delivery->order_id = $request->get('order_id');
        $delivery->trader_id = $request->get('trader_id');

        $delivery->save();
        $id = $request->get('id');
        $order_items = inputOrderItems::where('order_id',$id)->where('approved',2)->get();
        foreach($order_items as $order_item)
        {
            $order_item->approved = "3";
            $order_item->save();
        }
        $inputorder = inputOrders::find($id);
        $inputorder->approved = "3";
        $inputorder->save();
        return redirect()->route('bulk-seller.index')
        ->with('success','Delivery details added succesfully.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user_id = Auth::User()->id;
        $trader = Trader::where('user_id', $user_id)->first();

        //fetch FO members
        $trading = inputOrders::where('id', $id)->pluck('trader_id');

        $farmer = TraderMember::all();
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        $input = Input::all();
        $items = inputOrderItems::all()->where('order_id', $id)->where('approved', ">",0)->where('directed_to', $trader->id)->sortByDesc('id');
        $order = inputOrders::find($id);
        return view('bulk-seller.details', compact('trader','order','items','farmer','input','dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $order = inputOrders::find($id);
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('bulk-seller.edit', compact('dashboard','order'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        if(isset($_POST['approveorder']))
        {
            $id = $request->get('id');
        $order = inputOrders::find($id);
        $order->approved = $request->get('approved');
        $order->save();

        return redirect()->route('bulk-seller.index')
        ->with("success","Input Order Has Been Completed.");
        }


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        if(isset($_POST['deleteitem'])) {
            $item = inputOrderItems::find($id);
            $item->delete();
            return redirect()->back()
                ->with("success","Input Order Item Deleted Successfully!");
        } else {
            $order = inputOrders::find($id);
            $order->delete();
            return redirect()->route('bulk-seller.index')
                ->with("success","Input Order Cancelled Successfully!");
        }
    }
}
