<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\TraderMember;
use App\Trader;
use App\County;
use App\User;   
use App\Expert_Audios;
use App\Exports\MapExport;
use Auth;
use EloquentBuilder;
use App\Charts\RegionChart;
use DB;
use App\Http\Resources\County as CountyResource;
use PDF;

class BTcottonLocationController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth',['except' => ['btfarmermap','getCounties']]);
	}
    public function index()
    {

       $regions =County::with('traders')->get();
        // $regions =Trader::with('county')->get();

        $labels_arr = [];
        $data_arr = [];
          $code= County::with('traders')->pluck('id');
        foreach($regions as $region)
       
        {
           $county='';
           $traders=0;
           if($region->traders) {
           $traders=$region->traders->count();
           $y=rand(30,50);
           $x=rand(10,150);
           array_push($data_arr,['x'=>$x,'y'=>$y,'r'=>($traders/$regions->count('traders'))*5]);
           }
     
           $county= $region->name;
            array_push($labels_arr,$county);
            
        }
    
         $labels_arr;
        // $labels_arr = EloquentBuilder::to(BookMarkers::with('bookmarkerscompany'),request()->all())->pluck('licensee_name');
        // $data_arr = EloquentBuilder::to(BookMarkers::with('bookmarkerscompany'),request()->all())->pluck('ggr');
        // chart
        $borderColors = [ "#30ba35", "#f25961" ];
        $fillColors = ["#fdaf4b","#59d05d","#fdaf4b","#59d05d","#fdaf4b","#59d05d","#fdaf4b","#59d05d" ];
        $companyggrchart = new RegionChart;
        $companyggrchart->minimalist(false);
        $companyggrchart->labels($labels_arr);
        $companyggrchart->dataset('BT Cotton Seed Producers Population', 'bubble', $data_arr)
        // ->color($borderColors)
        ->backgroundcolor($fillColors);

        $dashboard='1';
        // $regions =Trader::all()->pluck('ward');
        return view('btcottonLocation.index', compact('dashboard','regions','data_arr','labels_arr'));
    }

    public function btfarmermap()
    {
        

        return view('btcottonLocation.map');

    }

    public function getCounties(){
        //get all the trader counties
        $traders = Trader::distinct('county_id')->pluck('county_id');
        return "hallo there";
        $counties = County::whereIn('id',$traders)->orderBy('id', 'DESC')->get();

        $geoJSONdata = $counties->map(function ($county) {
            return [
                'type'       => 'Feature',
                'properties' => new CountyResource($county),
                'geometry'   => [
                    'type'        => 'Point',
                    'coordinates' => [
                        $county->longitude,
                        $county->latitude,
                    ],
                ],
            ];
        });

        return response()->json([
            'type'     => 'FeatureCollection',
            'features' => $geoJSONdata,
        ]);

    }
    
    
    
public function btcottonpdf()
    {
          $traders = [];  //get all the trader counties
          $traders = Trader::distinct('county_id')->get();
        // $traders = DB::table('trading_traders')->pluck('county_id');
          $traderscounts = Trader::distinct('county_id')->get();
          $counties = County::whereIn('id',$traders)->orderBy('id', 'DESC')->get();


        $geoJSONdata = $counties->map(function ($county) {
            return [
                'type'       => 'Feature',
                'properties' => new CountyResource($county),
                'geometry'   => [
                    'type'        => 'Point',
                    'coordinates' => [
                        $county->longitude,
                        $county->latitude,
                    ],
                ],
            ];
        });

    
        $pdf = PDF::loadView('btcottonLocation.exportmap',compact('traders','counties','traderscounts'));
        return $pdf->download('BtcottonLocation.pdf');
    } 

    
    
    
    
    public function export(Request $request) {
        return new MapExport($request);
    }
}
