<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\TraderMember;
use App\Trader;
use App\User;   
use App\Expert_Audios;
use Auth;
use EloquentBuilder;

class AudioQuestionController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    public function index()
    {
    $trader = Auth::user()->userAgent;
    $trader_arr = [];
    foreach($trader as $traderobj)
    {
        $traderid = $traderobj->trader_id;
        array_push($trader_arr,$traderid);
    }

    $fos=Trader::whereIn('id',$trader_arr)->get(); 

    $expert_messages=Expert_Audios::with('audoTrader')->with('AudioCoach')->get();
    //$expert_messages = EloquentBuilder::to($query,request()->all())->get();

    $query=TraderMember::whereIn('trader_id',$trader_arr);
    $allfarmers = EloquentBuilder::to($query,request()->all())->get();
    $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
    $selectedtrader = Trader::where('id',json_decode(request()->trader))->pluck('organisation_name');
    return view('audioquestions.index', compact('dashboard','expert_messages','allfarmers','fos','selectedtrader'));
    }



    public function destroy($id)
    {
        //
    
        $audio = Expert_Audios::find($id);
        $audio->delete();
            return redirect()->back()
        ->with("success","Audio Deleted Successfully!");
    }
    public function confirm($id, Request $request)
    {
        //
    
        $audio = Expert_Audios::findOrFail($id);
        $audio->status = '1';
        $audio->save();
            return redirect()->back()
        ->with("success","Audio Confirmed Successfully!");
    }


}
