<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use DateTime;
use App\User;
use App\TraderMember;
use App\Trader;
use App\News;
use App\TraderType;
use App\ChatCategory;
use App\Trainingstopics;
use App\Chat;
use App\Expert_Audios;
use App\UserWallet;
use App\About;

use Log;
use Config;
use DB;

class ApiAccessController extends Controller
{

    //login via the application
    public function Login(Request $request){
        
           //find the user by the provided username
           $user = User::whereUsername($request->username)->first(); 
         
           if($user){
                        //get the id of the user
                $userid=$user->id;  //store this 1
                     
                $trader_member=TraderMember::where('user_id',$userid)->first();
              
                
                if($trader_member){
                    //get the trader to check if its a FO
                    $trader_id=$trader_member->trader_id;  //store this 2
                    $type = $trader_member->type;

                  
                   
                   if($type=="agent"){
                       
                         $user_object = (Object)[
                        'farmer_id'=>$userid,
                        'farmer_fname'=>$user->firstname,
                        'farmer_lname'=>$user->lastname,
                        'farmer_phone'=>$user->phone,
                        'farmer_email'=>$user->email,
                        'farmer_org_id'=>$trader_id,
                        'type'=>"agent"
                    ];
                       //check if its an FO
                    $trader=Trader::where('id',$trader_id)->where('type_id',1)->first();
                    if ($trader) {
                        $k=password_verify($request->password, $user->password);
                    
                        if ($k) {
                            
                                return response()->json(["success"=>true,"message"=>$user_object]);
                          
                        }
                        else{
                            return response()->json(["success"=>false,"message"=>"invalid password"]);
                        }
                    }
                    else{
                        return response()->json(["success"=>false,"message"=>"Invalid Account type"]);
                    }
                       
                   }
                   elseif($type=="farmer"){
                        $user_object = (Object)[
                        'farmer_id'=>$userid,
                        'farmer_fname'=>$user->firstname,
                        'farmer_lname'=>$user->lastname,
                        'farmer_phone'=>$user->phone,
                        'farmer_email'=>$user->email,
                        'farmer_org_id'=>$trader_id,
                        'type'=>"farmer"
                    ];
                       //check if its an FO
                    $trader=Trader::where('id',$trader_id)->where('type_id',1)->first();
                    if ($trader) {
                        $k=password_verify($request->password, $user->password);
                    
                        if ($k) {
                            if ($user->active==0) {
                                return response()->json(["success"=>false,"message"=>"pending approval"]);
                            } else {
                                return response()->json(["success"=>true,"message"=>$user_object]);
                            }
                        }
                        else{
                            return response()->json(["success"=>false,"message"=>"invalid password"]);
                        }
                    }
                    else{
                        return response()->json(["success"=>false,"message"=>"Invalid Account type"]);
                    }
                   }
                    
                }
                else{
                    return response()->json(["success"=>false,"message"=>"account not FO member"]);
                }
                
           }
           else{
            return response()->json(["success"=>false,"message"=>"Invalid Username"]);
           }
                   
   
           
   
    }
    //list all experts for a particular fo
    public function getExperts($fo_id){
        $experts = DB::table('trading_trader_members')->where('trader_id',$fo_id)->where('type','=','agent')->get();
       
        if(!empty($experts)){
            $expert_users=User::whereIn('id',$experts->pluck('user_id'))->get();
            $expert_list=[];
            foreach($expert_users as $expert){
                $expert_object = (Object)[
                    'expert_id'=>$expert->id,
                    'expert_fname'=>$expert->firstname,
                    'expert_lname'=>$expert->lastname,
                    'expert_phone'=>$expert->phone,
                    'expert_email'=>$expert->email,
                    'expert_avatar'=>$expert->picture_uri
                ];
                array_push($expert_list,$expert_object);
            }
            return response()->json(["success"=>true,"message"=>$expert_list]);
        }
        else{
            return response()->json(["success"=>false,"message"=>"FO does not have experts"]);
        }
  

    }
    //get market players list
    public function getRoleNumbers(){
        $experts_no = count(DB::table('trading_trader_members')->where('type','=','agent')->get());
        //farmer organisations
        $fos = count(DB::table('trading_traders')->where('type_id','=',1)->get());
        //farmers       
        $farmers = count(DB::table('trading_trader_members')->whereIn('trader_id',DB::table('trading_traders')->where('type_id','=',1)->get()->pluck('id'))->get());
        
        //buyers - ginners
        $buyer_ginner = count(DB::table('trading_traders')->where('type_id','=',2)->where('buyer_type','=',1)->get());
        //buyers - spinners
        $buyer_spinner = count(DB::table('trading_traders')->where('type_id','=',2)->where('buyer_type','=',2)->get());
        //drivers
        $drivers = count(DB::table('trading_drivers')->get());
        //input sellers
        $sellers = count(DB::table('trading_traders')->where('type_id','=',3)->get());
        //agrodealers
        $agrodealers = count(DB::table('trading_traders')->where('type_id','=',4)->get());

        $roles_object = (Object)[
            'experts'=>$experts_no,
            'farmer_organisations'=>$fos,
            'farmers'=>$farmers,
            'ginners'=>$buyer_ginner,
            'spinners'=>$buyer_spinner,
            'drivers'=>$drivers,
            'agrodealers'=>$agrodealers,            
            'input_sellers'=>$sellers,
            'input_sellers_id'=>3,
            'buyers_id'=>2,
            'agrodealers_id'=>4,
           // 'input_sellers'=$seller,
            //'agrodealers'=>$agrodealer,
        ];

        if(\is_null($roles_object)){
            return response()->json(["success"=>false,"message"=>"No roles"]);
        }
        else{
            return response()->json(["success"=>true,"message"=>$roles_object]);
        }
     


    }

    public function getRoleMembers($id){       
         //buyers - spinners
         if($id==2){
            $buyers = DB::table('trading_traders')->where('type_id','=',$id)->get(); 
            $members_object = (Object)[           
                
                //'buyers'=>$buyers,
                $buyers,
            ];
         }
         elseif($id==3){
            //input sellers
            $sellers =DB::table('trading_traders')->where('type_id','=',$id)->get();
            $members_object = (Object)[
                        
                //'input_sellers'=>$sellers,
                $sellers,
            ];
         }
         elseif($id==4){
            //agrodealers
            $agrodealers = DB::table('trading_traders')->where('type_id','=',$id)->get();
            $members_object = (Object)[
            
                //'agrodealers'=>$agrodealers, 
                $agrodealers,
                
            ];
         }
               
        
        

        

        if(\is_null($members_object)){
            return response()->json(["success"=>false,"message"=>"No members"]);
        }
        else{
            return response()->json(["success"=>true,"message"=>$members_object]);
        }
    }

    //get some recent chats
    public function getRecentChat($user_id,$category_id){
    

        /*$chats = DB::table('chat')->where('farmer_id','=',$user_id)->where('chat_category','=',$category_id)->get();

        $chats = DB::table('trading_chat')->where('farmer_id','=',$user_id)->where('expert_id','=',$expert_id)->get();


        $chat_array=[];
        if(!empty($chats)){
            foreach($chats as $chat){
                $chat_object = (Object)[
                    'chat_id'=>$chat->id,
                    'message'=>$chat->message,
                    'file_url'=>$chat->file_url,
                    'message_type'=>$chat->message_type,
                    'chat_date'=>$chat->created_at,
                ];
                array_push($chat_array,$chat_object);
            }
            return response()->json(["success"=>true,"message"=>$chat_array]);
        }
        else{
            return response()->json(["success"=>false,"message"=>"No chat history"]); 
        }*/
        
          //get the details of the chats
               $chats = DB::table('trading_chat')->where('chat_category','=',$category_id)->get();
            
               $chat_simple =[];

              if(!empty($chats)){
                   foreach($chats as $chat_detail){
                   $chat_id=$chat_detail->id;
                   $message=$chat_detail->message;
                   $role=$chat_detail->role;
                  
                      $attachments = (Object)[
                    'file_url'=>$chat_detail->file_url,
                    'mime'=>$chat_detail->mime_type,
                    'filename'=>$chat_detail->file_name,
                   ]; 
                  

                   

                   $senderid= $chat_detail->farmer_id;
                   $sender_details = User::where('id',$senderid)->first();

                   $sender = (Object)[
                    'id'=>$senderid,
                    'name'=>$sender_details->firstname.' '.$sender_details->lastname,
                    'avatar'=>$sender_details->picture_uri,
                   ];

                   $receiverid= $chat_detail->expert_id;
                   $receiver_details = User::where('id',$receiverid)->first();

                   $receiver = (Object)[
                    'id'=>$receiverid,
                    'name'=>$receiver_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$receiver_details['picture_uri'],
                   ];
                   $created_at = $chat_detail->created_at;
                    if($chat_detail->file_name ==""){
                        $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array(),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'created_at'=>$created_at,
                    'role'=>$role
                   ];
                    }
                    elseif($chat_detail->file_name !=""){
                         $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array($attachments),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'created_at'=>$created_at,
                    'role'=>$chat_detail->role
                   ];
                    }
                  

                   array_push($chat_simple,$complete_chat_object);
               }
               //return with the details
               return response()->json(["success"=>true,"message"=>$chat_simple]);
              }
              else{
                  return response()->json(["success"=>false,"message"=>"No chat history"]); 
              }
              
                
               
        
       
    }


    //store the chat messages(audio,video,text)
    public function storeChat(Request $request){
        
        

        try{
            
            $appurl = "http://btcotton.spin.mobisky.biz";//Config::get('app.url');
            //return $appurl;
            if($request->message=='' && !empty($request->file('attachments'))){

                $chat_id_array=[];
                $mime_type="";  
                $filename="";            
                if ($request->hasfile('attachments')) {

                    foreach($request->file('attachments') as $file){
                        
                        $destinationPath = 'publi/chatfiles/'; // upload path
                        $file_name = date('YmdHis') . "." . $file->getClientOriginalExtension();
                        $filename=$file_name;
                        $mime_type=$file->getClientMimeType();                        

                        $file->move($destinationPath, $file_name);
                        $file_path =  $appurl.'/'.'public/'.$destinationPath.$file_name;

                        $chat = new Chat();
                        $chat->farmer_id = $request->farmer_id;
                        $chat->farmer_org_id = $request->farmer_org_id;
                        $chat->message = '';
                        $chat->chat_category= $request ->category_id;
                        $chat->expert_id =$request->farmer_org_id;
                        $chat->file_url =$file_path;
                        $chat->mime_type=$mime_type;
                        $chat->message_type='file';
                        $chat->file_name=$filename;
                        $chat->role=$request->role;
                        
                        $chat->status =1; 
                        $chat->save();

                        //get the id
                        $chat_id = $chat->id;
                        array_push($chat_id_array,$chat_id);
                        
                  
                    }
                
                }
                //get the details of the chats
               $chat_details = Chat::whereIn('id',$chat_id_array)->get();
            
               $chat_simple =[];

               foreach($chat_details as $chat_detail){
                   $chat_id=$chat_detail->id;
                   $message=$chat_detail->message;
                   $role =$chat_detail->role;

                   $attachments = (Object)[
                    'file_url'=>$chat->file_url,
                    'mime'=>$mime_type,
                    'filename'=>$filename

                   ];

                   $senderid= $chat_detail->farmer_id;
                   $sender_details = User::where('id',$senderid)->first();
                  
                   $sender = (Object)[
                    'id'=>$senderid,
                    'name'=>$sender_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$sender_details['picture_uri'],
                   ];

                   $receiverid= $chat_detail->expert_id;
                   $receiver_details = User::where('id',$receiverid)->first();

                   $receiver = (Object)[
                    'id'=>$receiverid,
                     'name'=>$receiver_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$receiver_details['picture_uri'],
                   ];
                   $created_at = $chat_detail->created_at;
                   
                   $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array($attachments),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'role'=>$role,
                    'created_at'=>$created_at
                   ];
                    
                   array_push($chat_simple,$complete_chat_object);
               }
                
               //return with the details
               return response()->json(["success"=>true,"message"=>$chat_simple]);


            }
            
            elseif($request->message!='' && empty($request->file('attachments'))){
                $chat_id_array=[];

                $chat = new Chat();
                $chat->farmer_id = $request->farmer_id;
                $chat->farmer_org_id = $request->farmer_org_id;
                $chat->message = $request->message;
                $chat->chat_category= $request ->category_id;
                $chat->expert_id =$request->farmer_org_id;
                $chat->file_url ='';
                $chat->mime_type='';
                $chat->file_name='';
                $chat->message_type='text';
                $chat->role =$request->role;
                $chat->status =1;
                $chat->save();

                //get the id
                $chat_id = $chat->id;
                array_push($chat_id_array,$chat_id);

                  //get the details of the chats
               $chat_details = Chat::whereIn('id',$chat_id_array)->get();
            
               $chat_simple =[];

               foreach($chat_details as $chat_detail){
                   $chat_id=$chat_detail->id;
                   $message=$chat_detail->message;
                   $role =$chat_detail->role;

                   $attachments = (Object)[
                    'file_url'=>$chat->file_url,
                    'mime'=>'',
                    'filename'=>'',

                   ];

                   $senderid= $chat_detail->farmer_id;
                   $sender_details = User::where('id',$senderid)->first();

                   $sender = (Object)[
                    'id'=>$senderid,
                     'name'=>$sender_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$sender_details['picture_uri'],
                   ];

                   $receiverid= $chat_detail->expert_id;
                   $receiver_details = User::where('id',$receiverid)->first();

                   $receiver = (Object)[
                    'id'=>$receiverid,
                    'name'=>$receiver_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$receiver_details['picture_uri'],
                   ];
                   $created_at = $chat_detail->created_at;
                   
                    //was here
                   
                    if($chat_detail->file_name !=""){
                        $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array($attachments),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'created_at'=>$created_at,
                    'role'=>$role
                    ];
                    
                       array_push($chat_simple,$complete_chat_object);  
                       
                    }
                    else if($chat_detail->file_name==""){
                             $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array(),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'created_at'=>$created_at,
                    'role'=>$role
                    ];
                       array_push($chat_simple,$complete_chat_object);  
                    }
                  
               }
                
               //return with the details
               return response()->json(["success"=>true,"message"=>$chat_simple]);



             
                return response()->json(["success"=>true,"message"=>"chat saved"]);

            }
            elseif($request->message!='' && !empty($request->file('attachments'))){
                
                $chat_id_array=[];
                $mime_type="";  
                $filename="";      

                if ($request->hasfile('attachments')) {

                    foreach($request->file('attachments') as $file){
    
                        $destinationPath = 'publi/chatfiles/'; // upload path
                        $file_name = date('YmdHis') . "." . $file->getClientOriginalExtension();
                        $filename=$file_name;
                        $mime_type=$file->getClientMimeType(); 
                        $file->move($destinationPath, $file_name);
                        $file_path =  $appurl.'/'.$destinationPath.$file_name;

                       

                        $chat = new Chat();
                        
                        $chat->farmer_id = $request->farmer_id;
                        $chat->farmer_org_id = $request->farmer_org_id;
                        $chat->message = $request->message;
                        $chat->expert_id =$request->farmer_org_id;
                        $chat->chat_category= $request ->category_id;
                        $chat->file_url =$file_path;
                        $chat->mime_type=$mime_type;
                        $chat->message_type='text_with_file';
                        $chat->status =1;
                        
                        $chat->file_name=$filename;
                        $chat->role =$request->role;

                        $chat->save();

                         //get the id
                         $chat_id = $chat->id;
                         array_push($chat_id_array,$chat_id);
                    }
                
                }
                 //get the details of the chats
               $chat_details = Chat::whereIn('id',$chat_id_array)->get();
            
               $chat_simple =[];

               foreach($chat_details as $chat_detail){
                   $chat_id=$chat_detail->id;
                   $message=$chat_detail->message;
                   $role=$chat_detail->role;

                   $attachments = (Object)[
                    'file_url'=>$chat->file_url,
                    'mime'=>$mime_type,
                    'filename'=>$filename,
                   ];

                   $senderid= $chat_detail->farmer_id;
                   $sender_details = User::where('id',$senderid)->first();

                   $sender = (Object)[
                    'id'=>$senderid,
                    'name'=>$sender_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$sender_details['picture_uri'],
                   ];

                   $receiverid= $chat_detail->expert_id;
                   $receiver_details = User::where('id',$receiverid)->first();

                   $receiver = (Object)[
                    'id'=>$receiverid,
                    'name'=>$receiver_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$receiver_details['picture_uri'],
                   ];
                   $created_at = $chat_detail->created_at;
                   
                   $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array($attachments),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'created_at'=>$created_at,
                    'role'=>$role
                   ];

                   array_push($chat_simple,$complete_chat_object);
               }
                
               //return with the details
               return response()->json(["success"=>true,"message"=>$chat_simple]);
            }
        }
        catch(Exception $e)
        {
            return response()->json(["success"=>false,"message"=>"chat failed"]);
        }

    }


    public function storeAudio(Request $request)
    {
        request()->validate([
            // 'category' => 'required',
            'file' => 'required|mimes:mpeg,mp3,mp4'
        ],
        [
            'file.required' => 'Please upload an audio'
        ]);
        
        try{
            $audio = new Expert_Audios();
            $audio->farmer_id = $request->farmer_id;
            $audio->farmer_org_id = $request->farmer_org_id;
            $audio->expert_id = $request->expert_id;
            // return $news;
            //upload file if any
            $appurl = Config::get('app.url');
            $imagelink='';
            if($request->file('file'))
            {
                $files = $request->file('file');
                $destinationPath = 'public/audiouploads/'; // upload path
                $audioMessage = date('YmdHis') . "." . $files->getClientOriginalExtension();
                $files->move($destinationPath, $audioMessage);
                $audiolink =  $appurl.'/'.$destinationPath.$audioMessage;
            }
            

            $audio->audio_url = $audiolink;
            $audio->status = '0';
            
            $audio->save();
            return response()->json('Success');
        }
        catch(Exception $e)
        {
            return response()->json('Failed');
        }
    }
    public function storeVideo(Request $request)
    {
        request()->validate([
            // 'category' => 'required',
            
            'file' => 'required|mimes:3gp,mp4'
        ],
        [
            'file.required' => 'Please upload a video'
        ]);
        
        try{
            $video = new Expert_Videos();
            $video->farmer_id = $request->farmer_id;
            $video->farmer_org_id = $request->farmer_org_id;
            $video->expert_id = $request->expert_id;
            // return $news;
            //upload file if any
            $appurl = Config::get('app.url');
            $videolink='';
            if($request->file('file'))
            {
                $files = $request->file('file');
                $destinationPath = 'public/videouploads/'; // upload path
                $videoMessage = date('YmdHis') . "." . $files->getClientOriginalExtension();
                $files->move($destinationPath, $audioMessage);
                $videolink =  $appurl.'/'.$destinationPath.$videoMessage;
            }
            

            $video->video_url = $videolink;
            $video->status = '0';
            
            $video->save();
            return response()->json('Success');
        }
        catch(Exception $e)
        {
            return response()->json('Failed');
        }
    }


    //list all experts for a particular fo
    public function getFarmeBalance($id){
        $walletbalance = DB::table('trading_user_wallets')->where('user_id',$id)->get();
        if(!empty($walletbalance)){
            $expert_users=DB::table('user')->whereIn('id',$walletbalance->pluck('user_id'))->get();
            $walletbalance_list=[];
            foreach($expert_users as $expert){
                $walletbalance_object = (Object)[
                    'id'=>$expert->id,
                    'user_id'=>$expert->user_id,
                    'lastname'=>$expert->lastname,
                    'float_bal'=>$expert->firstname,
            
                ];
                //array_push($walletbalance_list,$walletbalance);
            }
            return response()->json(["success"=>true,"message"=>$walletbalance]);
        }
        else{
            return response()->json(["success"=>false,"message"=>"User does not have balance"]);
        }
  

    }

    public static function getChatCategories(){

        $chatcategories =DB::table('trading_chat_categories')->get();

        if(!empty($chatcategories)){
           $categories_list=[];
            foreach($chatcategories as $cat){
                $category_object = (Object)[
                    'id'=>$cat->id,
                    'name'=>$cat->name,
            
                ];
                array_push($categories_list,$category_object);
            }
            return response()->json(["success"=>true,"message"=>$categories_list]);
        }
        else{
            return response()->json(["success"=>false,"message"=>"No categories"]);
        }
  

    }
     public static function getChatCategories1(){

        $chatcategories =DB::table('trading_chat_categories')->get();
        return $chatcategories;
  

    }



    

  //list all experts for a particular fo
  public function getTrainingtopics($id){
     $trainingtopics = Trainingstopics::with('tainingsmodule')->where('module_id',$id)->get();
    if(!empty($trainingtopics)){
        $trainingtopic_list=[];
        foreach($trainingtopics as $trainingtopic){
            $trainingtopics_object = (Object)[
                'trainingtopic_id'=>$trainingtopic->trainingtopic_id,
                'trainingmodule_id'=>$trainingtopic->trainingmodule_id,
                'topic_heading'=>$trainingtopic->topic_heading,
                'text'=>$trainingtopic->text,
                'video_link'=>$trainingtopic->video_link,
                'status'=>$trainingtopic->status,
                'posted_by'=>$trainingtopic->posted_by,
        
            ];
            array_push($trainingtopic_list,$trainingtopics);
        }
        return response()->json(["success"=>true,"message"=>$trainingtopics]);
    }
    else{
        return response()->json(["success"=>false,"message"=>"No Data Available"]);
    }


}



public function getTrainingmodule(){

    $trainingmodules =DB::table('trading_trainingmodule')->get();

    if(!empty($trainingmodules)){
       $trainingmodules_list=[];
        foreach($trainingmodules as $module){
            $trainingmodules_object = (Object)[
                'trainingmodule_id'=>$module->trainingmodule_id,
                'module_name'=>$module->module_name,
                'status'=>$module->status,
        
            ];
            array_push($trainingmodules_list,$trainingmodules_object);
        }
        return response()->json(["success"=>true,"message"=>$trainingmodules_list]);
    }
    else{
        return response()->json(["success"=>false,"message"=>"No Training Modules"]);
    }


}


public function getNews_categories(){

    $newscategories =DB::table('trading_news_categories')->get();

    if(!empty($newscategories)){
       $newscategories_list=[];
        foreach($newscategories as $cat){
            $newscategories_object = (Object)[
                'id'=>$cat->id,
                'name'=>$cat->name,
        
            ];
            array_push($newscategories_list,$newscategories_object);
        }
        return response()->json(["success"=>true,"message"=>$newscategories_list]);
    }
    else{
        return response()->json(["success"=>false,"message"=>"No Training Modules"]);
    }


}

public function getNews($id){

    $newscategories =News::with('newsCategory')->where('newscategory_id',$id)->get();

    if(!empty($newscategories)){
       $newscategories_list=[];
        foreach($newscategories as $cat){
            $newscategories_object = (Object)[
                'id'=>$cat->id,
                'title'=>$cat->title,
                'content'=>$cat->content,
                'image'=>$cat->image,
                'newscategory_id '=>$cat->newscategory_id ,
                'user_id'=>$cat->user_id,
                'status'=>$cat->status,
        
            ];
            array_push($newscategories_list,$newscategories_object);
        }
        return response()->json(["success"=>true,"message"=>$newscategories_list]);
    }
    else{
        return response()->json(["success"=>false,"message"=>"No Training Modules"]);
    }


}


public function getCalenderEvents($id){

    $calenderevents =DB::table('trading_events')->where('farmer_id',$id)->get();

    if(!empty($calenderevents)){
       $calenderevents_list=[];
        foreach($calenderevents as $calenderevent){
            $calenderevents_object = (Object)[
                'id'=>$calenderevent->id,
                'title'=>$calenderevent->title,
                'description'=>$calenderevent->description,
                'start'=>$calenderevent->start,
                'end '=>$calenderevent->end ,
                'classNames'=>$calenderevent->classNames,
                'farmer_id'=>$calenderevent->farmer_id,
                'agent_id'=>$calenderevent->agent_id,
        
            ];
            array_push($calenderevents_list,$calenderevents_object);
        }
        return response()->json(["success"=>true,"message"=>$calenderevents_list]);
    }
    else{
        return response()->json(["success"=>false,"message"=>"No Calender Events"]);
    }

}
public function getAbout(){
    
    $abouts =About::all();

    if(!empty($abouts)){
       $abouts_list=[];
        foreach($abouts as $about){
            $about_object = (Object)[
                'id'=>$about->id,
                'type'=>$about->type,
                'description'=>$about->description,
        
            ];
            array_push($abouts_list,$about_object);
        }
        return response()->json(["success"=>true,"message"=>$abouts_list]);
    }
    else{
        return response()->json(["success"=>false,"message"=>"No about details"]);
    }
}

//////////////////////test chat///////////////////////////////
public function getChat($id){
        $messages = Chat::where('chat_category',$id)->get();
        return response()->json($messages);  
    }

}