<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Invoice;
use App\Order;
use App\InvoicePayment;
use App\ProduceCollection;
use App\TraderContract;
use App\ContractDetail;
use Auth;
use App\Trader;
use Illuminate\Http\Request;
use Exception;
use App\User;

class AdminInvoicesController extends Controller
{
    /**
     * Create a new Invoices controller instance.
     *
     * @return void
     */
	public function __construct()
	{
	    $this->middleware('auth');
	}

    /**
     * Display a listing of the admin-invoices.
     *
     * @return Illuminate\View\View
     */

    public function index()
    {
        //aded code
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);
        //addded trader---changes************
        $trader = $user->getRelatedTrader();
         
        if($user->isAdmin() || $user->getRelatedTrader()->isBulkBuyer() || $trader->isFarmerOrganisation()) {
            $traders = Trader::all();
            
            if($user->isAdmin()) {
                $invoiceout = Invoice::with('invoice')->paginate(100)->sortByDesc('id');
        
                
                $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
                return view('admin-invoices.index', compact('invoiceout','traders','dashboard'));
            }
            elseif($trader->isFarmerOrganisation()){
                $invoiceout = Invoice::with('invoice')->where('fo_id',$trader->id)->paginate(100)->sortByDesc('id');
               
                $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
                return view('admin-invoices.index', compact('invoiceout','traders','dashboard'));
            }
            else{
                $invoiceout = Invoice::with('invoice')->paginate(100)->sortByDesc('id');
                $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
                return view('admin-invoices.index', compact('invoiceout','traders','dashboard'));
            }
        }
        
        
        
        
    }
    /**
     * Show the form for creating a new invoice.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        // $orders = Order::pluck('id','id')->all();

        // return view('admin-invoices.create', compact('orders'));
    }

    /**
     * Store a new invoice in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        if(isset($_POST['confirm']))
        {
        try {

            $id = $request->get('id');
            $invoice = Invoice::find($id);
            $invoice->status = "2";
            $invoice->save();
            return redirect()->route('admin-invoices.index')
                ->with('success', 'Invoice payment confirmed successfully.');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
        }
        else{
            $pay = new InvoicePayment();
                $total = $request->get('total');   
                $amount = $request->get('amount');
                $balance = $request->get('balance');

                $id = $request->get('id');    
                $pay->invoice_id = $request->get('id');           
                $pay->amount = $request->get('amount');            
                $pay->mode = $request->get('mode');            
                //$pay->date = $request->get('date');
                $pay->save();
                if($amount ==  $balance)
                {
                    $invoice = Invoice::find($id);
                    $invoice->status = "1";
                    $invoice->balance = $balance -  $amount;
                    
                    $invoice->Save();
                } else
                {
                    $invoice = Invoice::find($id);
                    $invoice->status = "0";
                    $invoice->balance = $balance -  $amount;
                    
                    $invoice->Save();
                }
                return redirect()->back()
                ->with('success', "Payment made Succesfully");
        }
        
        // //invoice
        // $invoice = new Invoice();
        // $invoice->input_item_id = NULL;
        // $invoice->direction = "out";
        // if($request->get('amount') == $request->get('total'))
        // {
        //     $invoice->status = "2";
        // } else if($request->get('amount') > $request->get('total'))
        // {
        //     return redirect()->back()
        //     ->with('success', "Payment amount more than the invoice");
        // }
        // else if($request->get('amount') < $request->get('total'))
        // {
        //     $invoice->status = "0";
        // }
        
        // $invoice->directed_to = $request->get('directed_to');
        // $invoice->posted_by = Auth::User()->id;
        // $invoice->type = $request->get('type');
        // $invoice->total = $request->get('amount');
        // $invoice->number = $request->get('number');
        // $invoice->save();
        // return redirect()->route('admin-invoices.index')
        // ->with('success', "Done Successfully");
    }

    /**
     * Display the specified invoice.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $invoiceout = Invoice::find($id);
        $invoices = InvoicePayment::all()->where('invoice_id',$id);
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('admin-invoices.details', compact('invoices','invoiceout','dashboard'));
    }

    /**
     * Show the form for editing the specified invoice.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        // $invoice = Invoice::findOrFail($id);
        // $orders = Order::pluck('id','id')->all();

        // return view('admin-invoices.edit', compact('invoice','orders'));
    }

    /**
     * Update the specified invoice in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {
        
        // //update invoice
        // $invoice = Invoice::find($id);
        // $invoice->total = $request->get('total') - $request->get('amount');
               
        // $invoice->save();
        //add to invoice payments    
        // $invoicePayment = new InvoicePayment();
        // $invoicePayment->invoice_id = $request->get('id'); 
        // $invoicePayment->amount = $request->get('amount'); 
        // $invoicePayment->date = date('Y-m-d H:i:s');
        // $invoicePayment->save(); 
        // return redirect()->route('admin-invoices.index')
        // ->with('success', "Paid Successfully");
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    /**
     * Remove the specified invoice from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $invoice = Invoice::findOrFail($id);
            $invoice->delete();

            return redirect()->route('admin-invoices.index')
                ->with('success_message', 'Invoice was successfully deleted.');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'order_id' => 'required',
            'number' => 'nullable|numeric|string|min:0',
            'date' => 'required|string|date_format:m/d/Y',
            'total' => 'nullable|numeric|min:0|max:1.844674407371E+19',
            'status' => 'nullable|string|min:0|max:255',
        ];


        $data = $request->validate($rules);

        return $data;
    }

}
