<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class ForwardedInputOrderItem extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_input_order_items_forwarded';

    protected $fillable = [
        'input_order_item_id',
        'forwarded_by',
        'forwarded_to'
    ];

    public function input_order_item() {
        return $this->belongsTo(inputOrderItems::class, 'input_order_item_id', 'id');
    }

    public function by() {
        return $this->belongsTo(Trader::class, 'forwarded_by', 'id');
    }

    public function to() {
        return $this->belongsTo(Trader::class, 'forwarded_to', 'id');
    }
}
