<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class FarmerSoilHealth extends Model
{
    //use HasTradingPrefix;

    //soil health details
    protected $table = 'trading_farmer_soil_healths';
    protected $primaryKey = 'soil_health_id';
    protected $fillable = [
        'geolocation',
        'physical',
        'chemical',
        'biological',
        'biometric',
        'farmer_id',
    ];
    //=====relationships======//
    //soilhealth <> farmer rlshp
    public function soilFarmer()
    {
        return $this->belongsTo(FarmerProfile::class, 'farmer_id','id');
    }
    //soilhealth <> picture rlshp
    public function soilPicture()
    {
        return $this->hasMany(Picture::class, 'soil_health_id');
    }
}
