<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class FarmerProfile extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_farmers';

    protected $fillable = [
        'user_id',
        'middlename',
        'national_id',
        'mpesa_number',
        'education_level',
        'acreage',
        'acreage_farmed',
        'activities',
        'activities_crops',
        'activities_livestock',
        'input_spending',
        'preferred_learning_language',
        'preferred_agrodealer',
        'preferred_inputs',
        'phone_owned',
        'computer_access',
        'computer_access_location',
        'internet_access',
        'internet_access_location',
        'credit_history',
        'credit_history_outstanding',
        'credit_history_outstanding_details',
        'credit_needs',
    ];

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
    //soilhealth <> farmer rlshp
    public function farmerSoil()
    {
        return $this->hasMany(FarmerSoilHealth::class, 'farmer_id');
    }
    //season <> farmer rlshp
    public function farmerSeason()
    {
        return $this->hasMany(Season::class, 'farmer_id');
    }
    //calendar <> farmer rlshp
    public function farmerCropCalendar()
    {
        return $this->hasMany(CropCalendar::class, 'farmer_id');
    }
    //ivr <> farmer rlshp
    public function farmerIvr()
    {
        return $this->hasMany(IVR::class, 'farmer_id');
    }
    //livestock <> farmer rlshp
    public function farmerLivestock()
    {
        return $this->hasMany(Livestock::class, 'farmer_id');
    }
    ///farmer <> businessplan
    public function farmerBusiness()
    {
        return $this->hasMany(FarmerBusinessPlan::class, 'farmer_id');
    }
    //=====relationships======//
    //Expert video <> farmer rlshp
    public function videoFarmer()
    {
        return $this->hasMany(Expert_Videos::class, 'user_id');
    }
}