<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class FarmerProduceAggregation extends Model
{
    //use HasTradingPrefix;

     /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_farmer_produce_aggregation';

    protected $fillable = [
        'farmer_id',
        'produce_item_id',
        'quantity',
        'price_per_unit',
        'aggregated_by',
        'approved',
        'approved_by',
    ];

    public function farmer() {
        return $this->belongsTo(User::class, 'farmer_id', 'id');
    }

    public function produce_item() {
        return $this->belongsTo(ProduceItem::class);
    }

    public function aggregator() {
        return $this->belongsTo(User::class, 'aggregated_by');
    }

    public function approver() {
        return $this->belongsTo(User::class, 'approved_by');
    }

}
