<?php

namespace App\Exports;

use EloquentBuilder;
use App\User;
use Maatwebsite\Excel\Excel;
use Illuminate\Contracts\Support\Responsable;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class UsersExport implements Responsable, FromQuery, WithHeadings, WithMapping
{
    use Exportable;

    protected $request;

    /**
    * It's required to define the fileName within
    * the export class when making use of Responsable.
    */
    private $fileName = 'users.xlsx';

    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;

    /**
    * Optional headers
    */
    private $headers = [
        'Content-Type' => 'text/csv',
    ];

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function headings(): array
    {
        return [
            'Organisation',
            'User ID',
            'Firstname',
            'Middlename',
            'Lastname',
            'Username',
            'Email',
            'Phone',
            'Balance',
            'Credit Limit',
        ];
    }

    public function map($user): array
    {
        return [
            isset($user->traderMember) ? $user->traderMember->trader->organisation_name : '',
            $user->id,
            $user->firstname,
            isset($user->farmer_profile) ? $user->farmer_profile->middlename : '',
            $user->lastname,
            $user->username,
            $user->email,
            $user->phone,
            isset($user->wallet) ? $user->wallet->balance : '',
            isset($user->wallet) && $user->wallet->credit_limit != null ? $user->wallet->credit_limit : '',
        ];
    }

    public function query()
    {
        return EloquentBuilder::to(User::class, $this->request->all());

        // $users = User::query();
        // if(isset($this->request)) {
        //     if ($this->request->trader_id) {
        //         $users->whereHas('traderMember', function ($query) {
        //             $query->where('trader_id', '=', $this->request->trader_id);
        //         });
        //     }
        // }

        // return $users;
    }
}
