<?php

namespace App\Exports;

use EloquentBuilder;
use Maatwebsite\Excel\Excel;
use Illuminate\Contracts\Support\Responsable;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use App\Trader;

class TradersExport implements Responsable, FromQuery, WithHeadings, WithMapping
{
    use Exportable;

    protected $request;

    /**
    * It's required to define the fileName within
    * the export class when making use of Responsable.
    */
    private $fileName = 'organisations.xlsx';

    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;

    /**
    * Optional headers
    */
    private $headers = [
        'Content-Type' => 'text/csv',
    ];

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function headings(): array
    {
        return [
            'Organisation ID',
            'Name',
            'Email',
            'Phone',
            'Physical Address',
            'Postal Address',
            'Type',
            'Admin Name',
            'Username',
        ];
    }

    public function map($trader): array
    {
        return [
            $trader->id,
            $trader->organisation_name,
            $trader->email,
            $trader->phone,
            $trader->physical_address,
            $trader->postal_address,
            isset($trader->trader_type) ? $trader->trader_type->name : '',
            isset($trader->user) ? $trader->user->firstname . ' ' . $trader->user->lastname : '',
            isset($trader->user) ? $trader->user->username : '',
        ];
    }

    public function query()
    {
        // return Trader::with('trader_type', 'user');
        return EloquentBuilder::to(Trader::class, $this->request->all());
        // dd($traders);
    }
}
