<?php

namespace App\Exports;

use EloquentBuilder;
use App\TraderMember;
use Maatwebsite\Excel\Excel;
use Illuminate\Contracts\Support\Responsable;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class TraderMembersExport implements Responsable, FromQuery, WithHeadings, WithMapping
{
    use Exportable;

    protected $request;

    /**
    * It's required to define the fileName within
    * the export class when making use of Responsable.
    */
    private $fileName = 'organisation-members.xlsx';

    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;

    /**
    * Optional headers
    */
    private $headers = [
        'Content-Type' => 'text/xlsx',
    ];

    public function __construct($trader_id, $type = 'xlsx', $request)
    {
        $this->request = $request;
        $this->trader_id = $trader_id;

        if ($type != 'xlsx') {
            switch ($type) {
                case 'csv':
                    $this->fileName = 'organisation-members.csv';
                    $this->writerType = Excel::CSV;
                    $this->headers = [
                        'Content-Type' => 'text/csv',
                    ];
                    break;
                case 'pdf':
                    $this->fileName = 'organisation-members.pdf';
                    $this->writerType = Excel::DOMPDF;
                    $this->headers = [
                        'Content-Type' => 'application/pdf',
                    ];
                    break;
                default:
                    break;
            }
        }
    }

    public function headings(): array
    {
        return [
            'ID',
            'Firstname',
            'Middlename',
            'Lastname',
            'Email',
            'Phone',
            'Balance',
            'Credit Limit',
            'Username',
            'Organisation',
        ];
    }

    public function map($member): array
    {
        return [
            $member->user_id,
            $member->user->firstname,
            isset($member->user->farmer_profile) && $member->user->farmer_profile->middlename != null ? $member->user->farmer_profile->middlename : '-',
            $member->user->lastname,
            $member->user->email,
            $member->user->phone,
            isset($member->user->wallet) && $member->user->wallet->balance != null ? $member->user->wallet->balance : '0',
            isset($member->user->wallet) && $member->user->wallet->credit_limit != null ? $member->user->wallet->credit_limit : '0',
            $member->user->username,
            $member->trader->organisation_name,
        ];
    }

    public function query()
    {
        return EloquentBuilder::to(TraderMember::class, $this->request->all())->where('trader_id', $this->trader_id);
    }
}
