<?php

namespace App\Exports;

use EloquentBuilder;
use Illuminate\Contracts\Support\Responsable;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Maatwebsite\Excel\Excel;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use App\inputOrderItems;

class InputOrderItemsExport implements Responsable, FromQuery, WithHeadings, WithMapping
{
    use Exportable;

    protected $request;

    /**
    * It's required to define the fileName within
    * the export class when making use of Responsable.
    */
    private $fileName = 'input_order_items.xlsx';

    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;

    /**
    * Optional headers
    */
    private $headers = [
        'Content-Type' => 'text/csv',
    ];

    public function __construct($id, $request)
    {
        $this->order_id = $id;
        $this->request = $request;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Order ID',
            'Seller',
            'Farmer',
            'Input',
            'Quantity',
            'Price',
            'Financing',
            'Status',
        ];
    }

    public function map($input_order_item): array
    {
        return [
            $input_order_item->id,
            $input_order_item->orders->id,
            $input_order_item->input->trader->organisation_name,
            $input_order_item->farmer->fullname,
            $input_order_item->input->input->name,
            $input_order_item->quantity,
            $input_order_item->price,
            ucfirst($input_order_item->financing),
            ($input_order_item->approved == 0) ? 'Pending Financing' : // 0 - Pending Financing, 1 - In Process, 2 - Completed, 3 - Delivered, 4 - Received
            (($input_order_item->approved == 1) ? 'In Process' :
            (($input_order_item->approved == 2) ? 'Completed' :
            (($input_order_item->approved == 3) ? 'Delivered' :
            (($input_order_item->approved == 4) ? 'Received' : '')))),
        ];
    }

    public function query()
    {
        $query = inputOrderItems::where('order_id', $this->order_id);
        return EloquentBuilder::to($query, $this->request->all());
    }
}
