<?php

namespace App\Exports;

use App\inputOrders;
use App\inputOrderItems;
use App\Trader;
use App\User;
use App\TraderMember;
use App\Input;
use App\Invoice;
use App\Credits;
use App\UserWallet;
use Auth;
use Maatwebsite\Excel\Excel;
use Illuminate\Contracts\Support\Responsable;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class CreditRequestsExport implements  Responsable, FromQuery, WithHeadings, WithMapping
{
    
    use Exportable;

    protected $request;

    /**
    * It's required to define the fileName within
    * the export class when making use of Responsable.
    */
    private $fileName = 'credit-requests.xlsx';

    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;

    /**
    * Optional headers
    */
    private $headers = [
        'Content-Type' => 'text/csv',
    ];

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Farmer',
            'Requested Amount',
            'Credit Limit',
            'Order Details',
            'Status',
            'Created On',
        ];
    }

    public function map($member): array
    {
        return [
            $member->id,
            $member->user->fullname,
            $member->requested_amount,
            $member->user->wallet->credit_limit,
            $member->inputOrderItems->input->name,
            $member->approved,
            $member->created_at,
            
        ];
    }

    public function query()
    {
        $id = $_GET['id'];
        
        $items = inputOrderItems::where('approved' ,0)->where('financing', "credit")->where('order_id',$id)->pluck('id');
        $members = Credits::all()->whereIn('input_order_item_id',$items)->sortByDesc('id');
        if(isset($this->request)) {
            if ($this->request->trader_id) {
                $members->where('trader_id', $this->request->trader_id);
            }
        }

        return $members;
    }
}
        