<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Expert_Videos extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_expert_videos';

    protected $fillable = [
        'id',
        'farmer_id',
        'farmer_org_id',
        'expert_id',
        'video_url',
        'status'
    ];


      //=====relationships======//
    //Expert video <> farmer rlshp
    public function videoFarmer()
    {
        return $this->belongsTo(FarmerProfile::class, 'farmer_id','id');
    }

    //=====relationships======//
    //Expert video <> farmer rlshp
    public function videoCoach()
    {
        return $this->hasOne(User::class, 'id');
    }

    //=====relationships======//
    //Expert video <> farmer rlshp
    public function videoOrganization()
    {
        return $this->hasOne(Trader::class, 'id');
    }


}
