<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Expert_Audios extends Model
{
   // use HasTradingPrefix;

    protected $table = 'trading_expert_audios';

    protected $fillable = [
        'id',
        'farmer_id',
        'farmer_org_id',
        'expert_id',
        'audio_url',
        'status'
    ];
    //rlshps
    public function eventFarmer()
    {
        return $this->belongsTo(FarmerProduceAggregation::class, 'farmer_id','id');
    }

      //=====relationships======//
    //Expert video <> farmer rlshp
    public function audoFarmer()
    {
        return $this->belongsTo(FarmerProfile::class, 'farmer_id','id');
    }
    //Expert video <> Trader rlshp
    public function audoTrader()
    {
        return $this->hasOne(Trader::class, 'id');
    }
    

  //=====relationships======//
    //Expert video <> farmer rlshp
    public function AudioCoach()
    {
        return $this->hasOne(User::class, 'id');
    }

}
