<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Events extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_events';
    protected $primaryKey = 'id';
    protected $fillable = [
        'title',
        'description',
        'start',
        'end',
        'classNames',
        'farmer_id',
        'agent_id',
    ];
    //rlshps
    public function eventFarmer()
    {
        return $this->belongsTo(FarmerProfile::class, 'farmer_id','id');
    }
    // public function eventAgent()
    // {
    //     return $this->belongsTo(Agent::class, 'agent_id','agent_id');
    // }
    
}