<?php

namespace App\EloquentFilters\SeasonProduce;

use Fouladgar\EloquentBuilder\Support\Foundation\Contracts\Filter;
use Illuminate\Database\Eloquent\Builder;

class TraderFilter extends Filter
{
    /**
     * Apply the age condition to the query.
     *
     * @param Builder $builder
     * @param mixed $value
     *
     * @return Builder
     */
    public function apply(Builder $builder, $value): Builder
    {
        return $builder->whereHas('seasonproduceSeason', function($query) use($value) {
            $query->whereHas('soilFarmer', function($q) use($value) {
                $q->whereHas('user', function($q1) use($value) {
                    $q1->whereHas('traderMember', function($q2) use($value) {
                        $q2->where('trader_id', $value);
                    });
                });
            });
        });
    }
}
