<?php

namespace App\EloquentFilters\Producecollection;

use Fouladgar\EloquentBuilder\Support\Foundation\Contracts\Filter;
use Illuminate\Database\Eloquent\Builder;
use App\ProduceCollection;

class OrganisationNameFilter extends Filter
{
    /**
     * Apply the age condition to the query.
     *
     * @param Builder $builder
     * @param mixed $value
     *
     * @return Builder
     */
    public function apply(Builder $builder, $value): Builder
    {
        return $builder->whereHas('contract_detail', function($query) use($value) {
            $query->whereHas('produce_item', function($q) use($value) {
                $q->whereHas('trader', function($q) use($value) {
                    $q->where('organisation_name', 'LIKE', '%'.$value.'%');
                });
            });
        });
    }
}
