<?php

namespace App\EloquentFilters\InputOrderItems;

use Fouladgar\EloquentBuilder\Support\Foundation\Contracts\Filter;
use Illuminate\Database\Eloquent\Builder;

class StatusFilter extends Filter
{
    /**
     * Apply the age condition to the query.
     *
     * @param Builder $builder
     * @param mixed $value
     *
     * @return Builder
     */
    public function apply(Builder $builder, $value): Builder
    {
        // 0 - Pending Financing, 1 - In Process, 2 - Completed, 3 - Delivered, 4 - Received
        return $builder->where('approved', '=', (int) $value);
    }
}
