<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Driver extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_drivers';

    protected $fillable = [
        'firstname',
        'lastname',
        'email',
        'phone',
        'licence_no',
        'driver_class',
        'experience',
        'trader_id',
        'user_id',
        'status'
    ];
    public function driver()
    {
       return $this->belongsTo(Trader::class, 'trader_id', 'id');
    }
    public function drivers()
    {
       return $this->belongsTo(User::class, 'user_id', 'id');
    }
    public function drive()
    {
       return $this->hasMany(Delivery::class);
    }
}
