<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class DeliveryRequests extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_delivery_requests';

    protected $fillable = [
        'produce_collection_id',
        'transporter_id',
        'picking_time',
        'delivery_time',
        'from_id',
        'to_id',
        'status'
    ];
    public function produce_collection() {
        return $this->belongsTo(ProduceCollection::class,'produce_collection_id','id');
    }

    public function transporter() {
        return $this->belongsTo(Trader::class, 'transporter_id','id');
    }

    public function delivery() {
        return $this->hasMany(Delivery::class);
    }
}
