<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class DeliveryAcknowledgement extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_delivery_acknowledgements';

    protected $fillable = [
       'comment',
       'delivery_id',
       'trader_id',
       'state_of_arrival'
    ];
    public function trader() {
        return $this->belongsTo(Trader::class,'trader_id','id');
     }
     public function delivery() {
        return $this->belongsTo(Delivery::class,'delivery_id','id');
     }
}
