<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Delivery extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_deliveries';

    protected $fillable = [
        'driver_id',
        'vehicle_id',
        'transporter_id',
        'input_order_id',
        'produce_collection_id',
        'status',
        'delivery_request_id'
    ];

    public function delivery() {
       return $this->belongsTo(Driver::class, 'driver_id', 'id');
    }

    public function deliveries() {
       return $this->belongsTo(Vehicle::class, 'vehicle_id', 'id');
    }

    public function produce_collection() {
       return $this->belongsTo(ProduceCollection::class, 'produce_collection_id', 'id');
    }

    public function deliverInput() {
       return $this->belongsTo(inputOrders::class, 'input_order_id', 'id');
    }

    public function deliveryRequests() {
      return $this->belongsTo(DeliveryRequests::class,'delivery_request_id','id');
    }

    public function deliveryAcknowledgement() {
        return $this->hasMany(DeliveryAcknowledgement::class);
    }
}
