<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CropCalendar extends Model
{
    //crop calendar
    //crop setting
    //use HasTradingPrefix;
    protected $table = 'trading_crop_calendar';
    protected $primaryKey = 'crop_calendar_id';
    protected $fillable = [
        'event_type',
        'specific_activity',
        'date_time',
        'status',
        'comments',
        'farmer_id',
    ];
    //=====relationships======//
    //calendar <> farmer rlshp
    public function calendarFarmer()
    {
        return $this->belongsTo(FarmerProfile::class, 'farmer_id','id');
    }
}
