<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Credits extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_credits';

    protected $fillable = [
        'user_id',
        'input_order_item_id',
        'requested_amount',
        'credited_amount',
        'payable_amount',
        'balance',
        'period',
        'interest',
        'approved',
        'cleared'
    ];

    public function creditClearing()
    {
        return $this->hasMany(CreditClearing::class,'credit_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id','id');
    }
    public function inputOrderItems()
    {
        return $this->belongsTo(inputOrderItems::class, 'input_order_item_id','id');
    }
    public function creditTransaction()
    {
        return $this->hasMany(CreditTransaction::class);
    }
}
