<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;

class County extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_counties';

    protected $fillable = [
        'name',
        'code',
        'latitude',
        'longitude'
    ];

    protected $appends = [
        'url','coordinate', 'map_popup_content',
    ];

    public function getUrlAttribute() {
        return route("counties.show", $this);
    }

    public function tradercounty() {
        return $this->hasMany(Trader::class,'id');
    }


    public function networks() {
        return $this->hasMany(TraderNetwork::class, 'county_id');
    }

    public function traders() {
        return $this->hasMany(Trader::class, 'county_id');
    }
    public function getCoordinateAttribute()
    {
        if ($this->latitude && $this->longitude) {
            return $this->latitude.', '.$this->longitude;
        }
    }

    /**
     * Get outlet map_popup_content attribute.
     *
     * @return string
     */
    public function getMapPopupContentAttribute()
    {
        //get farmers in this county
        $fos=DB::table('trading_traders')->where('type_id','2')->where('county_id',$this->id)->get();
        //get the farmers in the fos
        $farmer_nos=0;
        foreach($fos as $fo){
            $farmers = DB::table('trading_trader_members')->where('trader_id',$fo->id)->get();
            $farmer_nos+=count($farmers);
        }    
       
       
        $mapPopupContent = '';
        $mapPopupContent .= '<div class="my-2"><strong>'.__('County Name').':</strong><br>'.$this->name.'</div>';
        $mapPopupContent .= '<div class="my-2"><strong>'.__('County FOs').':</strong><br>'.count($fos).'</div>';
        $mapPopupContent .= '<div class="my-2"><strong>'.__('County Farmers').':</strong><br>'.$farmer_nos.'</div>';

        return $mapPopupContent;
    }

}
