<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
use App\TraderContract;
use App\ProduceItem;

class ContractDetail extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_contract_details';

    protected $fillable = [
        'contract_id',
        'produce_item_id',
        'tonnage'
    ];

    public function contract() {
        return $this->belongsTo(TraderContract::class,'contract_id','id');
    }

    public function produce_item() {
        return $this->belongsTo(ProduceItem::class,'produce_item_id','id');
    }

    public function collections() {
        return $this->hasMany(ProduceCollection::class, 'contract_detail_id', 'id');
    }
}
