<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\ProductionCost;
use App\FarmerBusinesPlan;
use App\FarmerProfile;
use App\Libs\Mobisky;
use Log;
use Auth;

use Illuminate\Support\Facades\Mail;

class FarmerActivity extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'activity:day';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Notify farmers of their set activities 5 days before time';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $activities = ProductionCost::where('time', '=', now()->addDays(4)->toDateString())->orWhere('time', '=', now()->toDateString())->with('costBusiness.businessFarmer')->get();
        foreach($activities as $activity)
        {
            $smsobject=new Mobisky('twalisha','twalisha');

            $phn= "+254".substr($activity->costBusiness->businessFarmer->mpesa_number,-9);
            // $farmer_id=$request->farmer_id;
            $sms="Twalisha Reminder. \r".$activity->costBusiness->businessFarmer->middlename.", Please carry out activity: ".$activity->input." on ".$activity->time;
        
            $textstatus=$smsobject->sendMessage($phn,$sms);

            // return $textstatus;
            // Mail::raw("{$key} -> {$value}", function ($mail) use ($user) {
            //     $mail->from('info@twalisha.com');
            //     $mail->to($activity->costBusiness->businessFarmer->email)
            //         ->subject('Twalisha: Activities Reminder');
            // });
            
            Log::info($textstatus);
        }
        $this->info('Reminders sent');
    }
}
