<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Events;
use App\FarmerBusinesPlan;
use App\FarmerProfile;
use App\Libs\Mobisky;
use Log;

use Illuminate\Support\Facades\Mail;
class AgentActivity extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'agent:activity';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remind agents of their activities';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $activities = Events::where('start', '=', now()->addDays(5)->toDateString())->orWhere('start', '=', now()->toDateString())->get();
        foreach($activities as $activity)
        {
            // $smsobject=new Mobisky('twalisha','twalisha');

            // $phn= "+254".substr($activity->,-9);
            // $farmer_id=$request->farmer_id;
            $sms="Twalisha Reminder. \r Please carry out activity: ".$activity->title." : ".$activity->description." from ".$activity->start." to ".$activity->end;
        
            // $textstatus=$smsobject->sendMessage($phn,$sms);

            // return $textstatus;
            // Mail::raw("{$key} -> {$value}", function ($mail) use ($user) {
            //     $mail->from('info@twalisha.com');
            //     $mail->to($activity->)
            //         ->subject('Twalisha: Activities Reminder');
            // });
            
            Log::info($sms);
        }
        $this->info('Reminders sent to agents');
    }
}
