<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class ChatCategory extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_chat_categories';

    protected $fillable = [
        'name',
        'description',
        'parent_id'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url',
        'parent_name'
    ];

    public function chats() {
        return $this->hasMany(Chat::class, 'category_id');
    }

    public function children() {
        return $this->hasMany(ChatCategory::class, 'parent_id');
    }

    public function categories() {
        return $this->HasMany(ChatCategory::class);
    }

    public function childrenCategories() {
        return $this->hasMany(ChatCategory::class)->with('categories');
    }

    public function parent() {
        return $this->belongsTo(ChatCategory::class, 'parent_id');
    }

    public function scopeMain($query) {
        $query->whereNull('parent_id');
    }

    /**
     * Get the url for this model.
     *
     * @return URL
     */
    public function getUrlAttribute()
    {
        return route("chat-categories.show", $this);
    }

    /**
     * Get the parent name for this model.
     *
     * @return URL
     */
    public function getParentNameAttribute()
    {
        return isset($this->parent) ? $this->parent->name : '';
    }
}
