<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Chat extends Model
{
    //use HasTradingPrefix;
    protected $table = 'trading_chat';

    protected $fillable = [
        'id',        
        'farmer_id',
        'category_id',
        'message_type',
        'message',
        'expert_id',
        'chat_to',
        'farmer_org_id',
        'chat_from',
        'mime_type',
        'file_name',
        'status'

        

    ];

    
     public function traderchart() {
        return $this->belongsTo(Trader::class,'farmer_org_id');
    }
    public function user() {
        return $this->belongsTo(User::class, 'id', 'id');
    }

}
