<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Agent extends Model
{
    //
    //use HasTradingPrefix;

    protected $primaryKey = 'agent_id';
    protected $table = 'trading_agents';
    protected $fillable = [
        'agent_id',
        'trader_id',
        'user_id'
    ];
    //relationships
    public function agentTrader()
    {
        return $this->hasMany(Trader::class,'trader_id','id');
    }
    public function agentUser()
    {
        return $this->belongsTo(User::class, 'user_id','id');
    }
    
}
