# update [![NPM version](https://img.shields.io/npm/v/update.svg)](https://www.npmjs.com/package/update) [![Build Status](https://img.shields.io/travis/update/update.svg)](https://travis-ci.org/update/update)

> Easily keep anything in your project up-to-date by installing the updaters you want to use and running `update` in the command line! Update the copyright date, licence type, ensure that a project uses your latest eslint or jshint configuration, remove deprecated package.json fields, or anything you can think of!

## CLI

### Install

Install globally with [npm](https://www.npmjs.com/)

```sh
$ npm i -g update
```

### Commands

```sh
$ update <command> [options]
```

**List updaters**

Choose from a list of updaters and tasks to run:

```sh
$ update list
```

**Run a specific updater**

The following would run updater `foo`:

```sh
$ update foo

# run updater "foo" with options
$ update foo --bar=baz
```

### tasks

_(TODO)_

### plugins

_(TODO)_

#### pipeline plugins

_(TODO)_

#### instance plugins

_(TODO)_

### middleware

A middleware is a function that exposes the following parameters:

* `file`: **{Object}** [vinyl](http://github.com/gulpjs/vinyl) file object
* `next`: **{Function}** must be called to continue on to the next file.

```js
function rename(file, next) {
  file.path = 'foo/' + file.path;
  next();
}

// example usage: prefix all `.js` file paths with `foo/`
app.onLoad(/\.js/, rename);
```

The `onStream` method is a custom [middleware](docs/middleware.md) handler that the `update`

```js
app.onStream(/lib\//, rename);
```

## API

### Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm i update --save
```

```js
var update = require('update');
```

## API

### [Update](index.js#L30)

Create an `update` application. This is the main function exported by the update module.

**Params**

* `options` **{Object}**

**Example**

```js
var Update = require('update');
var update = new Update();
```

## Related projects

* [assemble](https://www.npmjs.com/package/assemble): Assemble is a powerful, extendable and easy to use static site generator for node.js. Used… [more](https://www.npmjs.com/package/assemble) | [homepage](https://github.com/assemble/assemble)
* [boilerplate](https://www.npmjs.com/package/boilerplate): Tools and conventions for authoring and publishing boilerplates that can be generated by any build… [more](https://www.npmjs.com/package/boilerplate) | [homepage](http://boilerplates.io)
* [composer](https://www.npmjs.com/package/composer): API-first task runner with three methods: task, run and watch. | [homepage](https://github.com/jonschlinkert/composer)
* [generate](https://www.npmjs.com/package/generate): Fast, composable, highly extendable project generator with a user-friendly and expressive API. | [homepage](https://github.com/generate/generate)
* [scaffold](https://www.npmjs.com/package/scaffold): Conventions and API for creating declarative configuration objects for project scaffolds - similar in format… [more](https://www.npmjs.com/package/scaffold) | [homepage](https://github.com/jonschlinkert/scaffold)
* [templates](https://www.npmjs.com/package/templates): System for creating and managing template collections, and rendering templates with any node.js template engine.… [more](https://www.npmjs.com/package/templates) | [homepage](https://github.com/jonschlinkert/templates)
* [update](https://www.npmjs.com/package/update): Update | [homepage](https://github.com/jonschlinkert/update)
* [verb](https://www.npmjs.com/package/verb): Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used… [more](https://www.npmjs.com/package/verb) | [homepage](https://github.com/verbose/verb)

## Authoring

### Updaters

_(TODO)_

#### Tasks

_(TODO)_

#### Middleware

_(TODO)_

#### Plugins

> Updater plugins follow the same signature as gulp plugins

**Example**

```js
function myPlugin(options) {
  return through.obj(function(file, enc, next) {
    var str = file.contents.toString();
    // do stuff to `file`
    file.contents = new Buffer(file.contents);
    next(null, file);
  });
}
```

### Publish

1. Name your project following the convention: `updater-*`
2. Don't use dots in the name (e.g `.js`)
3. Make sure you add `updater` to the keywords in `package.json`
4. Tweet about your updater!

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/update/issues/new).

## Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016 [Jon Schlinkert](https://github.com/jonschlinkert)
Released under the MIT license.

***

_This file was generated by [verb](https://github.com/verbose/verb) on January 09, 2016._