(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    }
    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    if (!echarts.registerMap) {
        log('ECharts Map is not loaded')
        return;
    }
    echarts.registerMap('world', {"type":"FeatureCollection","features":[{"geometry":{"type":"Polygon","coordinates":[[[74.54140625000002,37.02216796875],[74.00185546875002,36.823095703125],[73.769140625,36.888476562499996],[72.62285156250002,36.82958984375],[71.62050781250002,36.436474609375],[71.18505859375,36.04208984375],[71.42753906250002,35.833740234375],[71.62050781250002,35.183007812499994],[70.96562500000002,34.53037109375],[71.05156250000002,34.049707031249994],[69.86806640625002,33.89765625],[70.2841796875,33.369042968749994],[69.92011718750001,33.1125],[69.5015625,33.020068359374996],[69.24140625000001,32.433544921875],[69.279296875,31.936816406249996],[68.86894531250002,31.634228515624997],[68.21396484375,31.807373046875],[67.57822265625,31.506494140624994],[67.28730468750001,31.217822265624996],[66.92431640625,31.305615234374997],[66.39716796875001,30.91220703125],[66.17705078125002,29.835595703124994],[65.09550781250002,29.559472656249994],[64.52109375,29.564501953124996],[64.09873046875,29.391943359375],[63.56757812500001,29.497998046874997],[62.4765625,29.408349609374994],[62.37343750000002,29.425390625],[61.22441406250002,29.749414062499994],[60.843359375000006,29.858691406249996],[61.104101562500006,30.12841796875],[61.55947265625002,30.599365234375],[61.7841796875,30.831933593749994],[61.81083984375002,30.913281249999997],[61.81425781250002,31.072558593749996],[61.75507812500001,31.285302734374994],[61.66015625,31.382421875],[61.34648437500002,31.421630859375],[61.11074218750002,31.451123046874997],[60.854101562500006,31.483251953125],[60.82929687500001,32.249414062499994],[60.71044921875,32.599999999999994],[60.57656250000002,32.994873046875],[60.560546875,33.137841796874994],[60.9169921875,33.505224609375],[60.485937500000006,33.7119140625],[60.48574218750002,34.094775390624996],[60.72626953125001,34.51826171875],[60.802343750000006,34.554638671875],[60.91474609375001,34.633984375],[60.951171875,34.653857421874996],[61.080078125,34.855615234374994],[61.18925781250002,35.31201171875],[61.3447265625,35.6294921875],[61.54277343750002,35.457861328125],[62.61054687500001,35.233154296875],[62.688085937500006,35.255322265625],[62.72265625,35.271337890625],[62.858007812500006,35.349658203124996],[62.98027343750002,35.4091796875],[63.056640625,35.44580078125],[63.08417968750001,35.56806640625],[63.16972656250002,35.678124999999994],[63.15078125000002,35.728271484375],[63.129980468750006,35.766748046874994],[63.10859375000001,35.818701171875],[63.129980468750006,35.84619140625],[63.17890625000001,35.858447265624996],[63.30166015625002,35.8583984375],[63.86250000000001,36.012353515624994],[64.18437500000002,36.14892578125],[64.51103515625002,36.340673828125],[64.6025390625,36.554541015625],[64.75312500000001,36.964794921875],[64.78242187500001,37.05927734375],[64.81630859375002,37.132080078125],[64.95156250000002,37.1935546875],[65.08964843750002,37.237939453124994],[65.30361328125002,37.24677734375],[65.55498046875002,37.251171875],[65.76503906250002,37.569140624999996],[66.1083984375,37.41474609375],[66.35029296875001,37.3681640625],[66.47187500000001,37.3447265625],[66.52226562500002,37.348486328125],[66.827734375,37.3712890625],[67.06884765625,37.334814453125],[67.19550781250001,37.235205078125],[67.31972656250002,37.2095703125],[67.44169921875002,37.2580078125],[67.51728515625001,37.266650390624996],[67.546484375,37.235644531249996],[67.607421875,37.222509765625],[67.70000000000002,37.22724609375],[67.7529296875,37.1998046875],[67.75898437500001,37.172216796875],[67.76601562500002,37.14013671875],[67.83447265625,37.064208984375],[67.9580078125,36.972021484375],[68.06777343750002,36.9498046875],[68.21210937500001,37.021533203124996],[68.38691406250001,37.137499999999996],[68.66914062500001,37.2583984375],[68.96044921875,37.325048828125],[69.18017578125,37.15830078125],[69.26484375000001,37.1083984375],[69.30390625000001,37.116943359375],[69.35380859375002,37.150048828124994],[69.41445312500002,37.207763671875],[69.4296875,37.290869140625],[69.39921875000002,37.399316406249994],[69.42011718750001,37.486718749999994],[69.49208984375002,37.553076171875],[69.62578125000002,37.594042968749996],[69.8208984375,37.6095703125],[69.9849609375,37.566162109375],[70.25146484375,37.66416015625],[70.41777343750002,38.075439453125],[70.87890625,38.456396484375],[71.255859375,38.306982421875],[71.33271484375001,38.170263671875],[71.2828125,38.00791015625],[71.27851562500001,37.918408203125],[71.319921875,37.90185546875],[71.3896484375,37.906298828124996],[71.48779296875,37.931884765625],[71.55195312500001,37.933154296874996],[71.58222656250001,37.910107421875],[71.58037109375002,37.8642578125],[71.50507812500001,37.602929687499994],[71.43291015625002,37.1275390625],[71.530859375,36.845117187499994],[71.665625,36.696923828124994],[72.65742187500001,37.029052734375],[72.8955078125,37.267529296875],[73.21113281250001,37.408496093749996],[73.38291015625,37.462255859375],[73.48134765625002,37.4716796875],[73.60468750000001,37.446044921875],[73.63261718750002,37.43720703125],[73.65712890625002,37.430468749999996],[73.72060546875002,37.418749999999996],[73.71728515625,37.329443359375],[73.749609375,37.231787109375],[74.16708984375,37.329443359375],[74.20351562500002,37.372460937499994],[74.25966796875002,37.415429687499994],[74.65937500000001,37.394482421875],[74.37216796875,37.15771484375],[74.37617187500001,37.137353515624994],[74.49794921875002,37.0572265625],[74.52646484375,37.030664062499994],[74.54140625000002,37.02216796875]]]},"properties":{"name":"Afghanistan","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[17.57958984375,-8.099023437500009],[17.643359375000017,-8.090722656250009],[18.00878906250003,-8.107617187499983],[18.56269531250001,-7.9359375000000085],[18.89833984375008,-7.998144531249977],[18.944433593750063,-8.001464843750028],[19.142675781250034,-8.001464843750028],[19.34082031249997,-7.966601562500031],[19.369921875000045,-7.706542968749986],[19.371679687500063,-7.655078124999989],[19.527636718750017,-7.144433593749952],[19.87519531250004,-6.986328124999986],[19.99746093750008,-6.976464843750023],[20.190039062500063,-6.9462890625],[20.482226562500074,-6.915820312500017],[20.59003906250001,-6.919921874999957],[20.598730468750006,-6.935156249999949],[20.536914062500045,-7.1217773437499545],[20.558398437500045,-7.244433593749989],[20.60781250000008,-7.277734375000023],[20.910937500000017,-7.281445312499983],[21.190332031250023,-7.284960937499989],[21.751074218750034,-7.305468749999989],[21.905371093750034,-8.693359374999943],[21.813183593750068,-9.46875],[22.19775390625,-10.040624999999977],[22.274511718750006,-10.259082031249974],[22.30244140625001,-10.39667968750004],[22.203515625000023,-10.829492187500009],[22.226171875000006,-11.121972656250009],[23.156738281250057,-11.074804687499991],[23.400195312500017,-10.976464843750023],[23.55996093750005,-10.97861328125002],[23.696386718750034,-11.007617187499974],[23.83388671875008,-11.013671874999972],[23.96650390625001,-10.871777343750011],[24.046679687500074,-11.405371093750006],[23.991308593750006,-12.422167968750031],[23.90937500000001,-12.636132812500009],[23.843164062500023,-13.0009765625],[22.209570312500006,-13.0009765625],[21.97890625000008,-13.0009765625],[21.979101562500034,-13.477734374999969],[21.979101562500034,-13.798730468749994],[21.979296875000074,-14.11962890625],[21.979394531249994,-14.440527343750006],[21.97949218750003,-14.761425781250011],[21.979589843750034,-15.082324218750017],[21.979687500000068,-15.403222656250023],[21.97978515624999,-15.724121093750028],[21.97978515624999,-15.955566406250014],[22.15068359374999,-16.597167968749986],[22.193945312500006,-16.628124999999983],[22.305078125000023,-16.689550781249977],[22.955859375000074,-17.28574218750002],[23.181640625000057,-17.474414062500003],[23.380664062500017,-17.64062500000003],[23.06826171875005,-17.698828124999977],[22.624023437500057,-17.78164062499998],[22.32421875,-17.83749999999999],[21.96083984375005,-17.90517578125001],[21.41689453125008,-18.00068359375001],[20.625097656250063,-17.99667968749999],[20.507617187500017,-17.95253906249998],[20.392968750000023,-17.887402343750026],[19.076464843750045,-17.81767578125003],[18.825976562500074,-17.766308593750054],[18.718066406250045,-17.70322265624999],[18.39638671875005,-17.3994140625],[17.83535156250005,-17.392773437499983],[17.296289062500023,-17.391992187499994],[16.913671875000034,-17.39140624999996],[16.531054687500074,-17.390820312500026],[16.14843750000003,-17.39023437499999],[15.765820312500068,-17.389648437499957],[13.93798828125,-17.388769531249963],[13.403710937500051,-17.00781249999997],[13.101171875000063,-16.967675781249966],[12.548144531250017,-17.212695312499974],[12.35927734375008,-17.205859375000003],[12.318457031250006,-17.21337890625003],[12.213378906250028,-17.209960937500043],[12.013964843750074,-17.168554687500034],[11.902539062500011,-17.226562499999957],[11.743066406250023,-17.24921875000004],[11.780078125000017,-16.87128906249997],[11.818945312500034,-16.704101562500014],[11.750878906250023,-15.831933593749966],[11.967871093750006,-15.63398437500004],[12.280468750000011,-14.637499999999989],[12.55048828125004,-13.437792968750003],[12.983203124999989,-12.775683593750017],[13.4169921875,-12.52041015624998],[13.785351562499983,-11.81279296874996],[13.847460937500045,-11.054394531249997],[13.20937500000008,-9.703222656249977],[12.99853515625,-9.048046874999997],[13.358984375000006,-8.687207031250026],[13.378515625000063,-8.369726562500006],[12.862304687500057,-7.231835937499994],[12.82343750000004,-6.9547851562499545],[12.521289062500045,-6.590332031249957],[12.302539062500074,-6.092578124999989],[13.346484375000017,-5.863378906250006],[13.978515625,-5.857226562500003],[14.398632812500068,-5.89267578125002],[15.726953125000051,-5.86386718750002],[16.060156250000063,-5.864941406249969],[16.315234375000074,-5.865625000000023],[16.431445312500045,-5.90019531249996],[16.53710937499997,-5.9658203125],[16.63955078125008,-6.114550781250017],[16.697265625,-6.164257812500026],[16.71777343750003,-6.241406250000011],[16.70937500000008,-6.471679687499943],[16.74296874999999,-6.618457031250003],[16.813085937500063,-6.772558593749963],[16.919433593750057,-6.93398437499998],[16.98476562500005,-7.257421874999977],[17.57958984375,-8.099023437500009]]],[[[12.255273437500023,-5.746484374999994],[12.018359375000074,-5.004296874999966],[12.384570312500074,-4.619140625000014],[12.829687499999977,-4.73662109374996],[12.573535156250017,-4.996582031249986],[12.502734375000074,-5.036914062500031],[12.451464843750017,-5.071484374999969],[12.453222656250034,-5.09062499999996],[12.52236328125008,-5.148925781250028],[12.518945312499994,-5.424609374999974],[12.503710937500017,-5.695800781249972],[12.255273437500023,-5.746484374999994]]]]},"properties":{"name":"Angola","childNum":2}},{"geometry":{"type":"Polygon","coordinates":[[[20.06396484375,42.547265624999994],[20.485449218750006,42.223388671875],[20.566210937500017,41.873681640624994],[20.48896484375001,41.272607421874994],[20.964257812500023,40.849902343749996],[20.95576171875001,40.775292968749994],[20.881640625000017,40.467919921874994],[20.4560546875,40.065576171874994],[20.382421875000006,39.802636718749994],[20.001269531250017,39.709423828125],[19.851855468750017,40.0435546875],[19.39814453125001,40.28486328125],[19.44062500000001,41.424755859375],[19.342382812500006,41.869091796875],[19.280664062500023,42.17255859375],[19.65449218750001,42.628564453124994],[20.06396484375,42.547265624999994]]]},"properties":{"name":"Albania","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[56.29785156250003,25.650683593750045],[56.38798828125002,24.97919921875004],[56.06386718750005,24.73876953125],[55.795703125000074,24.868115234374955],[55.76083984375006,24.24267578125],[55.1999023437501,23.034765625000034],[55.185839843750074,22.7041015625],[55.104296875000074,22.621484375000023],[52.55507812500005,22.932812499999955],[51.592578125000074,24.07885742187503],[51.56835937500003,24.286181640625074],[51.906054687500074,23.98535156249997],[52.64824218750002,24.154638671875006],[53.89335937500002,24.077050781249994],[54.39707031250006,24.278173828125034],[54.74677734375004,24.810449218750023],[55.09814453124997,25.041601562500034],[55.522851562499994,25.498144531249977],[55.94121093750002,25.793994140625017],[56.080468749999994,26.06264648437505],[56.29785156250003,25.650683593750045]]]},"properties":{"name":"United Arab Emirates","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-68.65322265624994,-54.85361328124999],[-68.62993164062499,-52.65263671875004],[-68.27822265625002,-52.98398437500004],[-68.00849609374995,-53.5640625],[-67.29423828125002,-54.049804687500014],[-65.34599609374993,-54.87792968749997],[-66.5111328125,-55.032128906249945],[-66.93046874999999,-54.92490234375004],[-68.65322265624994,-54.85361328124999]]],[[[-61.084716796875,-23.65644531250001],[-60.83984375000003,-23.85810546874997],[-59.89248046874994,-24.093554687499974],[-59.60859375000001,-24.26679687500001],[-59.372949218749966,-24.45390625000003],[-58.72402343750002,-24.786621093749957],[-58.519628906250034,-24.84287109375005],[-58.422802734374926,-24.894140625000006],[-58.365380859374966,-24.95927734374996],[-57.82167968749994,-25.136425781249983],[-57.58715820312494,-25.405078125000003],[-57.943115234375,-26.05292968750001],[-58.19130859375002,-26.629980468749977],[-58.31767578125002,-26.79589843750003],[-58.33466796875001,-26.824902343749983],[-58.32255859374993,-26.857617187499983],[-58.64174804687494,-27.196093750000017],[-58.60483398437498,-27.314355468750037],[-58.16826171874993,-27.27343749999997],[-57.11181640625,-27.47011718749998],[-56.437158203124966,-27.553808593749977],[-56.16406250000003,-27.321484374999983],[-55.789990234374926,-27.416406249999966],[-55.426660156249994,-27.00927734374997],[-54.934472656249994,-26.70253906250001],[-54.677734375,-26.308789062499997],[-54.631933593750006,-26.005761718749994],[-54.615869140624994,-25.576074218750023],[-54.15458984374999,-25.523046874999963],[-53.89116210937499,-25.66884765625001],[-53.67128906249994,-26.22509765625],[-53.83818359375002,-27.121093750000014],[-54.32700195312495,-27.423535156249997],[-54.82910156250003,-27.55058593750003],[-55.10151367187501,-27.866796874999963],[-55.72548828125002,-28.20410156250003],[-56.938623046874994,-29.594824218750034],[-57.60888671875003,-30.187792968750045],[-57.87250976562501,-30.591015625000026],[-57.81059570312499,-30.85859375000001],[-58.18901367187499,-31.924218750000037],[-58.12304687499997,-32.32187499999996],[-58.201171875,-32.471679687500014],[-58.219970703125,-32.563964843749986],[-58.17099609374998,-32.95927734374996],[-58.424462890624994,-33.11152343749998],[-58.54721679687498,-33.66347656249998],[-58.28334960937494,-34.68349609375005],[-57.303662109374926,-35.188476562499986],[-57.15888671875001,-35.505957031250006],[-57.35390624999994,-35.72031249999998],[-57.26499023437495,-36.14414062499999],[-56.698095703125006,-36.42646484375004],[-56.67202148437494,-36.85126953124998],[-57.39575195312494,-37.74462890625],[-57.546972656250034,-38.085644531250026],[-58.17919921874994,-38.435839843750045],[-59.82832031250001,-38.83818359375003],[-61.112207031249994,-38.99296875000003],[-62.06689453125,-38.91914062500001],[-62.33808593749998,-39.1505859375],[-62.053662109374955,-39.373828125],[-62.28691406249996,-39.89531250000002],[-62.39501953124997,-40.89082031249997],[-62.95903320312493,-41.10966796875006],[-63.77299804687493,-41.150000000000006],[-64.85297851562495,-40.81376953124999],[-65.13339843749998,-40.88066406250003],[-65.05908203125003,-41.96992187499998],[-64.42041015625003,-42.43378906249998],[-63.59589843750001,-42.40654296875003],[-63.69248046874998,-42.80527343749999],[-64.13066406249996,-42.86142578124998],[-64.65048828125,-42.53144531249998],[-65.02690429687496,-42.75888671874996],[-64.43222656250003,-43.059179687500034],[-64.98554687499995,-43.29355468749999],[-65.28359375000002,-43.62998046874996],[-65.36127929687495,-44.47734375000002],[-65.64760742187502,-44.661425781250045],[-65.63876953125,-45.0078125],[-66.19013671874995,-44.96474609375002],[-66.94140625,-45.25732421875003],[-67.556640625,-45.97011718750002],[-67.56337890624997,-46.34541015625001],[-66.77685546874994,-47.005859375],[-65.99853515625,-47.09374999999997],[-65.73808593749999,-47.34492187499998],[-65.81005859374997,-47.941113281250026],[-67.03310546875002,-48.627734375000024],[-67.68486328125002,-49.2466796875],[-67.78349609374996,-49.85888671875002],[-68.939453125,-50.382324218749986],[-69.23515625000002,-50.95058593750003],[-69.03251953124993,-51.63623046875],[-68.443359375,-52.35664062500004],[-69.96025390624993,-52.00820312500002],[-71.91865234374995,-51.98955078125004],[-72.40766601562501,-51.54082031250002],[-72.27631835937498,-50.910253906249984],[-72.50981445312496,-50.607519531250034],[-73.15292968749998,-50.73828125000003],[-73.50126953124996,-50.125292968750024],[-73.57626953124998,-49.582910156250016],[-72.61440429687494,-48.79287109375],[-72.35473632812497,-48.36582031250005],[-72.517919921875,-47.87636718749998],[-72.34594726562497,-47.49267578124997],[-71.90498046875001,-47.201660156250014],[-71.94023437499999,-46.831250000000054],[-71.69521484375,-46.57841796875006],[-71.87568359374998,-46.16054687500001],[-71.77265624999995,-45.724414062499974],[-71.35375976562497,-45.23046874999997],[-71.5962890625,-44.97919921875004],[-71.26113281250002,-44.763085937499966],[-71.21259765624998,-44.44121093750003],[-71.82001953124993,-44.38310546875],[-71.68007812500002,-43.92958984374998],[-71.90498046875001,-43.44013671875001],[-71.781494140625,-43.16679687500002],[-72.14643554687498,-42.990039062499974],[-72.12460937499998,-42.298339843750014],[-71.76093749999998,-42.101464843749966],[-71.91127929687497,-41.650390624999986],[-71.93212890624994,-40.69169921874999],[-71.69531250000003,-40.33525390625003],[-71.71992187499995,-39.63525390624997],[-71.53945312499997,-39.60244140624995],[-71.42558593749996,-38.98564453125006],[-70.95161132812493,-38.73847656249997],[-71.028173828125,-38.041210937500026],[-71.16757812499998,-37.76230468749996],[-71.05551757812498,-36.52373046874996],[-70.40478515625,-36.06171874999998],[-70.47041015624995,-35.32617187499997],[-70.28994140624997,-34.732812499999966],[-69.85244140625,-34.224316406250026],[-69.79775390624997,-33.398632812500026],[-70.01982421874999,-33.27148437499997],[-70.16962890624995,-32.471679687500014],[-70.585205078125,-31.569433593749963],[-70.51958007812493,-31.1484375],[-70.16142578124999,-30.44023437499996],[-69.95634765624996,-30.35820312500003],[-69.92763671874997,-29.76914062500002],[-70.02680664062501,-29.324023437500017],[-69.82788085937497,-29.10322265624997],[-69.65693359374995,-28.413574218749986],[-69.17441406249998,-27.924707031250037],[-68.84633789062494,-27.153710937499994],[-68.34599609374996,-27.02792968750005],[-68.58115234375,-26.518359374999974],[-68.41450195312498,-26.153710937500023],[-68.60029296874998,-25.48564453124999],[-68.38422851562495,-25.091894531249977],[-68.56201171875,-24.83769531249996],[-68.25029296875002,-24.391992187500023],[-67.35620117187503,-24.033789062499963],[-67.00878906249994,-23.00136718750005],[-67.19487304687493,-22.821679687500037],[-66.99111328125,-22.509863281250006],[-66.71171874999999,-22.216308593749986],[-66.36518554687501,-22.113769531249957],[-66.32246093750001,-22.053125000000037],[-66.28212890624997,-21.94746093750001],[-66.24760742187496,-21.83046874999998],[-66.22016601562495,-21.802539062499974],[-66.174658203125,-21.805664062499986],[-66.09858398437495,-21.83505859375002],[-66.05859375,-21.87949218750002],[-65.86015624999999,-22.019726562499983],[-65.77104492187493,-22.099609375000014],[-65.68618164062497,-22.11025390625005],[-65.05781249999995,-22.102734375000026],[-64.60551757812499,-22.228808593750045],[-64.52363281250001,-22.37158203125],[-64.47773437499998,-22.485351562499986],[-64.44550781249998,-22.585351562500023],[-64.37397460937498,-22.761035156250017],[-64.32529296875,-22.82763671875],[-64.30791015624993,-22.795312499999994],[-64.26640625000002,-22.60332031249996],[-63.97612304687502,-22.072558593750003],[-63.92167968749993,-22.028613281250017],[-63.81865234374999,-22.00546875000002],[-62.843359375000006,-21.997265625000026],[-62.62597656250003,-22.29042968749998],[-62.54155273437496,-22.349609374999957],[-62.37250976562498,-22.439160156249997],[-61.798535156249955,-23.182031249999994],[-61.084716796875,-23.65644531250001]]]]},"properties":{"name":"Argentina","childNum":2}},{"geometry":{"type":"Polygon","coordinates":[[[46.490624999999994,38.90668945312498],[46.1144531250001,38.877783203125034],[45.76630859375004,39.37846679687499],[45.03164062500005,39.76513671874997],[44.76826171875004,39.70351562500005],[44.28925781250004,40.040380859375006],[43.79169921875004,40.07026367187498],[43.56933593750003,40.48237304687498],[43.72265624999997,40.71953124999999],[43.43945312500003,41.10712890625001],[44.077246093750006,41.182519531249994],[44.227343750000074,41.213330078124955],[44.473046874999994,41.191015625000034],[44.56484375000005,41.20820312499998],[44.841406250000006,41.21137695312501],[44.84853515625005,41.22016601562501],[44.810937499999994,41.248583984375045],[44.81132812500002,41.259375000000006],[44.97587890625002,41.277490234374966],[45.001367187499994,41.29096679687498],[45.58750000000006,40.846923828125],[45.37617187500004,40.63808593750002],[45.96464843750002,40.233789062499966],[45.789648437500006,39.88110351562497],[46.5500000000001,39.20141601562497],[46.490624999999994,38.90668945312498]]]},"properties":{"name":"Armenia","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[69.18486328125002,-49.10957031250004],[69.915625,-49.348535156249966],[69.612890625,-49.65097656250003],[68.87207031249997,-49.44433593750003],[69.18486328125002,-49.10957031250004]]]},"properties":{"name":"France","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[145.04296875000003,-40.78671874999999],[145.28300781250002,-40.76992187500002],[146.31748046875006,-41.16347656250001],[146.98984375000006,-40.99238281249997],[147.45478515625004,-41.00166015624998],[147.96875000000003,-40.779589843750045],[148.29287109375,-40.947070312499974],[148.30146484375004,-42.03994140624995],[147.92441406250006,-42.5724609375],[147.980859375,-43.157031249999974],[147.40800781250002,-42.89384765625],[146.87392578125,-43.61250000000004],[146.04316406250004,-43.547167968749974],[145.26816406250006,-42.54433593749995],[145.23818359375,-42.01962890624999],[144.77792968750012,-41.41884765624998],[144.64609375000006,-40.98085937500001],[145.04296875000003,-40.78671874999999]]],[[[137.59648437500007,-35.73867187499998],[137.44843750000004,-36.07480468749999],[136.7550781250001,-36.03310546875002],[136.63867187499997,-35.74882812500002],[137.33408203125006,-35.59248046875004],[137.59648437500007,-35.73867187499998]]],[[[136.71464843750002,-13.803906249999983],[136.89433593750002,-14.293066406249977],[136.36328125000003,-14.228906249999966],[136.42470703125,-13.864843749999963],[136.71464843750002,-13.803906249999983]]],[[[130.6188476562501,-11.376074218749991],[131.26826171875004,-11.18984374999998],[131.53857421874997,-11.436914062500037],[130.95097656250007,-11.926464843750026],[130.644921875,-11.742382812500011],[130.6188476562501,-11.376074218749991]]],[[[143.17890625000004,-11.954492187499966],[143.11025390625,-12.303515625000017],[143.40156250000004,-12.639941406249989],[143.5866210937501,-13.443652343750031],[143.54843750000012,-13.74101562499996],[143.75634765625003,-14.348828124999969],[143.96181640625005,-14.462890625000028],[144.473046875,-14.231835937500023],[144.64804687500006,-14.492480468750017],[145.28769531250006,-14.943164062499989],[145.27158203125006,-15.476660156249963],[145.45800781250003,-16.05644531249996],[145.42607421875002,-16.406152343749966],[145.90195312500006,-17.070214843749994],[146.12587890625005,-17.63525390625],[146.03222656249997,-18.272851562500037],[146.3332031250001,-18.55371093749997],[146.48115234375004,-19.07871093749999],[147.13876953125006,-19.39316406250002],[147.41855468750012,-19.37812499999997],[147.91562500000006,-19.86923828125002],[148.75937500000006,-20.28955078125003],[148.68369140625012,-20.58017578124999],[149.20488281250007,-21.125097656249977],[149.70390625000002,-22.440527343750006],[150.07617187500003,-22.16445312499998],[150.54130859375002,-22.55908203125],[150.76386718750004,-22.576171875000014],[150.84316406250005,-23.4580078125],[151.50078125000002,-24.01240234374997],[151.902734375,-24.200976562500017],[152.12988281250003,-24.59755859374998],[152.45634765625007,-24.802441406249983],[152.91347656250005,-25.432128906250014],[153.16494140625,-25.964160156250045],[153.0841796875001,-26.303808593749963],[153.11679687500006,-27.194433593750034],[153.57568359375003,-28.24052734374999],[153.60458984375006,-28.854492187500014],[153.348046875,-29.29042968750001],[153.27236328125005,-29.89248046875001],[153.03056640625002,-30.563378906249994],[152.94394531250012,-31.43486328124999],[152.5592773437501,-32.045703125],[152.4704101562501,-32.439062500000034],[151.812890625,-32.90107421875001],[151.4837890625,-33.3474609375],[151.23154296875006,-34.02968749999998],[150.96035156250005,-34.29707031250001],[150.69033203125,-35.177734375000014],[150.19531249999997,-35.83359374999996],[149.96025390625002,-36.845507812499974],[149.93271484375012,-37.528515625000026],[149.29843750000012,-37.802148437499994],[148.26250000000002,-37.830664062500034],[147.39560546875006,-38.21914062499995],[146.8568359375,-38.663476562499966],[145.93535156250002,-38.90175781250002],[145.79082031250007,-38.66699218749997],[144.6652343750001,-38.20996093750003],[143.53896484375005,-38.82089843749998],[142.61210937500007,-38.451660156249986],[141.725,-38.27138671875002],[141.42421875,-38.36347656250004],[141.0109375000001,-38.07695312500003],[140.62724609375007,-38.02841796874999],[139.78427734375012,-37.24580078124998],[139.85732421875,-36.662109375],[139.54873046875,-36.0966796875],[139.03769531250006,-35.68925781249996],[138.18437500000002,-35.612695312499994],[138.5111328125,-35.02441406249996],[138.48994140625004,-34.76357421875002],[138.0892578125,-34.16982421875002],[137.69169921875002,-35.14296875000004],[136.88359375000007,-35.23974609375004],[137.01425781250012,-34.91582031250003],[137.39101562500005,-34.91328124999997],[137.49384765625004,-34.16113281250003],[137.9318359375001,-33.57910156250003],[137.85234375000007,-33.20078124999996],[137.44228515625,-33.1935546875],[137.23730468750003,-33.62949218749999],[136.43066406249997,-34.02998046875004],[135.64755859375006,-34.93964843750001],[135.18544921875005,-33.906738281249986],[134.79101562499997,-33.32832031250001],[134.30126953124997,-33.16503906249996],[134.10039062500007,-32.748632812500034],[134.23417968750007,-32.54853515625004],[133.55136718750012,-32.182910156249974],[133.21210937500004,-32.18378906249998],[132.75742187500012,-31.956249999999983],[132.21464843750002,-32.00712890624996],[131.72119140625003,-31.696289062499957],[131.14365234375006,-31.49570312500005],[130.78300781250002,-31.604003906249986],[130.12978515625,-31.579101562499986],[128.94619140625,-31.702636718750014],[128.06767578125002,-32.06650390624998],[127.31982421874997,-32.264062499999994],[125.91718750000004,-32.296972656250034],[124.75878906250003,-32.882714843749994],[124.12607421875006,-33.129394531249986],[123.65039062499997,-33.83632812500002],[123.20761718750012,-33.988281249999986],[122.7775390625001,-33.890820312500026],[121.40507812500007,-33.826757812500034],[119.85410156250012,-33.97470703124998],[119.45058593750005,-34.368261718750034],[118.89531250000007,-34.47988281250004],[118.13554687500002,-34.98662109374999],[117.58193359375005,-35.09775390624998],[116.51718750000012,-34.98789062499998],[115.98671875000005,-34.795019531250034],[115.7262695312501,-34.52607421875004],[115.00878906250003,-34.25585937499997],[115.18164062499997,-33.643457031249994],[115.5153320312501,-33.53134765624998],[115.68300781250005,-33.19287109375003],[115.6984375000001,-31.694531250000054],[115.17685546875006,-30.80800781250001],[114.99453125000005,-30.216210937499966],[114.95898437499997,-29.433593749999957],[114.53740234375007,-28.542871093750037],[114.16513671875012,-28.08066406250002],[114.02812500000007,-27.34726562499999],[113.58164062500006,-26.558105468749986],[113.85283203125007,-26.33212890625005],[113.58906250000004,-26.098632812499986],[113.539453125,-25.625195312499997],[114.21572265625,-26.289453124999966],[114.2142578125,-25.851562500000014],[113.67080078125,-24.97705078125003],[113.41767578125004,-24.435644531250034],[113.5529296875001,-23.732812500000023],[113.7570312500001,-23.418164062500054],[113.68281250000004,-22.637792968749963],[113.9583984375,-21.93916015625001],[114.16386718750002,-22.32333984375002],[114.37773437500007,-22.341503906249997],[114.85908203125004,-21.73593749999999],[115.45615234375012,-21.49169921874997],[116.0109375000001,-21.030371093749963],[116.7067382812501,-20.653808593749986],[117.40625000000003,-20.72119140625003],[118.19921875000003,-20.37519531249997],[118.75146484374997,-20.261914062499983],[119.10449218749997,-19.995312500000026],[119.58593750000003,-20.038281249999997],[120.87841796874997,-19.665039062499986],[121.49355468750005,-19.106445312499957],[121.83378906250002,-18.477050781249986],[122.23740234375006,-17.968554687500045],[122.16025390625006,-17.313671875000026],[122.72041015625004,-16.78769531249999],[122.97070312499997,-16.436816406250003],[123.52519531250007,-17.485742187499994],[123.77812500000007,-16.867773437499963],[123.4904296875001,-16.49072265624997],[124.5768554687501,-16.11367187499998],[124.38164062500002,-15.758203125000037],[124.83906250000004,-15.160742187500006],[125.24326171875006,-14.944531250000011],[125.17871093749997,-14.714746093749994],[125.68125000000012,-14.38798828124996],[126.0207031250001,-14.494531249999994],[126.11132812499997,-14.114062500000017],[126.5697265625,-14.160937499999974],[126.90322265625,-13.744140624999972],[127.67285156249997,-14.195117187500003],[128.19941406250004,-14.751757812499989],[129.45898437499997,-14.933203125000006],[129.75351562500006,-14.789550781249957],[129.37871093750002,-14.39248046874998],[129.70986328125,-13.979980468749972],[129.83886718749997,-13.572949218749997],[130.25976562500003,-13.30224609375],[130.1681640625001,-12.957421875000009],[130.67236328124997,-12.40693359375004],[131.43828125000002,-12.27695312500002],[132.37207031250003,-12.239160156249966],[132.58378906250002,-12.110253906249994],[132.6828125000001,-11.505566406249997],[133.02490234374997,-11.452832031249997],[133.18525390625004,-11.705664062499991],[133.90419921875,-11.832031249999972],[134.23710937500002,-12.00771484374998],[134.73027343750002,-11.984375000000014],[135.2179687500001,-12.221679687499957],[135.7884765625,-11.907031249999974],[136.08183593750007,-12.422460937500006],[136.5402343750001,-11.957617187499977],[136.94746093750004,-12.34990234374996],[136.53701171875,-12.784277343749991],[136.59433593750012,-13.003808593750051],[135.92734375000012,-13.304296874999977],[135.98955078125002,-13.810156250000006],[135.88339843750006,-14.153124999999974],[135.40517578125005,-14.758203124999966],[135.53076171874997,-15.000390625000023],[136.20537109375002,-15.403417968749963],[136.78466796874997,-15.89423828125004],[137.00214843750004,-15.878320312499994],[137.70371093750006,-16.233007812499963],[138.24501953125005,-16.718359374999977],[139.00986328125006,-16.899316406249994],[139.2484375,-17.328613281249957],[140.03583984375004,-17.702636718749957],[140.51113281250005,-17.62451171875003],[140.83046875,-17.414453125000037],[141.21914062500005,-16.646191406250026],[141.41191406250007,-16.069531250000054],[141.45156250000005,-15.605273437499974],[141.62548828124997,-15.056640625000014],[141.52294921875003,-14.470117187499994],[141.59433593750006,-14.152832031250014],[141.47255859375,-13.797558593750011],[141.64541015625,-13.259082031250003],[141.67773437500003,-12.491406250000011],[141.95156250000005,-11.896191406249997],[142.168359375,-10.946582031249974],[142.45644531250005,-10.707324218749989],[142.83681640625,-11.306933593750031],[142.87255859374997,-11.821386718750034],[143.17890625000004,-11.954492187499966]]]]},"properties":{"name":"Australia","childNum":5}},{"geometry":{"type":"Polygon","coordinates":[[[16.953125,48.598828125],[17.147363281250023,48.00595703125],[16.434375000000017,47.367431640625],[16.453417968750017,47.006787109375],[16.093066406250017,46.86328125],[15.957617187500006,46.677636718749994],[15.000683593750011,46.6259765625],[14.503515625000006,46.417041015624996],[13.700000000000017,46.520263671875],[13.490039062500017,46.555566406249994],[13.3515625,46.557910156249996],[13.168750000000017,46.572656249999994],[12.388281250000006,46.70263671875],[11.775683593750017,46.986083984375],[11.025097656250011,46.79697265625],[10.993261718750006,46.777001953124994],[10.927343750000006,46.769482421875],[10.828906250000017,46.775244140625],[10.759765625,46.793310546875],[10.689257812500017,46.84638671875],[10.579785156250011,46.8537109375],[10.479394531250023,46.855126953124994],[10.452832031250011,46.86494140625],[10.45458984375,46.8994140625],[10.414941406250023,46.964404296874996],[10.349414062500017,46.984765624999994],[9.996875000000017,46.8853515625],[9.580273437500011,47.057373046875],[9.527539062500011,47.270751953125],[9.524023437500006,47.524218749999996],[9.748925781250023,47.575537109375],[10.034082031250023,47.473583984375],[10.07421875,47.428515624999996],[10.066308593750023,47.393359374999996],[10.096484375000017,47.37958984375],[10.200292968750006,47.363427734374994],[10.312792968750017,47.313427734375],[10.403906250000006,47.4169921875],[10.430371093750011,47.541064453124996],[10.439453125,47.551562499999996],[10.482812500000023,47.541796874999996],[10.65869140625,47.547216796875],[10.873046875,47.52021484375],[11.297949218750006,47.42490234375],[11.716796875,47.58349609375],[12.685839843750017,47.669335937499994],[13.014355468750011,47.478076171874996],[12.953515625000023,47.890625],[13.215234375000023,48.301904296874994],[13.322851562500006,48.33125],[13.374609375000006,48.361376953124996],[13.409375000000011,48.394140625],[13.459863281250023,48.56455078125],[13.4716796875,48.571826171874996],[13.486621093750017,48.581835937499996],[13.675195312500023,48.523046875],[13.785351562500011,48.587451171874996],[13.798828125,48.6216796875],[13.802929687500011,48.747509765625],[13.814746093750017,48.766943359375],[14.049121093750017,48.602490234375],[14.691308593750023,48.59921875],[14.97216796875,48.983935546874996],[16.057226562500006,48.754785156249994],[16.477929687500023,48.800097656249996],[16.953125,48.598828125]]]},"properties":{"name":"Austria","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[46.1144531250001,38.877783203125034],[45.4796875000001,39.006249999999994],[44.81718750000002,39.65043945312496],[44.76826171875004,39.70351562500005],[45.03164062500005,39.76513671874997],[45.76630859375004,39.37846679687499],[46.1144531250001,38.877783203125034]]],[[[48.572851562500006,41.84448242187503],[49.10664062500004,41.30170898437504],[49.22646484375005,41.026220703125034],[49.77597656250006,40.583984375],[49.3244140625001,39.60834960937501],[49.36279296875003,39.349560546874955],[49.013476562500074,39.13398437500001],[48.86875000000006,38.43549804687498],[48.59267578125005,38.41108398437498],[48.02324218750002,38.81904296874998],[48.24199218750002,38.978955078124955],[47.995898437500074,39.683935546875034],[47.772851562499994,39.64858398437505],[46.490624999999994,38.90668945312498],[46.5500000000001,39.20141601562497],[45.789648437500006,39.88110351562497],[45.96464843750002,40.233789062499966],[45.37617187500004,40.63808593750002],[45.58750000000006,40.846923828125],[45.001367187499994,41.29096679687498],[45.217187499999994,41.423193359375006],[45.28095703125004,41.449560546875034],[46.086523437500006,41.183837890625],[46.43095703125002,41.077050781249994],[46.30546875000002,41.507714843749994],[46.42988281250004,41.890966796875006],[46.74931640625002,41.812597656250006],[47.26113281250005,41.315087890624994],[47.861132812500074,41.212744140625034],[48.572851562500006,41.84448242187503]]]]},"properties":{"name":"Azerbaijan","childNum":2}},{"geometry":{"type":"Polygon","coordinates":[[[30.553613281250023,-2.4000976562500114],[30.53369140625,-2.42626953125],[30.441992187500006,-2.6134765625000114],[30.424218750000023,-2.6416015625],[30.42402343750001,-2.824023437500003],[30.433496093750023,-2.87451171875],[30.515039062500023,-2.9175781250000057],[30.811132812500006,-3.1164062500000114],[30.400000000000006,-3.6539062500000057],[30.14716796875001,-4.0853515625000085],[29.947265625,-4.307324218750011],[29.7177734375,-4.455859375000003],[29.403222656250023,-4.449316406250006],[29.223242187500006,-3.9108398437500114],[29.224414062500017,-3.053515625000003],[29.01435546875001,-2.72021484375],[29.390234375000006,-2.80859375],[29.8681640625,-2.7164062500000057],[29.93017578125,-2.3395507812500114],[30.553613281250023,-2.4000976562500114]]]},"properties":{"name":"Burundi","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[5.693554687500011,50.774755859375006],[5.993945312500017,50.75043945312504],[6.364453125000011,50.31616210937503],[6.1165039062500455,50.120996093749966],[6.110058593750068,50.123779296875],[6.08906250000004,50.15458984374996],[5.976269531250068,50.167187499999955],[5.866894531250068,50.08281250000002],[5.817382812500028,50.01269531250003],[5.7880859375,49.96123046875002],[5.744042968749994,49.91962890624998],[5.73525390625008,49.875634765624994],[5.7408203125000625,49.85717773437506],[5.725781250000011,49.83334960937498],[5.725000000000023,49.80830078125004],[5.78798828125008,49.758886718750006],[5.8037109375,49.73217773437497],[5.880371093749972,49.64477539062503],[5.789746093749983,49.53828125000001],[4.867578125000051,49.78813476562502],[4.174609375000017,50.24648437500005],[2.8397460937500227,50.71176757812498],[2.52490234375,51.097119140624955],[3.35009765625,51.37768554687503],[3.9020507812500114,51.20766601562502],[4.226171875000034,51.38647460937503],[4.503417968750028,51.47470703124998],[5.827148437500057,51.125634765624994],[5.693554687500011,50.774755859375006]]]},"properties":{"name":"Belgium","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[3.5954101562500114,11.6962890625],[3.5539062500000114,11.631884765624989],[3.490527343750017,11.499218749999997],[3.48779296875,11.395410156249994],[3.6388671875000114,11.176855468749991],[3.7164062500000057,11.07958984375],[3.7568359375,10.768749999999997],[3.83447265625,10.607421875],[3.6465820312500057,10.408984374999989],[3.5572265625000057,9.907324218749991],[3.3251953125,9.778466796874994],[3.044921875,9.083837890624991],[2.7748046875000227,9.048535156249997],[2.703125,8.371826171875],[2.68603515625,7.873730468749997],[2.75048828125,7.395068359374989],[2.7213867187500114,6.980273437499989],[2.731738281250017,6.852832031249989],[2.7529296875,6.771630859374994],[2.7746093750000114,6.711718749999989],[2.753710937500017,6.661767578124994],[2.735644531250017,6.595703125],[2.7064453125000227,6.3692382812499915],[1.6226562500000057,6.216796875],[1.6001953125000057,9.050048828125],[1.42431640625,9.285009765624991],[1.330078125,9.996972656249994],[0.7799804687500114,10.359570312499997],[0.9004882812500057,10.993261718749991],[1.4267578125,11.447119140624991],[1.9803710937500227,11.418408203124997],[2.38916015625,11.897070312499991],[2.366015625000017,12.221923828125],[2.8781250000000114,12.367724609374989],[3.3599609375000057,11.880468749999991],[3.4498046875000057,11.851953124999994],[3.5954101562500114,11.6962890625]]]},"properties":{"name":"Benin","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[0.21748046875001137,14.911474609374991],[0.16386718750001705,14.497216796874994],[0.6181640625,13.703417968750003],[0.9777343750000114,13.551953124999997],[0.9873046875,13.041894531249994],[1.56494140625,12.635400390624994],[2.0738281250000057,12.713964843749991],[2.0914062500000057,12.277978515624994],[2.38916015625,11.897070312499991],[1.9803710937500227,11.418408203124997],[1.4267578125,11.447119140624991],[0.9004882812500057,10.993261718749991],[-0.068603515625,11.115624999999994],[-0.701416015625,10.988964843749997],[-2.8299316406249773,10.998388671874991],[-2.9148925781249773,10.592333984374989],[-2.78662109375,10.401904296874989],[-2.6958496093749886,9.481347656249994],[-2.7666015625,9.424707031249994],[-2.8167480468749773,9.425830078124989],[-3.2235351562499943,9.895458984374997],[-3.5811523437499773,9.92431640625],[-3.7906249999999773,9.917187499999997],[-4.18115234375,9.78173828125],[-4.267187499999977,9.743261718749991],[-4.332226562499983,9.645703124999997],[-4.406201171874983,9.647998046874989],[-4.526611328125,9.723486328124991],[-4.625830078124977,9.713574218749997],[-4.721777343749977,9.756542968749997],[-4.969921874999983,9.930078124999994],[-5.262304687499977,10.319677734374991],[-5.523535156249977,10.426025390625],[-5.457080078124989,10.771386718749994],[-5.490478515625,11.042382812499994],[-5.299853515624989,11.205957031249994],[-5.288134765624989,11.827929687499989],[-4.797949218749977,12.032128906249994],[-4.4287109375,12.337597656249997],[-4.480615234374994,12.672216796874991],[-4.227099609374989,12.793701171875],[-4.328710937499977,13.119042968749994],[-4.051171874999994,13.382421874999991],[-3.5757812499999773,13.194189453124991],[-3.3017578125,13.28076171875],[-3.198437499999983,13.6728515625],[-2.457226562499983,14.274121093749997],[-2.113232421874983,14.16845703125],[-1.767773437499983,14.486035156249997],[-1.049560546875,14.819531249999997],[-0.760449218749983,15.047753906249994],[-0.23588867187498863,15.059423828124991],[0.21748046875001137,14.911474609374991]]]},"properties":{"name":"Burkina Faso","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[88.94072265625002,26.24536132812497],[88.97041015625004,26.250878906250023],[88.95195312500002,26.412109375],[89.01865234375012,26.410253906249977],[89.10830078125005,26.202246093749977],[89.57275390625003,26.13232421875003],[89.8229492187501,25.94140625000003],[89.82490234375004,25.560156250000006],[89.80087890625012,25.33613281250001],[89.81406250000006,25.305371093749955],[89.86630859375012,25.293164062499955],[90.11962890625003,25.21997070312497],[90.61308593750002,25.16772460937497],[92.04970703125005,25.16948242187499],[92.38496093750004,24.848779296875023],[92.22666015625012,24.77099609374997],[92.11748046875002,24.493945312500017],[92.06416015625004,24.374365234375006],[91.72656250000003,24.20507812499997],[91.35019531250012,24.06049804687501],[91.16044921875007,23.66064453125],[91.35937500000003,23.06835937500003],[91.43623046875004,23.19990234375001],[91.75097656250003,23.053515625000017],[91.75419921875007,23.287304687499955],[91.79003906249997,23.361035156249983],[91.937890625,23.504687500000017],[91.92949218750007,23.598242187499977],[91.92958984375,23.68598632812501],[91.97851562500003,23.691992187499977],[92.04404296875006,23.677783203125017],[92.33378906250002,23.242382812499955],[92.36162109375002,22.929003906250074],[92.46445312500006,22.734423828125045],[92.49140625000004,22.685400390625006],[92.5612304687501,22.04804687500001],[92.57490234375004,21.978076171875045],[92.5934570312501,21.46733398437499],[92.17958984375005,21.293115234375023],[92.32412109375,20.791845703125063],[92.0560546875,21.1748046875],[92.0080078125001,21.684765624999983],[91.69296875000012,22.504785156249966],[91.48212890625004,22.79741210937499],[90.94560546875002,22.597021484375034],[90.63359375000002,23.09423828124997],[90.43505859374997,22.751904296874955],[90.58945312500012,22.258447265624966],[90.15878906250012,21.816845703124983],[89.81191406250005,21.983496093750006],[89.56855468750004,21.767431640625034],[89.09394531250004,21.872753906249983],[89.0500000000001,22.274609374999983],[88.92070312500002,22.632031249999955],[88.89970703125002,22.843505859375057],[88.72441406250002,23.254980468750034],[88.69765625,23.493017578125034],[88.56738281249997,23.674414062500034],[88.69980468750006,24.002539062500006],[88.71376953125,24.069628906250017],[88.72656250000003,24.186230468749955],[88.7335937500001,24.23090820312501],[88.72353515625,24.27490234375],[88.64228515625004,24.325976562500017],[88.49853515625003,24.34663085937504],[88.33750000000006,24.45385742187503],[88.22500000000005,24.460644531249983],[88.14550781250003,24.485791015624955],[88.07910156249997,24.549902343750063],[88.02343750000003,24.62783203125005],[88.03027343749997,24.66445312500005],[88.0451171875001,24.713037109374994],[88.1498046875,24.914648437500034],[88.57382812500006,25.187890624999994],[88.92978515625012,25.222998046875063],[88.94414062500002,25.290771484375],[88.85478515625002,25.333544921875017],[88.76914062500006,25.490478515625],[88.14746093749997,25.811425781250023],[88.1066406250001,25.841113281250045],[88.33398437499997,26.257519531249955],[88.44042968749997,26.369482421875034],[88.38623046875003,26.471533203125034],[88.35146484375005,26.482568359374966],[88.36992187500002,26.564111328124994],[88.41816406250004,26.57153320312497],[88.51826171875004,26.517773437499955],[88.68066406249997,26.352978515624955],[88.68281250000004,26.291699218749983],[88.94072265625002,26.24536132812497]]]},"properties":{"name":"Bangladesh","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[28.585351562500023,43.742236328124996],[28.465429687500006,43.389306640624994],[27.92890625000001,43.1861328125],[27.88886718750001,42.74970703125],[27.484765625000023,42.468066406249996],[27.982714843750017,42.047412109374996],[28.014453125000017,41.969042968749996],[27.879199218750017,41.986621093749996],[27.801660156250023,41.95654296875],[27.53486328125001,41.920800781249994],[27.47480468750001,41.946875],[27.362890625000006,42.025048828124994],[27.294921875,42.079541015625],[27.24433593750001,42.09326171875],[27.193359375,42.077099609375],[27.01171875,42.058642578124996],[26.96875,42.02685546875],[26.884863281250006,41.991845703124994],[26.800390625000006,41.975146484374996],[26.615332031250006,41.964892578124996],[26.549707031250023,41.896728515625],[26.066015625000006,41.673242187499994],[26.155175781250023,41.434863281249996],[25.92333984375,41.311914062499994],[25.784960937500017,41.330419921875],[25.723925781250017,41.3150390625],[25.52705078125001,41.2998046875],[25.381933593750006,41.26435546875],[25.25117187500001,41.243554687499994],[25.133398437500006,41.315771484375],[24.993554687500023,41.364990234375],[24.84687500000001,41.39423828125],[24.595996093750017,41.442724609375],[24.056054687500023,41.527246093749994],[24.03291015625001,41.469091796875],[24.011328125000006,41.46005859375],[23.973535156250023,41.452294921874994],[23.880859375,41.455957031249994],[23.635156250000023,41.386767578124996],[23.53583984375001,41.386035156249996],[23.433398437500017,41.398730468749996],[23.3720703125,41.3896484375],[23.239843750000006,41.3849609375],[23.15595703125001,41.322070312499996],[23.02558593750001,41.325634765625],[22.916015625,41.336279296875],[22.9296875,41.356103515624994],[22.951464843750017,41.605615234374994],[23.005664062500017,41.716943359374994],[22.836816406250023,41.993603515625],[22.344042968750017,42.31396484375],[22.42207031250001,42.328857421875],[22.445703125000023,42.359130859375],[22.523535156250006,42.440966796874996],[22.524218750000017,42.50390625],[22.43623046875001,42.6291015625],[22.463281250000023,42.70947265625],[22.465625000000017,42.750781249999996],[22.466796875,42.84248046875],[22.799902343750006,42.985742187499994],[22.976855468750017,43.18798828125],[22.85957031250001,43.252343749999994],[22.819726562500023,43.300732421875],[22.767578125,43.354150390624994],[22.554589843750023,43.454492187499994],[22.394824218750017,43.706640625],[22.38691406250001,43.740136718749994],[22.36962890625,43.781298828124996],[22.36542968750001,43.862109374999996],[22.399023437500006,43.969531249999996],[22.420800781250023,44.007421875],[22.469042968750017,44.018017578125],[22.597460937500017,44.07529296875],[22.705078125,44.23779296875],[23.224609375,43.873876953125],[25.4970703125,43.670800781249994],[26.2158203125,44.007275390625],[27.0869140625,44.167382812499994],[28.585351562500023,43.742236328124996]]]},"properties":{"name":"Bulgaria","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-77.74384765625001,24.707421874999994],[-78.04492187499997,24.287451171875063],[-78.298828125,24.753906250000057],[-78.03330078125,25.143115234375045],[-77.74384765625001,24.707421874999994]]]},"properties":{"name":"The Bahamas","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[19.007128906250045,44.86918945312502],[19.35683593750005,44.858544921874994],[19.15185546875003,44.302539062500045],[19.583789062500017,44.04345703125003],[19.19433593749997,43.533300781250006],[18.94023437499999,43.49672851562502],[18.85107421875003,43.34633789062502],[18.749218750000068,43.283544921875006],[18.67421875000008,43.230810546875006],[18.46601562500001,42.777246093749994],[18.436328125000017,42.559716796874994],[17.667578125000063,42.897119140624994],[17.585156250000068,42.93837890625005],[17.624804687500074,43.04277343749999],[16.214257812500023,44.21513671874999],[15.736621093750045,44.76582031250001],[15.788085937500057,45.17895507812497],[16.29335937500005,45.00883789062496],[16.53066406250008,45.21669921875002],[17.812792968750074,45.07812500000006],[18.66259765625,45.07744140624999],[19.007128906250045,44.86918945312502]]]},"properties":{"name":"Bosnia and Herzegovina","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[28.14794921875,56.142919921875],[28.284277343750006,56.055908203125],[29.375,55.938720703125],[29.39794921875,55.8810546875],[29.373144531250006,55.834716796875],[29.353417968750023,55.784375],[29.412988281250023,55.724853515625],[29.482226562500017,55.6845703125],[29.63007812500001,55.751171875],[29.6845703125,55.7697265625],[29.744140625,55.77041015625],[29.82392578125001,55.7951171875],[29.881640625000017,55.832324218749996],[29.93701171875,55.845263671874996],[30.04267578125001,55.83642578125],[30.23359375000001,55.84521484375],[30.625585937500006,55.666259765625],[30.906835937500006,55.57001953125],[31.12128906250001,54.648486328124996],[31.754199218750017,53.81044921875],[32.45097656250002,53.6533203125],[32.70429687500001,53.336328125],[31.849707031250006,53.106201171875],[31.668261718750017,53.200927734375],[31.417871093750023,53.196044921875],[31.38837890625001,53.184814453125],[31.364550781250017,53.138964843749996],[31.30292968750001,53.060888671875],[31.2587890625,53.01669921875],[31.585546875000006,52.532470703125],[31.57734375000001,52.312304687499996],[31.69062500000001,52.220654296875],[31.758593750000017,52.125830078125],[31.76337890625001,52.10107421875],[31.57373046875,52.10810546875],[31.345996093750017,52.10537109375],[30.98066406250001,52.046191406249996],[30.533007812500017,51.596337890624994],[30.449511718750017,51.274316406249994],[30.160742187500006,51.477880859375],[29.346484375000017,51.382568359375],[29.298828125,51.413037109375],[29.23046875,51.497021484375],[29.174218750000023,51.580615234374996],[29.135644531250023,51.61728515625],[29.10205078125,51.6275390625],[29.06074218750001,51.625439453125],[29.013085937500023,51.598925781249996],[28.97773437500001,51.57177734375],[28.793261718750017,51.5103515625],[28.731250000000017,51.433398437499996],[28.690234375000017,51.438867187499994],[28.647753906250017,51.45654296875],[28.599023437500023,51.542626953124994],[27.689746093750017,51.572412109374994],[27.141992187500023,51.75205078125],[25.785742187500006,51.923828125],[24.361914062500006,51.867529296875],[23.61376953125,51.525390625],[23.605273437500017,51.517919921875],[23.652441406250006,52.040380859375],[23.19697265625001,52.25693359375],[23.8447265625,52.664208984375],[23.887109375000023,53.0275390625],[23.484667968750017,53.939794921875],[24.191308593750023,53.950439453125],[24.236621093750017,53.919970703124996],[24.317968750000006,53.89296875],[24.768164062500006,53.974658203124996],[25.573046875000017,54.139892578125],[25.859277343750023,54.919287109375],[25.964453125000006,54.94716796875],[26.09296875000001,54.9623046875],[26.175195312500023,55.003271484375],[26.291796875000017,55.139599609375],[26.601171875000006,55.130175781249996],[26.775683593750017,55.273095703125],[26.681250000000006,55.306445312499996],[26.49531250000001,55.318017578125],[26.457617187500006,55.34248046875],[26.469531250000017,55.371923828125],[26.51923828125001,55.44814453125],[26.56660156250001,55.546484375],[26.5908203125,55.62265625],[26.593554687500017,55.667529296874996],[26.620214843750006,55.679638671875],[26.82246093750001,55.709228515625],[27.052539062500017,55.83056640625],[27.576757812500006,55.798779296875],[28.14794921875,56.142919921875]]]},"properties":{"name":"Belarus","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-89.2328125,15.888671875],[-89.16147460937503,17.814843749999994],[-88.80634765624998,17.965527343749983],[-88.52299804687499,18.445898437500063],[-88.29565429687494,18.47241210937503],[-88.09721679687502,18.121630859375074],[-88.27172851562494,17.60986328125],[-88.31342773437501,16.632763671874983],[-88.89404296875,15.890625000000028],[-89.2328125,15.888671875]]]},"properties":{"name":"Belize","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-58.15976562499999,-20.164648437500006],[-58.18017578125,-19.81787109375],[-59.09052734375,-19.286230468750006],[-60.00737304687499,-19.29755859375001],[-61.7568359375,-19.645312500000003],[-61.916943359375,-20.05537109375001],[-62.276318359375,-20.5625],[-62.27666015624999,-21.066015625000006],[-62.65097656249999,-22.233691406250003],[-62.84335937499999,-21.99726562500001],[-63.81865234374999,-22.005468750000006],[-63.92167968749999,-22.028613281250003],[-63.97612304687499,-22.072558593750003],[-64.26640624999999,-22.603320312500003],[-64.30791015624999,-22.79531250000001],[-64.32529296874999,-22.82763671875],[-64.373974609375,-22.761035156250003],[-64.4455078125,-22.58535156250001],[-64.477734375,-22.4853515625],[-64.5236328125,-22.37158203125],[-64.60551757812499,-22.228808593750003],[-65.0578125,-22.10273437500001],[-65.48486328125,-22.09814453125],[-65.686181640625,-22.11025390625001],[-65.77104492187499,-22.099609375],[-65.86015624999999,-22.01972656250001],[-66.05859375,-21.879492187500006],[-66.098583984375,-21.835058593750006],[-66.17465820312499,-21.8056640625],[-66.220166015625,-21.802539062500003],[-66.24760742187499,-21.83046875000001],[-66.28212890625,-21.94746093750001],[-66.3224609375,-22.05312500000001],[-66.365185546875,-22.11376953125],[-66.71171874999999,-22.21630859375],[-66.99111328125,-22.509863281250006],[-67.19487304687499,-22.82167968750001],[-67.362255859375,-22.85517578125001],[-67.57993164062499,-22.891699218750006],[-67.79443359375,-22.879492187500006],[-67.87944335937499,-22.82294921875001],[-67.88173828125,-22.49335937500001],[-67.950390625,-22.33369140625001],[-67.95390624999999,-22.20400390625001],[-67.98837890624999,-22.05712890625],[-68.07675781249999,-21.98281250000001],[-68.11215820312499,-21.753027343750006],[-68.18642578125,-21.61855468750001],[-68.197021484375,-21.30029296875],[-68.74516601562499,-20.458593750000006],[-68.75932617187499,-20.115527343750003],[-68.69829101562499,-19.72109375000001],[-68.462890625,-19.43281250000001],[-68.470166015625,-19.409960937500003],[-68.49199218749999,-19.381933593750006],[-68.85795898437499,-19.093359375000006],[-68.96831054687499,-18.96796875000001],[-68.97885742187499,-18.81298828125],[-69.026806640625,-18.65625],[-69.09228515625,-18.28242187500001],[-69.0939453125,-18.05048828125001],[-69.28232421874999,-17.96484375],[-69.31337890625,-17.943164062500003],[-69.35800781249999,-17.77167968750001],[-69.49501953125,-17.61953125000001],[-69.5109375,-17.50605468750001],[-69.62485351562499,-17.2001953125],[-69.020703125,-16.642187500000006],[-68.9134765625,-16.26191406250001],[-69.21757812499999,-16.14912109375001],[-69.41850585937499,-15.603417968750009],[-69.17246093749999,-15.236621093750003],[-69.37470703125,-14.962988281250006],[-69.23491210937499,-14.597070312500009],[-68.880322265625,-14.198828125000006],[-69.07412109375,-13.682812500000011],[-68.97861328124999,-12.880078125000011],[-68.68525390625,-12.501953125],[-69.57861328125,-10.951757812500006],[-68.84833984375,-11.011132812500009],[-68.678369140625,-11.11279296875],[-68.0716796875,-10.703125],[-67.99169921875,-10.674414062500006],[-67.83500976562499,-10.662792968750011],[-67.72177734374999,-10.68310546875],[-67.582421875,-10.505957031250006],[-67.416943359375,-10.389843750000011],[-67.33271484375,-10.35791015625],[-67.28046875,-10.317285156250009],[-67.1115234375,-10.268945312500009],[-66.72998046875,-9.975488281250009],[-66.575341796875,-9.89990234375],[-66.26357421875,-9.826074218750009],[-65.396142578125,-9.71240234375],[-65.31308593749999,-10.253027343750006],[-65.395458984375,-10.392285156250011],[-65.4369140625,-10.449023437500003],[-65.33403320312499,-10.892773437500011],[-65.32377929687499,-11.024804687500009],[-65.389892578125,-11.246289062500011],[-64.99252929687499,-11.975195312500006],[-64.513427734375,-12.2509765625],[-64.42050781249999,-12.439746093750003],[-63.93857421874999,-12.529687500000009],[-63.7880859375,-12.469433593750011],[-63.68857421874999,-12.47802734375],[-63.58564453125,-12.518945312500009],[-63.3466796875,-12.680078125000009],[-63.06748046874999,-12.669140625000011],[-62.76547851562499,-12.997265625000011],[-62.17607421874999,-13.133691406250009],[-62.11801757812499,-13.159765625000006],[-62.09477539062499,-13.241992187500003],[-61.944726562499994,-13.40625],[-61.87412109374999,-13.470410156250011],[-61.789941406249994,-13.525585937500011],[-61.57568359375,-13.524804687500009],[-61.51157226562499,-13.541210937500011],[-61.41606445312499,-13.526562500000011],[-61.129150390625,-13.49853515625],[-61.07700195312499,-13.48974609375],[-60.914501953125,-13.561425781250009],[-60.506591796875,-13.789843750000003],[-60.372705078124994,-14.418750000000003],[-60.17558593749999,-16.269335937500003],[-58.53793945312499,-16.328222656250006],[-58.49658203125,-16.32666015625],[-58.42368164062499,-16.307910156250003],[-58.345605468749994,-16.28437500000001],[-58.35039062499999,-16.490820312500006],[-58.470605468749994,-16.650195312500003],[-58.47812499999999,-16.70068359375],[-58.45981445312499,-16.910742187500006],[-58.417382812499994,-17.08056640625],[-58.39599609375,-17.23427734375001],[-57.832470703125,-17.51210937500001],[-57.780175781249994,-17.67177734375001],[-57.66166992187499,-17.947363281250006],[-57.58647460937499,-18.12226562500001],[-57.57402343749999,-18.279296875],[-57.80039062499999,-19.08095703125001],[-58.131494140624994,-19.74453125000001],[-58.15976562499999,-20.164648437500006]]]},"properties":{"name":"Bolivia","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-51.83251953124997,-1.4337890624999687],[-51.546044921874966,-0.6496093749999972],[-51.16074218749998,-0.6666992187500114],[-51.27631835937498,-1.0217773437499602],[-51.83251953124997,-1.4337890624999687]]],[[[-49.62866210937497,-0.22919921874996874],[-49.11699218749999,-0.1635742187500142],[-48.37968749999999,-0.35283203125001705],[-48.539697265624994,-0.8009765625000114],[-48.928906249999955,-1.4823242187499943],[-49.587890625,-1.7124023437499716],[-50.50761718749999,-1.7879882812500085],[-50.759765625,-1.2402343749999716],[-50.771386718749966,-0.6454101562500227],[-50.6455078125,-0.2728515624999801],[-50.24824218749998,-0.11640624999999716],[-49.62866210937497,-0.22919921874996874]]],[[[-59.69970703125,4.353515625],[-59.551123046875034,3.9335449218749687],[-59.854394531249994,3.5874999999999915],[-59.99433593749998,2.6899902343750313],[-59.75522460937495,2.27412109375004],[-59.74350585937498,2.12163085937496],[-59.75175781249996,1.9624023437500284],[-59.75620117187498,1.9006347656249716],[-59.666601562500006,1.7462890624999687],[-59.59663085937498,1.7180175781249858],[-59.53569335937499,1.7000000000000455],[-59.23120117187494,1.3760253906250313],[-58.968505859375,1.3045898437500512],[-58.91660156249998,1.2488769531249773],[-58.86249999999998,1.2036132812499858],[-58.511865234374966,1.2846679687499858],[-58.506054687499926,1.4386718750000114],[-58.39580078124993,1.4817382812499886],[-58.38037109375,1.5302246093750114],[-58.34067382812498,1.5875488281250512],[-58.03466796875,1.5202636718750142],[-57.982812499999994,1.6484375000000142],[-57.79565429687497,1.7000000000000455],[-57.691748046875034,1.7047851562500398],[-57.59443359375001,1.7041015624999858],[-57.500439453124955,1.77382812499998],[-57.412695312500034,1.9089355468749716],[-57.366796875000006,1.9401367187500256],[-57.31748046874998,1.9634765624999915],[-57.11889648437494,2.0139648437499744],[-57.03759765625,1.9364746093749972],[-56.96953124999999,1.9164062499999943],[-56.48281249999994,1.9421386718749858],[-56.019921874999966,1.842236328124983],[-56.12939453124997,2.2995117187499687],[-56.08779296875002,2.3413085937500426],[-56.02036132812498,2.392773437500054],[-55.935937499999994,2.516601562500057],[-55.730566406250006,2.4061523437500227],[-55.385351562500006,2.4406250000000256],[-55.34399414062503,2.4887695312499716],[-55.28603515625002,2.49965820312498],[-55.18769531249998,2.547509765625037],[-55.114111328125006,2.539208984375037],[-55.07031249999994,2.5483398437500284],[-55.005810546874955,2.592968749999983],[-54.97866210937502,2.5976562500000426],[-54.968408203124966,2.5483398437500284],[-54.92656249999999,2.4973632812500455],[-54.876074218750006,2.4503906249999687],[-54.851660156250006,2.4395507812499915],[-54.76684570312503,2.454736328124966],[-54.72221679687499,2.4416503906249716],[-54.69741210937502,2.359814453124997],[-54.66186523437497,2.3275390624999943],[-54.61625976562499,2.3267578125000057],[-54.59194335937502,2.3137695312500313],[-54.55048828125001,2.2930664062499915],[-54.51508789062498,2.245458984374963],[-54.13007812499998,2.1210449218750256],[-53.76777343749998,2.3548339843750483],[-52.96484375,2.1835449218749687],[-52.70063476562501,2.36367187499998],[-51.99062499999994,3.702001953124963],[-51.65253906249998,4.061279296874972],[-51.46152343749998,4.313769531249989],[-51.219921874999955,4.0936035156249915],[-51.05239257812502,3.2818359374999915],[-50.65893554687497,2.1309570312500057],[-50.458886718749994,1.8295898437499716],[-49.957128906250006,1.6598632812500398],[-49.898876953124955,1.16298828124998],[-50.29443359374997,0.8357421875000028],[-50.81635742187498,0.17255859374999716],[-51.28291015625001,-0.08520507812502842],[-51.70263671874997,-0.7623046874999488],[-51.94755859374996,-1.586718749999946],[-51.29736328125003,-1.223535156250037],[-50.917871093749966,-1.115234375],[-50.690039062500006,-1.7617187499999858],[-50.40322265625002,-2.0155273437500085],[-49.999218749999955,-1.8318359374999744],[-49.71953125000002,-1.926367187499963],[-49.31367187500001,-1.7317382812500028],[-48.99130859374998,-1.8297851562499972],[-48.11508789062498,-0.7374999999999545],[-47.39809570312502,-0.6266601562500256],[-46.81123046875001,-0.7796875000000227],[-46.61723632812502,-0.9706054687500227],[-46.219140624999994,-1.0312500000000284],[-45.64477539062497,-1.3478515624999545],[-45.07636718749998,-1.4664062499999488],[-44.651269531249966,-1.7458007812500256],[-44.30815429687496,-2.53515625],[-43.93291015624999,-2.583496093749986],[-42.93671874999998,-2.4650390625000114],[-42.24960937499998,-2.7919921875],[-41.876171874999926,-2.746582031249986],[-41.318212890625034,-2.936230468749997],[-40.474560546874926,-2.7956054687500256],[-39.96469726562498,-2.8615234374999545],[-38.475781249999955,-3.717480468749997],[-38.04882812500003,-4.216406250000034],[-37.174658203125006,-4.912402343749974],[-36.590722656249966,-5.097558593749952],[-35.979882812499966,-5.05439453125004],[-35.549414062500006,-5.129394531249957],[-35.235449218750006,-5.56669921874996],[-34.988183593749994,-6.393749999999969],[-34.80546874999999,-7.288378906249974],[-34.83466796874998,-7.97148437499996],[-35.15776367187499,-8.930566406249952],[-35.34086914062499,-9.230664062499983],[-36.39833984374994,-10.484082031249983],[-36.93779296874999,-10.820410156250034],[-37.41181640625001,-11.497265624999983],[-37.68872070312503,-12.100000000000037],[-38.23974609375003,-12.844238281249957],[-38.787988281249966,-12.782714843750028],[-38.835302734375034,-13.147167968750026],[-39.08935546875,-13.588183593749989],[-38.94233398437498,-14.030664062499994],[-39.05957031249997,-14.654785156249957],[-38.88061523437503,-15.864257812499972],[-39.215234374999966,-17.315820312500023],[-39.154003906249926,-17.70390625000003],[-39.486767578124955,-17.990136718749994],[-39.73979492187499,-18.639843750000026],[-39.69985351562502,-19.27783203124997],[-40.001367187499994,-19.74199218750003],[-40.39594726562501,-20.56943359375002],[-40.78925781250001,-20.90605468750003],[-41.047265624999994,-21.505664062499974],[-41.122509765624955,-22.08437500000001],[-41.70551757812498,-22.30966796874999],[-41.980419921874955,-22.580664062499963],[-42.042382812499966,-22.947070312500003],[-42.95830078124996,-22.96708984374999],[-43.532812500000006,-23.046386718749986],[-43.86616210937498,-22.910546875000023],[-44.63725585937496,-23.05546874999996],[-45.423291015624955,-23.68535156250003],[-45.97207031250002,-23.795507812500006],[-46.86728515624998,-24.236328125000014],[-47.87656249999998,-24.99746093750001],[-48.54516601562503,-25.815917968750043],[-48.67773437499994,-26.702929687500003],[-48.55415039062498,-27.195996093749997],[-48.62080078124998,-28.075585937499966],[-48.799658203125006,-28.575292968749977],[-49.27128906249999,-28.87119140625005],[-49.745996093749966,-29.363183593749994],[-50.299511718749955,-30.42578125000003],[-51.15727539062499,-30.364257812500014],[-51.46367187499996,-31.052636718750023],[-51.97246093749999,-31.383789062499986],[-52.19355468749998,-31.885546874999974],[-52.12739257812501,-32.1677734375],[-52.652246093749994,-33.137792968750006],[-53.37060546874997,-33.74218750000003],[-53.39755859374995,-33.737304687500014],[-53.46357421875001,-33.70986328125002],[-53.51884765624999,-33.67724609375004],[-53.531347656250034,-33.65546875000004],[-53.53764648437499,-33.622851562499974],[-53.531347656250034,-33.1708984375],[-53.39521484375001,-33.01035156249998],[-53.21406249999998,-32.82109374999996],[-53.12558593749998,-32.73671875000001],[-53.601708984374994,-32.40302734374997],[-53.76171875,-32.05683593749997],[-53.920605468749926,-31.952343749999997],[-54.220556640625034,-31.855175781249997],[-54.58764648437503,-31.48515625000003],[-54.89599609374997,-31.391210937499977],[-55.036035156249994,-31.27900390625004],[-55.091162109375034,-31.31396484374997],[-55.173535156249926,-31.279589843749974],[-55.25463867187503,-31.225585937499986],[-55.36606445312498,-31.04619140625003],[-55.449560546875034,-30.96445312499999],[-55.557324218749955,-30.8759765625],[-55.62714843749998,-30.858105468749997],[-55.650488281250034,-30.89208984375],[-55.66523437500001,-30.92490234375002],[-55.705957031249966,-30.94658203124999],[-55.75634765625,-30.98710937499999],[-55.807763671874994,-31.036718749999977],[-55.87368164062502,-31.069628906250017],[-55.95200195312498,-31.08085937499999],[-56.00468749999996,-31.079199218750006],[-56.015527343749966,-31.059667968750034],[-56.01845703125002,-30.991894531249983],[-55.998974609374955,-30.837207031250003],[-56.4072265625,-30.44746093750001],[-56.83271484374998,-30.107226562499974],[-57.21445312499995,-30.283398437499983],[-57.60888671875003,-30.187792968750045],[-56.938623046874994,-29.594824218750034],[-55.72548828125002,-28.20410156250003],[-55.10151367187501,-27.866796874999963],[-54.82910156250003,-27.55058593750003],[-54.32700195312495,-27.423535156249997],[-53.83818359375002,-27.121093750000014],[-53.67128906249994,-26.22509765625],[-53.89116210937499,-25.66884765625001],[-54.15458984374999,-25.523046874999963],[-54.615869140624994,-25.576074218750023],[-54.47314453124997,-25.22021484375],[-54.281005859375,-24.30605468750001],[-54.31826171874994,-24.128124999999997],[-54.26689453124996,-24.06582031250001],[-54.241796875000006,-24.047265624999966],[-54.44023437500002,-23.90175781249998],[-54.62548828125,-23.8125],[-54.98266601562494,-23.974511718749966],[-55.081884765625006,-23.997656249999977],[-55.1943359375,-24.017480468750023],[-55.28691406249993,-24.004296874999994],[-55.366308593750034,-23.99101562499996],[-55.41591796875002,-23.95136718749997],[-55.4423828125,-23.86533203125002],[-55.4423828125,-23.792578125000034],[-55.458886718749966,-23.686718750000054],[-55.65405273437494,-22.81035156250003],[-55.627587890624966,-22.74091796875001],[-55.61767578125,-22.67148437499999],[-55.64741210937501,-22.621875000000003],[-55.70366210937502,-22.592089843749974],[-55.74663085937499,-22.51269531249997],[-55.753271484375006,-22.410156250000043],[-55.84916992187499,-22.307617187500014],[-56.18984374999994,-22.28115234375005],[-56.35185546874999,-22.178613281250023],[-56.52382812499994,-22.102539062499986],[-56.63300781249998,-22.23486328125003],[-56.77519531249999,-22.261328125000006],[-57.23823242187501,-22.195214843750037],[-57.56894531249998,-22.18193359374999],[-57.721093749999966,-22.09921875000002],[-57.76406250000002,-22.109179687500003],[-57.82031250000003,-22.142285156249997],[-57.94267578124999,-21.79833984375],[-57.830224609374994,-20.99794921875001],[-58.15976562499998,-20.164648437499977],[-58.131494140624994,-19.74453125000001],[-57.80039062499995,-19.08095703125001],[-57.57402343749993,-18.279296875000014],[-57.58647460937499,-18.122265624999997],[-57.66166992187493,-17.94736328124999],[-57.78017578125002,-17.67177734374998],[-57.83247070312501,-17.512109375000037],[-58.39599609374997,-17.234277343750023],[-58.417382812499994,-17.08056640624997],[-58.459814453125006,-16.910742187500006],[-58.478125000000006,-16.70068359375003],[-58.470605468749994,-16.650195312500045],[-58.35039062500002,-16.49082031249999],[-58.34560546875002,-16.284375000000026],[-58.423681640625034,-16.30791015625003],[-58.49658203124994,-16.32666015625003],[-58.537939453125034,-16.32822265624999],[-60.17558593749996,-16.26933593749999],[-60.372705078124994,-14.418750000000003],[-60.506591796875,-13.78984374999996],[-60.914501953124955,-13.561425781249966],[-61.077001953125034,-13.489746093750014],[-61.129150390625,-13.498535156250028],[-61.41606445312502,-13.526562499999969],[-61.511572265625006,-13.541210937500011],[-61.789941406249966,-13.525585937500026],[-61.87412109374998,-13.470410156249983],[-61.944726562499966,-13.406249999999972],[-62.09477539062499,-13.241992187499989],[-62.118017578125006,-13.15976562500002],[-62.17607421874993,-13.133691406250037],[-62.35283203124999,-13.132421874999963],[-62.765478515625034,-12.99726562500004],[-63.01518554687502,-12.80556640624998],[-63.067480468750006,-12.669140624999983],[-63.34667968749994,-12.680078124999994],[-63.585644531249955,-12.518945312500037],[-63.68857421874998,-12.478027343749957],[-63.7880859375,-12.469433593749983],[-63.938574218750006,-12.529687499999994],[-64.42050781249995,-12.439746093749974],[-64.51342773437497,-12.250976562499972],[-64.99252929687498,-11.975195312500006],[-65.389892578125,-11.246289062500011],[-65.33403320312499,-10.892773437500026],[-65.43999023437499,-10.586230468750017],[-65.4369140625,-10.449023437499946],[-65.39545898437498,-10.392285156250026],[-65.31308593749998,-10.253027343749991],[-65.39614257812494,-9.712402343749986],[-66.26357421875,-9.826074218749966],[-66.57534179687502,-9.899902343749986],[-66.72998046875,-9.975488281250023],[-67.11152343750001,-10.268945312500037],[-67.28046874999995,-10.317285156250023],[-67.33271484374995,-10.357910156249957],[-67.41694335937495,-10.389843749999969],[-67.58242187500002,-10.505957031250006],[-67.72177734374998,-10.683105468749943],[-67.83500976562496,-10.662792968749983],[-67.99169921875,-10.674414062499949],[-68.07167968749994,-10.703125000000028],[-68.678369140625,-11.11279296875],[-68.84833984374998,-11.01113281249998],[-69.228515625,-10.955664062499963],[-69.96035156249997,-10.92988281250004],[-70.642333984375,-11.010253906249986],[-70.59916992187499,-9.620507812500009],[-71.11528320312499,-9.852441406250009],[-71.237939453125,-9.966015624999955],[-72.18159179687495,-10.003710937500003],[-72.37905273437497,-9.510156249999994],[-73.20942382812493,-9.411425781249946],[-73.08984375,-9.26572265625002],[-72.970361328125,-9.120117187500028],[-72.97402343750002,-8.9931640625],[-73.07050781249995,-8.8828125],[-73.20312499999997,-8.719335937499991],[-73.30244140624995,-8.654003906250011],[-73.36040039062496,-8.479296875000031],[-73.39814453125001,-8.458984374999986],[-73.43588867187498,-8.42705078124996],[-73.54912109374993,-8.34580078125002],[-73.77558593749998,-7.9364257812500085],[-73.72041015624993,-7.782519531250017],[-73.76689453124999,-7.753515624999963],[-73.82207031249996,-7.738964843750026],[-73.89462890624998,-7.654785156250014],[-73.94687499999998,-7.611230468750023],[-73.98173828124996,-7.58505859375002],[-74.00205078125003,-7.556054687499966],[-73.98173828124996,-7.535742187500006],[-73.95849609374994,-7.506640625000031],[-73.96430664062498,-7.378906250000028],[-73.74946289062498,-7.335351562500037],[-73.79301757812499,-7.135058593750003],[-73.75810546874999,-6.90576171875],[-73.137353515625,-6.4658203125],[-73.23554687500001,-6.098437500000017],[-73.209375,-6.028710937500023],[-73.16289062499996,-5.933398437499974],[-72.97988281249997,-5.6348632812499915],[-72.88706054687498,-5.122753906250026],[-72.83193359374994,-5.093749999999972],[-72.69873046874997,-5.067187499999989],[-72.60834960937495,-5.009570312499974],[-72.46899414062497,-4.901269531250023],[-72.35283203124993,-4.786035156249994],[-72.25678710937501,-4.74892578124998],[-71.8447265625,-4.504394531249986],[-70.97368164062499,-4.350488281249994],[-70.86601562499999,-4.229589843749963],[-70.79951171874995,-4.173339843749957],[-70.72158203124997,-4.15888671875004],[-70.53066406249997,-4.167578125000034],[-70.40463867187498,-4.150097656250026],[-69.96591796875003,-4.235937500000006],[-69.66904296875003,-2.667675781249997],[-69.40024414062498,-1.1949218749999773],[-69.66748046874997,-0.48242187499995737],[-70.07050781249993,-0.1388671875000398],[-70.05390624999993,0.5786132812500284],[-69.16323242187502,0.8640625000000028],[-69.36137695312496,1.0640136718749744],[-69.85214843750003,1.0595214843750398],[-69.84858398437493,1.7087402343750426],[-68.17656249999999,1.7198242187499915],[-67.815087890625,1.790087890625017],[-67.35195312499997,2.085839843750051],[-66.87602539062499,1.223046875000037],[-66.42924804687502,0.8216796874999801],[-66.06005859375003,0.7853515625000398],[-65.68144531249999,0.9834472656249886],[-65.36083984374994,0.8686523437500568],[-65.10375976562497,1.108105468749983],[-64.11484375000003,1.619287109375037],[-64.03544921874993,1.904443359375037],[-63.393945312499994,2.2225097656250057],[-63.389257812500006,2.4119140625000455],[-63.924169921875006,2.4524414062500313],[-64.21884765625,3.2046874999999915],[-64.22109375000002,3.5874023437499716],[-64.56791992187496,3.8998046875000227],[-64.25566406249996,4.140332031249997],[-64.02148437500003,3.929101562500051],[-63.29472656249993,3.92226562499998],[-62.96865234374994,3.593945312499983],[-62.71210937499998,4.01791992187502],[-62.15312499999996,4.098388671874986],[-61.00283203125002,4.5352539062499915],[-60.60449218749994,4.99458007812504],[-60.671972656250034,5.164355468749989],[-60.71196289062499,5.191552734375023],[-60.742138671874926,5.202050781250037],[-60.6513671875,5.221142578125011],[-60.576416015625,5.192480468750034],[-60.45952148437499,5.188085937500034],[-60.40878906249998,5.210156249999997],[-60.33520507812497,5.199316406250006],[-60.14204101562498,5.238818359374974],[-59.990673828124955,5.0828613281249915],[-60.03178710937499,4.740527343749974],[-60.12456054687496,4.59765625],[-60.14863281249998,4.533251953125031],[-60.11113281249999,4.511181640624969],[-59.69970703125,4.353515625]]]]},"properties":{"name":"Brazil","childNum":3}},{"geometry":{"type":"Polygon","coordinates":[[[115.02675781250005,4.899707031249989],[114.74667968750006,4.718066406250017],[114.84023437500005,4.3932128906250085],[114.60830078125005,4.023974609375017],[114.0638671875,4.592675781249966],[114.29941406250012,4.607177734374986],[115.02675781250005,4.899707031249989]]]},"properties":{"name":"Brunei","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[91.63193359375003,27.759960937499997],[91.5947265625,27.557666015624996],[91.74306640625002,27.442529296874994],[91.85126953125001,27.438623046874994],[91.95097656249999,27.458300781249996],[91.99082031250003,27.4501953125],[92.044921875,27.364697265624997],[92.08339843750002,27.290625],[92.03115234375002,27.214306640624997],[91.99228515625003,27.099902343749996],[92.07343750000001,26.914843749999996],[92.04970703125002,26.874853515625],[91.99833984374999,26.85498046875],[91.84208984374999,26.852978515624997],[91.67158203125001,26.802001953125],[90.73964843750002,26.771679687499997],[90.34589843750001,26.890332031249997],[90.2060546875,26.847509765625],[90.12294921875002,26.754589843749997],[89.94316406249999,26.723925781249996],[89.76386718750001,26.701562499999994],[89.60996093750003,26.719433593749997],[89.33212890625003,26.8486328125],[89.14824218749999,26.816162109375],[88.85761718750001,26.961474609374996],[88.73876953125,27.175585937499996],[88.76035156250003,27.218115234375],[88.88164062499999,27.2974609375],[88.89140624999999,27.316064453124994],[88.94755859374999,27.464013671874994],[89.53691406249999,28.107421875],[89.65273437500002,28.15830078125],[89.74980468749999,28.188183593749997],[89.81689453125,28.256298828124997],[89.89785156250002,28.294140624999997],[89.98105468750003,28.311181640624994],[90.35273437500001,28.080224609374994],[90.47734374999999,28.070849609374996],[90.71572265625002,28.071728515624997],[91.07773437500003,27.974462890625],[91.22587890624999,28.071240234374997],[91.27304687500003,28.078369140625],[91.60556640625003,27.951708984374996],[91.64189453124999,27.923242187499994],[91.63193359375003,27.759960937499997]]]},"properties":{"name":"Bhutan","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[25.2587890625,-17.793554687500006],[25.224023437500023,-17.91523437500001],[25.76123046875,-18.649218750000003],[26.168066406250006,-19.53828125000001],[26.67822265625,-19.89277343750001],[27.221484375000017,-20.145800781250003],[27.28076171875,-20.47871093750001],[27.699609375000023,-20.53066406250001],[27.66943359375,-21.064257812500003],[28.04560546875001,-21.573046875000003],[29.03730468750001,-21.811328125000003],[29.106835937500023,-22.065722656250003],[29.237207031250023,-22.07949218750001],[29.315234375000017,-22.15771484375],[29.364843750000006,-22.193945312500006],[29.1298828125,-22.21328125000001],[29.013476562500017,-22.278417968750006],[28.94580078125,-22.395117187500006],[28.83984375,-22.48085937500001],[28.21015625000001,-22.693652343750003],[27.812597656250006,-23.108007812500006],[27.7685546875,-23.14892578125],[27.146386718750023,-23.5244140625],[27.085546875000006,-23.577929687500003],[26.98701171875001,-23.70458984375],[26.835058593750006,-24.240820312500006],[26.617773437500006,-24.3955078125],[26.501562500000006,-24.513281250000006],[26.451757812500006,-24.58271484375001],[26.39716796875001,-24.613574218750003],[25.912109375,-24.74746093750001],[25.518164062500006,-25.66279296875001],[24.748144531250006,-25.8173828125],[24.33056640625,-25.74287109375001],[24.192968750000006,-25.632910156250006],[23.969531250000017,-25.626074218750006],[23.89375000000001,-25.600878906250003],[23.670703125000017,-25.43398437500001],[23.521484375,-25.34443359375001],[23.148730468750017,-25.288671875000006],[22.878808593750023,-25.45791015625001],[22.79609375000001,-25.67910156250001],[22.72900390625,-25.85732421875001],[22.640234375000006,-26.07119140625001],[22.217578125000017,-26.38886718750001],[22.090917968750006,-26.580175781250006],[22.01093750000001,-26.635839843750006],[21.91455078125,-26.661914062500003],[21.83320312500001,-26.678320312500006],[21.78828125000001,-26.710058593750006],[21.738085937500017,-26.80683593750001],[21.694726562500023,-26.840917968750006],[21.646289062500017,-26.85419921875001],[20.739843750000006,-26.84882812500001],[20.641406250000017,-26.7421875],[20.79316406250001,-25.915625000000006],[20.34521484375,-25.029882812500006],[19.98046875,-24.77675781250001],[19.977343750000017,-22.00019531250001],[20.970996093750017,-22.00019531250001],[20.976171875000006,-19.74433593750001],[20.97412109375,-18.31884765625],[23.298632812500017,-18.02734375],[23.58056640625,-18.452929687500003],[24.358984375000006,-17.97822265625001],[25.2587890625,-17.793554687500006]]]},"properties":{"name":"Botswana","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[22.86005859375001,10.919677734375],[23.312304687500017,10.387939453125],[23.646289062500017,9.822900390624994],[23.53730468750001,8.815820312499994],[24.147363281250023,8.665624999999991],[24.291406250000023,8.291406249999994],[24.853320312500017,8.137548828124991],[25.247363281250017,7.724560546874997],[25.380664062500017,7.333398437499994],[25.888964843750017,7.06494140625],[26.36181640625,6.635302734374989],[26.514257812500006,6.069238281249994],[27.083398437500023,5.77685546875],[27.4033203125,5.109179687499989],[27.11494140625001,5.1978515624999915],[26.822070312500017,5.062402343749994],[25.52509765625001,5.3121093749999915],[25.249316406250017,5.024560546874994],[24.765527343750023,4.930078124999994],[24.31982421875,4.994140625],[23.41718750000001,4.663134765624989],[22.755761718750023,4.646679687499997],[22.422167968750017,4.134960937499997],[21.53759765625,4.244824218749997],[20.55810546875,4.462695312499989],[20.226367187500017,4.829638671874989],[19.806542968750023,5.089306640624997],[19.5009765625,5.127490234374989],[19.06855468750001,4.891406249999989],[18.567480468750006,4.257568359375],[18.6103515625,3.4784179687499943],[18.160937500000017,3.4998046874999886],[17.43798828125,3.6846191406249886],[16.67333984375,3.5352050781249886],[16.468554687500017,2.831738281249997],[16.183398437500017,2.2700683593749886],[16.0634765625,2.9085937499999943],[15.775000000000006,3.127197265625],[15.128710937500017,3.826904296875],[15.022753906250017,4.358544921874994],[14.708984375,4.665576171874989],[14.616894531250011,5.865136718749994],[14.7392578125,6.27978515625],[15.245898437500017,7.263574218749994],[15.480078125000006,7.5237792968749915],[15.845019531250017,7.475292968749997],[16.37890625,7.683544921874997],[16.784765625000006,7.550976562499997],[17.6494140625,7.983593749999997],[18.455078125,8.032031249999989],[19.108691406250017,8.656152343749994],[19.1455078125,9.015966796874991],[20.342089843750017,9.127099609374994],[20.773242187500017,9.405664062499994],[21.26386718750001,9.974609375],[21.72578125000001,10.366552734374991],[21.70654296875,10.574804687499991],[22.49384765625001,10.996240234374994],[22.86005859375001,10.919677734375]]]},"properties":{"name":"Central African Republic","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-61.10517578124998,45.94472656250002],[-60.80610351562498,45.73808593750002],[-60.50493164062502,46.20385742187497],[-59.86503906249993,46.159521484375006],[-60.38608398437495,45.65463867187498],[-61.28369140624994,45.573876953124966],[-61.49531249999998,45.94145507812499],[-60.87016601562499,46.796777343749966],[-60.33173828124998,46.76782226562503],[-60.57685546875001,46.17216796874999],[-61.10517578124998,45.94472656250002]]],[[[-63.811279296875,46.46870117187501],[-63.12939453125,46.422216796875034],[-62.16357421874997,46.487207031249966],[-62.878369140624926,46.00136718750002],[-63.641015624999966,46.23046874999997],[-63.811279296875,46.46870117187501]]],[[[-74.70888671874997,45.0038574218751],[-73.55810546875,45.425097656250045],[-73.1595703125,46.01005859375002],[-71.90092773437499,46.63193359375006],[-71.26118164062495,46.756249999999966],[-70.51948242187501,47.032519531250045],[-68.987060546875,48.275000000000034],[-67.56088867187498,48.85595703125],[-66.17817382812493,49.21313476562503],[-64.83632812499994,49.191748046875006],[-64.26181640624995,48.921875],[-64.253759765625,48.550390625000006],[-65.259423828125,48.02124023437503],[-65.92670898437495,48.188867187499994],[-65.66645507812495,47.69614257812506],[-65.22817382812502,47.81127929687497],[-64.70322265625,47.72485351562503],[-64.91220703125003,47.36865234375003],[-65.31889648437502,47.101220703124994],[-64.90576171874997,46.88793945312497],[-64.54150390625,46.240332031250034],[-63.29277343749999,45.751953125],[-62.483056640624966,45.62182617187506],[-61.955517578124955,45.86816406249997],[-61.49228515624998,45.68701171875],[-61.28378906249998,45.23549804687505],[-63.761132812499994,44.486425781250034],[-64.28608398437493,44.55034179687499],[-64.86235351562499,43.867871093749955],[-65.73813476562498,43.56074218750001],[-66.125732421875,43.813818359375034],[-66.09956054687498,44.367480468750045],[-65.65673828125,44.760302734375045],[-64.44882812499995,45.256054687499955],[-64.89790039062495,45.6259765625],[-65.88447265624995,45.22290039062506],[-66.87246093749997,45.067285156249966],[-67.12485351562498,45.16943359375],[-67.47255859375002,45.27587890625],[-67.43266601562496,45.60312499999998],[-67.78466796875,45.70170898437499],[-67.806787109375,47.08281249999999],[-68.310888671875,47.3544921875],[-68.82871093749998,47.20332031250001],[-69.24287109374998,47.46298828124998],[-70.00771484375002,46.70893554687501],[-70.296240234375,45.90610351562506],[-70.89799804687493,45.26245117187503],[-71.327294921875,45.29008789062496],[-71.51752929687495,45.00756835937497],[-74.663232421875,45.00390625000003],[-74.70888671874997,45.0038574218751]]],[[[-61.801123046875034,49.093896484374966],[-62.21953124999999,49.07910156249997],[-63.565869140624926,49.39931640625002],[-64.13144531249995,49.94165039062503],[-62.858544921874966,49.70546875000005],[-61.817138671875,49.28354492187498],[-61.801123046875034,49.093896484374966]]],[[[-127.19731445312495,50.640380859375],[-125.48208007812501,50.316796874999966],[-124.64287109375002,49.428662109374955],[-123.99580078125,49.22402343750002],[-123.49702148437498,48.58208007812499],[-123.59462890624998,48.33354492187496],[-124.689404296875,48.597314453124966],[-125.82851562499998,49.09184570312499],[-125.83544921874997,49.27666015624999],[-126.54853515625003,49.41894531250003],[-126.68310546875,49.87646484374997],[-127.114306640625,49.879736328125034],[-128.267431640625,50.609277343749966],[-127.91806640624998,50.86054687500001],[-127.19731445312495,50.640380859375]]],[[[-55.45874023437494,51.53652343750005],[-55.87138671874999,50.90737304687502],[-56.693994140624966,50.059667968750006],[-55.764746093750034,49.96044921875003],[-55.892041015624926,49.58027343750004],[-55.02617187500002,49.30537109374998],[-54.579052734374955,49.490820312500006],[-53.957714843749955,49.44184570312498],[-53.57343750000001,49.141210937500034],[-53.852880859375006,48.81132812499996],[-53.53120117187501,48.231884765624955],[-52.95498046874994,48.02929687499997],[-53.17553710937503,47.652978515624966],[-52.653662109375034,47.549414062500006],[-53.06977539062498,46.68125000000006],[-53.61635742187494,46.680273437500034],[-54.173730468749994,46.88037109375003],[-53.86909179687501,47.38701171874996],[-54.856640624999955,47.385009765625],[-56.22128906249995,47.67138671874997],[-56.95249023437498,47.57446289062506],[-58.33320312499998,47.676855468750034],[-59.11694335937494,47.570703124999994],[-59.36240234374995,47.865673828124955],[-58.71059570312494,48.325048828125006],[-58.716455078124994,48.59804687500002],[-58.01582031249998,49.54248046874997],[-57.29799804687502,50.69873046874997],[-56.75019531249998,51.27490234375003],[-56.025585937499955,51.56835937500006],[-55.45874023437494,51.53652343750005]]],[[[-80.73168945312494,52.74726562499998],[-81.83906249999995,52.957910156249994],[-81.84731445312494,53.18627929687497],[-81.135595703125,53.20581054687503],[-80.73168945312494,52.74726562499998]]],[[[-131.7537109375,53.195556640625],[-131.727294921875,52.75639648437496],[-132.16508789062493,52.783300781250034],[-132.34541015625,53.136083984375034],[-131.7537109375,53.195556640625]]],[[[-132.65551757812503,54.12749023437496],[-131.70253906250002,53.98637695312499],[-132.01132812499998,53.26518554687496],[-132.747509765625,53.310498046874955],[-133.05224609375003,53.77812500000002],[-132.65551757812503,54.12749023437496]]],[[[-78.93559570312496,56.26606445312498],[-79.17548828124998,55.88505859374999],[-80.00078124999999,55.93208007812498],[-79.59633789062502,56.244482421875034],[-78.93559570312496,56.26606445312498]]],[[[-79.54531250000002,62.41171875000006],[-79.32392578124995,62.02607421875001],[-79.71425781249997,61.61254882812503],[-80.27617187499996,61.85859374999998],[-80.23466796874996,62.152685546875034],[-79.54531250000002,62.41171875000006]]],[[[-82.00048828124997,62.95419921874998],[-82.11372070312495,62.65224609375002],[-83.01582031249998,62.20991210937498],[-83.69887695312497,62.16025390624998],[-83.899267578125,62.476464843749994],[-83.37641601562498,62.904931640624994],[-82.00048828124997,62.95419921874998]]],[[[-84.91962890624995,65.26108398437503],[-83.40712890625002,65.10390625],[-82.04999999999995,64.64428710937506],[-81.71611328124996,64.021875],[-80.82895507812495,64.08994140625],[-80.30205078124999,63.76220703125003],[-81.04638671875003,63.461572265624966],[-82.37812500000001,63.706787109375],[-82.46708984375002,63.92695312500001],[-83.49433593749993,64.09921875000003],[-83.728271484375,63.813378906249966],[-84.63291015625,63.30922851562502],[-85.49550781249997,63.13911132812501],[-85.71416015625002,63.657958984375],[-87.18891601562498,63.672265624999994],[-86.252099609375,64.13686523437497],[-86.37426757812503,64.56582031249997],[-85.96166992187497,65.704248046875],[-85.24111328125,65.7955078125],[-84.91962890624995,65.26108398437503]]],[[[-75.67587890624998,68.32250976562506],[-75.15380859375,68.23403320312497],[-75.12729492187503,67.53730468749995],[-75.78007812499996,67.28354492187503],[-77.0048828125,67.26694335937503],[-77.30590820312497,67.70610351562505],[-76.740234375,68.23125000000002],[-75.67587890624998,68.32250976562506]]],[[[-97.439453125,69.64267578125006],[-96.29995117187494,69.34438476562505],[-95.68564453125003,68.73583984375006],[-96.40156249999995,68.47070312500003],[-97.47202148437498,68.543701171875],[-99.25400390625002,68.86318359374997],[-99.56406249999995,69.03413085937498],[-97.439453125,69.64267578125006]]],[[[-74.70888671874997,45.0038574218751],[-74.76245117187494,44.99907226562502],[-74.99614257812496,44.970117187499966],[-75.40126953124997,44.77226562499999],[-75.81933593749997,44.468017578125],[-76.18579101562503,44.24223632812502],[-76.819970703125,43.62880859375011],[-77.87924804687489,43.62954101562508],[-78.45825195312497,43.63149414062511],[-78.72041015624993,43.62495117187501],[-78.84555664062492,43.58334960937506],[-79.17187499999997,43.466552734375085],[-79.0830566406249,43.33139648437509],[-79.05922851562494,43.27807617187506],[-79.066064453125,43.10610351562502],[-79.02617187499996,43.01733398437506],[-78.98076171874993,42.98061523437502],[-78.91508789062496,42.90913085937504],[-79.17373046875,42.74853515625],[-80.24755859374991,42.366015625000045],[-81.02822265624997,42.247167968750006],[-81.50732421874997,42.10346679687504],[-81.97416992187496,41.88872070312499],[-82.69003906249995,41.675195312499994],[-83.141943359375,41.97587890624996],[-83.10952148437497,42.25068359375001],[-82.54531249999997,42.62470703124998],[-82.19038085937495,43.47407226562501],[-82.137841796875,43.570898437500034],[-82.48505859374993,45.08374023437503],[-82.91933593749994,45.51796875000002],[-83.59267578125,45.81713867187506],[-83.61596679687503,46.116845703124994],[-83.97778320312494,46.08491210937507],[-84.12319335937497,46.50292968749997],[-84.44047851562496,46.49814453125006],[-84.66577148437503,46.54326171875002],[-84.87597656249994,46.89990234375003],[-85.07006835937497,46.97993164062498],[-85.65224609375,47.21997070312503],[-86.67216796874996,47.636425781249955],[-87.20800781249997,47.848486328125006],[-87.74389648437497,48.06054687500003],[-88.37817382812497,48.30307617187506],[-89.45566406249992,47.99624023437508],[-90.79731445312495,48.13105468750001],[-91.38720703124997,48.05854492187498],[-92.00517578125002,48.301855468750006],[-92.34843749999996,48.276611328125],[-92.41459960937493,48.276611328125],[-92.50058593749995,48.43535156250002],[-92.83671874999996,48.567773437499994],[-93.25795898437497,48.62885742187501],[-93.37788085937498,48.61655273437498],[-93.85161132812496,48.607275390625034],[-94.71279296874997,48.863427734374994],[-94.80346679687497,49.0029296875],[-94.86040039062493,49.258593750000045],[-94.85434570312495,49.304589843749994],[-95.16206054687493,48.991748046875045],[-95.39790039062493,48.99316406249997],[-96.25068359374993,48.99316406249997],[-96.67705078124993,48.99316406249997],[-97.52983398437493,48.99316406249997],[-98.80898437499995,48.99316406249997],[-102.64643554687497,48.993115234375125],[-105.63110351562497,48.993115234375125],[-107.76298828124989,48.993115234375125],[-109.4685546874999,48.993066406250136],[-112.45322265625,48.993066406250136],[-115.86425781249993,48.993066406250136],[-117.99619140624993,48.993066406250136],[-118.84892578124993,48.993066406250136],[-119.27534179687494,48.993066406250136],[-119.70170898437495,48.99301757812495],[-120.98085937499995,48.99301757812495],[-122.78876953124994,48.99301757812495],[-122.82670898437495,49.028417968750034],[-122.9241699218749,49.07465820312504],[-123.04921874999998,48.993017578125034],[-123.33564453124997,49.45917968750004],[-123.85893554687492,49.48286132812507],[-124.14160156249994,49.792675781250125],[-124.78237304687492,50.02011718749992],[-125.05668945312495,50.418652343750125],[-126.4044921875,50.529882812500034],[-126.397119140625,50.80708007812504],[-127.057568359375,50.86752929687509],[-127.70810546875,51.15117187499996],[-127.644873046875,51.47846679687504],[-128.3576171875,52.1588867187501],[-128.1087890624999,52.85805664062508],[-128.6523437499999,53.24384765624998],[-129.28427734374995,53.393164062500006],[-129.56372070312506,53.251464843750114],[-130.33525390625002,53.723925781250074],[-130.04331054687495,54.13354492187503],[-130.4302734375,54.42099609374998],[-129.89013671874994,55.16464843749995],[-130.01406249999997,55.950537109375006],[-130.09785156249995,56.10927734375002],[-130.47709960937496,56.230566406250034],[-130.649072265625,56.26367187500003],[-131.86616210937495,56.792822265625006],[-132.062890625,56.95336914062503],[-133.00141601562495,57.948974609375],[-133.27529296875,58.22285156250004],[-133.54638671874997,58.50346679687499],[-134.21850585937503,58.849902343750045],[-134.32963867187505,58.93969726562506],[-134.39306640625,59.009179687499994],[-134.67724609374997,59.19926757812499],[-134.94375,59.28828125000001],[-135.36787109374998,59.743310546874994],[-135.70258789062504,59.72875976562506],[-136.46635742187493,59.459082031250006],[-136.81328125000002,59.15004882812511],[-137.59331054687493,59.22626953124998],[-138.317626953125,59.611132812500074],[-138.70546874999997,59.90131835937504],[-139.23476562499997,60.339746093749994],[-139.67631835937505,60.32832031249998],[-139.97329101562497,60.183154296875074],[-140.45283203125004,60.29970703125002],[-141.00214843750004,60.300244140625125],[-141.00214843750004,60.884667968749994],[-141.00214843750004,61.761279296875045],[-141.00214843750004,63.22226562499998],[-141.00214843750004,64.09887695312506],[-141.00214843750004,65.55991210937498],[-141.00214843750004,66.43652343750006],[-141.00214843750004,67.89755859374998],[-141.00214843750004,68.77416992187506],[-141.00214843750004,69.65078125000011],[-139.18154296874997,69.51552734375008],[-138.12836914062495,69.15195312500009],[-136.71733398437493,68.88916015625003],[-135.876318359375,68.9169921875],[-135.6914550781249,69.31118164062502],[-135.1408203124999,69.46782226562496],[-133.16313476562496,69.43388671874999],[-130.49843749999997,70.14316406250006],[-128.9714355468749,69.71240234375006],[-127.76494140624995,70.2218750000001],[-127.13847656249996,70.23935546874995],[-126.06381835937495,69.46708984374999],[-124.767919921875,69.99003906249996],[-123.60913085937491,69.37744140625003],[-123.02578125,69.81000976562504],[-120.96245117187502,69.66040039062511],[-120.29252929687496,69.42055664062511],[-118.86870117187496,69.25717773437503],[-118.09521484374994,69.0429199218751],[-116.06523437500002,68.85541992187507],[-115.63115234374995,68.97255859375014],[-114.41386718749993,68.65957031250014],[-115.42685546874989,67.92353515625013],[-113.89321289062501,67.70688476562503],[-112.43515624999988,67.68476562499998],[-110.9900390624999,67.79082031250007],[-110.04248046874994,67.97719726562505],[-109.63037109374991,67.73271484374996],[-108.59291992187495,67.59086914062502],[-107.15649414062497,66.88173828124997],[-108.26103515625002,68.14990234375006],[-108.31347656249996,68.61079101562498],[-106.16445312499992,68.91987304687507],[-105.42861328124994,68.458251953125],[-104.19355468749994,68.03120117187504],[-103.47412109374993,68.11503906250005],[-102.69199218749992,67.81157226562505],[-101.55498046874992,67.69316406250007],[-100.45610351562496,67.83945312500003],[-99.14687499999995,67.72363281250009],[-98.41713867187497,67.82646484375007],[-98.21855468750002,68.31743164062507],[-97.2659179687499,68.45292968749996],[-96.03603515625,68.15776367187505],[-96.37138671875002,67.55385742187514],[-95.78251953124996,67.19379882812513],[-95.25874023437493,67.26254882812492],[-95.65048828124986,67.73745117187505],[-93.65170898437489,68.54311523437505],[-93.68144531249993,68.88725585937499],[-94.2708007812499,69.45512695312505],[-96.11909179687504,69.87187500000005],[-96.54560546874998,70.32724609375009],[-96.4056640625,71.27363281249998],[-95.20122070312493,71.90371093750008],[-94.30834960937491,71.76489257812506],[-92.94868164062493,71.26210937500011],[-92.98144531249994,70.8522460937501],[-91.56406249999995,70.1782714843751],[-92.75092773437498,69.71391601562502],[-90.82211914062495,69.29047851562507],[-90.468359375,68.86376953125],[-89.05673828124992,69.26611328125009],[-88.041357421875,68.81171875000007],[-87.81030273437491,68.40415039062498],[-88.34697265624993,68.28828125000001],[-88.19589843749986,67.76582031249995],[-87.26625976562494,67.18383789062506],[-86.53642578125002,67.51616210937507],[-85.9525878906249,68.0724609375001],[-85.73383789062493,68.630126953125],[-84.86220703125,69.07397460937503],[-85.38676757812493,69.23188476562504],[-85.50737304687487,69.84526367187493],[-82.61835937499993,69.69106445312514],[-82.64204101562495,69.4583984375],[-81.3286621093749,69.11992187499996],[-81.28154296874987,68.65722656250003],[-82.55268554687504,68.44648437500007],[-81.97646484374997,67.86201171875001],[-81.27011718749995,67.45991210937498],[-81.46757812499996,67.0698730468751],[-82.64150390624991,66.58750000000006],[-84.47841796875005,66.17929687500003],[-85.44223632812495,66.53735351562497],[-86.63320312499991,66.53134765625],[-86.04287109375,66.02255859375009],[-87.2914550781249,65.35483398437495],[-87.28051757812491,64.82617187500006],[-88.10561523437497,64.18330078125001],[-88.65302734374993,64.00937499999992],[-90.14189453125002,63.981982421875045],[-90.01342773437497,63.80429687500006],[-91.33007812499997,63.50683593750006],[-90.74658203124994,63.35156250000003],[-90.87119140625,62.945947265624994],[-91.44897460937503,62.804052734375034],[-92.3612792968749,62.81938476562496],[-93.42060546874998,61.705810546875114],[-94.06074218749993,61.317822265625125],[-94.64677734374993,60.416406249999994],[-94.78579101562494,59.953320312499955],[-94.71337890624991,58.903320312500114],[-94.28706054687493,58.716015625000125],[-93.2781249999999,58.75639648437502],[-92.24902343749994,57.00898437500001],[-91.11127929687498,57.24121093750006],[-90.59218749999991,57.224462890625034],[-89.7908203124999,56.98134765625005],[-88.94848632812489,56.85131835937503],[-88.07509765624997,56.46728515624994],[-87.560888671875,56.05634765625007],[-85.67666015625,55.60107421875006],[-85.06093749999997,55.285644531250085],[-83.91059570312493,55.314648437499955],[-82.57744140625002,55.1487304687501],[-82.219384765625,54.8134765625],[-82.41806640624986,54.355810546875034],[-82.14145507812492,53.81762695312497],[-82.26044921874993,52.9611328125001],[-81.5994140624999,52.432617187500085],[-81.66123046874986,52.29389648437507],[-80.65795898437503,51.75834960937502],[-80.36796875000002,51.32988281249996],[-79.83623046874996,51.17333984375003],[-79.49755859374997,51.569921875000006],[-78.97773437499993,51.733789062499994],[-78.49165039062495,52.25209960937508],[-78.723779296875,52.627734375000045],[-79.241796875,54.098876953125085],[-79.66552734374991,54.69746093749998],[-77.89111328124989,55.236425781250006],[-77.32495117187494,55.555517578125006],[-76.65048828124992,56.10722656249996],[-76.5728515625,57.1812011718751],[-77.15678710937496,58.018896484375034],[-78.51508789062493,58.68237304687503],[-77.76069335937498,59.38002929687505],[-77.31181640624993,60.042382812499994],[-77.8715332031249,60.7858398437501],[-77.73618164062495,61.43735351562498],[-78.13715820312493,62.10737304687504],[-78.06811523437489,62.355419921875125],[-77.372412109375,62.572509765625114],[-74.68989257812493,62.18344726562509],[-73.62998046874989,62.454199218750006],[-72.0814453125,61.728271484375085],[-71.42270507812489,61.158935546875085],[-70.27929687499991,61.06865234374999],[-69.64047851562489,60.68979492187509],[-69.75590820312496,60.38852539062498],[-69.68188476562489,59.34174804687507],[-69.17348632812497,58.896630859374994],[-68.69819335937495,58.904541015625],[-67.5696289062499,58.21347656250006],[-66.60791015624991,58.548925781250034],[-65.60624999999993,59.11074218750008],[-65.4333984374999,59.776513671874994],[-64.93125,60.252001953125074],[-64.49941406250005,60.26826171875001],[-63.18535156249993,58.85776367187506],[-62.593847656249864,58.47402343750005],[-62.30566406249997,57.97226562499995],[-61.899072265624994,57.861328125000085],[-61.851074218749886,57.38129882812501],[-61.33374023437494,57.01059570312498],[-61.514599609374926,56.3903320312501],[-59.93032226562491,55.25942382812508],[-58.99711914062496,55.149462890625074],[-58.780175781249994,54.838378906250114],[-58.195263671874926,54.86591796875004],[-57.40444335937494,54.570410156250034],[-58.15136718749997,54.350439453125006],[-57.4160644531249,54.162744140625136],[-57.14897460937493,53.847705078125074],[-56.46499023437505,53.76503906250011],[-55.79794921874995,53.211962890625045],[-55.83364257812494,52.31040039062506],[-55.695214843749994,52.13779296875006],[-56.97597656250005,51.45766601562505],[-58.510351562500006,51.295068359375136],[-59.16538085937495,50.779882812500006],[-60.08017578124989,50.2545898437501],[-61.289746093749926,50.20195312500002],[-62.71542968749995,50.30166015625008],[-64.86787109374998,50.27548828125009],[-65.2686035156249,50.3200195312501],[-66.49550781249991,50.2118652343751],[-66.94116210937503,49.993701171875045],[-67.37202148437495,49.348437500000045],[-68.28193359374998,49.197167968750136],[-68.929052734375,48.82895507812509],[-69.77499999999995,48.09809570312504],[-69.9055664062499,47.83222656250007],[-70.70585937499996,47.13979492187505],[-71.26777343749995,46.79594726562499],[-71.87958984374998,46.68681640624996],[-72.98100585937493,46.209716796875085],[-73.97382812499995,45.345117187499994],[-74.70888671874997,45.0038574218751]]],[[[-114.52153320312502,72.592919921875],[-113.50004882812502,72.69443359375006],[-112.75361328125001,72.98603515624995],[-111.26972656249994,72.71372070312498],[-108.69829101562502,72.499267578125],[-108.23823242187498,73.10581054687503],[-107.72001953125002,73.32905273437504],[-106.48212890624998,73.19619140624997],[-105.41513671874995,72.788330078125],[-104.34956054687501,71.43398437500005],[-104.56958007812499,71.10405273437507],[-103.10498046874994,70.51025390624997],[-101.14853515624998,70.147607421875],[-100.93510742187493,69.71533203125003],[-102.18212890624997,69.845947265625],[-101.85712890625001,69.02397460937505],[-103.46821289062497,68.80854492187504],[-105.019580078125,69.08124999999998],[-106.140869140625,69.16201171875002],[-106.65908203124997,69.439599609375],[-107.43989257812497,69.00214843749995],[-108.9458984375,68.75981445312505],[-111.3109375,68.54204101562502],[-113.12773437500002,68.49414062500003],[-113.69414062499995,69.19501953124998],[-116.51347656249993,69.42460937500005],[-117.13544921875,70.10014648437499],[-114.59233398437497,70.31245117187498],[-112.63789062499997,70.225244140625],[-112.11416015624994,70.44687500000003],[-113.75727539062503,70.69072265625005],[-115.99091796874997,70.586279296875],[-117.58706054687498,70.62954101562502],[-118.26406249999998,70.888330078125],[-117.81406249999996,71.15844726562503],[-118.868408203125,71.68676757812503],[-118.94462890624997,71.98554687499995],[-118.21347656249998,72.26289062499998],[-118.37451171875,72.53388671875004],[-116.57324218749994,73.05493164062506],[-114.63823242187499,73.37265625000003],[-114.05170898437497,73.07099609375004],[-114.52153320312502,72.592919921875]]],[[[-105.28891601562499,72.919921875],[-106.92153320312497,73.479833984375],[-105.51230468750002,73.765771484375],[-104.58286132812493,73.35390625000002],[-105.28891601562499,72.919921875]]],[[[-79.53730468749998,73.65449218749998],[-78.2865234375,73.66582031250007],[-77.20654296874997,73.49956054687505],[-76.28955078125003,73.08100585937504],[-76.400537109375,72.820654296875],[-77.83593750000003,72.89682617187498],[-79.50053710937496,72.75595703124998],[-80.82416992187495,73.38066406250007],[-80.84887695312503,73.72124023437499],[-79.53730468749998,73.65449218749998]]],[[[-86.58935546874997,71.01079101562507],[-84.78959960937493,71.09326171875],[-84.65996093749999,71.58613281249995],[-85.91162109375,71.98652343749998],[-85.34111328124993,72.42153320312497],[-85.64453125000003,72.77446289062502],[-85.018408203125,73.33549804687502],[-82.65961914062498,73.72958984375],[-81.40615234374997,73.634521484375],[-80.27470703124993,72.74555664062498],[-80.94121093750002,72.21015624999998],[-79.000244140625,72.27202148437507],[-78.00102539062499,72.68759765625],[-76.89350585937495,72.72065429687498],[-75.18579101562494,72.434228515625],[-74.31572265624999,71.84267578125],[-71.45991210937493,71.46372070312498],[-70.56093750000002,70.73828124999997],[-69.16870117187497,70.76416015625],[-67.36367187499994,70.03442382812503],[-68.51303710937498,69.57729492187497],[-66.77084960937498,69.33666992187497],[-67.75170898437494,69.038671875],[-68.037939453125,68.55073242187501],[-67.032958984375,68.32607421874997],[-66.2251953125,67.958740234375],[-64.52753906250001,67.81269531250001],[-64.00795898437502,67.34731445312497],[-61.96855468749993,67.01904296874997],[-61.29970703125002,66.64873046875002],[-61.99160156250002,66.03530273437502],[-62.65888671874998,65.63994140625002],[-63.36425781249997,65.54321289062503],[-63.40180664062498,65.11845703125002],[-64.66533203125002,65.1689453125],[-65.401611328125,65.764013671875],[-65.30537109374993,66.00844726562497],[-66.47695312499997,66.27973632812498],[-67.18320312499995,66.03442382812503],[-68.2568359375,65.93862304687505],[-67.30341796874993,65.48291015625],[-66.86064453124996,65.09160156250005],[-65.2748046875,64.63154296875004],[-64.67846679687503,64.027978515625],[-64.51435546874998,63.263964843750045],[-65.06894531249998,63.26347656250002],[-65.26582031249995,62.71508789062503],[-65.978857421875,63.000683593749955],[-67.67597656249998,63.093554687500045],[-66.28124999999997,62.302685546874955],[-66.25668945312503,61.868261718750006],[-67.44013671874998,62.15126953125002],[-69.08232421874996,62.405175781249966],[-69.54516601562503,62.74458007812501],[-70.23613281250002,62.76337890625001],[-71.25371093749993,63.042529296875045],[-73.44365234374996,64.423486328125],[-74.512451171875,64.670166015625],[-75.0673828125,64.45668945312502],[-76.72382812499995,64.24204101562498],[-77.79116210937497,64.36708984374997],[-78.09560546875,64.93925781250002],[-77.44746093749993,65.16157226562501],[-77.32670898437493,65.45312499999997],[-75.82832031249993,65.22705078125003],[-73.56074218750001,65.54291992187498],[-74.433935546875,66.139013671875],[-72.22001953124999,67.25429687500002],[-73.32822265624998,68.26674804687497],[-74.64794921874997,68.70751953124997],[-74.91728515624996,68.98286132812501],[-76.40341796874995,68.69233398437498],[-75.78715820312499,69.31865234375005],[-77.12880859374994,69.65273437499997],[-78.809814453125,70.17856445312498],[-79.61591796875001,69.89472656249998],[-81.09829101562494,70.09116210937503],[-82.13872070312499,69.8412109375],[-86.32202148437503,70.14541015625],[-86.62431640624999,70.40126953124997],[-87.90068359374996,70.25190429687501],[-88.84843749999993,70.52290039062498],[-89.36552734374996,71.06718750000002],[-87.84492187499995,70.94438476562505],[-87.87246093749997,71.20854492187505],[-89.079345703125,71.28793945312503],[-89.84575195312499,71.49228515625],[-90.02519531249996,71.94877929687502],[-89.26323242187499,73.068994140625],[-87.71977539062496,73.72290039062497],[-86.76875000000001,73.83398437500006],[-84.97451171874997,73.69477539062501],[-86.62934570312493,72.87080078125001],[-86.03613281249997,71.77094726562504],[-85.02338867187495,71.35322265625001],[-86.58935546874997,71.01079101562507]]],[[[-100.00190429687497,73.9458984375],[-99.15795898437499,73.73159179687497],[-97.58183593749996,73.88754882812503],[-97.001708984375,73.66650390625003],[-97.79589843749997,73.285302734375],[-97.05180664062499,72.63681640625003],[-96.61342773437494,71.83383789062506],[-98.66289062499993,71.302099609375],[-99.167138671875,71.36718750000003],[-100.594482421875,72.15234375000003],[-101.72392578124996,72.31489257812501],[-102.71367187499999,72.78291015624995],[-100.48476562500002,72.77294921874997],[-100.28266601562497,73.12031249999995],[-101.45087890625003,73.43095703125002],[-100.91513671874995,73.80537109374998],[-100.00190429687497,73.9458984375]]],[[[-93.17084960937498,74.16098632812506],[-92.22270507812502,73.97236328124998],[-90.35458984375,73.86865234375],[-92.11791992187497,72.75380859375],[-93.34062499999993,72.80185546875],[-94.03754882812498,72.02875976562498],[-95.19296875,72.02744140624998],[-95.54760742187497,72.78154296875005],[-95.63291015625003,73.69545898437497],[-95.03984374999999,74.02387695312501],[-93.17084960937498,74.16098632812506]]],[[[-119.73632812499997,74.11264648437498],[-117.96586914062497,74.26606445312495],[-117.19882812500003,74.171142578125],[-115.51069335937501,73.61874999999998],[-115.44687499999998,73.43886718750002],[-118.96157226562497,72.68413085937499],[-120.17988281250001,72.21264648437506],[-120.61933593750001,71.50576171875002],[-123.210595703125,71.12343750000002],[-124.00776367187494,71.67744140624998],[-125.76259765624997,72.13750000000002],[-124.98710937499997,72.58798828125003],[-124.83642578125001,73.07626953125003],[-123.79726562499997,73.76816406250003],[-124.69624023437497,74.34819335937499],[-121.31523437499995,74.52998046874998],[-119.73632812499997,74.11264648437498]]],[[[-93.54257812499995,75.0279296875],[-93.54716796875002,74.69106445312505],[-94.697265625,74.64218750000003],[-96.565771484375,75.09873046875003],[-95.67080078125002,75.52866210937498],[-94.42724609374997,75.593359375],[-93.54257812499995,75.0279296875]]],[[[-102.22734374999995,76.014892578125],[-103.31474609374996,75.76420898437499],[-104.35063476562497,76.18232421875001],[-102.58408203124996,76.281640625],[-102.22734374999995,76.014892578125]]],[[[-97.70092773437497,76.46650390624998],[-97.40961914062495,75.55209960937503],[-97.79936523437496,75.11665039062495],[-100.234375,75.00771484374997],[-100.71191406250003,75.40634765625],[-102.54140624999998,75.51362304687501],[-101.43134765624995,75.99199218750005],[-102.13774414062499,76.28486328125001],[-100.38793945312501,76.61357421875002],[-97.70092773437497,76.46650390624998]]],[[[-108.29238281250001,76.05712890625],[-105.48090820312503,75.74565429687505],[-105.86259765624997,75.19155273437505],[-107.15341796874996,74.9271484375],[-108.83129882812501,75.06489257812498],[-110.94086914062501,74.63872070312505],[-112.51933593749997,74.41684570312503],[-113.51406249999994,74.430078125],[-114.45175781250002,75.08789062499997],[-115.72885742187496,74.968115234375],[-117.60009765624997,75.27167968750001],[-116.60976562500001,76.07373046875],[-115.58066406249996,76.43750000000003],[-114.19394531249999,76.45146484375005],[-112.69760742187496,76.20170898437505],[-111.05268554687495,75.54853515625001],[-109.08637695312503,75.506494140625],[-109.79604492187501,75.86303710937497],[-109.48681640624999,76.14467773437497],[-110.27001953125003,76.41699218750003],[-108.62763671875001,76.58671875000005],[-108.29238281250001,76.05712890625]]],[[[-94.29497070312493,76.91245117187498],[-92.71625976562493,76.60297851562498],[-91.305029296875,76.68076171875003],[-90.25136718749994,76.05346679687503],[-88.201318359375,75.51201171875005],[-86.06874999999994,75.50224609375002],[-83.931982421875,75.81894531250003],[-82.153662109375,75.83105468750003],[-79.66020507812499,75.44951171875002],[-79.50795898437497,74.880126953125],[-80.27773437500002,74.58159179687502],[-81.80883789062503,74.47661132812505],[-88.42304687499995,74.49414062499997],[-89.844384765625,74.54858398437497],[-91.96157226562502,74.79321289062497],[-92.427099609375,75.34638671874995],[-92.18510742187499,75.84653320312498],[-93.09174804687495,76.35400390624997],[-95.27387695312498,76.26440429687503],[-96.63969726562496,76.70292968750002],[-95.63823242187496,77.06376953124999],[-94.29497070312493,76.91245117187498]]],[[[-115.55126953125001,77.36328125],[-116.22045898437501,76.61108398437506],[-119.36791992187497,76.22177734375003],[-119.91289062499997,75.85883789062501],[-121.90820312499996,76.03476562500006],[-121.61376953125001,76.44145507812505],[-119.09018554687496,77.30507812500002],[-115.55126953125001,77.36328125]]],[[[-95.48437499999997,77.79199218750003],[-93.30097656249995,77.73979492187505],[-93.51958007812499,77.47441406250007],[-95.98706054687497,77.484130859375],[-95.48437499999997,77.79199218750003]]],[[[-110.45805664062496,78.10322265625001],[-109.77177734374995,77.95742187499997],[-110.19848632812501,77.52451171874998],[-111.95195312500002,77.34418945312501],[-113.16435546875002,77.5302734375],[-113.21518554687498,77.90351562500001],[-110.45805664062496,78.10322265625001]]],[[[-109.81596679687499,78.65039062500003],[-109.39052734375,78.33666992187506],[-113.14995117187502,78.40839843750001],[-110.40781249999995,78.75664062499999],[-109.81596679687499,78.65039062500003]]],[[[-96.20449218749994,78.53129882812499],[-94.88715820312498,78.34521484375003],[-95.08701171875,77.99262695312495],[-96.98964843749994,77.80600585937503],[-98.25493164062496,78.42924804687499],[-96.20449218749994,78.53129882812499]]],[[[-103.42602539062499,79.31562500000001],[-99.60942382812495,78.58305664062507],[-99.16640625000002,77.85693359375003],[-100.58603515624996,77.89179687500001],[-101.07412109375001,78.19384765625],[-102.73134765624995,78.37104492187495],[-103.51835937499996,78.76914062500006],[-105.53564453124999,79.03251953125007],[-105.38769531249994,79.32358398437503],[-103.42602539062499,79.31562500000001]]],[[[-91.88554687499999,81.13286132812505],[-90.64301757812498,80.59370117187498],[-87.67499999999998,80.37211914062505],[-87.14423828124993,79.66264648437502],[-85.5013671875,79.53032226562505],[-85.28984374999999,79.208349609375],[-87.016455078125,78.89868164062497],[-88.79101562499997,78.19243164062507],[-90.614404296875,78.14985351562501],[-92.67827148437502,78.38911132812498],[-95.10317382812502,79.289892578125],[-95.29697265624998,79.653076171875],[-96.77324218749999,80.13579101562502],[-95.61445312499998,80.39624023437497],[-96.1328125,80.69140624999997],[-95.26977539062503,81.00078125000005],[-91.88554687499999,81.13286132812505]]],[[[-69.4888671875,83.01679687499998],[-64.77675781249997,82.87646484374997],[-61.392480468749994,82.44189453125],[-62.17670898437498,82.04340820312498],[-64.57402343749996,81.73374023437506],[-65.48398437499998,81.28476562499998],[-70.14350585937498,80.39765625000001],[-71.387841796875,79.76176757812505],[-75.25947265624995,79.421044921875],[-76.255859375,79.00683593749997],[-74.43310546875,78.72412109375003],[-75.86596679687497,78.00981445312499],[-78.01259765624997,77.94604492187506],[-78.07617187500003,77.51904296875],[-79.34086914062493,77.15839843749998],[-78.28886718750002,76.97797851562501],[-78.284326171875,76.57124023437501],[-80.69028320312495,76.17646484374995],[-81.17070312499996,76.51274414062499],[-83.88569335937501,76.45312500000003],[-85.141259765625,76.30458984375005],[-89.57006835937497,76.49194335937503],[-89.49975585937503,76.82680664062502],[-88.39814453124995,77.10395507812501],[-86.873779296875,77.20029296875],[-88.09467773437495,77.71918945312501],[-87.01796874999997,77.89223632812502],[-87.5517578125,78.17661132812503],[-86.80791015624999,78.77436523437495],[-84.31611328124993,78.97529296874995],[-85.08979492187498,79.61215820312503],[-86.42075195312498,79.84521484374997],[-86.30717773437493,80.31933593750003],[-83.72363281250003,80.22895507812501],[-80.05107421874993,80.52856445312503],[-83.40141601562502,80.71396484375003],[-85.30742187500002,80.52597656250003],[-88.92143554687499,80.80561523437498],[-89.94731445312499,81.17265625000005],[-88.97836914062503,81.54150390624997],[-90.49018554687501,81.87724609374999],[-86.58061523437496,82.18720703124998],[-82.12250976562498,82.60175781249998],[-79.88632812500003,82.93852539062502],[-69.96992187499995,83.11611328125005],[-69.4888671875,83.01679687499998]]]]},"properties":{"name":"Canada","childNum":36}},{"geometry":{"type":"Polygon","coordinates":[[[9.524023437500006,47.524218749999996],[9.527539062500011,47.270751953125],[9.580273437500011,47.057373046875],[9.996875000000017,46.8853515625],[10.349414062500017,46.984765624999994],[10.414941406250023,46.964404296874996],[10.45458984375,46.8994140625],[10.452832031250011,46.86494140625],[10.406054687500017,46.73486328125],[10.39794921875,46.6650390625],[10.4306640625,46.550048828125],[10.363085937500017,46.5470703125],[10.272265625000017,46.564843749999994],[10.195507812500011,46.62109375],[10.137500000000017,46.61435546875],[10.087011718750006,46.599902343749996],[9.939257812500017,46.36181640625],[9.203417968750017,46.21923828125],[8.826757812500006,46.06103515625],[8.818554687500011,46.0771484375],[8.458398437500023,46.245898437499996],[8.370703125000006,46.445117187499996],[8.08154296875,46.256005859374994],[7.787890625000017,45.921826171875],[7.327929687500017,45.912353515625],[6.772070312500006,46.16513671875],[6.758105468750017,46.415771484375],[6.428906250000011,46.430517578125],[6.27294921875,46.252246093749996],[6.199414062500011,46.19306640625],[6.086621093750011,46.147021484374996],[6.006640625000017,46.142333984375],[5.971484375000017,46.151220703125],[5.970019531250017,46.214697265625],[6.060253906250011,46.428173828125],[6.429003906250017,46.832275390625],[7.000585937500006,47.322509765625],[7.615625000000023,47.592724609375],[8.414746093750011,47.589599609375],[8.572656250000023,47.775634765625],[9.524023437500006,47.524218749999996]]]},"properties":{"name":"Switzerland","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-67.07993164062498,-55.15380859374996],[-68.07001953124995,-55.22109374999999],[-68.10693359375003,-54.929394531249976],[-67.245263671875,-54.977636718750034],[-67.07993164062498,-55.15380859374996]]],[[[-69.70297851562503,-54.91904296875],[-68.90078125000002,-55.01777343750004],[-68.28266601562495,-55.25517578125],[-68.293359375,-55.521386718749966],[-69.41181640624995,-55.44423828124997],[-69.97978515625002,-55.14746093749999],[-69.70297851562503,-54.91904296875]]],[[[-72.92324218749997,-53.481640625],[-72.20541992187503,-53.80742187500002],[-73.30473632812499,-53.943945312500034],[-73.68652343749997,-53.42685546875003],[-72.92324218749997,-53.481640625]]],[[[-68.62993164062499,-52.65263671875004],[-68.65322265624994,-54.85361328124999],[-69.48627929687493,-54.85888671875],[-69.72343750000002,-54.71210937500003],[-70.49716796875,-54.80957031249999],[-71.44091796874997,-54.61962890625002],[-70.89824218749999,-54.337890625],[-70.86772460937499,-53.88417968750002],[-70.09038085937499,-53.41816406250003],[-70.39067382812496,-53.02646484374999],[-69.76357421875002,-52.731347656249994],[-68.62993164062499,-52.65263671875004]]],[[[-74.47617187499998,-49.14785156250002],[-74.59472656249997,-50.00664062500001],[-75.30009765624996,-49.8474609375],[-75.184228515625,-49.08359374999999],[-74.79345703124997,-48.70507812499997],[-74.47617187499998,-49.14785156250002]]],[[[-74.56728515625,-48.591992187500026],[-74.92304687499998,-48.62646484375003],[-75.21289062499997,-48.141699218750034],[-74.72929687499996,-48.12587890625001],[-74.56728515625,-48.591992187500026]]],[[[-72.98613281249999,-44.780078124999974],[-73.44506835937497,-44.641015624999966],[-73.20771484374993,-44.33496093749997],[-72.76406249999997,-44.54902343749997],[-72.98613281249999,-44.780078124999974]]],[[[-73.73535156249997,-44.39453125000003],[-73.98330078125002,-44.494824218750026],[-73.72714843749998,-45.11904296875001],[-74.09907226562498,-45.32539062500004],[-74.61777343749998,-44.64794921874996],[-74.50180664062498,-44.47353515624995],[-73.73535156249997,-44.39453125000003]]],[[[-73.77338867187498,-43.3458984375],[-74.35493164062498,-43.26357421875001],[-74.20947265625,-42.87871093750003],[-74.03666992187496,-41.79550781249998],[-73.52783203124997,-41.89628906249999],[-73.47080078124998,-42.46630859375004],[-73.78925781249993,-42.58574218750003],[-73.43632812499996,-42.9365234375],[-73.77338867187498,-43.3458984375]]],[[[-67.19487304687493,-22.821679687500037],[-67.00878906249994,-23.00136718750005],[-67.35620117187503,-24.033789062499963],[-68.25029296875002,-24.391992187500023],[-68.56201171875,-24.83769531249996],[-68.38422851562495,-25.091894531249977],[-68.60029296874998,-25.48564453124999],[-68.41450195312498,-26.153710937500023],[-68.58115234375,-26.518359374999974],[-68.34599609374996,-27.02792968750005],[-68.84633789062494,-27.153710937499994],[-69.17441406249998,-27.924707031250037],[-69.65693359374995,-28.413574218749986],[-69.82788085937497,-29.10322265624997],[-70.02680664062501,-29.324023437500017],[-69.92763671874997,-29.76914062500002],[-69.95634765624996,-30.35820312500003],[-70.16142578124999,-30.44023437499996],[-70.51958007812493,-31.1484375],[-70.585205078125,-31.569433593749963],[-70.16962890624995,-32.471679687500014],[-70.01982421874999,-33.27148437499997],[-69.79775390624997,-33.398632812500026],[-69.85244140625,-34.224316406250026],[-70.28994140624997,-34.732812499999966],[-70.47041015624995,-35.32617187499997],[-70.40478515625,-36.06171874999998],[-71.05551757812498,-36.52373046874996],[-71.16757812499998,-37.76230468749996],[-71.028173828125,-38.041210937500026],[-70.95161132812493,-38.73847656249997],[-71.42558593749996,-38.98564453125006],[-71.53945312499997,-39.60244140624995],[-71.71992187499995,-39.63525390624997],[-71.69531250000003,-40.33525390625003],[-71.93212890624994,-40.69169921874999],[-71.91127929687497,-41.650390624999986],[-71.76093749999998,-42.101464843749966],[-72.12460937499998,-42.298339843750014],[-72.14643554687498,-42.990039062499974],[-71.781494140625,-43.16679687500002],[-71.90498046875001,-43.44013671875001],[-71.68007812500002,-43.92958984374998],[-71.82001953124993,-44.38310546875],[-71.21259765624998,-44.44121093750003],[-71.26113281250002,-44.763085937499966],[-71.5962890625,-44.97919921875004],[-71.35375976562497,-45.23046874999997],[-71.77265624999995,-45.724414062499974],[-71.87568359374998,-46.16054687500001],[-71.69521484375,-46.57841796875006],[-71.94023437499999,-46.831250000000054],[-71.90498046875001,-47.201660156250014],[-72.34594726562497,-47.49267578124997],[-72.517919921875,-47.87636718749998],[-72.35473632812497,-48.36582031250005],[-72.61440429687494,-48.79287109375],[-73.57626953124998,-49.582910156250016],[-73.50126953124996,-50.125292968750024],[-73.15292968749998,-50.73828125000003],[-72.50981445312496,-50.607519531250034],[-72.27631835937498,-50.910253906249984],[-72.40766601562501,-51.54082031250002],[-71.91865234374995,-51.98955078125004],[-69.96025390624993,-52.00820312500002],[-68.443359375,-52.35664062500004],[-69.24101562499996,-52.20546874999997],[-69.56059570312496,-52.42158203125004],[-70.79511718749995,-52.768749999999976],[-70.99584960937497,-53.77929687499997],[-71.29775390625002,-53.88339843750004],[-72.1744140625,-53.632324218749964],[-71.85273437499993,-53.28574218749996],[-71.40034179687495,-53.10703124999997],[-71.38774414062496,-52.76425781250004],[-72.45830078124993,-53.25449218749999],[-73.05273437499997,-53.24345703125005],[-74.01445312499999,-52.63935546875],[-73.51816406250003,-52.04101562499996],[-73.9732421875,-51.78447265625],[-73.8958984375,-51.331445312499994],[-74.81474609374996,-51.062890624999994],[-75.09467773437495,-50.681249999999956],[-74.333740234375,-49.97460937499997],[-74.34101562499998,-48.59570312499998],[-74.57719726562496,-48.274414062499986],[-74.654931640625,-47.702246093750034],[-74.15839843749998,-47.18251953125002],[-74.15190429687499,-46.97441406249999],[-75.65678710937499,-46.610351562499986],[-74.924462890625,-46.159667968750014],[-75.06669921874993,-45.874902343749994],[-74.15786132812497,-45.76718749999999],[-74.03754882812498,-45.41767578125001],[-73.54990234375,-45.48378906249998],[-73.36245117187502,-44.97822265625001],[-72.73896484375001,-44.73417968750003],[-72.66386718749999,-44.43642578124995],[-73.26508789062498,-44.16865234375001],[-72.99658203125,-43.63154296875001],[-72.78515625,-42.301269531249986],[-72.49941406249997,-41.980859374999994],[-72.66977539062503,-41.65937500000004],[-73.014990234375,-41.54384765624995],[-73.52128906249996,-41.797070312500026],[-73.96586914062493,-41.118261718750034],[-73.66943359375003,-40.08232421875002],[-73.41040039062503,-39.78916015624998],[-73.22646484375002,-39.22441406250003],[-73.53256835937503,-38.366796875000006],[-73.46479492187498,-38.04033203125003],[-73.66181640624998,-37.69853515625003],[-73.60166015624998,-37.18847656250003],[-73.21596679687502,-37.16689453124998],[-73.11806640624997,-36.68837890625002],[-72.87456054687502,-36.39042968749999],[-72.62392578125002,-35.5857421875],[-72.22377929687494,-35.096191406250014],[-72.00283203124997,-34.16533203125],[-71.66435546875002,-33.65263671875],[-71.74296874999996,-33.09511718750001],[-71.45224609374998,-32.65957031250001],[-71.52587890624997,-31.805859374999997],[-71.66196289062498,-31.169531250000034],[-71.66948242187499,-30.33037109374996],[-71.40039062499997,-30.142968749999966],[-71.31572265624996,-29.649707031250017],[-71.51923828124993,-28.926464843750026],[-71.18642578125,-28.37783203124998],[-71.05263671875,-27.727343749999974],[-70.64658203124998,-26.329394531250017],[-70.71372070312498,-25.78417968749997],[-70.44536132812502,-25.17265624999999],[-70.57412109374994,-24.644335937500003],[-70.48779296874994,-23.781738281249957],[-70.56318359374995,-23.057031250000023],[-70.33168945312494,-22.848632812500014],[-70.08754882812494,-21.49306640624998],[-70.19702148437494,-20.725390625000003],[-70.14814453124995,-19.805078124999994],[-70.27578125000002,-19.267578125000014],[-70.33486328124997,-18.82753906249998],[-70.33608398437494,-18.595214843749986],[-70.36162109374999,-18.398046874999963],[-70.41826171874999,-18.345605468750023],[-70.37749023437496,-18.333593749999977],[-70.18378906250001,-18.325195312499957],[-70.05908203125,-18.28349609374999],[-69.92636718749998,-18.206054687500014],[-69.85209960937493,-17.70380859375001],[-69.49501953125002,-17.619531249999994],[-69.3580078125,-17.771679687499983],[-69.31337890624997,-17.943164062500017],[-69.28232421875003,-17.96484375],[-69.09394531249993,-18.05048828125004],[-69.09228515624994,-18.28242187500004],[-69.02680664062493,-18.656249999999986],[-68.97885742187503,-18.81298828125003],[-68.96831054687502,-18.967968749999983],[-68.85795898437499,-19.09335937500005],[-68.62055664062495,-19.29667968749999],[-68.54785156249997,-19.341113281249974],[-68.49199218749996,-19.381933593750034],[-68.47016601562495,-19.409960937499974],[-68.46289062499997,-19.43281250000001],[-68.69829101562499,-19.721093750000037],[-68.75932617187499,-20.115527343750003],[-68.74516601562493,-20.458593750000006],[-68.197021484375,-21.30029296874997],[-68.18642578124997,-21.618554687499966],[-68.11215820312503,-21.753027343750006],[-68.0767578125,-21.982812500000023],[-67.98837890625003,-22.05712890624997],[-67.95390624999993,-22.204003906249966],[-67.95039062499993,-22.333691406249997],[-67.88173828124997,-22.493359375000026],[-67.87944335937496,-22.822949218750026],[-67.57993164062495,-22.89169921874999],[-67.36225585937493,-22.85517578125001],[-67.19487304687493,-22.821679687500037]]]]},"properties":{"name":"Chile","childNum":10}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[110.88876953125006,19.99194335937497],[111.01367187500003,19.65546875000001],[110.57216796875005,19.17187499999997],[110.45126953125012,18.747949218750023],[109.51933593750007,18.21826171875003],[108.7015625,18.535253906250034],[108.69355468750004,19.33828125000005],[109.17910156250005,19.674121093750074],[109.21894531250004,19.842822265625074],[110.1715820312501,20.053710937500057],[110.88876953125006,19.99194335937497]]],[[[130.52695312500012,42.535400390625],[130.24033203125006,42.891796874999955],[129.89824218750002,42.998144531250034],[129.71972656249997,42.47500000000005],[129.3136718750001,42.41357421874997],[128.92343750000006,42.038232421874966],[128.04521484375007,41.98750000000004],[128.29091796875,41.56279296875002],[128.11123046875,41.389257812500006],[127.17968750000003,41.531347656250006],[126.9035156250001,41.78105468749999],[125.98906250000002,40.904638671875034],[124.8893554687501,40.459814453125006],[124.36210937500002,40.004052734374994],[124.10576171875002,39.84101562499998],[123.34814453124997,39.76293945312497],[122.33486328125005,39.36611328125005],[121.64990234375003,38.865087890625034],[121.78544921875002,39.40083007812501],[121.51757812499997,39.638964843750045],[122.27500000000012,40.541845703125034],[121.85878906250005,40.84208984375002],[121.1745117187501,40.901269531249994],[120.47910156250006,40.23095703125003],[119.59111328125007,39.90263671875002],[118.9123046875001,39.16640625000005],[118.29785156249997,39.067089843749955],[117.78466796875003,39.13447265625001],[117.5578125000001,38.625146484374994],[118.01494140625007,38.18339843749996],[118.94003906250006,38.04277343750002],[119.08916015625007,37.70073242187496],[118.95263671875003,37.33115234374998],[119.4499023437501,37.12475585937503],[120.37011718749997,37.701025390625006],[120.75000000000003,37.83393554687501],[121.64023437500012,37.46035156250002],[122.60234375000002,37.42641601562502],[122.51972656250004,36.94682617187502],[121.93271484375006,36.95947265625003],[120.98994140625004,36.59794921874999],[120.39306640625003,36.053857421874994],[120.05468750000003,35.86113281249999],[119.21582031250003,35.01176757812496],[119.58291015625,34.58222656250004],[120.20146484375007,34.32568359375],[120.87109374999997,33.016503906249994],[120.8532226562501,32.66137695312503],[121.40097656250012,32.371923828125034],[121.351953125,31.85878906250005],[121.05537109375004,31.719433593749983],[121.66064453124997,31.319726562499994],[121.87792968750003,30.91699218750003],[120.99765625000012,30.558251953125023],[121.1593750000001,30.3017578125],[121.94433593749997,29.89409179687499],[121.71748046875004,29.25634765625],[121.60205078124997,28.366601562500023],[121.09843750000002,28.29052734374997],[120.2787109375,27.097070312500023],[119.64824218750002,25.91870117187503],[119.53945312500005,25.59125976562504],[119.02460937500004,25.223437500000045],[118.56035156250007,24.580371093750045],[118.0871093750001,24.627001953125045],[118.0560546875,24.24609374999997],[116.53828125000004,23.17968749999997],[116.47070312499997,22.945898437500034],[115.49833984375002,22.718847656250063],[115.19580078125003,22.81728515625005],[114.85380859375007,22.616796875000063],[114.26601562500005,22.540966796874983],[114.01542968750007,22.51191406250001],[113.61962890624997,22.861425781249977],[113.54912109375002,22.225195312500034],[112.30498046875002,21.74169921875003],[111.94394531250012,21.84965820312499],[111.60273437500004,21.55908203125003],[110.77109375000006,21.386523437500045],[110.1935546875001,21.037646484375045],[110.51152343750007,20.51826171875001],[110.12314453125006,20.263720703125017],[109.66259765625003,20.91689453125005],[109.93076171875012,21.480566406250034],[109.54404296875012,21.537939453125006],[109.14863281250004,21.425537109375],[109.03056640625007,21.626513671875017],[108.32480468750006,21.693505859374994],[107.97265624999997,21.507958984375023],[107.35117187500012,21.60888671874997],[106.72949218749997,22.000341796875063],[106.53632812500004,22.395410156249994],[106.78027343749997,22.778906250000034],[106.14843749999997,22.970068359375006],[105.8429687500001,22.922802734374955],[105.27539062500003,23.34521484375003],[104.86474609375003,23.136376953125023],[104.79570312500007,22.91113281249997],[104.37177734375004,22.704052734374983],[103.35605468750006,22.75468749999999],[103.00537109375003,22.452978515624977],[102.51718750000012,22.741015625000045],[102.42792968750004,22.732812499999966],[102.2370117187501,22.466015624999983],[102.1759765625001,22.414648437500006],[102.12744140624997,22.379199218750045],[102.02441406250003,22.43920898437503],[101.84179687500003,22.38847656249999],[101.75996093750004,22.490332031250034],[101.73876953124997,22.495263671874994],[101.70751953125003,22.486572265625],[101.67148437500006,22.462304687500023],[101.64619140625004,22.405419921874966],[101.61992187500002,22.32744140624999],[101.56787109374997,22.27636718749997],[101.52451171875006,22.25366210937497],[101.7365234375001,21.826513671874977],[101.74394531250007,21.77797851562505],[101.74726562500004,21.605761718750045],[101.72294921875007,21.31494140625003],[101.7630859375,21.278906249999977],[101.80205078125002,21.235986328125023],[101.80058593750007,21.212597656249983],[101.78349609375007,21.204150390625017],[101.7047851562501,21.15014648437503],[101.54238281250005,21.23427734375005],[101.2814453125001,21.184130859375045],[101.24785156250007,21.197314453125045],[101.22441406250002,21.223730468750034],[101.1388671875001,21.567480468749977],[100.83515625000004,21.655175781249994],[100.21474609375,21.462988281250006],[99.9176757812501,22.02802734375001],[99.19296875000006,22.12597656249997],[99.33769531250002,22.49804687500003],[99.34082031249997,23.095898437499955],[98.86376953125003,23.191259765625034],[98.76435546875004,24.116064453125063],[98.21250000000006,24.110644531250017],[97.68603515624997,23.898095703124966],[97.53144531250004,24.49169921875003],[97.8195312500001,25.251855468749994],[98.01074218749997,25.292529296875017],[98.6546875,25.917773437500017],[98.7318359375,26.583398437499994],[98.65117187500007,27.572460937499983],[98.29882812499997,27.550097656250045],[98.09892578125002,28.142285156249983],[97.53789062500002,28.510205078124983],[97.43144531250002,28.353906250000023],[97.35644531249997,28.254492187500006],[97.3224609375001,28.21796875000004],[97.28945312500005,28.236816406250057],[97.14511718750012,28.34033203125],[97.07539062500004,28.36894531249996],[96.65283203125003,28.44975585937499],[96.3890625,28.36791992187503],[96.32988281250002,28.496826171875],[96.58085937500007,28.763671875],[96.14140625000007,28.963476562500034],[96.18085937500004,29.11767578125],[96.23496093750006,29.245800781249983],[96.12851562500012,29.38139648437499],[96.07958984375003,29.42412109374999],[96.03535156250004,29.447167968749994],[95.88505859375007,29.39091796874999],[95.7103515625,29.313818359375006],[95.5158203125001,29.206347656250045],[95.49375000000012,29.137011718750045],[95.42021484375007,29.054296875000063],[95.27910156250002,29.04956054687497],[94.99882812500002,29.14916992187503],[94.46806640625007,29.216210937499994],[94.01328125000006,28.90751953124999],[93.76074218750003,28.729785156250017],[93.36054687500004,28.654052734375057],[92.70185546875004,28.147119140624994],[92.65253906250004,28.093359375000034],[92.41484375000002,27.824609374999994],[91.63193359375012,27.759960937499983],[91.64189453125002,27.923242187500023],[91.60556640625006,27.95170898437496],[91.22587890625007,28.071240234374983],[91.07773437500012,27.974462890624977],[91.02080078125002,27.970068359374977],[90.71572265625,28.071728515624983],[90.47734375000007,28.07084960937499],[90.3527343750001,28.080224609375023],[89.98105468750006,28.311181640625023],[89.8978515625,28.29414062500001],[89.81689453125003,28.25629882812501],[89.74980468750002,28.18818359375001],[89.65273437500005,28.158300781250034],[89.53691406250007,28.10742187499997],[88.94755859375002,27.464013671874994],[88.89140625000002,27.316064453124966],[88.83251953125003,27.36284179687499],[88.7648437500001,27.429882812499983],[88.74902343749997,27.521874999999966],[88.82988281250002,27.76738281249999],[88.84882812500004,27.86865234375],[88.80371093750003,28.006933593750034],[88.57792968750002,28.093359375000034],[87.68271484375006,27.821386718750063],[87.29072265625004,27.821923828124994],[87.14140625000002,27.838330078124955],[87.02011718750006,27.928662109374983],[86.9337890625001,27.96845703125001],[86.750390625,28.022070312500006],[86.55449218750007,28.08520507812497],[86.40869140625003,27.928662109374983],[86.07871093750006,28.083593750000006],[85.67832031250012,28.277441406249977],[85.41064453125003,28.27602539062505],[85.21210937500004,28.292626953124966],[85.1224609375,28.315966796875017],[85.08857421875004,28.37226562500001],[85.121484375,28.484277343750023],[85.15908203125,28.592236328124983],[85.1263671875,28.602636718750063],[85.06914062500007,28.60966796874999],[84.85507812500006,28.553613281250023],[84.7142578125,28.595556640625034],[84.2287109375001,28.911767578124966],[84.17558593750002,29.036376953125057],[84.12783203125005,29.15629882812496],[84.10136718750002,29.21997070312497],[84.02197265624997,29.25385742187504],[83.93593750000005,29.27949218750001],[83.58349609375003,29.18359375000003],[83.15546875000004,29.612646484375034],[83.01396484375007,29.618066406249994],[82.85429687500002,29.68339843749996],[82.6408203125001,29.831201171874966],[82.4865234375001,29.941503906249977],[82.15898437500007,30.11518554687501],[82.04335937500005,30.326757812500034],[81.8548828125,30.362402343750006],[81.64189453125007,30.38749999999999],[81.4171875000001,30.33759765625001],[81.25507812500004,30.09331054687499],[81.17714843750005,30.039892578125034],[81.11035156250003,30.03681640625004],[80.98544921875006,30.23710937499999],[80.87353515625003,30.290576171875045],[80.19121093750002,30.56840820312496],[80.20712890625006,30.683740234375023],[79.92451171875004,30.888769531250034],[79.66425781250004,30.965234374999994],[79.10712890625004,31.402636718750017],[78.74355468750005,31.323779296875017],[78.7550781250001,31.55029296875],[78.69345703125006,31.740380859374994],[78.49589843750002,32.21577148437504],[78.4552734375001,32.30034179687502],[78.41748046874997,32.466699218749994],[78.38964843749997,32.51987304687498],[78.73671875,32.55839843750002],[78.75351562500012,32.49926757812506],[79.16992187500003,32.497216796874994],[79.14550781250003,33.00146484375006],[79.10283203125007,33.05253906249996],[79.13515625000005,33.17192382812496],[79.11250000000004,33.22626953125001],[78.94843750000004,33.346533203125006],[78.86503906250002,33.43110351562501],[78.78378906250006,33.80878906250004],[78.72666015625006,34.013378906249955],[78.93642578125,34.35195312500002],[78.86484375000006,34.39033203125001],[78.32695312500007,34.60639648437498],[78.15849609375002,34.94648437499998],[78.07578125000006,35.13491210937502],[77.79941406250006,35.49589843750002],[77.44648437500004,35.47558593750006],[76.25166015625004,35.810937499999994],[76.07089843750006,35.983007812500034],[76.01044921875004,35.996337890625],[75.94511718750002,36.01757812499997],[75.840234375,36.64970703124999],[75.34667968749997,36.913476562499966],[75.05390625000004,36.98715820312498],[74.94912109375,36.96835937500006],[74.88925781250006,36.95244140625002],[74.69218750000007,37.035742187500006],[74.60058593749997,37.03666992187502],[74.54140625,37.02216796875001],[74.52646484375006,37.03066406250005],[74.49794921875,37.057226562500034],[74.37617187500004,37.13735351562502],[74.37216796875006,37.15771484375],[74.72666015625006,37.29072265625001],[74.89130859375004,37.231640624999955],[74.74501953125,38.51000976562497],[74.27744140625,38.659765625000034],[73.80166015625,38.60688476562501],[73.7956054687501,39.00214843749998],[73.60732421875,39.229199218749955],[73.63632812500006,39.396679687499955],[73.63164062500007,39.44887695312502],[73.82294921875004,39.48896484375004],[73.8727539062501,39.533300781250006],[73.9146484375,39.60649414062499],[73.8353515625,39.800146484375006],[73.85625000000002,39.828662109375045],[73.88457031250002,39.87792968750006],[73.93876953125002,39.97880859374999],[73.99160156250005,40.04311523437502],[74.02050781249997,40.05937499999996],[74.0851562500001,40.074316406250006],[74.24267578124997,40.09204101562506],[74.41191406250007,40.13720703125003],[75.0044921875,40.44951171874996],[75.58349609375003,40.605322265625006],[75.65595703125004,40.329248046874966],[75.87197265625,40.30322265625],[76.06230468750002,40.387548828125034],[76.25830078124997,40.43076171875006],[76.3185546875001,40.352246093749955],[76.39638671875005,40.389794921874966],[76.4801757812501,40.44951171874996],[76.82402343750002,40.982324218749966],[76.90771484374997,41.02416992187497],[76.98662109375002,41.039160156250006],[77.58173828125004,40.99277343750006],[77.71933593750012,41.024316406249994],[77.81523437500002,41.05561523437498],[77.9564453125,41.05068359375005],[78.1234375,41.07563476562498],[78.34628906250012,41.28144531249998],[78.36240234375012,41.37163085937496],[79.29355468750006,41.78281249999998],[79.76611328124997,41.89887695312501],[79.84042968750012,41.99575195312502],[79.90966796875003,42.014990234375034],[80.21621093750005,42.03242187500004],[80.23515625000007,42.04345703124997],[80.24619140625012,42.05981445312503],[80.20937500000005,42.190039062500006],[80.16503906249997,42.66552734375006],[80.78574218750006,43.16157226562504],[80.35527343750002,44.09726562500006],[80.45546875,44.74609375],[80.05917968750012,45.006445312500006],[81.60205078125003,45.31083984375002],[82.4787109375001,45.12358398437499],[82.32666015625003,45.519921874999994],[83.0041015625001,47.03349609374996],[83.19306640625004,47.18657226562499],[84.78613281249997,46.83071289062505],[85.65664062500005,47.254638671875],[85.52597656250006,47.915625000000006],[85.7494140625,48.38505859374999],[86.54941406250012,48.52861328125002],[86.75312500000004,49.00883789062496],[87.32285156250012,49.085791015625006],[87.41669921875004,49.07661132812501],[87.5158203125001,49.122412109375006],[87.76250000000007,49.16582031249996],[87.81425781250002,49.162304687499955],[87.82519531249997,49.116308593750006],[87.81630859375,49.080273437499955],[87.83466796875004,49.031933593749955],[87.87216796875012,49.000146484374966],[87.85986328125003,48.96552734375001],[87.74316406250003,48.88164062499999],[87.9796875000001,48.55512695312498],[88.30996093750005,48.47207031250002],[88.41396484375,48.403417968750006],[88.51708984374997,48.384472656249955],[88.56679687500005,48.31743164062496],[88.57597656250007,48.220166015624955],[88.68183593750004,48.170556640624994],[88.83828125000005,48.101708984374994],[88.91777343750007,48.089013671874966],[89.04765625000007,48.002539062500034],[89.11562500000005,47.98769531250002],[89.19628906249997,47.98090820312498],[89.32988281250007,48.024853515624955],[89.5609375,48.00395507812496],[89.63847656250007,47.909082031249994],[89.69316406250002,47.87915039062503],[89.72558593749997,47.85249023437501],[89.77812500000002,47.82700195312498],[89.91044921875007,47.844335937500034],[89.95869140625004,47.88632812499998],[90.02792968750012,47.877685546875],[90.31328125000007,47.676171874999994],[90.49619140625012,47.28515625],[90.86992187500002,46.95449218750005],[91.03388671875004,46.529003906249955],[91.00175781250007,46.03579101562502],[90.6618164062501,45.525244140625006],[90.87724609375002,45.19609375000002],[90.95361328125003,45.21591796875006],[91.05000000000004,45.217431640624994],[91.31210937500006,45.11811523437501],[91.44101562500012,45.12475585937503],[91.51005859375007,45.09824218750006],[91.584375,45.07651367187498],[92.42382812499997,45.008935546874994],[92.57890625000002,45.01098632812506],[92.78789062500007,45.035742187500034],[93.6564453125001,44.900976562500006],[94.71201171875012,44.35083007812503],[95.35029296875004,44.27807617187503],[95.35644531250003,44.005957031250006],[95.52558593750004,43.953955078125006],[95.8419921875001,43.383691406249994],[95.9125,43.20649414062504],[96.29951171875004,42.92871093750003],[96.38544921875004,42.72036132812502],[97.20566406250012,42.78979492187506],[99.46787109375012,42.568212890625034],[99.98378906250005,42.67734375000006],[101.71386718749997,42.46582031250006],[101.97294921875002,42.21586914062502],[103.07285156250006,42.00595703125006],[103.7111328125001,41.75131835937506],[103.99726562500004,41.796972656250034],[104.30517578124997,41.84614257812501],[104.49824218750004,41.87700195312499],[104.49824218750004,41.65869140625],[105.19707031250002,41.738037109375],[105.31435546875005,41.77089843750005],[105.86757812500005,41.993994140625034],[106.77001953125003,42.28872070312502],[108.17119140625002,42.44731445312502],[108.68730468750002,42.416113281250034],[109.13164062500002,42.440576171874966],[109.33984374999997,42.43837890625005],[109.44316406250002,42.455957031249994],[110.40039062499997,42.77368164062497],[111.00722656250005,43.34140624999998],[111.18681640625002,43.391992187499994],[111.45107421875005,43.47490234375002],[111.50351562500006,43.492773437500006],[111.54736328124997,43.49628906250001],[111.6408203125001,43.563183593749955],[111.71972656249997,43.62114257812496],[111.77109375000006,43.66459960937502],[111.8781250000001,43.68017578125],[111.93320312500006,43.71142578125006],[111.94287109374997,43.75244140624997],[111.93173828125012,43.81494140625],[111.83691406249997,43.93466796875006],[111.40224609375005,44.367285156250006],[111.89804687500006,45.064062500000034],[112.03261718750005,45.08164062500006],[112.11289062500006,45.06293945312498],[112.41132812500004,45.05820312499998],[112.59677734375006,44.917675781249955],[112.7067382812501,44.883447265624994],[113.04941406250006,44.81035156250002],[113.3009765625001,44.79165039062502],[113.58701171875006,44.745703125000006],[113.65263671875002,44.76347656249999],[113.87705078125012,44.89619140625001],[114.03027343749997,44.942578124999955],[114.41914062500004,45.20258789062501],[114.48730468750003,45.27172851562506],[114.50224609375002,45.316308593749994],[114.51718750000006,45.36459960937506],[114.56015625000012,45.38999023437498],[114.64433593750002,45.41328125000001],[114.73876953124997,45.41962890624998],[114.91923828125007,45.378271484375006],[115.16259765624997,45.390234375000034],[115.6810546875,45.45825195312503],[116.240625,45.795996093750006],[116.22910156250012,45.84575195312502],[116.21298828125012,45.88691406249998],[116.56259765625012,46.28979492187497],[116.6888671875,46.321972656249955],[116.78701171875,46.37666015625001],[116.85908203125004,46.387939453125],[117.3333984375,46.36201171875004],[117.6710937500001,46.52207031250006],[117.81347656249997,46.537695312500034],[117.91044921875007,46.61933593749998],[118.30869140625012,46.71704101562497],[118.72294921875007,46.69189453125],[118.8439453125001,46.76020507812498],[118.95712890625006,46.73486328124997],[119.16210937499997,46.638671875],[119.33183593750002,46.61381835937499],[119.47402343750005,46.626660156249955],[119.62021484375006,46.60395507812504],[119.70664062500006,46.60600585937502],[119.74746093750005,46.62719726562497],[119.86718750000003,46.67216796874999],[119.89785156250005,46.857812499999966],[119.71113281250004,47.14999999999998],[118.49843750000005,47.98398437499998],[117.76835937500002,47.98789062499998],[117.67666015625005,47.908300781250034],[117.55537109375004,47.80468750000006],[117.45507812500003,47.74135742187502],[117.38398437500004,47.67573242187498],[117.3507812500001,47.65219726562498],[117.28593750000002,47.666357421875034],[117.19707031250007,47.74028320312499],[117.06972656250005,47.80639648437506],[116.95166015624997,47.836572265624966],[116.90117187500007,47.85307617187496],[116.76054687500002,47.869775390624994],[116.65195312500012,47.86450195312497],[116.51347656250007,47.839550781249955],[116.37822265625002,47.84404296874999],[116.31718750000002,47.85986328125],[116.2311523437501,47.85820312500002],[116.07480468750012,47.78955078125],[115.99384765625004,47.71132812500005],[115.89824218750002,47.68691406250005],[115.71171875000002,47.798925781250034],[115.6164062500001,47.874804687500045],[115.55761718750003,47.945019531249955],[115.52509765625004,48.13085937499997],[115.63945312500007,48.18623046874998],[115.785546875,48.24824218750001],[115.7965820312501,48.346337890624994],[115.7916992187501,48.455712890624994],[115.8205078125001,48.57724609375006],[115.9538085937501,48.689355468749994],[116.6833007812501,49.82377929687499],[117.8734375,49.51347656250002],[118.4515625,49.84448242187503],[119.25986328125012,50.06640625000003],[119.19189453125003,50.37983398437504],[120.06689453125003,51.60068359375006],[120.74980468750007,52.096533203125006],[120.65615234375,52.56665039062503],[120.09453125000007,52.787207031250034],[120.70410156249997,53.171826171874955],[122.33779296875,53.485009765624994],[123.6078125,53.546533203124994],[124.81230468750002,53.133837890625045],[125.64902343750012,53.042285156250045],[126.312890625,52.39975585937506],[126.92480468749997,51.10014648437496],[127.590234375,50.20898437500003],[127.50244140624997,49.873437499999994],[127.99960937500006,49.56860351562506],[128.70400390625,49.60014648437499],[129.12011718750003,49.36206054687497],[129.49814453125012,49.38881835937502],[130.80429687500012,48.34150390624998],[130.7121093750001,48.12763671875004],[131.00273437500002,47.69145507812499],[132.5619140625,47.768505859374955],[133.14404296875003,48.10566406249998],[133.46835937500006,48.09716796875003],[134.29335937500005,48.37343750000002],[134.56357421875012,48.321728515624955],[134.75234375,47.71542968749998],[134.1676757812501,47.30219726562501],[133.86132812500003,46.24775390625004],[133.18603515625003,45.49482421875004],[132.93603515624997,45.029931640624994],[131.97753906250003,45.243994140625006],[131.08232421875002,44.91000976562498],[131.2552734375,44.07158203124999],[131.26181640625006,43.43305664062501],[131.06855468750004,42.90224609375005],[130.57724609375006,42.81162109375006],[130.52695312500012,42.535400390625]]],[[[121.00878906249997,22.62036132812497],[120.5812500000001,22.35639648437504],[120.32558593750005,22.54243164062501],[120.0724609375001,23.149755859375006],[120.15898437500002,23.70903320312499],[121.04062500000006,25.032812500000034],[121.59365234375,25.275341796874983],[121.92900390625002,24.973730468749977],[121.29589843750003,22.96660156249999],[121.00878906249997,22.62036132812497]]]]},"properties":{"name":"China","childNum":2}},{"geometry":{"type":"Polygon","coordinates":[[[-5.262304687499977,10.319677734374991],[-4.969921874999926,9.930078125000023],[-4.814453124999972,9.841162109375034],[-4.72177734374992,9.756542968750026],[-4.625830078125006,9.713574218749969],[-4.526611328124943,9.723486328125034],[-4.406201171874926,9.647998046875031],[-4.3322265624999545,9.645703124999997],[-4.18115234375,9.78173828125],[-3.7906249999999204,9.917187499999983],[-3.5811523437499773,9.924316406250014],[-3.2235351562499375,9.895458984374997],[-2.9882812499999716,9.687353515624963],[-2.900878906249943,9.534619140625026],[-2.8751464843749375,9.500927734374997],[-2.816748046874949,9.425830078124974],[-2.705761718749983,9.351367187499989],[-2.5058593750000284,8.208740234375],[-2.6133789062499773,8.046679687500017],[-2.6688476562499943,8.022216796875014],[-2.7897460937499545,7.931933593750003],[-2.9590820312499773,7.454541015624997],[-3.2271484374999773,6.7491210937499915],[-3.200585937499966,6.348242187500034],[-2.9622558593749204,5.643017578124983],[-2.7549804687499773,5.432519531249994],[-2.815673828125,5.153027343749997],[-3.3475585937499943,5.13066406249996],[-4.037207031249977,5.23012695312498],[-5.56474609374996,5.089453125000006],[-6.8451660156249545,4.671484375000034],[-7.544970703124989,4.351318359375],[-7.574658203124983,4.572314453124989],[-7.585058593749977,4.916748046875],[-7.39990234375,5.550585937499989],[-7.636132812499994,5.90771484375],[-7.730371093749994,5.9190429687499915],[-7.800927734374994,6.0389160156249915],[-7.833251953125,6.076367187499983],[-7.855517578125017,6.150146484375],[-7.888623046875011,6.234863281250028],[-7.9815917968749375,6.2861328125],[-8.203857421875,6.29072265625004],[-8.587890625,6.490527343749989],[-8.324511718749989,6.9200195312499915],[-8.408740234374989,7.411816406249997],[-8.429980468749989,7.601855468749989],[-8.231884765624955,7.556738281250034],[-8.205957031249994,7.590234375000023],[-8.115429687499926,7.760742187500028],[-8.016748046874994,8.144921874999966],[-7.953125,8.477734374999997],[-7.823583984374977,8.467675781249994],[-7.950976562499989,8.786816406249997],[-7.8961914062499545,9.415869140624991],[-8.136962890624972,9.495703124999991],[-8.14584960937492,9.881738281250037],[-8.155175781249937,9.973193359375017],[-8.136621093749994,10.022070312500034],[-7.990624999999994,10.162500000000037],[-7.9609375,10.163476562499966],[-7.88408203124996,10.185742187499983],[-7.814208984374943,10.236572265625028],[-7.749072265624989,10.342285156249986],[-7.661132812500028,10.427441406250011],[-7.385058593749989,10.340136718749989],[-6.950341796874994,10.342333984374989],[-6.482617187499983,10.561230468749997],[-6.261132812499994,10.724072265625054],[-6.0345703124999375,10.194824218750057],[-5.843847656249977,10.389550781250023],[-5.694287109374983,10.433203125000034],[-5.556591796874983,10.439941406249986],[-5.382275390625011,10.314013671875003],[-5.262304687499977,10.319677734374991]]]},"properties":{"name":"Ivory Coast","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[15.480078125000006,7.5237792968749915],[15.245898437500017,7.263574218749994],[14.7392578125,6.27978515625],[14.616894531250011,5.865136718749994],[14.708984375,4.665576171874989],[15.022753906250017,4.358544921874994],[15.128710937500017,3.826904296875],[15.775000000000006,3.127197265625],[16.0634765625,2.9085937499999943],[16.183398437500017,2.2700683593749886],[16.059375000000017,1.6762207031249972],[15.741601562500023,1.9149902343749972],[14.902441406250006,2.0123046874999915],[14.484082031250011,2.154736328124997],[13.293554687500006,2.161572265624997],[13.220312500000006,2.2564453124999915],[11.348437500000017,2.2997070312499943],[11.328710937500006,2.167431640624997],[11.096582031250023,2.16748046875],[10.790917968750023,2.1675781249999915],[9.979882812500023,2.1677734374999886],[9.8701171875,2.2132812499999943],[9.80078125,2.304443359375],[9.876171875000011,3.309765624999997],[9.42529296875,3.922314453124997],[9.000097656250006,4.091601562499989],[8.90283203125,4.4351562499999915],[8.532812500000006,4.605859374999994],[8.800976562500011,5.197460937499997],[8.997167968750006,5.917724609375],[9.490234375,6.418652343749997],[9.779882812500006,6.760156249999994],[9.820703125000023,6.783935546875],[9.874218750000011,6.803271484374989],[10.038867187500017,6.92138671875],[10.1435546875,6.9964355468749915],[10.167773437500017,6.959179687499997],[10.185546875,6.912792968749997],[10.205468750000023,6.8916015625],[10.482324218750023,6.891259765624994],[10.606250000000017,7.0630859374999915],[10.954199218750006,6.776562499999997],[11.032519531250017,6.697900390624994],[11.079687500000006,6.505517578124994],[11.1533203125,6.437939453124997],[11.2373046875,6.4505371093749915],[11.324609375000023,6.484667968749989],[11.551660156250023,6.697265625],[11.767382812500017,7.272265624999989],[11.809179687500006,7.3450683593749915],[12.016015625000023,7.589746093749994],[12.2333984375,8.282324218749991],[12.403515625000011,8.595556640624991],[12.582714843750011,8.624121093749991],[12.651562500000011,8.667773437499989],[12.929492187500017,9.42626953125],[13.175488281250011,9.539648437499991],[13.269921875000023,10.036181640624989],[13.535351562500011,10.605078124999991],[13.89208984375,11.140087890624997],[14.559765625000011,11.492285156249991],[14.627148437500011,12.108691406249989],[14.272851562500023,12.356494140624989],[14.184863281250017,12.447216796874997],[14.06396484375,13.078515624999994],[14.244824218750011,13.077343749999997],[14.516210937500006,12.979736328125],[14.76123046875,12.655615234374991],[15.081250000000011,11.845507812499989],[15.029882812500006,11.113671874999994],[15.276074218750011,10.357373046874997],[15.540917968750023,9.960302734374991],[14.243261718750006,9.979736328125],[13.977246093750011,9.691552734374994],[14.332324218750017,9.203515624999994],[15.1162109375,8.557324218749997],[15.442968750000006,7.851855468749989],[15.480078125000006,7.5237792968749915]]]},"properties":{"name":"Cameroon","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[27.4033203125,5.109179687499989],[27.7880859375,4.644677734374994],[28.19208984375001,4.350244140624994],[28.72705078125,4.5049804687499915],[29.151464843750006,4.38818359375],[29.676855468750006,4.5869140625],[30.194921875000006,3.98193359375],[30.50830078125,3.835693359375],[30.83857421875001,3.49072265625],[30.728613281250006,2.4553710937499886],[31.176367187500006,2.2700683593749886],[31.252734375000017,2.0445800781249943],[30.94257812500001,1.6828124999999972],[29.94287109375,0.8192382812499943],[29.934472656250023,0.4990234375],[29.717675781250023,0.09833984374999716],[29.561914062500023,-0.9773437500000028],[29.576953125000017,-1.3878906250000114],[29.12939453125,-1.8602539062500085],[29.1064453125,-2.233203125000003],[28.876367187500023,-2.4002929687500085],[29.01435546875001,-2.72021484375],[29.224414062500017,-3.053515625000003],[29.223242187500006,-3.9108398437500114],[29.403222656250023,-4.449316406250006],[29.404199218750023,-4.496679687500006],[29.32568359375,-4.835644531250011],[29.3427734375,-4.983105468750011],[29.42011718750001,-5.1761718750000085],[29.476464843750023,-5.316601562500011],[29.594140625000023,-5.6507812500000085],[29.59638671875001,-5.775976562500006],[29.490820312500006,-5.965429687500006],[29.480078125000006,-6.025000000000006],[29.506250000000023,-6.172070312500011],[29.540820312500017,-6.3138671875000085],[29.590625000000017,-6.3944335937500085],[29.70966796875001,-6.616894531250011],[29.798144531250017,-6.69189453125],[29.961816406250023,-6.8031250000000085],[30.106250000000017,-6.9150390625],[30.212695312500017,-7.037890625000003],[30.31318359375001,-7.203710937500006],[30.40673828125,-7.460644531250011],[30.75117187500001,-8.193652343750003],[28.972265625000006,-8.464941406250006],[28.917773437500017,-8.700585937500009],[28.400683593750017,-9.224804687500011],[28.63007812500001,-9.831250000000011],[28.63886718750001,-10.669238281250003],[28.357226562500017,-11.483007812500006],[28.482519531250006,-11.812109375000006],[29.064355468750023,-12.348828125000011],[29.427539062500017,-12.431250000000006],[29.79511718750001,-12.155468750000011],[29.795312500000023,-13.392773437500011],[29.55419921875,-13.248925781250009],[29.014257812500006,-13.368847656250011],[28.357714843750017,-12.482031250000006],[27.53339843750001,-12.1953125],[27.04609375000001,-11.615917968750011],[26.949609375000023,-11.898828125000009],[26.59638671875001,-11.972070312500009],[26.025976562500006,-11.89013671875],[25.349414062500017,-11.623046875],[25.184863281250017,-11.242968750000003],[24.5185546875,-11.4384765625],[24.319921875000006,-11.07177734375],[23.96650390625001,-10.871777343750011],[23.901171875000017,-10.983203125000003],[23.833886718750023,-11.013671875],[23.696386718750006,-11.007617187500003],[23.559960937500023,-10.978613281250006],[23.400195312500017,-10.976464843750009],[22.226171875000006,-11.121972656250009],[22.203515625000023,-10.829492187500009],[22.307031250000023,-10.691308593750009],[22.30244140625001,-10.396679687500011],[22.274511718750006,-10.259082031250003],[22.19775390625,-10.040625000000006],[21.81318359375001,-9.46875],[21.905371093750006,-8.693359375],[21.751074218750006,-7.305468750000003],[21.190332031250023,-7.284960937500003],[20.910937500000017,-7.281445312500011],[20.607812500000023,-7.2777343750000085],[20.558398437500017,-7.244433593750003],[20.536914062500017,-7.121777343750011],[20.598730468750006,-6.935156250000006],[20.59003906250001,-6.919921875],[20.482226562500017,-6.915820312500003],[20.190039062500006,-6.9462890625],[19.997460937500023,-6.9764648437500085],[19.87519531250001,-6.986328125],[19.527636718750017,-7.1444335937500085],[19.3408203125,-7.966601562500003],[19.142675781250006,-8.00146484375],[18.944433593750006,-8.00146484375],[18.898339843750023,-7.998144531250006],[18.56269531250001,-7.9359375000000085],[18.0087890625,-8.107617187500011],[17.643359375000017,-8.090722656250009],[17.57958984375,-8.099023437500009],[16.984765625000023,-7.257421875000006],[16.91943359375,-6.9339843750000085],[16.813085937500006,-6.772558593750006],[16.742968750000017,-6.618457031250003],[16.709375000000023,-6.4716796875],[16.7177734375,-6.241406250000011],[16.697265625,-6.164257812500011],[16.537109375,-5.9658203125],[16.431445312500017,-5.900195312500003],[16.315234375000017,-5.8656250000000085],[15.726953125000023,-5.863867187500006],[14.398632812500011,-5.892675781250006],[13.978515625,-5.857226562500003],[13.346484375000017,-5.863378906250006],[13.003320312500023,-5.836132812500011],[12.411718750000006,-5.986328125],[12.503710937500017,-5.69580078125],[12.518945312500023,-5.424609375000003],[12.522363281250023,-5.14892578125],[12.453222656250006,-5.090625000000003],[12.451464843750017,-5.071484375000011],[12.502734375000017,-5.036914062500003],[12.573535156250017,-4.99658203125],[12.829687500000006,-4.736621093750003],[13.07275390625,-4.634765625],[13.414941406250023,-4.83740234375],[14.358300781250023,-4.299414062500006],[14.410742187500006,-4.831250000000011],[14.707910156250023,-4.8817382812500085],[15.60009765625,-4.030957031250011],[15.872460937500023,-3.9342773437500114],[16.146777343750017,-3.464160156250003],[16.217382812500006,-3.0302734375],[16.21533203125,-2.1778320312500057],[16.54072265625001,-1.8401367187500028],[16.8798828125,-1.2258789062500028],[17.27880859375,-0.9996093750000057],[17.752832031250023,-0.5490234375000114],[17.72412109375,-0.27753906250001137],[17.8876953125,0.234130859375],[17.902441406250006,1.1180664062499943],[18.05781250000001,1.5348632812499972],[18.072167968750023,2.0132812499999915],[18.49091796875001,2.9244140624999915],[18.6103515625,3.4784179687499943],[18.567480468750006,4.257568359375],[19.06855468750001,4.891406249999989],[19.5009765625,5.127490234374989],[19.806542968750023,5.089306640624997],[20.226367187500017,4.829638671874989],[20.55810546875,4.462695312499989],[21.53759765625,4.244824218749997],[22.422167968750017,4.134960937499997],[22.755761718750023,4.646679687499997],[23.41718750000001,4.663134765624989],[24.31982421875,4.994140625],[24.765527343750023,4.930078124999994],[25.249316406250017,5.024560546874994],[25.52509765625001,5.3121093749999915],[26.822070312500017,5.062402343749994],[27.11494140625001,5.1978515624999915],[27.4033203125,5.109179687499989]]]},"properties":{"name":"Democratic Republic of the Congo","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[18.6103515625,3.4784179687499943],[18.49091796875001,2.9244140624999915],[18.072167968750023,2.0132812499999915],[18.05781250000001,1.5348632812499972],[17.902441406250006,1.1180664062499943],[17.8876953125,0.234130859375],[17.72412109375,-0.27753906250001137],[17.752832031250023,-0.5490234375000114],[17.27880859375,-0.9996093750000057],[16.8798828125,-1.2258789062500028],[16.54072265625001,-1.8401367187500028],[16.21533203125,-2.1778320312500057],[16.217382812500006,-3.0302734375],[16.146777343750017,-3.464160156250003],[15.872460937500023,-3.9342773437500114],[15.60009765625,-4.030957031250011],[14.707910156250023,-4.8817382812500085],[14.410742187500006,-4.831250000000011],[14.358300781250023,-4.299414062500006],[13.414941406250023,-4.83740234375],[13.07275390625,-4.634765625],[12.881054687500011,-4.445117187500003],[12.384570312500017,-4.619140625],[12.018359375000017,-5.0042968750000085],[11.777539062500011,-4.5658203125000085],[11.130175781250017,-3.916308593750003],[11.504296875000023,-3.520312500000003],[11.685742187500011,-3.6820312500000085],[11.934179687500006,-3.3185546875000114],[11.537792968750011,-2.836718750000003],[11.5751953125,-2.3970703125000057],[12.446386718750006,-2.3299804687500085],[12.43212890625,-1.9289062500000114],[12.793554687500006,-1.9318359375000114],[12.991992187500017,-2.3133789062500085],[13.464941406250006,-2.3954101562500085],[13.784375000000011,-2.1637695312500114],[14.08740234375,-2.4668945312500057],[14.383984375000011,-1.8900390625000085],[14.480566406250006,-0.6183593750000114],[13.860058593750011,-0.20332031250001137],[13.884570312500017,0.19082031249999432],[14.087500000000006,0.5365722656249972],[14.434472656250023,0.8114746093749972],[14.180859375000011,1.3702148437499915],[13.851367187500017,1.4187499999999886],[13.274121093750011,1.2410156249999886],[13.162695312500006,1.6480957031249943],[13.293554687500006,2.161572265624997],[14.484082031250011,2.154736328124997],[14.902441406250006,2.0123046874999915],[15.741601562500023,1.9149902343749972],[16.059375000000017,1.6762207031249972],[16.183398437500017,2.2700683593749886],[16.468554687500017,2.831738281249997],[16.67333984375,3.5352050781249886],[17.43798828125,3.6846191406249886],[18.160937500000017,3.4998046874999886],[18.6103515625,3.4784179687499943]]]},"properties":{"name":"Republic of the Congo","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-71.31972656249997,11.861914062500048],[-71.95810546875,11.666406250000009],[-72.24848632812501,11.196435546875009],[-72.690087890625,10.835839843749994],[-72.86933593750001,10.49125976562496],[-73.00654296874998,9.789160156250006],[-73.35634765625002,9.226855468750031],[-72.79638671874997,9.108984374999991],[-72.66542968749994,8.62758789062498],[-72.41655273437496,8.381982421875037],[-72.44296875,7.454882812499989],[-72.08427734374993,7.096874999999969],[-71.01328124999998,6.994433593749974],[-70.65507812500002,7.082763671875028],[-70.09501953124996,6.937939453125011],[-69.43925781249993,6.1349121093750085],[-68.47177734375,6.156542968749974],[-67.85917968749999,6.289892578124963],[-67.43935546875,6.025537109375023],[-67.82490234374995,5.270458984375026],[-67.85527343750002,4.506884765624989],[-67.66162109375,3.864257812499986],[-67.3111328125,3.41586914062502],[-67.83476562499999,2.8928222656250426],[-67.21083984375,2.3901367187500426],[-66.87602539062499,1.223046875000037],[-67.35195312499997,2.085839843750051],[-67.815087890625,1.790087890625017],[-68.17656249999999,1.7198242187499915],[-69.84858398437493,1.7087402343750426],[-69.85214843750003,1.0595214843750398],[-69.36137695312496,1.0640136718749744],[-69.16323242187502,0.8640625000000028],[-70.05390624999993,0.5786132812500284],[-70.07050781249993,-0.1388671875000398],[-69.66748046874997,-0.48242187499995737],[-69.40024414062498,-1.1949218749999773],[-69.66904296875003,-2.667675781249997],[-69.96591796875003,-4.235937500000006],[-70.16752929687499,-4.0501953125000085],[-70.24028320312496,-3.8827148437499943],[-70.2984375,-3.8442382812499716],[-70.33950195312502,-3.8143554687500085],[-70.73510742187497,-3.7815429687499886],[-70.07402343749993,-2.7501953125000114],[-70.09584960937494,-2.658203125000014],[-70.91455078125003,-2.2185546874999744],[-71.39697265625,-2.3340820312499773],[-71.55947265624997,-2.2242187499999773],[-71.75253906249995,-2.15273437499998],[-71.80273437499997,-2.1663085937499886],[-71.86728515624998,-2.227734374999983],[-71.932470703125,-2.288671874999963],[-71.98427734375,-2.3265624999999517],[-72.13681640624998,-2.38066406249996],[-72.21845703125001,-2.4004882812500057],[-72.30073242187498,-2.40927734375002],[-72.39560546874995,-2.4289062500000256],[-72.62534179687495,-2.3516601562500057],[-72.88715820312501,-2.408496093749946],[-73.15449218749993,-2.278222656249966],[-73.19697265624995,-1.8302734375000114],[-73.49628906249993,-1.6930664062500398],[-73.66430664062497,-1.248828124999946],[-73.86318359374997,-1.19667968749998],[-73.92695312500001,-1.125195312499983],[-74.05439453124995,-1.0286132812500313],[-74.18076171875,-0.9977539062499545],[-74.24638671874999,-0.9706054687500227],[-74.28388671874998,-0.9278320312500057],[-74.33442382812498,-0.8508789062499602],[-74.41787109375,-0.5806640624999773],[-74.80175781249997,-0.20009765624999432],[-75.13837890624998,-0.050488281249968736],[-75.18408203124997,-0.04174804687497158],[-75.22460937499997,-0.04174804687497158],[-75.28447265624999,-0.1065429687500199],[-75.46396484374995,-0.038427734375005684],[-75.61733398437494,0.06289062500003695],[-75.87978515624994,0.1509765625000341],[-76.31103515624997,0.4484863281249858],[-76.49462890624997,0.2354492187500199],[-77.42275390624997,0.4248535156249602],[-77.46767578124997,0.636523437500017],[-78.31210937499995,1.046093750000054],[-78.85966796874996,1.4553710937500313],[-78.576904296875,1.7737792968749773],[-78.617041015625,2.3067871093750227],[-78.12001953125,2.488183593750037],[-77.67001953124998,2.87885742187504],[-77.24277343749998,3.5853515625000085],[-77.1666015625,3.8622558593750114],[-77.42729492187499,4.06044921874998],[-77.28632812499995,4.72172851562496],[-77.40175781249994,5.416162109375037],[-77.24926757812497,5.780175781250037],[-77.46943359374995,6.176757812500014],[-77.35986328125003,6.5044921874999915],[-77.90117187499999,7.229345703125048],[-77.74389648437503,7.536962890625006],[-77.35078124999995,7.7058593750000455],[-77.2123046875,8.033886718749997],[-77.37421874999993,8.65830078125002],[-76.85185546875002,8.09047851562498],[-76.88798828124999,8.619873046875],[-76.27685546875,8.989111328124991],[-76.135498046875,9.265625000000014],[-75.63935546874998,9.450439453125014],[-75.67089843750003,10.196337890625003],[-75.44599609374995,10.610888671874989],[-74.84458007812498,11.109716796875006],[-74.45424804687497,10.989062500000031],[-74.05913085937502,11.340624999999974],[-73.31337890624997,11.295751953124991],[-72.72182617187497,11.712158203125],[-72.27499999999998,11.88925781250002],[-72.13574218749994,12.188574218749977],[-71.71455078124993,12.41997070312496],[-71.26210937499997,12.335302734375034],[-71.31972656249997,11.861914062500048]]]},"properties":{"name":"Colombia","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-83.6419921875,10.917236328125],[-83.4482421875,10.465917968749991],[-82.77841796874999,9.669531249999991],[-82.93984375,9.449169921874997],[-82.94033203125,9.060107421874989],[-82.741162109375,8.951708984374989],[-82.72783203124999,8.916064453124989],[-82.739990234375,8.898583984374994],[-82.91704101562499,8.740332031249991],[-82.855712890625,8.635302734374989],[-82.86162109374999,8.453515624999994],[-83.02734375,8.337744140624991],[-83.16240234374999,8.588183593749989],[-83.73408203125,8.614453124999997],[-83.63725585937499,9.035351562499997],[-83.89555664062499,9.276416015624989],[-84.65888671875,9.646679687499997],[-85.114501953125,9.581787109375],[-85.62485351562499,9.902441406249991],[-85.83061523437499,10.398144531249997],[-85.667236328125,10.745019531249994],[-85.7443359375,11.062109374999991],[-85.62138671874999,11.184472656249994],[-84.9091796875,10.9453125],[-84.348291015625,10.979882812499994],[-84.168359375,10.780371093749991],[-83.6419921875,10.917236328125]]]},"properties":{"name":"Costa Rica","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-82.56176757812503,21.571679687500023],[-82.85317382812497,21.443896484375017],[-83.08251953124997,21.791406250000023],[-82.71455078124998,21.890283203125023],[-82.56176757812503,21.571679687500023]]],[[[-81.83745117187499,23.163037109374955],[-81.17861328124997,23.059667968750034],[-80.65014648437494,23.10307617187499],[-79.67666015624997,22.743066406250023],[-79.27568359374999,22.407617187499994],[-78.68647460937493,22.366845703125023],[-77.86503906250002,21.900585937499983],[-77.49726562499995,21.871630859375045],[-76.64741210937501,21.284521484375063],[-75.72294921874996,21.111035156249983],[-75.64277343749998,20.733496093749977],[-74.882568359375,20.65063476562497],[-74.25283203124997,20.079687500000006],[-75.11640624999995,19.901416015625017],[-76.15844726562497,19.98974609374997],[-77.715087890625,19.85546874999997],[-77.21337890625003,20.300390625000034],[-77.22958984374995,20.643749999999983],[-77.99731445312494,20.715380859375017],[-78.49077148437493,21.05371093750003],[-78.63647460937497,21.51552734375005],[-79.27441406249997,21.562646484374966],[-80.23134765625,21.872167968750063],[-80.49907226562499,22.063525390625045],[-80.96191406249997,22.052880859375023],[-81.81621093750002,22.2001953125],[-81.90341796875,22.679003906250017],[-82.73803710937497,22.689257812500074],[-83.37963867187503,22.222998046875034],[-84.32636718749998,22.074316406250034],[-84.36127929687498,22.37890625],[-84.04492187500003,22.666015625000057],[-83.25781249999997,22.967578125000017],[-82.10136718750002,23.19042968750003],[-81.83745117187499,23.163037109374955]]]]},"properties":{"name":"Cuba","childNum":2}},{"geometry":{"type":"Polygon","coordinates":[[[34.004492187500006,35.065234374999996],[32.71269531250002,35.171044921874994],[32.94160156250001,35.390429687499996],[33.941992187500006,35.292041015624996],[34.004492187500006,35.065234374999996]]]},"properties":{"name":"Northern Cyprus","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[32.71269531250002,35.171044921874994],[34.004492187500006,35.065234374999996],[32.94179687500002,34.57587890625],[32.44902343750002,34.729443359375],[32.31718750000002,34.9533203125],[32.71269531250002,35.171044921874994]]]},"properties":{"name":"Cyprus","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[14.809375000000017,50.858984375],[16.007226562500023,50.611621093749996],[16.679101562500023,50.097460937499996],[17.151953125000006,50.378320312499994],[17.874804687500017,49.972265625],[18.562402343750023,49.879345703125],[18.83222656250001,49.510791015624996],[18.160937500000017,49.257373046874996],[17.75849609375001,48.888134765625],[17.1884765625,48.8609375],[16.953125,48.598828125],[16.477929687500023,48.800097656249996],[16.057226562500006,48.754785156249994],[14.97216796875,48.983935546874996],[14.691308593750023,48.59921875],[14.049121093750017,48.602490234375],[13.814746093750017,48.766943359375],[13.769921875000023,48.815966796874996],[13.547656250000017,48.95966796875],[13.140527343750023,49.158349609374994],[12.632031250000011,49.461230468749996],[12.512500000000017,49.87744140625],[12.3056640625,50.205712890624994],[13.016406250000017,50.490380859374994],[13.18115234375,50.510498046875],[14.369042968750023,50.898730468749996],[14.809375000000017,50.858984375]]]},"properties":{"name":"Czech Republic","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[9.739746093750028,54.82553710937498],[10.360449218750006,54.43833007812506],[11.39960937500004,53.94462890625002],[12.111328125,54.168310546875006],[12.57539062500004,54.467382812500006],[13.028613281250017,54.411035156249994],[13.865527343750074,53.85336914062498],[14.250000000000057,53.73188476562501],[14.298730468750051,53.55644531249999],[14.41455078125,53.28349609374996],[14.412304687500011,53.216748046874955],[14.410937500000074,53.19902343749999],[14.368554687500051,53.105566406250034],[14.293164062500068,53.026757812499966],[14.193652343750045,52.982324218749994],[14.138867187500068,52.93286132812503],[14.128613281250011,52.87822265625002],[14.253710937500017,52.78251953124996],[14.514062500000023,52.645605468750034],[14.619433593750017,52.52851562499998],[14.569726562499994,52.431103515624955],[14.554589843750023,52.35966796874996],[14.573925781250068,52.31416015625001],[14.615625000000023,52.277636718750045],[14.679882812500068,52.25],[14.705371093750017,52.207470703124955],[14.752539062500034,52.08183593750002],[14.601660156250034,51.832373046875006],[14.9638671875,51.095117187499994],[13.18115234375,50.510498046875],[13.016406250000017,50.490380859374994],[12.3056640625,50.205712890624994],[12.512500000000017,49.87744140625],[12.63203125000004,49.46123046875002],[13.14052734375008,49.15834960937505],[13.547656250000074,48.95966796874998],[13.769921875000051,48.81596679687502],[13.814746093750017,48.76694335937498],[13.802929687500011,48.74750976562501],[13.785351562499983,48.58745117187502],[13.486621093750074,48.58183593750002],[13.471679687500028,48.57182617187502],[13.459863281250023,48.564550781250034],[13.40937500000004,48.39414062500006],[13.374609375000063,48.361376953125045],[13.322851562500006,48.33125000000004],[13.215234375000023,48.301904296874994],[12.685839843750074,47.66933593750002],[11.716796875,47.58349609375003],[11.297949218750034,47.424902343750034],[10.873046874999972,47.52021484375001],[10.65869140625,47.547216796875006],[10.482812500000051,47.54179687499996],[10.43037109375004,47.54106445312499],[10.403906250000063,47.41699218750003],[10.312792968750074,47.31342773437498],[10.18300781250008,47.27880859375003],[10.096484375000045,47.379589843749955],[10.066308593750023,47.39335937500002],[10.074218750000028,47.42851562499999],[10.034082031250023,47.47358398437501],[9.748925781250023,47.575537109375006],[8.572656250000023,47.775634765625],[8.414746093750011,47.58959960937503],[7.615624999999994,47.59272460937504],[7.584179687499983,48.064306640625006],[8.134863281250006,48.97358398437498],[7.450585937500051,49.152197265625034],[6.735449218750006,49.16059570312498],[6.344335937500006,49.45273437499998],[6.4873046875,49.798486328124994],[6.1165039062500455,50.120996093749966],[6.364453125000011,50.31616210937503],[5.993945312500017,50.75043945312504],[5.894726562500068,50.98422851562506],[6.193261718750051,51.48891601562502],[5.948535156250017,51.762402343749955],[6.7417968750000625,51.91088867187503],[7.035156250000057,52.38022460937498],[7.197265625000028,53.28227539062499],[7.285253906250034,53.68134765625001],[8.00927734375,53.69072265624999],[8.53847656250008,53.55688476562497],[8.897753906250074,53.83569335937503],[8.95722656250004,54.538330078125],[8.670312500000023,54.903417968750034],[9.739746093750028,54.82553710937498]]]},"properties":{"name":"Germany","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[43.24599609375002,11.499804687499989],[42.92275390625002,10.999316406249989],[42.557714843750006,11.080761718749997],[41.79824218750002,10.98046875],[41.76650390625002,11.589111328125],[42.378515625000006,12.466406249999991],[42.67011718750001,12.376562499999991],[42.703710937500006,12.380322265624997],[42.76748046875002,12.4228515625],[42.88330078125,12.621289062499997],[43.00566406250002,12.662304687499997],[43.11669921875,12.708593749999991],[43.409765625000006,12.18994140625],[43.272070312500006,11.969531249999989],[42.79902343750001,11.739404296874994],[43.24599609375002,11.499804687499989]]]},"properties":{"name":"Djibouti","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[10.645117187500006,55.60981445312498],[10.785253906250034,55.13339843749998],[9.988769531250028,55.163183593750006],[9.860644531250045,55.515478515625034],[10.645117187500006,55.60981445312498]]],[[[12.568750000000023,55.785058593749966],[11.653808593750057,55.186914062499966],[11.286328125000068,55.20444335937498],[10.978906250000051,55.721533203125006],[12.218945312499983,56.11865234374997],[12.568750000000023,55.785058593749966]]],[[[9.739746093750028,54.82553710937498],[8.670312500000023,54.903417968750034],[8.61591796875004,55.41821289062503],[8.132128906250074,55.59980468749998],[8.16396484375008,56.60688476562498],[8.618554687500051,57.11127929687498],[9.554296874999977,57.23247070312496],[9.96230468750008,57.580957031249994],[10.537109375000028,57.44853515625002],[10.282714843750057,56.620507812499994],[10.18300781250008,55.86518554687504],[9.591113281250017,55.49321289062502],[9.739746093750028,54.82553710937498]]]]},"properties":{"name":"Denmark","childNum":3}},{"geometry":{"type":"Polygon","coordinates":[[[-71.647216796875,19.195947265624994],[-71.75742187499999,19.688183593749997],[-71.557763671875,19.89536132812499],[-70.95415039062499,19.913964843749994],[-70.12944335937499,19.636132812499994],[-69.739404296875,19.299218749999994],[-68.684765625,18.90478515625],[-68.35927734375,18.5380859375],[-68.658837890625,18.22202148437499],[-68.9349609375,18.408007812500003],[-69.770654296875,18.443554687499997],[-70.18310546875,18.251757812500003],[-71.02783203125,18.273193359375],[-71.395703125,17.64609374999999],[-71.63173828125,17.773632812499997],[-71.7619140625,18.34130859375],[-71.647216796875,19.195947265624994]]]},"properties":{"name":"Dominican Republic","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[8.207617187500006,36.518945312499994],[8.348730468750006,36.367968749999996],[8.318066406250011,35.654931640624994],[8.31640625,35.403124999999996],[8.35986328125,35.299609374999996],[8.394238281250011,35.203857421875],[8.312109375000006,35.084619140624994],[8.27685546875,34.9794921875],[8.24560546875,34.73408203125],[7.513867187500011,34.080517578125],[7.49560546875,33.976513671875],[7.500195312500011,33.832470703125],[7.534375000000011,33.717919921874994],[7.7626953125,33.23310546875],[7.877246093750017,33.172119140625],[8.2109375,32.926708984375],[8.333398437500023,32.543603515624994],[9.044042968750006,32.07236328125],[9.160253906250006,31.621337890625],[9.224023437500023,31.373681640624994],[9.36328125,30.832910156249994],[9.518750000000011,30.229394531249994],[9.310253906250011,30.115234375],[9.672656250000017,29.5669921875],[9.842578125000017,28.966992187499997],[9.916015625,27.785693359374996],[9.74755859375,27.330859374999996],[9.859375,26.551953124999997],[9.491406250000011,26.333740234375],[9.4482421875,26.067138671875],[10.000683593750011,25.332080078125003],[10.255859375,24.591015624999997],[10.686132812500006,24.55136718749999],[11.536914062500017,24.290820312500003],[11.967871093750006,23.517871093750003],[9.378710937500017,21.991406249999997],[7.481738281250017,20.873095703125003],[5.836621093750011,19.479150390624994],[4.227636718750006,19.142773437499997],[3.40087890625,18.988427734374994],[3.1060546875000057,19.150097656249997],[3.255859375,19.410937500000003],[3.2037109375000057,19.789697265624994],[2.4061523437500227,20.063867187499994],[2.2193359375000057,20.247802734375],[1.6854492187500227,20.378369140624997],[1.1657226562500114,20.817431640625003],[1.1455078125,21.102246093749997],[-1.29296875,22.696533203125],[-3.2578613281249886,23.981250000000003],[-4.822607421874977,24.99560546875],[-6.238671874999994,25.848193359375003],[-8.683349609375,27.285937499999996],[-8.683349609375,27.656445312499997],[-8.683349609375,27.900390625],[-8.659912109375,28.718603515625],[-8.265185546874989,28.980517578124996],[-7.998925781249994,29.132421875],[-7.685156249999977,29.349511718749994],[-7.485742187499994,29.392236328124994],[-7.094921874999983,29.625195312499997],[-6.855566406249977,29.601611328124996],[-6.755126953125,29.583837890625],[-6.635351562499977,29.568798828124997],[-6.520556640624989,29.659863281249997],[-6.510693359374983,29.726025390624997],[-6.507910156249977,29.7837890625],[-6.500878906249994,29.809130859374996],[-5.774999999999977,29.869042968749994],[-5.448779296874989,29.956933593749994],[-5.293652343749983,30.058642578124996],[-5.180126953124983,30.166162109374994],[-4.96826171875,30.465380859374996],[-4.778515624999983,30.552392578124994],[-4.529150390624977,30.625537109374996],[-4.322851562499977,30.698876953124994],[-4.148779296874977,30.8095703125],[-3.7020019531249773,30.944482421874994],[-3.6667968749999886,30.964013671874994],[-3.626904296874983,31.000927734374997],[-3.6725097656249943,31.111376953124996],[-3.8333984374999943,31.197802734374996],[-3.837109374999983,31.512353515624994],[-3.8267578124999773,31.661914062499996],[-3.4397949218749773,31.704541015624997],[-3.0173828124999886,31.834277343749996],[-2.988232421874983,31.874218749999997],[-2.930859374999983,32.042529296874996],[-2.8634277343749943,32.07470703125],[-2.5232421874999886,32.12568359375],[-2.4483886718749943,32.12998046875],[-2.0728027343749886,32.115039062499996],[-1.8169921874999773,32.104785156249996],[-1.275341796874983,32.089013671874994],[-1.16259765625,32.399169921875],[-1.510009765625,32.87763671875],[-1.550732421874983,33.073583984375],[-1.67919921875,33.318652343749996],[-1.7069335937499943,34.176074218749996],[-1.8496582031249886,34.607324218749994],[-1.792187499999983,34.723193359374996],[-1.795605468749983,34.751904296875],[-1.9208984375,34.835546875],[-2.131787109374983,34.970849609374994],[-2.1907714843749773,35.02978515625],[-2.2196289062499943,35.10419921875],[-1.3358398437499943,35.3642578125],[-0.42612304687497726,35.8615234375],[0.047949218750005684,35.900537109374994],[0.514941406250017,36.26181640625],[1.2572265625000227,36.519580078124996],[2.5933593750000057,36.60068359375],[2.9728515625000114,36.784472656249996],[3.7790039062500114,36.89619140625],[4.758105468750017,36.896337890625],[5.195605468750017,36.676806640624996],[6.064746093750017,36.8642578125],[6.486523437500011,37.085742187499996],[6.927539062500017,36.91943359375],[7.607714843750017,36.999755859375],[7.910449218750017,36.856347656249994],[8.127148437500011,36.9103515625],[8.576562500000023,36.93720703125],[8.207617187500006,36.518945312499994]]]},"properties":{"name":"Algeria","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-91.27216796874998,0.02514648437498579],[-90.799658203125,-0.7520507812499915],[-90.90551757812497,-0.9405273437500199],[-91.36918945312493,-0.28720703124997726],[-91.27216796874998,0.02514648437498579]]],[[[-75.28447265624999,-0.1065429687500199],[-75.34047851562494,-0.14218750000000568],[-75.47597656250002,-0.15712890625002274],[-75.26323242187502,-0.555371093749983],[-75.25937500000003,-0.5901367187499602],[-75.27871093749997,-0.6539062499999773],[-75.28359375,-0.7071289062499915],[-75.24960937499998,-0.9518554687500256],[-75.570556640625,-1.5312500000000142],[-75.64165039062502,-1.60732421874998],[-76.08979492187501,-2.1331054687499744],[-76.6791015625,-2.5625976562499915],[-77.860595703125,-2.9816406250000114],[-78.240380859375,-3.4725585937500085],[-78.64799804687499,-4.248144531250006],[-78.68603515625003,-4.562402343749994],[-78.86152343749998,-4.665039062499943],[-78.97539062499999,-4.873242187499997],[-78.99526367187497,-4.908007812499974],[-79.03330078124998,-4.969140624999994],[-79.07626953125003,-4.990625000000023],[-79.18666992187497,-4.958203124999983],[-79.26811523437493,-4.957617187499949],[-79.33095703124997,-4.92783203125002],[-79.39941406249997,-4.840039062499983],[-79.45576171874998,-4.766210937499949],[-79.50190429687495,-4.670605468750011],[-79.51616210937493,-4.539160156249963],[-79.57768554687496,-4.50058593750002],[-79.638525390625,-4.454882812500031],[-79.79726562500002,-4.47636718749996],[-79.962890625,-4.390332031250026],[-80.06352539062499,-4.327539062500023],[-80.13955078125002,-4.296093750000011],[-80.19746093750001,-4.311035156249943],[-80.293359375,-4.416796875000003],[-80.48847656249995,-4.3936523437499915],[-80.35288085937495,-4.208496093750014],[-80.453759765625,-4.205175781249963],[-80.48847656249995,-4.165527343749972],[-80.49345703124999,-4.119140625000014],[-80.510009765625,-4.06953125000004],[-80.49013671874994,-4.010058593750003],[-80.43720703125001,-3.9786132812499915],[-80.30327148437499,-4.005078124999969],[-80.26689453124993,-3.948828124999963],[-80.17924804687493,-3.87773437499996],[-80.21757812500002,-3.7876953124999915],[-80.22060546875002,-3.613183593749966],[-80.24375000000003,-3.5767578125000057],[-80.24541015625002,-3.522167968749997],[-80.26523437499995,-3.4924804687499886],[-80.27353515624995,-3.424609375000017],[-80.30312499999994,-3.3748046874999886],[-79.92158203124993,-3.0901367187499886],[-79.72988281249997,-2.5791015624999716],[-80.45009765624997,-2.6259765625000284],[-80.96279296874997,-2.18925781249996],[-80.770361328125,-2.0766601562500284],[-80.80141601562494,-1.3833984375000057],[-80.90239257812499,-1.0789062499999744],[-80.55390624999998,-0.8479492187499886],[-80.48227539062503,-0.36826171874996305],[-80.1333984375,-0.006054687499982947],[-80.02499999999995,0.4101562499999858],[-80.08828124999997,0.7847656250000199],[-79.74121093749997,0.9797851562500455],[-78.89965820312503,1.2062499999999972],[-78.85966796874996,1.4553710937500313],[-78.31210937499995,1.046093750000054],[-77.46767578124997,0.636523437500017],[-77.42275390624997,0.4248535156249602],[-76.49462890624997,0.2354492187500199],[-76.31103515624997,0.4484863281249858],[-75.87978515624994,0.1509765625000341],[-75.61733398437494,0.06289062500003695],[-75.46396484374995,-0.038427734375005684],[-75.28447265624999,-0.1065429687500199]]]]},"properties":{"name":"Ecuador","childNum":2}},{"geometry":{"type":"Polygon","coordinates":[[[34.24531250000001,31.208300781249996],[34.904296875,29.477343749999996],[34.736425781250006,29.27060546875],[34.39970703125002,28.016015624999994],[34.22011718750002,27.764306640624994],[33.76025390625,28.047656249999996],[33.24775390625001,28.567724609375],[33.075781250000006,29.073046874999996],[32.72148437500002,29.521777343749996],[32.6318359375,28.992236328124996],[32.89824218750002,28.565234374999996],[33.54707031250001,27.898144531249997],[33.5498046875,27.607373046874997],[33.89306640625,27.049462890624994],[33.959082031250006,26.6490234375],[34.56513671875001,25.691162109375],[35.19414062500002,24.475146484375003],[35.62470703125001,24.06601562499999],[35.52275390625002,23.442529296874994],[35.697851562500006,22.946191406249994],[36.22968750000001,22.628808593749994],[36.87138671875002,21.996728515624994],[33.91845703125,21.996240234374994],[31.434472656250023,21.995849609375],[29.564550781250006,21.9951171875],[28.036425781250017,21.995361328125],[24.980273437500017,21.995849609375],[24.980273437500017,24.466064453125],[24.980273437500017,26.487109374999996],[24.980273437500017,29.181884765625],[24.726464843750023,30.2505859375],[24.973925781250017,30.776562499999997],[24.85273437500001,31.334814453125],[25.150488281250006,31.654980468749997],[25.382226562500023,31.51279296875],[25.89326171875001,31.620898437499996],[27.248046875,31.377880859374997],[27.967578125000017,31.097412109375],[28.51484375000001,31.050439453124994],[29.072070312500017,30.830273437499997],[29.591601562500017,31.011523437499996],[30.395117187500006,31.4576171875],[30.700488281250017,31.403857421874996],[31.193945312500006,31.587597656249997],[32.10175781250001,31.092822265624996],[34.24531250000001,31.208300781249996]]]},"properties":{"name":"Egypt","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[40.938574218750006,13.983105468749997],[40.82011718750002,14.111669921874991],[40.22148437500002,14.431152343749972],[39.531835937500006,14.536718749999991],[38.43144531250002,14.428613281249994],[38.221484375000074,14.649658203124986],[38.002539062500006,14.737109375000045],[37.94345703125006,14.810546875],[37.884179687499994,14.852294921874972],[37.82031250000003,14.708496093749986],[37.70839843750005,14.45722656250004],[37.64843750000003,14.32255859375006],[37.571191406249994,14.149072265624966],[37.546777343749994,14.143847656249974],[37.507226562499994,14.156396484375037],[37.257226562499994,14.453759765625051],[37.024511718750006,14.271972656250057],[36.81191406250005,14.315039062500034],[36.67910156250005,14.307568359375026],[36.542382812499994,14.258203124999994],[36.52431640625005,14.256835937499986],[36.492285156250006,14.544335937500023],[36.470800781250006,14.736474609375009],[36.448144531249994,14.940087890625009],[36.42675781249997,15.132080078125043],[36.566015625000006,15.362109375000003],[36.9137695312501,16.296191406250045],[36.887792968750006,16.624658203124994],[36.9787109375001,16.800585937500045],[36.9757812500001,16.866552734375006],[36.99521484375006,17.020556640625017],[37.00898437500004,17.058886718750017],[37.06152343749997,17.061279296875057],[37.16953125000006,17.041406249999994],[37.41103515625005,17.061718749999955],[37.452929687500074,17.108691406250017],[37.510156249999994,17.28813476562499],[37.78242187500004,17.458007812500057],[38.253515625000006,17.584765625000017],[38.26728515625004,17.616699218750057],[38.28984375000002,17.637011718750017],[38.34736328125004,17.68359375],[38.37373046875004,17.717333984375045],[38.42246093750006,17.823925781249983],[38.60947265625006,18.00507812500004],[38.91171875000006,17.427148437499994],[39.14257812500003,16.729150390624966],[39.298925781250006,15.921093750000011],[39.5065429687501,15.532128906249994],[39.86376953124997,15.470312500000034],[40.20410156250003,15.014111328124983],[41.17646484375004,14.620312500000054],[41.65820312499997,13.983056640624994],[42.24511718749997,13.587646484374986],[42.796191406250074,12.864257812500057],[43.08291015625005,12.824609374999966],[43.11669921874997,12.708593749999963],[43.00566406250002,12.66230468750004],[42.88330078124997,12.621289062500026],[42.767480468749994,12.422851562500014],[42.70371093750006,12.380322265625054],[42.67011718750004,12.376562499999991],[42.479394531249994,12.513623046875026],[42.37851562500006,12.466406250000006],[41.76503906250005,13.183935546874991],[41.362890625000006,13.499804687500031],[40.938574218750006,13.983105468749997]]]},"properties":{"name":"Eritrea","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-16.33447265624997,28.37993164062499],[-16.65800781249999,28.007177734374977],[-16.905322265625017,28.33959960937503],[-16.33447265624997,28.37993164062499]]],[[[3.145312500000017,39.79008789062499],[3.4618164062500227,39.69775390625003],[3.0728515625000057,39.30126953124997],[2.371289062500068,39.61308593749999],[2.7849609375000455,39.854833984375034],[3.145312500000017,39.79008789062499]]],[[[-1.7940429687499488,43.407324218750006],[-1.2854492187499886,43.05961914062496],[-0.041162109374994316,42.689111328124966],[1.4283203124999773,42.59589843749998],[1.7060546875,42.50332031250005],[2.0327148437500284,42.353515625],[3.21142578125,42.43115234375],[3.248046875,41.94423828125002],[2.0826171875000625,41.287402343750045],[1.0329101562500682,41.06206054687496],[-0.32700195312494884,39.519873046875006],[-0.20493164062494884,39.062597656250034],[0.20156250000007958,38.75917968750002],[-0.3812499999999943,38.435644531250034],[-0.6467773437499886,38.15185546875003],[-0.8221679687499375,37.58076171875004],[-1.3275390624999375,37.561132812500034],[-1.7976074218749716,37.23286132812504],[-2.111523437499983,36.77666015624999],[-4.366845703124994,36.71811523437506],[-4.67412109374996,36.506445312500006],[-5.171484374999949,36.423779296874955],[-5.62548828125,36.02592773437499],[-6.0406738281249375,36.18842773437498],[-6.492431640624943,36.95463867187502],[-6.88461914062492,37.194238281249966],[-7.4061523437499375,37.17944335937497],[-7.503515624999977,37.58549804687502],[-7.185449218749994,38.00634765625006],[-7.343017578124943,38.45742187500002],[-7.0460449218749375,38.907031250000045],[-7.44511718749996,39.53618164062496],[-7.036718750000006,39.713964843750034],[-6.81015624999992,40.343115234375034],[-6.928466796874972,41.009130859375006],[-6.212499999999949,41.53203124999996],[-6.61826171874992,41.9423828125],[-7.40361328124996,41.833691406249955],[-7.920849609374983,41.883642578125006],[-8.213085937499926,42.133691406249966],[-8.777148437500017,41.941064453124994],[-8.690917968749943,42.274169921875],[-9.235205078124977,42.97690429687498],[-8.873681640624966,43.33442382812498],[-7.698144531249994,43.76455078125005],[-7.261962890624972,43.594628906249966],[-5.66582031249996,43.58247070312498],[-4.52304687499992,43.41572265625004],[-3.604638671874966,43.51948242187504],[-3.045605468749926,43.37158203125],[-2.337109374999926,43.32802734375002],[-1.7940429687499488,43.407324218750006]]]]},"properties":{"name":"Spain","childNum":3}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[22.61738281250004,58.62124023437502],[23.29287109375008,58.483496093750006],[22.152929687500006,58.11533203124998],[22.081347656250074,58.47812499999998],[22.61738281250004,58.62124023437502]]],[[[28.012500000000045,59.484277343749966],[27.464453125000034,58.84130859375],[27.48779296875,58.270068359375045],[27.75283203125008,57.841015624999955],[27.542089843750063,57.799414062500006],[27.400000000000063,57.66679687499999],[27.35195312500005,57.52812499999999],[27.187109375000034,57.53833007812503],[27.033398437500068,57.578759765624994],[26.96601562500001,57.60913085937506],[26.899804687500023,57.608789062499994],[26.29804687500001,57.60107421875],[25.66015625,57.920166015625],[25.11103515625004,58.06342773437498],[24.91132812500001,58.00458984374998],[24.83906250000004,57.98872070312504],[24.775781250000023,57.98525390625002],[24.45888671875005,57.907861328124994],[24.529101562500045,58.35424804687497],[23.767578125000057,58.36083984374997],[23.50927734375003,58.65854492187498],[23.494433593750017,59.19565429687498],[24.38037109375003,59.47265625],[25.50927734374997,59.63901367187506],[26.974707031250006,59.450634765624955],[28.012500000000045,59.484277343749966]]]]},"properties":{"name":"Estonia","childNum":2}},{"geometry":{"type":"Polygon","coordinates":[[[38.43144531250002,14.428613281249994],[39.531835937500006,14.536718749999991],[40.22148437500002,14.43115234375],[40.82011718750002,14.111669921874991],[40.938574218750006,13.983105468749997],[41.362890625000006,13.499804687500003],[41.76503906250002,13.183935546874991],[42.378515625000006,12.466406249999991],[41.76650390625002,11.589111328125],[41.79824218750002,10.98046875],[42.557714843750006,11.080761718749997],[42.92275390625002,10.999316406249989],[42.65957031250002,10.621386718749989],[42.84160156250002,10.203076171874997],[43.181640625,9.879980468749991],[43.482519531250006,9.379492187499991],[44.02285156250002,8.986035156249997],[46.97822265625001,7.9970703125],[47.97822265625001,7.9970703125],[45.93496093750002,5.997216796874994],[44.940527343750006,4.912011718749994],[44.02812500000002,4.950976562499989],[43.53828125000001,4.84033203125],[43.01601562500002,4.5633300781249915],[42.791601562500006,4.2919921875],[42.02412109375001,4.137939453125],[41.91533203125002,4.031298828124989],[41.88398437500001,3.977734374999997],[41.73769531250002,3.9790527343749886],[41.48193359375,3.9632812499999943],[41.22089843750001,3.943554687499997],[41.02080078125002,4.0574707031249915],[40.765234375000006,4.2730468749999915],[39.84218750000002,3.8514648437499943],[39.79033203125002,3.7542480468749915],[39.65751953125002,3.577832031249997],[39.49443359375002,3.4561035156249886],[38.608007812500006,3.60009765625],[38.45156250000002,3.6048339843749915],[38.22529296875001,3.6189941406249915],[38.08613281250001,3.6488281249999943],[37.15458984375002,4.254541015624994],[36.90556640625002,4.4114746093749915],[36.08193359375002,4.44970703125],[36.02197265625,4.4681152343749915],[35.97871093750001,4.503808593749994],[35.76308593750002,4.808007812499994],[35.75615234375002,4.950488281249989],[35.779296875,5.1055664062499915],[35.80029296875,5.156933593749997],[35.74501953125002,5.343994140625],[35.325292968750006,5.364892578124994],[35.2646484375,5.412060546874997],[35.26386718750001,5.457910156249994],[35.26835937500002,5.4922851562499915],[35.08193359375002,5.673144531249989],[34.71064453125001,6.660302734374994],[34.06425781250002,7.225732421874994],[33.666113281250006,7.6709960937499915],[33.22597656250002,7.760644531249994],[33.01259765625002,7.9515136718749915],[33.23427734375002,8.396386718749994],[33.95332031250001,8.443505859374994],[34.09453125000002,8.582226562499997],[34.078125,9.461523437499991],[34.29150390625,10.124755859375],[34.27568359375002,10.528124999999989],[34.571875000000006,10.880175781249989],[34.93144531250002,10.864794921874989],[35.1123046875,11.816552734374994],[35.59609375000002,12.537304687499997],[36.107519531250006,12.726464843749994],[36.21220703125002,13.271093749999991],[36.390625,13.626074218749991],[36.52431640625002,14.2568359375],[36.54238281250002,14.258203124999994],[36.67910156250002,14.307568359374997],[36.81191406250002,14.315039062499991],[37.024511718750006,14.27197265625],[37.25722656250002,14.453759765624994],[37.50722656250002,14.156396484374994],[37.54677734375002,14.143847656250003],[37.57119140625002,14.149072265624994],[37.6484375,14.322558593750003],[37.70839843750002,14.457226562499997],[37.8203125,14.70849609375],[37.88417968750002,14.852294921875],[37.943457031250006,14.810546875],[38.002539062500006,14.737109375000003],[38.22148437500002,14.649658203125],[38.43144531250002,14.428613281249994]]]},"properties":{"name":"Ethiopia","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[28.96582031250003,69.02197265625],[28.470703125000057,68.48837890625],[29.343847656250006,68.06186523437506],[29.941210937500074,67.54746093749998],[29.087011718750034,66.97094726562503],[29.903417968750006,66.091064453125],[29.60419921875004,64.968408203125],[30.072851562500063,64.76503906250005],[30.10810546875004,64.36611328125005],[30.50390625000003,64.02060546875],[30.05537109375004,63.689013671875045],[31.180859375000097,63.208300781250074],[31.533984375000017,62.885400390624994],[31.28564453125003,62.567822265624955],[29.69013671875004,61.54609375000001],[27.797656250000074,60.53613281250003],[25.65644531250004,60.33320312499998],[23.721777343750063,59.965673828125006],[22.79345703125003,60.076806640624994],[22.57587890625001,60.35908203125004],[21.436035156250057,60.596386718749955],[21.36054687500004,60.96748046874998],[21.605957031250057,61.59155273437503],[21.255957031250063,61.98964843750005],[21.103613281250034,62.622949218749994],[22.243261718750034,63.437939453124955],[23.248730468750068,63.89614257812505],[24.557910156250045,64.801025390625],[25.372656250000034,65.00947265625001],[25.34785156250004,65.47924804687497],[24.15546875000004,65.80527343750006],[23.70117187500003,66.48076171874999],[23.988574218750045,66.81054687500003],[23.468066406250074,67.449951171875],[23.63886718750004,67.95439453125002],[22.78242187500001,68.39101562499997],[21.99746093750005,68.52060546874998],[20.622167968750006,69.036865234375],[21.621777343750068,69.27070312499995],[22.410937500000074,68.719873046875],[23.85400390625,68.80590820312503],[24.94140625000003,68.59326171875006],[25.748339843750017,68.99013671875],[26.011523437500074,69.65263671875005],[26.525390625000057,69.91503906250003],[27.889941406250045,70.06166992187497],[29.14160156250003,69.67143554687505],[28.96582031250003,69.02197265625]]]},"properties":{"name":"Finland","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[178.28017578124994,-17.37197265625001],[178.59160156249996,-17.651464843750006],[178.66767578125004,-18.080859375000003],[177.8470703125,-18.254882812500014],[177.32138671875,-18.077539062500037],[177.26396484375007,-17.86347656250004],[177.61796875000007,-17.461035156250034],[178.28017578124994,-17.37197265625001]]],[[[179.99921875000004,-16.168554687499977],[179.74814453125006,-16.44628906249997],[179.9279296875001,-16.74443359374996],[179.00683593750003,-16.90019531249999],[178.80507812499994,-16.631445312500034],[179.55175781250003,-16.249902343750023],[180.00000000000003,-16.15292968749999],[179.99921875000004,-16.168554687499977]]]]},"properties":{"name":"Fiji","childNum":2}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-60.28623046874995,-51.461914062500014],[-59.26806640625,-51.42753906250003],[-59.92138671874997,-51.969531250000045],[-60.28623046874995,-51.461914062500014]]],[[[-58.85019531249995,-51.26992187499998],[-58.473730468750006,-51.50908203125003],[-57.976513671874955,-51.38437500000003],[-57.83818359374993,-51.70917968750003],[-58.68349609375002,-51.93623046875001],[-59.06801757812502,-52.17304687500003],[-59.57080078124994,-51.92539062500003],[-59.05952148437498,-51.685449218749994],[-58.85019531249995,-51.26992187499998]]]]},"properties":{"name":"United Kingdom","childNum":2}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[55.79736328125003,-21.33935546875003],[55.36269531250005,-21.27363281250004],[55.311328125000074,-20.90410156249999],[55.661914062500074,-20.906249999999986],[55.79736328125003,-21.33935546875003]]],[[[-51.65253906249998,4.061279296874972],[-51.99062499999994,3.702001953124963],[-52.70063476562501,2.36367187499998],[-52.96484375,2.1835449218749687],[-53.76777343749998,2.3548339843750483],[-54.13007812499998,2.1210449218750256],[-54.51508789062498,2.245458984374963],[-54.55048828125001,2.2930664062499915],[-54.59194335937502,2.3137695312500313],[-54.61625976562499,2.3267578125000057],[-54.60473632812497,2.3357910156249915],[-54.56840820312502,2.3425781250000313],[-54.53593749999999,2.343310546875003],[-54.48554687500001,2.4161132812500057],[-54.402001953124966,2.46152343750002],[-54.25673828125002,2.7137207031249773],[-54.19550781249998,2.817871093750057],[-54.03422851562499,3.62939453125],[-54.350732421874994,4.054101562500023],[-54.45219726562496,5.013476562499989],[-54.085302734375006,5.41181640625004],[-53.84716796875,5.782226562500014],[-53.454443359375006,5.563476562500028],[-52.899316406249966,5.425048828124986],[-52.29052734375003,4.942187500000031],[-51.91958007812494,4.52431640624998],[-51.65253906249998,4.061279296874972]]],[[[9.480371093750023,42.80541992187503],[9.550683593750051,42.12973632812506],[9.186132812500034,41.38491210937502],[8.80751953125008,41.58837890625],[8.71308593750004,42.54975585937501],[9.480371093750023,42.80541992187503]]],[[[5.789746093749983,49.53828125000001],[5.823437500000011,49.50507812499998],[5.9013671875,49.48974609374997],[5.928906250000011,49.47753906249997],[5.959472656250028,49.45463867187502],[6.074121093750023,49.45463867187502],[6.119921875000017,49.485205078125034],[6.242187500000057,49.49433593750001],[6.277343750000028,49.47753906249997],[6.344335937500006,49.45273437499998],[6.735449218750006,49.16059570312498],[7.450585937500051,49.152197265625034],[8.134863281250006,48.97358398437498],[7.584179687499983,48.064306640625006],[7.615624999999994,47.59272460937504],[7.000585937500034,47.32250976562506],[6.429003906250017,46.832275390625],[6.06025390625004,46.42817382812501],[6.095898437500011,46.279394531250006],[5.9700195312500455,46.214697265625034],[5.971484375000074,46.151220703125006],[6.0066406250000455,46.14233398437506],[6.086621093750068,46.14702148437502],[6.758105468750017,46.41577148437497],[6.772070312500006,46.16513671874998],[7.021093750000034,45.92578124999997],[7.153417968749977,45.40092773437499],[6.627734375000017,45.11796874999999],[7.030664062500023,44.71669921875005],[6.96728515625,44.280029296875],[7.651464843750034,44.03364257812498],[7.4931640625,43.767138671875045],[6.494042968750023,43.169287109375006],[6.115917968750011,43.07236328124998],[5.406542968750074,43.228515625],[5.05976562500004,43.44453125000004],[4.628710937500074,43.387109374999966],[4.052636718750023,43.59306640625002],[3.2588867187500625,43.193212890625006],[3.051757812500057,42.915136718750006],[3.21142578125,42.43115234375],[2.0327148437500284,42.353515625],[1.7060546875,42.50332031250005],[1.4283203124999773,42.59589843749998],[-0.041162109374994316,42.689111328124966],[-1.2854492187499886,43.05961914062496],[-1.7940429687499488,43.407324218750006],[-1.4848632812499432,43.56376953124999],[-1.2455078124999375,44.55986328124999],[-1.0660156249999488,45.80566406250003],[-1.1462890624999602,46.311376953125034],[-1.7865234374999375,46.51484375000001],[-2.0188964843749204,47.03764648437502],[-3.1588378906249943,47.694677734375034],[-4.312109374999949,47.82290039062502],[-4.62919921874996,48.085791015625034],[-4.39316406249992,48.36762695312498],[-4.72075195312496,48.539892578125006],[-3.2314453124999716,48.84082031250003],[-2.692333984374983,48.53681640624998],[-2.4461914062499375,48.64829101562506],[-1.4376464843749943,48.64140624999999],[-1.8564453124999716,49.68378906249998],[-1.2586425781249488,49.68017578125006],[-1.1385253906249773,49.38789062500001],[-0.16347656249993747,49.296777343749994],[0.18671874999998295,49.703027343749994],[1.2455078125000512,49.99824218750001],[1.5515625000000455,50.29394531250003],[1.5794921875000512,50.73925781249997],[1.9125000000000512,50.99062500000002],[2.52490234375,51.097119140624955],[2.8397460937500227,50.71176757812498],[4.174609375000017,50.24648437500005],[4.867578125000051,49.78813476562502],[5.789746093749983,49.53828125000001]]]]},"properties":{"name":"France","childNum":4}},{"geometry":{"type":"Polygon","coordinates":[[[13.293554687500006,2.161572265624997],[13.162695312500006,1.6480957031249943],[13.274121093750011,1.2410156249999886],[13.851367187500017,1.4187499999999886],[14.180859375000011,1.3702148437499915],[14.434472656250023,0.8114746093749972],[14.087500000000006,0.5365722656249972],[13.884570312500017,0.19082031249999432],[13.860058593750011,-0.20332031250001137],[14.480566406250006,-0.6183593750000114],[14.383984375000011,-1.8900390625000085],[14.08740234375,-2.4668945312500057],[13.784375000000011,-2.1637695312500114],[13.464941406250006,-2.3954101562500085],[12.991992187500017,-2.3133789062500085],[12.793554687500006,-1.9318359375000114],[12.43212890625,-1.9289062500000114],[12.446386718750006,-2.3299804687500085],[11.5751953125,-2.3970703125000057],[11.537792968750011,-2.836718750000003],[11.934179687500006,-3.3185546875000114],[11.685742187500011,-3.6820312500000085],[11.504296875000023,-3.520312500000003],[11.130175781250017,-3.916308593750003],[10.34765625,-3.0130859375000085],[9.759472656250011,-2.5185546875],[9.265625,-1.8250976562500085],[9.330664062500006,-1.5345703125000085],[9.064648437500011,-1.29833984375],[8.821386718750006,-0.7083984375000085],[9.296679687500017,-0.35126953125001137],[9.470117187500023,0.3619140624999915],[9.329980468750023,0.61083984375],[9.625878906250023,0.7794433593749943],[9.676464843750011,1.07470703125],[10.028515625000011,1.0040039062499915],[11.335351562500023,0.9997070312499972],[11.332324218750017,1.5283691406249886],[11.328710937500006,2.167431640624997],[11.348437500000017,2.2997070312499943],[13.220312500000006,2.2564453124999915],[13.293554687500006,2.161572265624997]]]},"properties":{"name":"Gabon","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-6.218017578125,54.08872070312506],[-7.3551757812499545,54.12124023437502],[-8.118261718749977,54.41425781250004],[-7.2186523437499375,55.09199218749998],[-6.129150390625028,55.217382812500034],[-5.470410156249926,54.500195312499955],[-5.60678710937492,54.272558593750034],[-6.218017578125,54.08872070312506]]],[[[-3.109667968749932,58.515478515625034],[-3.212353515624983,58.32124023437501],[-3.99003906249996,57.95903320312502],[-3.4027832031249545,57.708251953125],[-2.0740722656249773,57.70239257812506],[-1.7779296874999488,57.493750000000006],[-2.6527343750000227,56.318261718749966],[-3.178222656249943,56.080126953125045],[-2.1470703124999204,55.90297851562502],[-1.6553710937499488,55.57036132812502],[-1.2917480468749432,54.77387695312501],[-0.6713867187499432,54.50390625],[-0.20556640625,54.021728515625],[0.5587890625000398,52.96694335937505],[1.6567382812499716,52.753710937500045],[1.5589843750000512,52.08686523437498],[0.9550781250000284,51.80781249999998],[0.6865234375000284,51.38657226562506],[1.4149414062500227,51.36328125],[0.9601562500000114,50.92587890624998],[0.205078125,50.763037109375034],[-1.5167480468749375,50.747460937499966],[-2.5477539062499375,50.61630859374998],[-3.40458984374996,50.63242187499998],[-3.7933593749999375,50.229248046875],[-4.172558593749926,50.390820312499955],[-5.342285156249943,50.24614257812496],[-4.582910156249966,50.7763671875],[-4.188183593749926,51.18852539062502],[-3.1359863281249716,51.20502929687501],[-4.38627929687496,51.74106445312506],[-4.902294921874926,51.626269531250045],[-5.088085937499926,51.99589843750002],[-4.383154296874949,52.19731445312502],[-3.980322265624949,52.54174804687503],[-4.111035156249926,53.218945312499955],[-3.064746093749932,53.426855468750034],[-2.9250976562499886,53.732763671875006],[-3.9579101562499943,54.780957031249955],[-5.135498046875,54.857519531250006],[-4.7211425781249545,55.42099609375006],[-5.245605468749972,55.929248046875045],[-5.6095703124999545,56.055273437500034],[-5.39194335937492,56.51479492187505],[-5.936767578125,56.605712890625],[-5.561914062499994,57.23271484375002],[-5.8180664062499545,57.43608398437496],[-5.338281250000023,58.23872070312498],[-4.715429687499949,58.510009765625],[-3.109667968749932,58.515478515625034]]]]},"properties":{"name":"United Kingdom","childNum":2}},{"geometry":{"type":"Polygon","coordinates":[[[46.30546875000002,41.507714843749994],[46.43095703125002,41.077050781249994],[46.086523437500006,41.183837890625],[45.28095703125001,41.449560546875],[45.21718750000002,41.423193359375],[45.00136718750002,41.290966796875],[44.97587890625002,41.277490234374994],[44.81132812500002,41.259375],[44.81093750000002,41.248583984374996],[44.84853515625002,41.220166015625],[44.841406250000006,41.211376953125],[44.47304687500002,41.191015625],[44.077246093750006,41.182519531249994],[43.43339843750002,41.155517578125],[42.78789062500002,41.563720703125],[42.466406250000006,41.439843749999994],[41.92578125,41.495654296874996],[41.82353515625002,41.432373046875],[41.779394531250006,41.44052734375],[41.701757812500006,41.471582031249994],[41.57656250000002,41.497314453125],[41.51005859375002,41.517480468749994],[41.76298828125002,41.970019531249996],[41.48876953125,42.659326171874994],[40.83662109375001,43.0634765625],[40.524023437500006,43.121044921875],[40.02373046875002,43.48486328125],[40.648046875000006,43.53388671875],[41.083105468750006,43.374462890625],[41.35820312500002,43.333398437499994],[41.46074218750002,43.276318359375],[41.58056640625,43.21923828125],[42.05000000000001,43.19013671875],[42.27968750000002,43.228076171874996],[42.419042968750006,43.22421875],[42.566015625000006,43.155126953125],[42.660253906250006,43.159082031249994],[42.76064453125002,43.169580078124994],[42.99160156250002,43.09150390625],[43.78261718750002,42.747021484375],[43.79873046875002,42.727783203125],[43.79541015625,42.702978515625],[43.74990234375002,42.657519531249996],[43.738378906250006,42.616992187499996],[43.759863281250006,42.59384765625],[43.82597656250002,42.571533203125],[43.95742187500002,42.566552734374994],[44.00468750000002,42.595605468749994],[44.10273437500001,42.616357421874994],[44.32949218750002,42.703515624999994],[44.505859375,42.7486328125],[44.64433593750002,42.734716796875],[44.771093750000006,42.616796875],[44.85048828125002,42.746826171875],[44.87099609375002,42.756396484374996],[44.943359375,42.730273437499996],[45.07158203125002,42.694140624999996],[45.20820312500001,42.648242187499996],[45.34375,42.52978515625],[45.56289062500002,42.5357421875],[45.7275390625,42.475048828125],[45.63427734375,42.234716796875],[45.63857421875002,42.205078125],[46.21269531250002,41.989892578124994],[46.30546875000002,41.507714843749994]]]},"properties":{"name":"Georgia","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-0.068603515625,11.115624999999994],[-0.05771484374997726,10.630615234375],[0.36269531250002274,10.236474609374994],[0.26191406250001137,9.49560546875],[0.5290039062500114,9.358300781249994],[0.41533203125001705,8.652734374999994],[0.6880859375000057,8.304248046874989],[0.5835937500000057,8.145800781249989],[0.634765625,7.353662109374994],[0.5255859375000114,6.8509277343749915],[0.7369140625000057,6.452587890624997],[1.1872070312500114,6.089404296874989],[0.94970703125,5.810253906249997],[0.25966796875002274,5.75732421875],[-0.7977050781249773,5.226708984374994],[-1.6384765624999886,4.980859374999994],[-2.0018554687499943,4.762451171875],[-2.7230468749999943,5.013720703124989],[-2.815673828125,5.153027343749997],[-2.7549804687499773,5.432519531249994],[-2.9622558593749773,5.643017578124997],[-3.2005859374999943,6.3482421874999915],[-3.2271484374999773,6.7491210937499915],[-2.9590820312499773,7.454541015624997],[-2.789746093749983,7.931933593749989],[-2.6688476562499943,8.022216796875],[-2.6133789062499773,8.046679687499989],[-2.505859375,8.208740234375],[-2.705761718749983,9.351367187499989],[-2.6958496093749886,9.481347656249994],[-2.78662109375,10.401904296874989],[-2.9148925781249773,10.592333984374989],[-2.8299316406249773,10.998388671874991],[-0.701416015625,10.988964843749997],[-0.068603515625,11.115624999999994]]]},"properties":{"name":"Ghana","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-11.389404296875,12.404394531249991],[-11.30517578125,12.015429687499989],[-10.933203124999977,12.205175781249991],[-10.677343749999977,11.8994140625],[-10.274853515624983,12.212646484375],[-9.820703124999994,12.04248046875],[-9.043066406249977,12.40234375],[-8.822021484375,11.673242187499994],[-8.407470703125,11.386279296874989],[-8.231494140624989,10.43798828125],[-8.007275390624983,10.321874999999991],[-7.974462890624977,10.229541015624989],[-7.990624999999994,10.162499999999994],[-8.136621093749994,10.022070312499991],[-8.155175781249994,9.973193359374989],[-8.145849609374977,9.881738281249994],[-8.136962890625,9.495703124999991],[-7.896191406249983,9.415869140624991],[-7.950976562499989,8.786816406249997],[-7.823583984374977,8.467675781249994],[-7.953125,8.477734374999997],[-8.236962890624994,8.455664062499991],[-8.256103515625,8.253710937499989],[-8.016748046874994,8.144921874999994],[-8.126855468749994,7.867724609374989],[-8.115429687499983,7.7607421875],[-8.205957031249994,7.590234374999994],[-8.231884765624983,7.5567382812499915],[-8.429980468749989,7.601855468749989],[-8.486425781249977,7.558496093749994],[-8.708300781249989,7.658886718749997],[-8.8896484375,7.2626953125],[-9.117578124999994,7.2159179687499915],[-9.459765624999989,7.442529296874994],[-9.368945312499989,7.639550781249994],[-9.518261718749983,8.346093749999994],[-9.768261718749983,8.534570312499994],[-10.283203125,8.485156249999989],[-10.677343749999977,8.400585937499997],[-10.500537109374989,8.687548828124989],[-10.758593749999989,9.385351562499991],[-11.047460937499977,9.786328124999997],[-11.115673828124983,9.843164062499994],[-11.180859374999983,9.925341796874989],[-11.205664062499977,9.977734374999997],[-11.273632812499983,9.996533203124997],[-11.911083984374983,9.993017578124991],[-12.142333984375,9.875390624999994],[-12.557861328125,9.704980468749994],[-12.958789062499989,9.263330078124994],[-12.998632812499977,9.146923828124997],[-13.028027343749983,9.103564453124989],[-13.077294921874994,9.069628906249989],[-13.1298828125,9.047558593749997],[-13.178369140624994,9.060888671874991],[-13.234228515624977,9.070117187499989],[-13.302636718749994,9.078369140625],[-13.269482421874983,9.170556640624994],[-13.568261718749994,9.543408203124997],[-13.700488281249989,9.851269531249997],[-14.426904296874994,10.248339843749989],[-14.775927734374989,10.931640625],[-15.043017578124989,10.940136718749997],[-14.9990234375,10.9921875],[-14.944433593749977,11.072167968749994],[-14.779296875,11.405517578125],[-14.720263671874989,11.48193359375],[-14.682958984374977,11.508496093749997],[-13.953222656249977,11.664599609374989],[-13.732763671874977,11.736035156249997],[-13.759765625,12.262353515624994],[-13.673535156249983,12.478515625],[-13.732617187499983,12.592822265624989],[-13.729248046875,12.673925781249991],[-13.40576171875,12.662255859374994],[-13.082910156249994,12.633544921875],[-12.291210937499983,12.328027343749994],[-11.389404296875,12.404394531249991]]]},"properties":{"name":"Guinea","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-16.763330078124994,13.064160156249997],[-16.824804687499977,13.341064453125],[-16.56230468749999,13.587304687499994],[-15.509667968749994,13.586230468750003],[-15.834277343749989,13.156445312499997],[-16.648779296874977,13.154150390624991],[-16.763330078124994,13.064160156249997]]]},"properties":{"name":"Gambia","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-13.759765625,12.262353515624994],[-13.73276367187492,11.736035156249983],[-13.953222656249977,11.664599609374989],[-14.682958984374949,11.508496093749983],[-14.720263671875017,11.481933593749986],[-14.779296874999972,11.405517578125057],[-14.944433593749949,11.072167968749994],[-14.999023437499972,10.992187500000043],[-15.04301757812496,10.940136718750011],[-15.093749999999972,11.011035156249974],[-15.181054687499994,11.034228515625003],[-15.216699218749994,11.156249999999986],[-15.39311523437496,11.217236328124983],[-15.501904296875011,11.723779296874966],[-16.138427734375,11.917285156250045],[-16.43681640624996,12.204150390625045],[-16.711816406249937,12.354833984375006],[-16.656933593749955,12.364355468749991],[-16.52133789062495,12.348632812499986],[-16.41630859374996,12.367675781250057],[-16.144189453124937,12.457421875000037],[-15.839550781249955,12.437890624999966],[-15.57480468749992,12.490380859375009],[-15.19609374999996,12.679931640624986],[-14.34921874999992,12.67641601562498],[-14.064843749999966,12.675292968750014],[-13.729248046875,12.673925781250006],[-13.732617187499983,12.592822265625003],[-13.673535156249926,12.478515624999986],[-13.759765625,12.262353515624994]]]},"properties":{"name":"Guinea Bissau","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[11.332324218750017,1.5283691406249886],[11.335351562500023,0.9997070312500114],[10.028515625000068,1.0040039062500057],[9.385937500000068,1.13925781250002],[9.494238281250006,1.4353027343750284],[9.632128906250045,1.5655273437500057],[9.807031250000051,1.9274902343750284],[9.77968750000008,2.0682128906250057],[9.870117187500028,2.21328124999998],[9.979882812499994,2.1677734375000455],[10.790917968750023,2.1675781250000057],[11.096582031250051,2.167480468749986],[11.328710937500006,2.1674316406249687],[11.332324218750017,1.5283691406249886]]],[[[8.735742187500023,3.7583007812499716],[8.946093750000074,3.6275390624999773],[8.704003906250051,3.2236328125000284],[8.474902343749989,3.2646484375000426],[8.735742187500023,3.7583007812499716]]]]},"properties":{"name":"Equatorial Guinea","childNum":2}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[23.852246093749983,35.53544921874999],[24.31289062500005,35.36381835937502],[24.721289062500034,35.4248046875],[25.475683593750063,35.30620117187502],[25.74501953125005,35.142724609374994],[24.79980468750003,34.93447265625002],[24.463671875000045,35.160351562499955],[23.561621093750034,35.29516601562497],[23.852246093749983,35.53544921874999]]],[[[23.41542968750008,38.958642578124994],[24.09902343750008,38.670996093750006],[23.758789062500057,38.401220703125034],[23.25214843750004,38.80122070312498],[23.41542968750008,38.958642578124994]]],[[[26.03896484375008,40.726757812499955],[25.10449218750003,40.994726562500006],[24.38378906250003,40.91274414062502],[23.87890625,40.54438476562501],[23.66455078125003,40.22382812499998],[23.31201171874997,40.216455078124994],[22.629492187500034,40.49555664062501],[22.59218750000005,40.03691406250002],[22.919042968750034,39.62890625000003],[22.96552734375001,39.030908203124966],[23.25292968750003,38.66123046875006],[23.96699218750001,38.27499999999998],[23.58046875000005,38.01054687500002],[23.193652343750017,37.95903320312499],[23.16152343750005,37.333837890625006],[22.765039062500023,37.39331054687503],[23.073535156250074,36.77495117187499],[22.6083984375,36.77973632812501],[22.08046875000008,37.028955078124966],[21.58291015625005,37.080957031249994],[21.5712890625,37.54101562500003],[21.14501953125003,37.91928710937498],[21.40371093750005,38.19667968750002],[21.82470703125003,38.32812500000006],[22.799609375000045,37.981201171875],[22.421679687500045,38.43852539062499],[21.47255859375005,38.321386718750006],[21.113183593750023,38.38466796875002],[20.779687500000023,39.00854492187503],[20.300781250000057,39.32709960937501],[20.099414062500074,39.641259765624966],[20.382421875000006,39.802636718749994],[20.4560546875,40.065576171874994],[20.881640625000017,40.467919921874994],[20.95576171875001,40.775292968749994],[21.575781250000034,40.86894531249996],[21.929492187500045,41.10742187499997],[21.99335937500001,41.13095703125006],[22.23769531250005,41.15517578125002],[22.49355468750005,41.118505859375006],[22.75507812500004,41.31274414062506],[22.91601562500003,41.33627929687506],[23.025585937500068,41.32563476562501],[23.155957031250068,41.32207031249999],[23.239843750000034,41.38496093750001],[23.372070312500057,41.3896484375],[23.433398437500017,41.39873046874999],[23.53583984375001,41.38603515624999],[23.63515625000008,41.386767578125045],[23.880859375000057,41.45595703125002],[23.973535156250023,41.452294921874966],[24.011328124999977,41.460058593750034],[24.03291015625004,41.469091796875034],[24.05605468750005,41.527246093749966],[24.595996093750074,41.44272460937498],[24.773730468750045,41.356103515624994],[24.84687500000004,41.394238281249955],[24.99355468750008,41.36499023437503],[25.133398437500063,41.31577148437506],[25.251171875000068,41.243554687499994],[25.381933593750063,41.264355468749955],[25.52705078125004,41.2998046875],[25.723925781250017,41.31503906249998],[25.784960937500017,41.330419921875006],[25.923339843750057,41.311914062499966],[26.155175781250023,41.43486328124999],[26.320898437500034,41.716552734375],[26.62490234375008,41.401757812499994],[26.03896484375008,40.726757812499955]]]]},"properties":{"name":"Greece","childNum":3}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[-52.73115234375001,69.94472656250005],[-52.045312499999994,69.8072265625],[-52.11259765625002,69.48911132812503],[-53.57841796874996,69.25664062500002],[-53.78305664062498,69.50629882812498],[-54.804101562499994,69.63051757812497],[-54.83046875000002,70.16108398437498],[-53.37514648437502,70.22128906249998],[-52.73115234375001,69.94472656250005]]],[[[-25.43232421875001,70.92133789062495],[-25.402246093749994,70.65268554687503],[-27.89799804687496,70.45400390624997],[-27.70893554687501,70.897119140625],[-25.43232421875001,70.92133789062495]]],[[[-29.952880859375,83.56484374999997],[-25.947412109374966,83.28964843750003],[-24.47031249999995,82.87739257812498],[-21.520654296874966,82.59541015625001],[-25.148828124999966,82.001123046875],[-21.337988281249977,82.068701171875],[-21.14658203124995,81.695166015625],[-17.226220703125023,81.430419921875],[-15.555517578125006,81.83359374999998],[-12.19287109375,81.64912109374995],[-11.528808593749972,81.42402343750001],[-14.503564453124994,80.76328125000006],[-16.76059570312492,80.573388671875],[-16.868408203124943,80.19824218750006],[-19.429199218749943,80.25771484375],[-20.138476562499932,79.803369140625],[-19.283593749999937,79.68315429687502],[-19.07495117187497,79.15234375000006],[-20.955664062499977,78.55502929687503],[-20.862597656249932,77.91186523437503],[-20.23193359374997,77.36840820312497],[-18.339013671874966,77.21528320312504],[-18.51030273437496,76.77817382812498],[-20.942089843749955,76.88701171875005],[-21.877343749999966,76.57348632812503],[-21.56909179687497,76.29370117187506],[-20.10361328124992,76.21909179687503],[-19.508984374999926,75.75751953124995],[-19.425976562499983,75.22983398437503],[-20.484960937500006,75.31425781249999],[-19.22509765625,74.4794921875],[-19.36914062499997,74.28403320312498],[-21.129443359374932,74.11088867187505],[-20.36728515624992,73.8482421875],[-20.509667968749966,73.49287109375001],[-22.18505859374997,73.26987304687506],[-22.036328124999955,72.91845703125006],[-22.29321289062497,72.11953125],[-24.06904296875001,72.49873046874998],[-24.66684570312492,72.437353515625],[-22.013330078124966,71.688818359375],[-21.75224609374999,71.47832031250002],[-21.522656249999926,70.52622070312503],[-23.327832031249983,70.45097656250007],[-23.791796875000017,70.55517578124997],[-24.377001953124932,71.14638671875],[-25.74223632812499,71.18359375],[-26.717919921874994,70.95048828125005],[-27.68876953124999,70.99345703124999],[-28.540917968749937,70.476904296875],[-28.015039062500023,70.40224609375],[-26.747265624999926,70.47553710937501],[-23.173242187499937,70.114599609375],[-23.08823242187492,69.882958984375],[-26.34140624999992,68.70214843750003],[-29.24951171874997,68.29877929687501],[-29.86850585937495,68.31157226562505],[-30.97856445312499,68.06132812500005],[-32.13725585937496,68.38491210937497],[-32.274804687499994,67.92285156249997],[-33.15698242187497,67.62670898437506],[-34.101660156250034,66.72592773437503],[-34.63281249999997,66.43476562499995],[-36.37919921874996,65.830810546875],[-37.75419921874996,65.59306640624999],[-39.96093750000003,65.55620117187502],[-39.57792968749996,65.34077148437501],[-40.655468749999926,64.91533203125002],[-40.18222656249998,64.47993164062495],[-40.78173828125,64.22177734375003],[-40.550390625000034,63.72524414062505],[-42.15297851562502,62.568457031250006],[-42.32148437499998,62.15273437500005],[-42.110205078125006,61.857226562500074],[-42.41874999999999,61.53701171875002],[-42.717041015625,60.767480468749994],[-43.32011718749993,59.928124999999994],[-44.06547851562499,59.92480468750003],[-45.37924804687495,60.20292968750002],[-46.04663085937503,60.61572265625],[-46.01171875000003,61.09682617187505],[-46.87446289062501,60.81640625000003],[-47.79624023437495,60.828857421875],[-48.92207031249998,61.27744140624998],[-49.28906249999997,61.58994140625006],[-49.553466796875,62.23271484374999],[-50.319238281249966,62.473193359375045],[-50.338330078124955,62.82875976562502],[-51.46884765624995,63.64228515625001],[-51.451074218749994,63.90478515625003],[-52.09340820312502,64.41591796874997],[-52.259033203125,65.154931640625],[-53.634716796874955,66.413671875],[-53.038281249999955,66.82680664062497],[-53.88442382812502,67.13554687499999],[-53.418798828125034,67.57456054687498],[-53.577978515625034,67.83681640625005],[-53.03945312500002,68.61088867187499],[-51.24941406250002,68.73994140625001],[-50.50000000000003,69.935791015625],[-52.254638671875,70.05893554687503],[-54.01445312499996,70.42167968750005],[-54.16582031249999,70.82011718750005],[-52.405224609374955,70.68676757812506],[-51.52446289062502,70.43945312500003],[-51.130078124999955,70.97172851562502],[-53.117041015625006,71.31289062499997],[-53.476025390624955,71.64018554687505],[-54.689062500000006,71.36723632812505],[-55.59404296874999,71.55351562500005],[-55.315576171874994,72.11069335937498],[-55.60170898437494,72.453466796875],[-54.737939453124994,72.87250976562501],[-56.10405273437496,73.55815429687499],[-55.92949218750002,73.89541015625002],[-56.70634765625002,74.21918945312501],[-56.80131835937499,74.67167968749999],[-58.603466796874955,75.38530273437499],[-58.51621093749995,75.68906250000006],[-61.18823242187494,76.157861328125],[-63.438867187499994,76.33945312500003],[-66.82617187499997,75.96879882812502],[-69.372900390625,76.331884765625],[-69.25205078125,76.68613281250006],[-70.792822265625,76.86909179687504],[-70.86284179687496,77.175439453125],[-69.35136718749999,77.467138671875],[-72.81806640624995,78.1943359375],[-72.39560546874995,78.50434570312501],[-68.99345703124999,78.857421875],[-67.48222656249993,79.11689453125001],[-65.96787109374998,79.13237304687507],[-64.79228515624993,80.00063476562502],[-66.84365234374997,80.07622070312507],[-66.99589843749999,80.41298828125002],[-62.99326171874998,81.20698242187504],[-61.43598632812498,81.13359375000002],[-61.20292968750002,81.74687500000007],[-58.717382812500006,82.09306640624999],[-54.72587890624996,82.35136718750002],[-52.77558593749998,82.32172851562504],[-50.894433593749994,81.89521484375001],[-48.861181640625006,82.40541992187502],[-45.29106445312502,81.82880859374998],[-44.23886718749998,82.3681640625],[-46.47817382812502,82.95190429687497],[-43.19458007812503,83.25512695312503],[-32.98442382812499,83.59960937500006],[-29.952880859375,83.56484374999997]]]]},"properties":{"name":"Denmark","childNum":3}},{"geometry":{"type":"Polygon","coordinates":[[[-89.2328125,15.888671875],[-88.53623046874999,15.849609375],[-88.22832031249999,15.72900390625],[-88.97641601562499,15.142675781249991],[-89.142578125,15.072314453125003],[-89.22236328125,14.866064453124991],[-89.16220703124999,14.669238281250003],[-89.17177734375,14.606884765624997],[-89.28671874999999,14.529980468749997],[-89.36259765624999,14.416015625],[-89.872705078125,14.045605468749997],[-90.09521484375,13.736523437499997],[-90.60693359375,13.929003906250003],[-91.14604492187499,13.925585937500003],[-91.819091796875,14.228222656249997],[-92.23515624999999,14.54541015625],[-92.20903320312499,14.570996093749997],[-92.18706054687499,14.630078124999997],[-92.159912109375,14.691015624999991],[-92.17646484375,14.761328124999991],[-92.18637695312499,14.818359375],[-92.07480468749999,15.07421875],[-92.187158203125,15.320898437499991],[-92.08212890624999,15.495556640624997],[-91.9572265625,15.703222656249991],[-91.736572265625,16.07016601562499],[-91.433984375,16.070458984374994],[-90.97958984374999,16.07080078125],[-90.70322265624999,16.071044921875],[-90.52197265625,16.071191406249994],[-90.44716796875,16.072705078124997],[-90.45986328125,16.162353515625],[-90.450146484375,16.261376953124994],[-90.4169921875,16.351318359375],[-90.4169921875,16.391015624999994],[-90.710693359375,16.70810546874999],[-90.975830078125,16.867822265624994],[-90.98916015625,17.81640625],[-89.16147460937499,17.814843749999994],[-89.2328125,15.888671875]]]},"properties":{"name":"Guatemala","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-57.194775390625,5.5484374999999915],[-57.331005859375,5.020166015624994],[-57.711083984374994,4.9910644531249915],[-58.05449218749999,4.171923828124989],[-57.832666015624994,3.675976562499997],[-57.54960937499999,3.3528320312499886],[-57.303662109375,3.3770996093749943],[-57.20981445312499,2.8828125],[-56.704345703125,2.0364746093749915],[-56.482812499999994,1.942138671875],[-56.96953124999999,1.9164062499999943],[-57.03759765625,1.9364746093749972],[-57.41269531249999,1.908935546875],[-57.500439453125,1.7738281249999943],[-57.59443359375,1.7041015625],[-57.69174804687499,1.7047851562499972],[-57.795654296875,1.6999999999999886],[-57.982812499999994,1.6484375],[-58.03466796875,1.520263671875],[-58.34067382812499,1.5875488281249943],[-58.38037109375,1.5302246093749972],[-58.39580078124999,1.4817382812499886],[-58.5060546875,1.4386718749999972],[-58.511865234374994,1.28466796875],[-58.8625,1.20361328125],[-58.91660156249999,1.2488769531249915],[-58.968505859375,1.3045898437499943],[-59.231201171875,1.3760253906249886],[-59.53569335937499,1.6999999999999886],[-59.596630859375,1.718017578125],[-59.66660156249999,1.7462890624999972],[-59.66850585937499,1.8423339843749886],[-59.74072265625,1.8741699218749943],[-59.75620117187499,1.900634765625],[-59.75522460937499,2.274121093749997],[-59.9943359375,2.6899902343749886],[-59.854394531249994,3.5874999999999915],[-59.55112304687499,3.933544921874997],[-59.69970703125,4.353515625],[-59.83334960937499,4.4759277343749915],[-60.11113281249999,4.511181640624997],[-60.1486328125,4.533251953124989],[-60.14091796874999,4.569628906249989],[-60.12456054687499,4.59765625],[-60.03178710937499,4.740527343749989],[-59.990673828125,5.0828613281249915],[-60.142041015625,5.238818359374989],[-60.241650390625,5.257958984374994],[-60.335205078125,5.1993164062499915],[-60.40878906249999,5.210156249999997],[-60.45952148437499,5.1880859374999915],[-60.576416015625,5.1924804687499915],[-60.6513671875,5.221142578124997],[-60.742138671875,5.202050781249994],[-61.37680664062499,5.906982421875],[-61.3908203125,5.938769531249989],[-61.303124999999994,6.049511718749997],[-61.22495117187499,6.129199218749989],[-61.15947265624999,6.1744140624999915],[-61.12871093749999,6.214306640624997],[-61.152294921875,6.3851074218749915],[-61.151025390624994,6.446533203125],[-61.20361328125,6.58837890625],[-61.14560546874999,6.694531249999997],[-60.717919921874994,6.768310546875],[-60.586083984374994,6.857080078124994],[-60.39501953125,6.945361328124989],[-60.35209960937499,7.002880859374997],[-60.32207031249999,7.092041015625],[-60.32548828124999,7.133984374999997],[-60.34506835937499,7.1499999999999915],[-60.39238281249999,7.16455078125],[-60.46494140624999,7.166552734374989],[-60.523193359375,7.143701171874994],[-60.71923828125,7.498681640624994],[-60.513623046875,7.813183593749997],[-60.032421875,8.053564453124991],[-59.99072265625,8.162011718749994],[-59.96484375,8.191601562499997],[-59.849072265625,8.248681640624994],[-59.83164062499999,8.305957031249989],[-60.017529296875,8.54931640625],[-59.980615234374994,8.532617187499994],[-59.83652343749999,8.373828124999989],[-59.66611328124999,8.362597656249989],[-59.20024414062499,8.074609374999994],[-58.626611328124994,7.5458984375],[-58.48056640624999,7.038134765624989],[-57.982568359374994,6.785888671875],[-57.19023437499999,6.097314453124994],[-57.194775390625,5.5484374999999915]]]},"properties":{"name":"Guyana","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-83.635498046875,14.876416015624997],[-84.64594726562498,14.661083984375011],[-84.72978515625002,14.71337890625],[-84.78916015625003,14.790380859374977],[-84.98515624999999,14.752441406249972],[-85.17949218749996,14.343310546875017],[-85.28417968749997,14.29165039062498],[-85.37377929687503,14.223876953125028],[-85.47705078125003,14.108691406250003],[-85.68193359375002,13.98256835937498],[-85.731201171875,13.93183593750004],[-85.72773437499993,13.876074218750048],[-85.73393554687496,13.85869140625006],[-85.75341796875,13.852050781250028],[-85.78671874999995,13.844433593749997],[-85.98378906249997,13.965673828125006],[-86.04038085937503,14.050146484374977],[-86.15122070312495,13.994580078125026],[-86.23823242187501,13.899462890625017],[-86.33173828124995,13.770068359375031],[-86.37695312500003,13.755664062500031],[-86.61025390624997,13.774853515625026],[-86.73364257812494,13.763476562500017],[-86.75898437499995,13.746142578125045],[-86.77060546875003,13.698730468749972],[-86.72958984375,13.4072265625],[-86.710693359375,13.31337890624998],[-86.918212890625,13.223583984374983],[-86.92880859375,13.17939453125004],[-86.93315429687502,13.117529296874963],[-86.95888671875002,13.053710937500014],[-87.0591796875,12.991455078125028],[-87.337255859375,12.979248046875028],[-87.49838867187498,13.274902343750043],[-87.781884765625,13.521386718749994],[-87.71533203125003,13.812695312500011],[-87.99101562499996,13.879638671874972],[-88.15102539062497,13.987353515624974],[-88.44912109374994,13.850976562499994],[-88.48266601562503,13.854248046875043],[-88.49765624999998,13.904541015624986],[-88.50434570312501,13.964208984374963],[-88.51254882812498,13.97895507812504],[-89.05712890625,14.329150390624974],[-89.36259765624996,14.416015625],[-89.17177734375,14.606884765624983],[-89.16220703125,14.669238281249989],[-89.22236328125001,14.86606445312502],[-89.142578125,15.072314453125031],[-88.97641601562498,15.142675781249977],[-88.22832031249999,15.729003906249972],[-87.61816406249994,15.909863281249955],[-86.90722656249997,15.762353515625023],[-86.35664062499998,15.783203125],[-85.78398437500002,16.002832031249966],[-85.48369140624996,15.899511718749977],[-84.97373046874998,15.989892578124994],[-84.26142578124998,15.822607421875034],[-83.76044921874998,15.220361328124994],[-83.635498046875,14.876416015624997]]]},"properties":{"name":"Honduras","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[18.905371093750006,45.931738281250034],[19.055078125000023,45.527246093749966],[19.007128906250045,44.86918945312502],[18.66259765625,45.07744140624999],[17.812792968750074,45.07812500000006],[16.53066406250008,45.21669921875002],[16.29335937500005,45.00883789062496],[15.788085937500057,45.17895507812497],[15.736621093750045,44.76582031250001],[16.214257812500023,44.21513671874999],[17.624804687500074,43.04277343749999],[17.585156250000068,42.93837890625005],[16.903125000000017,43.392431640625006],[15.941503906250063,43.656640624999994],[15.122949218749994,44.256787109374955],[14.854589843750034,45.08100585937501],[14.38613281250008,45.342138671875006],[13.9658203125,44.83564453125004],[13.62929687500008,45.108203125000045],[13.878710937500017,45.428369140624994],[14.95458984375,45.499902343749994],[15.624804687500017,45.834033203125045],[15.652148437500074,45.86215820312498],[15.668066406250034,45.904443359374994],[15.666210937500011,46.04848632812502],[15.596875000000011,46.10922851562506],[15.592578125000017,46.139990234375006],[15.608984374999977,46.171923828125045],[15.635937500000068,46.200732421875045],[16.1064453125,46.382226562499994],[16.23671875000008,46.48383789062498],[16.32119140625005,46.53461914062504],[16.42763671875005,46.5244140625],[16.516210937499977,46.499902343749966],[16.569921875000006,46.48500976562505],[16.748046875000057,46.41640625000002],[17.310644531250006,45.99614257812502],[17.96386718750003,45.770263671875],[18.437304687500045,45.76733398437503],[18.533593750000023,45.79614257812503],[18.56464843750004,45.81328124999999],[18.666015625,45.90747070312497],[18.905371093750006,45.931738281250034]]]},"properties":{"name":"Croatia","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-71.647216796875,19.195947265624994],[-71.74321289062502,18.73291015625],[-72.000390625,18.59790039062503],[-72.05986328124993,18.228564453125017],[-72.87666015624998,18.151757812499994],[-73.38515625000002,18.251171874999983],[-73.88496093749998,18.041894531249994],[-74.41904296874998,18.34619140625],[-74.22773437499998,18.662695312499977],[-72.78935546874996,18.434814453125],[-72.34765624999994,18.674951171874994],[-72.81108398437496,19.071582031250074],[-72.70322265625,19.441064453125023],[-73.05273437499997,19.61074218750005],[-73.1177734375,19.90380859374997],[-72.63701171875002,19.90087890625],[-71.75742187499998,19.68818359375001],[-71.647216796875,19.195947265624994]]]},"properties":{"name":"Haiti","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[22.1318359375,48.405322265624996],[22.253710937500017,48.407373046874994],[22.582421875000023,48.134033203125],[22.87666015625001,47.947265625],[22.290625000000006,47.727832031249996],[21.151953125000006,46.304345703124994],[20.613671875000023,46.13349609375],[20.508105468750017,46.166943359375],[20.28095703125001,46.1330078125],[20.241796875000006,46.10859375],[20.21015625000001,46.126025390624996],[20.161425781250017,46.141894531249996],[19.61347656250001,46.169189453125],[19.421289062500023,46.064453125],[18.666015625,45.907470703125],[18.56464843750001,45.813281249999996],[18.533593750000023,45.796142578125],[18.437304687500017,45.767333984375],[17.9638671875,45.770263671875],[17.310644531250006,45.996142578124996],[16.748046875,46.416406249999994],[16.569921875000006,46.485009765624994],[16.516210937500006,46.499902343749994],[16.093066406250017,46.86328125],[16.453417968750017,47.006787109375],[16.434375000000017,47.367431640625],[17.147363281250023,48.00595703125],[17.76191406250001,47.770166015624994],[18.724218750000006,47.787158203124996],[18.914160156250006,48.050830078124996],[19.89863281250001,48.13134765625],[20.490039062500017,48.526904296874996],[21.45136718750001,48.55224609375],[22.1318359375,48.405322265624996]]]},"properties":{"name":"Hungary","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[120.01250000000002,-9.374707031250026],[120.50371093750002,-9.674023437499983],[120.83261718750006,-10.037499999999952],[120.4391601562501,-10.294042968749991],[120.14482421875002,-10.200097656249952],[119.60107421874997,-9.773535156250006],[119.08544921875003,-9.706933593750023],[119.18564453125006,-9.384472656249969],[120.01250000000002,-9.374707031250026]]],[[[125.06816406250002,-9.511914062499997],[124.42753906250002,-10.14863281250004],[123.85761718750004,-10.34355468749996],[123.5892578125,-9.966796875000028],[123.709375,-9.614843750000006],[124.0363281250001,-9.341601562500031],[124.44443359375012,-9.190332031250023],[124.92226562500005,-8.942480468749977],[125.06816406250002,-9.511914062499997]]],[[[116.64082031250004,-8.613867187500006],[116.37724609375002,-8.929003906249989],[116.07646484375002,-8.744921874999974],[116.06113281250006,-8.437402343750023],[116.4015625000001,-8.204199218750034],[116.73408203125004,-8.38691406250004],[116.64082031250004,-8.613867187500006]]],[[[122.7829101562501,-8.611718750000009],[121.65136718749997,-8.898730468749946],[121.03525390625012,-8.935449218749966],[119.80791015625002,-8.697656250000023],[119.91826171875002,-8.445117187500003],[120.61025390625005,-8.24042968750004],[121.44453125000004,-8.57783203125004],[121.96650390625004,-8.455175781250006],[122.2630859375,-8.624902343750037],[122.60351562499997,-8.402441406250006],[122.7829101562501,-8.611718750000009]]],[[[118.24238281250004,-8.317773437499994],[118.98779296875003,-8.33769531249996],[119.00625000000005,-8.749609375000034],[118.18994140624997,-8.840527343749997],[117.06132812500002,-9.099023437499994],[116.78847656250005,-9.006347656250028],[116.83505859375012,-8.532421875000026],[117.16484375000007,-8.367187500000014],[117.56708984375004,-8.426367187499991],[118.11748046875007,-8.12226562500004],[118.24238281250004,-8.317773437499994]]],[[[115.44785156250012,-8.155175781249994],[115.70429687500004,-8.40712890624998],[115.23613281250007,-8.79755859375004],[114.47529296875004,-8.119433593749989],[115.44785156250012,-8.155175781249994]]],[[[126.80097656250004,-7.6678710937500085],[126.4720703125,-7.950390625000011],[125.84316406250005,-7.81669921874996],[126.60957031250004,-7.571777343749972],[126.80097656250004,-7.6678710937500085]]],[[[138.53535156250004,-8.273632812499969],[138.2962890625,-8.405175781250037],[137.68515625000012,-8.262207031249943],[138.00751953125004,-7.641601562499986],[138.29550781250012,-7.4384765625],[138.76982421875002,-7.390429687499974],[138.98906250000002,-7.696093749999989],[138.53535156250004,-8.273632812499969]]],[[[131.3255859375,-7.999511718749986],[131.08681640625005,-7.865039062499946],[131.26005859375007,-7.470507812499946],[131.69111328125004,-7.438867187499994],[131.3255859375,-7.999511718749986]]],[[[113.84453125000007,-7.105371093749994],[113.47070312500003,-7.218457031250026],[112.76376953125006,-7.139648437499957],[112.86806640625,-6.899902343749972],[113.97470703125012,-6.873046875],[113.84453125000007,-7.105371093749994]]],[[[134.53681640625004,-6.442285156249994],[134.35595703124997,-6.814843749999952],[134.05917968750012,-6.769335937500017],[134.16806640625006,-6.176269531249986],[134.53681640625004,-6.442285156249994]]],[[[107.37392578125005,-6.007617187499989],[107.66679687500002,-6.215820312499957],[108.29501953125012,-6.265039062500037],[108.67783203125006,-6.790527343749972],[110.42626953124997,-6.947265625000028],[110.73691406250006,-6.472363281249997],[111.15439453125012,-6.669042968750006],[111.54033203125002,-6.648242187500031],[112.0873046875,-6.89335937499996],[112.53925781250004,-6.9264648437499545],[112.79453125000012,-7.55244140625004],[113.24843750000005,-7.718164062499952],[114.07070312500005,-7.633007812500011],[114.44423828125,-7.895605468749963],[114.38691406250004,-8.405175781250037],[114.58378906250002,-8.769628906250034],[113.25332031250005,-8.286718749999963],[112.67880859375006,-8.409179687499957],[111.50996093750004,-8.30507812499998],[110.60722656250002,-8.149414062499972],[110.03867187500006,-7.890527343749994],[109.28164062500005,-7.704882812500003],[108.74121093749997,-7.667089843750034],[108.45175781250006,-7.79697265625002],[107.91748046875003,-7.724121093750014],[107.28496093750007,-7.471679687500014],[106.63144531250006,-7.415527343750028],[106.51972656250004,-7.053710937499943],[105.48369140625007,-6.781542968750017],[105.86826171875006,-6.11640625000004],[106.07500000000002,-5.914160156249963],[106.82519531249997,-6.098242187499977],[107.0462890625,-5.90419921874998],[107.37392578125005,-6.007617187499989]]],[[[134.74697265625,-5.707031249999957],[134.75585937500003,-6.170605468749983],[134.44111328125004,-6.334863281249966],[134.34130859375003,-5.712890624999986],[134.74697265625,-5.707031249999957]]],[[[122.64511718750012,-5.26943359374998],[122.39628906250002,-5.069824218749986],[122.36894531250007,-4.767187499999977],[122.70195312500002,-4.61865234375],[122.64511718750012,-5.26943359374998]]],[[[126.86113281250007,-3.087890624999986],[127.22734375000007,-3.3910156250000085],[127.22958984375006,-3.6330078125000114],[126.68632812500007,-3.823632812500037],[126.21455078125004,-3.6051757812500256],[126.02646484375012,-3.17050781250002],[126.86113281250007,-3.087890624999986]]],[[[129.75468750000007,-2.865820312500034],[130.3791015625001,-2.9893554687499773],[130.85996093750006,-3.5703125000000284],[130.805078125,-3.85771484374996],[129.844140625,-3.3271484374999574],[129.46767578125005,-3.4532226562499773],[128.9674804687501,-3.3260742187500085],[128.41923828125002,-3.416015624999943],[128.08212890625012,-3.184082031249943],[128.19853515625002,-2.8659179687499687],[129.42734375000006,-2.7907226562500114],[129.75468750000007,-2.865820312500034]]],[[[108.2072265625001,-2.9976562499999773],[107.61445312500004,-3.209375000000037],[107.66630859375002,-2.566308593750037],[108.07441406250004,-2.5969726562499744],[108.2072265625001,-2.9976562499999773]]],[[[124.96953125000007,-1.70546874999998],[124.83447265624997,-1.8944335937500227],[124.41777343750002,-2.0051757812500313],[124.38085937499997,-1.6874999999999716],[124.96953125000007,-1.70546874999998]]],[[[135.47421875000006,-1.5917968750000142],[136.20156250000005,-1.6549804687499972],[136.19257812500004,-1.859179687499946],[135.47421875000006,-1.5917968750000142]]],[[[106.04570312500002,-1.6694335937500142],[106.36591796875004,-2.4648437499999716],[106.67880859375012,-2.7040039062500227],[106.54677734375005,-3.055566406249966],[105.99873046875004,-2.8249023437499545],[105.7858398437501,-2.18134765625004],[105.13339843750012,-2.0425781250000057],[105.58544921875003,-1.5267578124999943],[106.04570312500002,-1.6694335937500142]]],[[[128.1530273437501,-1.66054687499998],[127.56162109375012,-1.7285156249999716],[127.74296875000002,-1.3602539062499943],[128.1530273437501,-1.66054687499998]]],[[[99.16386718750007,-1.7779296875000057],[98.87431640625007,-1.6636718749999915],[98.60175781250004,-1.1978515624999488],[98.86904296875005,-0.9156250000000057],[99.2672851562501,-1.6277343749999602],[99.16386718750007,-1.7779296875000057]]],[[[135.38300781250004,-0.6513671875],[135.89355468749997,-0.7257812499999687],[135.83876953125,-1.1194335937499602],[135.38300781250004,-0.6513671875]]],[[[140.97343750000007,-2.6097656250000085],[140.97353515625,-2.8034179687500256],[140.97441406250002,-4.836328125000023],[140.97519531250006,-6.90537109375002],[140.97617187500012,-9.118750000000006],[139.93476562500004,-8.101171875000006],[139.38564453125,-8.189062499999963],[138.85615234375004,-8.145117187499991],[139.08798828125012,-7.587207031250017],[138.74794921875,-7.25146484375],[138.86455078125007,-6.858398437499943],[138.43867187500004,-6.343359375000006],[138.2521484375001,-5.688183593750026],[137.75908203125007,-5.256152343750017],[137.08925781250005,-4.924414062500034],[136.61884765625004,-4.818749999999994],[135.97968750000004,-4.530859374999963],[135.19560546875007,-4.450683593749972],[134.14707031250006,-3.79677734374998],[133.97382812500004,-3.817968750000034],[133.65312500000007,-3.3643554687499915],[133.24873046875004,-4.062304687499989],[132.96855468750007,-4.094921874999969],[132.75390625000003,-3.703613281250014],[132.75136718750005,-3.294628906249997],[132.34824218750006,-2.97509765625],[133.19101562500006,-2.43779296874996],[133.60869140625007,-2.54716796874996],[133.90488281250012,-2.390917968750003],[133.92158203125004,-2.1020507812499574],[132.96279296875005,-2.272558593749963],[132.30761718749997,-2.24228515625002],[132.02343749999997,-1.99033203125002],[131.93037109375004,-1.559667968750034],[131.29375000000002,-1.3934570312500085],[131.2572265625,-0.8554687500000142],[131.80429687500006,-0.7038085937500256],[132.12841796874997,-0.45410156249995737],[132.62509765625006,-0.3588867187500142],[133.47265624999997,-0.726171874999963],[133.97451171875,-0.7443359375000256],[134.25957031250007,-1.3629882812500256],[134.105859375,-1.720996093749946],[134.15566406250005,-2.1952148437500227],[135.03740234375002,-3.33310546875002],[135.48662109375002,-3.34511718749998],[136.24326171875006,-2.5831054687499915],[136.38994140625002,-2.273339843750037],[136.84326171875003,-2.19765624999998],[137.1234375,-1.840917968749963],[137.80625000000012,-1.4832031250000028],[138.6498046875,-1.79111328125002],[139.78955078125003,-2.34824218750002],[140.62255859374997,-2.44580078125],[140.97343750000007,-2.6097656250000085]]],[[[97.48154296875006,1.4650878906249716],[97.93193359375002,0.9739257812500028],[97.87646484374997,0.6283203125000227],[97.40537109375012,0.9469726562500256],[97.24423828125006,1.4236328124999602],[97.48154296875006,1.4650878906249716]]],[[[124.88886718750004,0.9953125000000114],[124.42753906250002,0.47060546875005116],[123.75380859375,0.3055175781249915],[123.26542968750007,0.3266113281250256],[123.08251953125003,0.48583984375004263],[121.8419921875001,0.4365722656250455],[121.42578125000003,0.49482421875001137],[120.34902343750005,0.44921875000004263],[120.01328125000012,-0.19619140624999432],[120.09746093750002,-0.6499023437499716],[120.51757812499997,-1.0394531250000085],[120.66738281250005,-1.3701171874999716],[121.03369140624997,-1.406542968750017],[121.51933593750007,-0.8555664062500341],[121.96962890625005,-0.9333007812499687],[122.27998046875004,-0.7570312500000256],[122.88876953125006,-0.7551757812500028],[122.50664062500002,-1.3478515624999545],[121.71875000000003,-1.8627929687499716],[121.34882812500004,-1.9459960937499545],[121.84824218750012,-2.331542968749986],[122.39902343750006,-3.200878906249997],[122.25292968749997,-3.620410156250017],[122.87734375,-4.109082031250011],[122.89736328125005,-4.349121093749972],[122.20712890625012,-4.49638671874996],[121.91699218749997,-4.847949218749989],[121.48652343750004,-4.581054687499972],[121.61806640625,-4.092675781249952],[120.9142578125001,-3.5557617187499915],[121.05429687500012,-3.167089843749949],[121.0521484375,-2.7516601562499545],[120.65361328125002,-2.6675781249999773],[120.25410156250004,-3.052832031250034],[120.43662109375012,-3.70732421874996],[120.36250000000004,-4.08574218749996],[120.42011718750004,-4.617382812500011],[120.27929687499997,-5.146093749999977],[120.31162109375006,-5.541601562500006],[119.71728515625003,-5.693359375000014],[119.3761718750001,-5.424804687500014],[119.61171875,-4.42353515625004],[119.62363281250006,-4.034374999999983],[119.41982421875,-3.47539062499996],[118.99462890624997,-3.5375976562500284],[118.81249999999997,-3.1566406249999517],[118.78369140624997,-2.764746093749963],[119.09218750000005,-2.482910156250014],[119.32187500000012,-1.9296875000000142],[119.308984375,-1.408203125],[119.7716796875001,-0.48359375000001137],[119.80927734375004,0.23867187500005116],[120.26953125000003,0.9708007812499915],[120.51660156249997,0.8175292968750227],[120.91210937499997,1.288964843749966],[121.44003906250006,1.2144042968749744],[121.59179687499997,1.0679687499999773],[122.43662109375006,1.0180664062500284],[122.89248046875005,0.8499999999999801],[123.27812500000002,0.9280761718749915],[123.84667968750003,0.8381835937499744],[124.27363281250004,1.0222656249999886],[124.98925781249997,1.7010253906249915],[125.2337890625,1.5022949218750057],[124.88886718750004,0.9953125000000114]]],[[[127.73271484375007,0.8481445312500426],[128.16074218750006,1.1578124999999915],[128.42412109375007,1.5175292968749972],[128.68837890625,1.572558593750017],[128.70263671874997,1.1063964843749972],[128.29882812500003,0.8768066406250199],[128.69160156250004,0.3603515624999716],[127.9831054687501,0.4718750000000398],[127.88740234375004,0.29833984375004263],[128.04638671875003,-0.7060546874999432],[127.69160156250004,-0.24189453124998295],[127.70869140625004,0.2880859374999858],[127.5553710937501,0.48964843750002274],[127.4203125,1.2519531249999858],[127.63173828125,1.8437011718750114],[128.0109375000001,1.7012207031250313],[128.01171874999997,1.331738281249983],[127.65283203124997,1.0138671874999687],[127.73271484375007,0.8481445312500426]]],[[[96.46367187500002,2.360009765625037],[95.80859374999997,2.655615234375034],[95.80625000000012,2.9160156249999716],[96.41728515625007,2.5151855468750313],[96.46367187500002,2.360009765625037]]],[[[117.5744140625001,4.17060546875004],[117.62988281250003,3.6363281249999915],[117.16640625,3.5919921875000256],[117.61064453125002,3.0643554687499943],[118.0666015625001,2.3178222656249687],[117.8646484375,1.9684082031250085],[118.08037109375007,1.701855468749983],[118.98496093750006,0.982128906249983],[118.53476562500006,0.813525390625017],[118.19609375000002,0.8743652343749773],[117.74511718749997,0.7296386718749801],[117.52216796875004,0.23588867187501705],[117.46289062500003,-0.32373046874995737],[117.56249999999997,-0.7708984375000085],[116.55449218750007,-1.4739257812499744],[116.42353515625004,-2.0525390624999886],[116.56542968749997,-2.2997070312499943],[116.33066406250012,-2.9021484374999744],[115.95615234375012,-3.595019531250003],[114.6935546875001,-4.169726562500017],[114.53613281249997,-3.4944335937500313],[114.0822265625001,-3.2789062499999915],[113.79580078125,-3.4562499999999687],[113.52597656250006,-3.184082031249943],[112.97148437500002,-3.187109375000034],[112.60029296875004,-3.4004882812499773],[112.28496093750002,-3.32099609375004],[111.82207031250007,-3.5325195312499744],[111.82304687500007,-3.057226562499949],[111.367578125,-2.9336914062500057],[111.04433593750005,-3.0557617187500057],[110.57402343750007,-2.891406250000003],[110.2326171875001,-2.9250976562500313],[110.01923828125004,-1.3988281249999517],[109.78740234375007,-1.011328124999963],[109.45380859375004,-0.868749999999963],[109.160546875,-0.49492187500001705],[109.2575195312501,0.03115234375005116],[108.94453125000004,0.35566406249999716],[108.90585937500006,0.7939453125000142],[109.07587890625004,1.4958984375000313],[109.37851562500006,1.922705078125034],[109.62890625000003,2.027539062499983],[109.65400390625004,1.6148925781250227],[110.50576171875005,0.8619628906250227],[110.93808593750006,1.0173339843750568],[111.76972656250004,0.9994628906249687],[112.078515625,1.1433593749999744],[112.1857421875001,1.4390624999999915],[112.47617187500006,1.5590820312500284],[113.6222656250001,1.2359375000000057],[113.90234375000003,1.4342773437499972],[114.54589843750003,1.467138671875034],[114.83056640625003,1.9800292968749886],[114.78642578125002,2.250488281250014],[115.1791015625,2.5231933593749716],[115.086328125,2.8411132812499886],[115.45439453125002,3.0343261718750085],[115.56845703125006,3.9387695312499744],[115.89619140625004,4.348681640624989],[117.10058593750003,4.337060546875023],[117.5744140625001,4.17060546875004]]],[[[96.49257812500005,5.2293457031249915],[97.54716796875002,5.205859375000003],[98.2484375,4.41455078125],[98.3073242187501,4.09287109375002],[99.73232421875005,3.1830566406250256],[100.45703124999997,2.2574218750000057],[100.68525390625004,2.120068359374997],[101.04619140625002,2.2574707031250227],[101.47666015625006,1.693066406250054],[101.78476562500012,1.621386718750017],[102.15722656249997,1.2588867187499773],[102.46923828124997,0.7792968750000568],[102.84941406250002,0.7154785156250227],[103.06650390625012,0.4919921874999602],[103.47890625000005,0.4801757812500398],[103.78671875000012,0.046972656249991473],[103.42851562500007,-0.1917968749999801],[103.43115234374997,-0.5335937499999801],[103.72109375,-0.8867187499999858],[104.36054687500004,-1.0383789062499744],[104.56875,-1.9217773437499943],[104.84521484375003,-2.0929687499999687],[104.66845703124997,-2.3855468749999744],[105.39697265624997,-2.380175781249946],[105.58203124999997,-2.4919921874999886],[106.0443359375,-3.1062499999999886],[105.84374999999997,-3.61367187499998],[105.88720703124997,-5.009570312499974],[105.81611328125004,-5.67656249999996],[105.6185546875,-5.799609374999989],[105.34941406250007,-5.549511718750011],[105.08134765625002,-5.74550781249998],[104.63955078125005,-5.520410156250037],[104.60156249999997,-5.90458984374996],[103.8314453125,-5.079589843750028],[102.91894531249997,-4.470703124999972],[102.53769531250006,-4.152148437499989],[102.12753906250006,-3.599218749999963],[101.57861328124997,-3.166992187500014],[100.848046875,-2.143945312499966],[100.85527343750002,-1.9341796874999488],[100.48652343750004,-1.2991210937499744],[100.30820312500006,-0.82666015625],[99.59765624999997,0.10244140625000853],[99.15917968749997,0.35175781249999716],[98.79638671874997,1.4946289062500426],[98.56425781250002,1.902148437500017],[97.70078125000006,2.3585449218750085],[97.59082031249997,2.846582031250037],[97.3913085937501,2.9752929687499687],[96.9689453125001,3.5751464843749687],[96.44472656250005,3.81630859374998],[95.49472656250006,4.761376953125051],[95.20664062500006,5.284033203125034],[95.39609375000012,5.628808593750023],[95.84130859374997,5.514501953125006],[96.13330078125003,5.2942871093749915],[96.49257812500005,5.2293457031249915]]]]},"properties":{"name":"Indonesia","childNum":30}},{"geometry":{"type":"Polygon","coordinates":[[[78.71972656250009,31.887646484374983],[78.69345703125006,31.740380859374994],[78.7550781250001,31.55029296875],[78.74355468750005,31.323779296875017],[79.10712890625004,31.402636718750102],[79.66425781250004,30.965234374999994],[79.92451171875004,30.888769531250034],[80.20712890625006,30.683740234375023],[80.19121093750002,30.56840820312496],[80.87353515625003,30.290576171875045],[80.98544921875006,30.23710937499999],[80.54902343750015,29.899804687499994],[80.40185546875003,29.730273437500102],[80.31689453125014,29.572070312500017],[80.25488281250009,29.423339843750114],[80.25595703125006,29.318017578125136],[80.23300781250006,29.194628906250045],[80.16953125000012,29.124316406250102],[80.13046875000006,29.100390625000045],[80.08457031249995,28.994189453125074],[80.05166015625,28.870312500000068],[80.07070312500005,28.830175781250063],[80.58701171875006,28.64960937500004],[81.85263671875018,27.867089843750136],[81.89687500000011,27.87446289062504],[81.94521484375005,27.89926757812495],[81.98769531250016,27.91376953125004],[82.03701171875,27.90058593750004],[82.11191406250006,27.86494140625004],[82.28769531250018,27.756542968749983],[82.45136718750004,27.671826171874955],[82.62988281249997,27.687060546875045],[82.67734375000006,27.67343749999995],[82.71083984375005,27.596679687500114],[82.73339843750003,27.518994140625097],[83.28974609375004,27.370996093750136],[84.09101562499993,27.491357421875136],[84.22978515625007,27.427832031250006],[84.48085937500005,27.348193359375102],[84.61015625000002,27.298681640624977],[84.64072265625012,27.249853515624977],[84.65478515625014,27.20366210937499],[84.68535156250013,27.041015625000057],[85.29296875000009,26.741015625000045],[86.36611328125,26.57441406250004],[86.70136718750015,26.435058593750057],[87.01640625000002,26.555419921875085],[87.2874023437499,26.360302734375125],[87.41357421875014,26.42294921875009],[87.63339843750006,26.39912109375004],[87.84921875000006,26.43691406250008],[87.99511718750014,26.38237304687499],[88.02695312500023,26.395019531250085],[88.05488281250004,26.43002929687492],[88.11152343750004,26.58642578125],[88.1615234375,26.724804687500125],[88.15722656250009,26.807324218750068],[88.1110351562501,26.928466796875057],[87.99316406250009,27.086083984374994],[87.98437499999997,27.133935546874994],[88.02412109375015,27.40888671875004],[88.14697265625014,27.749218750000097],[88.10898437499995,27.93300781250005],[88.57792968750002,28.093359375000034],[88.80371093750003,28.006933593750034],[88.74902343749997,27.521875000000136],[88.7648437500001,27.429882812500068],[88.83251953125003,27.362841796875074],[88.89140625000002,27.316064453125136],[88.88164062500007,27.29746093750009],[88.76035156250006,27.21811523437509],[88.73876953125009,27.175585937499932],[88.85761718750015,26.961474609375017],[89.14824218750002,26.816162109375085],[89.33212890625018,26.848632812500114],[89.60917968750013,26.762207031250114],[89.60996093750012,26.719433593750097],[89.71093750000009,26.713916015625045],[89.76386718750004,26.701562499999994],[89.94316406250013,26.723925781249932],[90.12294921875011,26.754589843749983],[90.20605468749997,26.847509765625063],[90.34589843750004,26.890332031250097],[90.73964843750005,26.771679687500068],[91.67158203124993,26.80200195312503],[91.84208984375013,26.852978515625125],[91.94375000000005,26.860839843750114],[91.99833984375013,26.85498046875],[92.04970703125016,26.87485351562495],[92.07343750000015,26.914843750000102],[91.99228515625018,27.09990234374999],[92.0833984375,27.29062499999992],[92.04492187499997,27.364697265625097],[91.99082031249995,27.450195312500114],[91.59472656250009,27.55766601562499],[91.63193359375012,27.759960937499983],[92.41484375000002,27.824609374999994],[92.65253906250004,28.093359375000034],[92.70185546875004,28.147119140624994],[93.36054687500004,28.654052734375057],[93.76074218750003,28.729785156250017],[94.01328125000006,28.90751953124999],[94.46806640625007,29.216210937499994],[94.99882812500002,29.14916992187503],[95.27910156250002,29.04956054687497],[95.42021484375007,29.054296875000063],[95.49375000000012,29.137011718750045],[95.51582031250015,29.20634765624996],[95.71035156250011,29.313818359375006],[95.88505859375007,29.390917968750074],[96.03535156250015,29.447167968749994],[96.07958984375009,29.424121093750074],[96.12851562500012,29.381396484375074],[96.23496093750006,29.245800781249983],[96.18085937500004,29.11767578125],[96.14140625000007,28.963476562500034],[96.58085937500007,28.763671875],[96.32988281250002,28.496826171875],[96.3890625,28.36791992187503],[96.65283203125003,28.44975585937499],[97.07539062500004,28.368945312500045],[97.14511718750012,28.340332031250085],[97.28945312500005,28.23681640624997],[97.32246093750015,28.21796875000004],[97.30273437499997,28.08598632812496],[97.34355468750002,27.982324218749994],[97.04970703125005,27.760009765625],[96.96279296875,27.698291015625017],[96.79785156249997,27.29619140624999],[96.19082031250005,27.26127929687499],[95.20146484375007,26.641406250000017],[95.05976562500015,26.473974609375006],[95.06894531250006,26.191113281250097],[95.10839843750014,26.091406250000034],[95.12929687500011,26.070410156250034],[95.13242187500006,26.041259765624943],[94.99199218750002,25.77045898437504],[94.66777343750007,25.458886718749966],[94.70371093750012,25.097851562499955],[94.49316406250003,24.637646484374983],[94.37724609375002,24.473730468750006],[94.07480468750006,23.8720703125],[93.68339843750007,24.00654296875004],[93.45214843750003,23.987402343750034],[93.32626953125006,24.064208984375057],[93.41494140625011,23.68208007812501],[93.36601562500007,23.132519531249955],[93.34941406250007,23.08496093750003],[93.20390625000002,23.03701171875005],[93.07871093750018,22.718212890625097],[93.16201171875,22.360205078125006],[93.07060546875002,22.20942382812501],[92.77138671875,22.104785156250017],[92.5612304687501,22.04804687500001],[92.49140625000004,22.685400390625006],[92.46445312500006,22.734423828125045],[92.36162109375002,22.929003906250074],[92.33378906250002,23.242382812499955],[92.04404296875006,23.677783203125017],[91.97851562500003,23.691992187500063],[91.92958984375011,23.685986328125097],[91.92949218750019,23.598242187499977],[91.93789062500011,23.504687500000102],[91.75419921875013,23.28730468750004],[91.75097656250003,23.053515625000017],[91.43623046875004,23.19990234375001],[91.35937500000003,23.06835937500003],[91.16044921875019,23.660644531250085],[91.35019531250012,24.06049804687501],[91.72656250000003,24.20507812499997],[92.06416015625004,24.374365234375006],[92.11748046875002,24.493945312500017],[92.22666015625012,24.77099609374997],[92.38496093750004,24.848779296875023],[92.04970703125016,25.16948242187499],[90.61308593750002,25.16772460937497],[90.11962890625003,25.21997070312497],[89.86630859375012,25.293164062499955],[89.81406250000006,25.305371093749955],[89.80087890625012,25.33613281250001],[89.82490234375004,25.560156250000006],[89.82294921875015,25.94140625000003],[89.57275390625003,26.13232421875003],[89.10830078125005,26.202246093750063],[89.01865234375012,26.410253906249977],[88.95195312500002,26.412109375],[88.97041015625004,26.250878906250023],[88.94072265625002,26.24536132812497],[88.68281250000004,26.291699218749983],[88.68066406250009,26.35297851562504],[88.51826171875004,26.51777343750004],[88.41816406250015,26.57153320312497],[88.36992187500002,26.56411132812508],[88.35146484375005,26.482568359374966],[88.38623046875003,26.471533203125034],[88.44042968749997,26.369482421875034],[88.33398437499997,26.257519531249955],[88.1066406250001,25.841113281250045],[88.14746093749997,25.811425781250023],[88.76914062500006,25.490478515625],[88.85478515625002,25.333544921875017],[88.94414062500002,25.290771484375],[88.92978515625012,25.222998046875063],[88.57382812500006,25.187890624999994],[88.31337890625011,24.8818359375],[88.14980468750011,24.91464843749995],[88.04511718750015,24.71303710937508],[88.03027343750009,24.664453125000136],[88.02343750000003,24.627832031250136],[88.07910156250009,24.549902343750063],[88.14550781250003,24.485791015624955],[88.22500000000005,24.460644531249983],[88.33750000000006,24.45385742187503],[88.49853515625003,24.34663085937504],[88.64228515625015,24.325976562500102],[88.72353515625011,24.27490234375],[88.7335937500001,24.230908203125097],[88.72656250000009,24.18623046875004],[88.71376953125016,24.069628906250102],[88.69980468750006,24.00253906249992],[88.56738281250009,23.674414062500034],[88.69765625,23.493017578125034],[88.72441406250002,23.254980468750034],[88.89970703125002,22.843505859375057],[88.92070312500002,22.632031249999955],[89.0500000000001,22.274609374999983],[89.05166015625,21.654101562500045],[88.25371093750002,21.622314453124943],[87.94843749999993,21.825439453124943],[87.10068359375006,21.500781250000074],[86.85957031250004,21.23671875000008],[86.97548828125005,20.70014648437501],[86.75039062500011,20.313232421875057],[86.27949218750021,19.919433593749943],[85.57500000000002,19.69291992187499],[84.77099609375009,19.125390625000023],[84.10410156250018,18.29267578125001],[83.65429687499997,18.069873046875102],[83.19833984375006,17.608984374999977],[82.35957031250004,17.09619140624997],[82.25878906250014,16.55986328124996],[81.76191406250015,16.32949218750008],[81.23857421875013,16.263964843750074],[80.97871093750004,15.758349609375074],[80.64658203125006,15.895019531250028],[80.29345703125014,15.710742187499989],[80.0534179687501,15.074023437499932],[80.16542968750016,14.577832031250097],[80.11171875000005,14.212207031250045],[80.34238281250006,13.361328125000071],[80.22910156250018,12.690332031249966],[79.85849609375018,11.988769531250043],[79.75410156250004,11.575292968750006],[79.84863281250009,11.196875000000006],[79.83818359375002,10.322558593750045],[79.39052734375005,10.305957031250045],[78.99628906249993,9.683105468749986],[78.97958984375018,9.268554687500085],[78.42148437500006,9.105029296874989],[78.19248046874995,8.890869140625057],[78.06015625000006,8.384570312499932],[77.51757812500003,8.078320312500068],[76.96689453125012,8.407275390624946],[76.5534179687501,8.902783203124997],[76.32460937500016,9.452099609374997],[76.34648437500002,9.922119140625],[75.92255859375015,10.784082031250108],[75.72382812500015,11.361767578125026],[75.1966796875,12.057519531250009],[74.77050781250009,13.077343750000125],[74.67089843749997,13.667626953125122],[74.38222656250005,14.494726562500048],[73.94921875000014,15.074755859375088],[73.93193359375013,15.39697265625],[73.47607421875003,16.05424804687496],[73.33759765625004,16.459863281249994],[73.15605468750019,17.62192382812495],[72.87089843750019,18.683056640624955],[72.66777343750019,19.83095703125005],[72.88115234375013,20.56318359375001],[72.81386718750011,21.117187500000085],[72.54306640625,21.69658203124999],[72.59013671875019,22.27812499999999],[72.33261718750012,22.270214843749955],[72.03720703125006,21.82304687499999],[72.25400390625006,21.531005859375],[72.01523437500012,21.155712890625097],[71.0246093750001,20.73886718750009],[70.71933593750006,20.740429687500068],[70.12734375,21.094677734375097],[69.00878906250009,22.196777343750114],[70.17724609375014,22.57275390624997],[70.2511718750001,22.970898437500068],[69.66464843750006,22.759082031250074],[69.23593749999995,22.848535156250023],[68.64072265625006,23.189941406250114],[68.16503906250009,23.857324218749994],[68.28251953125013,23.927978515625],[68.38125000000016,23.950878906250068],[68.48867187500011,23.96723632812501],[68.5866210937501,23.966601562500074],[68.72412109375003,23.964697265625034],[68.72812500000012,24.265625000000057],[68.73964843750016,24.291992187500085],[68.75898437499993,24.307226562500006],[68.78115234375011,24.313720703125085],[68.80000000000004,24.30908203125003],[68.82832031250004,24.26401367187509],[68.86347656250015,24.26650390625005],[68.90078125000011,24.29243164062501],[68.98457031250015,24.273095703124966],[69.11953125000011,24.26865234374995],[69.23505859374993,24.268261718750068],[69.44345703124995,24.275390625000085],[69.55917968750006,24.273095703124966],[69.63417968750016,24.225195312499977],[69.71621093750016,24.172607421875114],[70.54677734375,24.418310546875063],[70.71630859375009,24.237988281250097],[70.7672851562501,24.245410156250017],[70.80507812500011,24.26196289062503],[70.88623046875014,24.34374999999997],[70.92812500000016,24.362353515625045],[70.98281250000011,24.361035156250125],[71.04404296875006,24.400097656250097],[71.04531250000005,24.42998046874996],[71.00625,24.444335937500057],[70.97324218750012,24.48740234374995],[70.97636718750013,24.618750000000063],[71.00234375000016,24.65390624999992],[71.04785156250003,24.687744140625085],[71.02070312500021,24.75766601562492],[70.95087890625015,24.89160156250003],[70.87773437500019,25.06298828124997],[70.65205078125004,25.422900390625102],[70.10019531250006,25.91005859375005],[70.14921875000002,26.347558593749994],[70.05937500000002,26.578759765625023],[69.47001953125002,26.804443359375],[69.56796875,27.174609375000102],[69.89628906250007,27.473632812500085],[70.04980468750009,27.694726562500023],[70.14453125000003,27.849023437499994],[70.19394531250006,27.89487304687492],[70.24433593750004,27.934130859375102],[70.4037109375,28.025048828124994],[70.48857421875013,28.023144531250125],[70.62910156250015,27.937451171875068],[70.64912109375015,27.83535156250005],[70.73740234374995,27.729003906250057],[70.79794921875012,27.709619140625023],[70.87490234375016,27.71445312499995],[71.54296875000003,27.869873046875],[71.71669921875005,27.91508789062496],[71.8703125000001,27.962500000000034],[71.88886718750004,28.04746093749992],[71.94804687500002,28.177294921875102],[72.34189453125006,28.751904296875097],[72.90332031250003,29.02875976562501],[73.38164062500013,29.934374999999932],[73.46748046875004,29.971679687500085],[73.8091796875,30.093359375000006],[73.89931640625,30.435351562500045],[74.00898437500004,30.519677734374994],[74.21562500000013,30.768994140624983],[74.33935546875003,30.893554687499943],[74.38037109375003,30.89340820312509],[74.50976562500009,30.959667968750097],[74.63281250000014,31.034667968750114],[74.62578125000002,31.068750000000108],[74.61035156250009,31.112841796875045],[74.51767578125012,31.185595703124932],[74.53496093750007,31.261376953125108],[74.59394531249993,31.465380859375102],[74.58183593750013,31.523925781250114],[74.50996093750015,31.712939453125074],[74.73945312500015,31.948828125000006],[75.07148437500015,32.08935546875003],[75.13876953125,32.10478515624999],[75.25410156250004,32.140332031250125],[75.33349609374997,32.279199218749994],[74.98730468749997,32.46220703124996],[74.78886718750013,32.45781249999996],[74.6857421875001,32.493798828124994],[74.65781250000006,32.518945312499966],[74.66328125000004,32.75766601562495],[74.35458984375012,32.76870117187505],[74.30361328125005,32.991796875000034],[73.99423828125006,33.24218750000006],[74.15,33.506982421874994],[73.96123046875007,34.653466796874994],[74.05585937500015,34.68066406250003],[74.17197265624995,34.72089843750004],[74.30039062500006,34.76538085937506],[75.70917968750004,34.50307617187508],[76.04101562500014,34.66992187499997],[76.4567382812501,34.756103515625114],[76.5944335937501,34.73583984375006],[76.69628906249997,34.78691406249999],[76.74902343750014,34.84755859375008],[76.7829101562501,34.90019531249999],[77.00087890625011,34.99199218750002],[77.04863281250007,35.109912109375074],[77.79941406250006,35.49589843750002],[78.07578125000006,35.13491210937502],[78.15849609375002,34.94648437499998],[78.32695312500007,34.60639648437498],[78.86484375000006,34.39033203125001],[78.93642578125,34.35195312500002],[78.72666015625006,34.013378906249955],[78.78378906250006,33.80878906250004],[78.86503906250002,33.43110351562501],[78.94843750000004,33.346533203125006],[79.11250000000004,33.22626953125001],[79.13515625000005,33.17192382812496],[79.10283203125007,33.05253906249996],[79.14550781250003,33.00146484375006],[79.16992187500003,32.497216796874994],[78.75351562500012,32.49926757812506],[78.73671875,32.55839843750002],[78.38964843749997,32.51987304687498],[78.41748046874997,32.466699218749994],[78.4552734375001,32.30034179687502],[78.49589843750002,32.21577148437504],[78.71972656250009,31.887646484374983]]]},"properties":{"name":"India","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-6.218017578125,54.08872070312506],[-6.027392578124989,52.927099609375006],[-6.561083984374989,52.18881835937498],[-7.527294921874926,52.09887695312503],[-8.813427734374926,51.584912109374955],[-10.37871093749996,51.86875000000006],[-9.955810546874972,52.13666992187501],[-9.299218749999966,53.09755859375002],[-9.795410156249972,53.39497070312504],[-9.995947265624977,54.27602539062502],[-8.623144531249977,54.34687499999998],[-8.763916015624972,54.68120117187496],[-8.274609374999955,55.146289062500045],[-7.246679687499949,55.35302734374997],[-7.2186523437499375,55.09199218749998],[-8.118261718749977,54.41425781250004],[-7.3551757812499545,54.12124023437502],[-6.218017578125,54.08872070312506]]]},"properties":{"name":"Ireland","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[46.1144531250001,38.877783203125034],[46.490624999999994,38.90668945312498],[47.772851562499994,39.64858398437505],[47.995898437500074,39.683935546875034],[48.24199218750002,38.978955078124955],[48.02324218750002,38.81904296874998],[48.59267578125005,38.41108398437498],[48.86875000000006,38.43549804687498],[49.08095703125005,37.667578125000034],[49.470117187499994,37.496679687500034],[50.130468750000006,37.407128906249994],[50.53320312499997,37.01367187500006],[51.11855468750005,36.742578124999966],[52.19013671875004,36.62172851562505],[54.017187500000006,36.952490234375034],[53.91416015625006,37.34355468750002],[54.745214843750006,37.501904296874955],[55.075585937499994,37.90249023437502],[55.57841796875002,38.099755859374994],[56.22880859375002,38.07338867187502],[56.4406250000001,38.249414062499994],[57.1935546875001,38.216406250000034],[57.42382812500003,37.94770507812501],[58.4357421875001,37.63852539062498],[58.81542968750003,37.683496093749994],[59.240820312500006,37.52075195312497],[59.5622070312501,37.178906249999955],[60.06279296875002,36.962890625],[60.34130859375003,36.63764648437501],[61.11962890625003,36.64257812500003],[61.26201171875002,35.61958007812498],[61.08007812499997,34.85561523437505],[60.95117187499997,34.65385742187499],[60.91474609375004,34.63398437500001],[60.80234375000006,34.55463867187501],[60.7262695312501,34.51826171874998],[60.48574218750005,34.09477539062502],[60.485937500000006,33.7119140625],[60.91699218749997,33.505224609375006],[60.56054687499997,33.13784179687502],[60.576562499999994,32.99487304687503],[60.71044921874997,32.599999999999966],[60.82929687500004,32.24941406250005],[60.854101562500006,31.483251953125006],[61.110742187499994,31.45112304687504],[61.346484375000074,31.42163085937497],[61.66015625000003,31.382421874999977],[61.7550781250001,31.285302734374994],[61.814257812500074,31.072558593750017],[61.810839843750074,30.913281249999983],[61.78417968749997,30.831933593750023],[61.55947265625005,30.59936523437497],[61.10410156250006,30.12841796875003],[60.84335937500006,29.85869140624999],[61.03417968750003,29.663427734374977],[61.15214843750002,29.542724609375],[61.62304687500003,28.791601562500006],[61.8898437500001,28.546533203124994],[62.762500000000074,28.202050781249994],[62.782324218750006,27.800537109375],[62.75273437500002,27.265625],[63.16679687500002,27.25249023437499],[63.168066406250006,26.66557617187496],[62.31230468750002,26.490869140624994],[61.8698242187501,26.242431640625],[61.66865234375004,25.76899414062501],[61.61542968750004,25.28613281250003],[61.58789062499997,25.20234375000001],[61.533105468749994,25.195507812499955],[61.41220703125006,25.102099609375017],[60.66386718750002,25.28222656250003],[59.45605468749997,25.481494140625045],[59.0460937500001,25.417285156250017],[58.79785156249997,25.554589843750023],[57.7960937500001,25.65302734375001],[57.334570312500006,25.791552734375074],[56.98222656250002,26.905468749999983],[56.3561523437501,27.20024414062499],[55.650292968749994,26.9775390625],[54.89580078125002,26.55668945312499],[53.70576171875004,26.72558593750003],[53.45498046875005,26.94326171875005],[52.69160156250004,27.323388671875023],[52.475878906250074,27.61650390624999],[51.666308593750074,27.84497070312497],[51.278906250000006,28.13134765624997],[51.06201171874997,28.72612304687499],[50.67519531250005,29.146582031250034],[50.64960937500004,29.420068359374966],[49.9831054687501,30.209375000000023],[49.55488281250004,30.028955078125023],[48.91914062500004,30.120898437500017],[48.54648437500006,29.962353515624955],[48.47851562499997,30.003808593749966],[48.43457031249997,30.03759765625],[48.40136718749997,30.188330078124977],[48.33105468749997,30.28544921874996],[48.01494140625002,30.46562499999999],[48.01347656250002,30.656445312499955],[48.012011718750074,30.823632812500023],[48.01064453125005,30.989794921875017],[47.679492187500074,31.00239257812501],[47.679492187500074,31.400585937499955],[47.75390624999997,31.601367187500017],[47.829980468749994,31.79443359375],[47.71455078125004,31.936425781249966],[47.5915039062501,32.087988281250034],[47.51191406250004,32.15083007812504],[47.3712890625001,32.42373046875002],[47.3297851562501,32.45551757812501],[47.28515625000003,32.474023437499966],[47.121386718750074,32.46660156249996],[46.569921875000006,32.83393554687501],[46.37705078125006,32.92924804687499],[45.39707031250006,33.970849609374994],[45.43759765625006,34.415136718750006],[45.63750000000002,34.573828125000006],[45.661523437499994,34.61269531250002],[45.660058593749994,34.74877929687503],[45.67812500000005,34.798437500000034],[45.92089843750003,35.02851562500001],[46.04179687500002,35.08017578125006],[46.13378906249997,35.127636718749955],[46.15468750000005,35.19672851562498],[46.112109375000074,35.32167968750005],[45.97109375000005,35.524169921875],[46.03740234375002,35.67314453124999],[46.180957031250074,35.71137695312504],[46.262500000000074,35.74414062500006],[46.27343749999997,35.77324218750002],[46.16748046874997,35.820556640625],[45.72343750000002,35.83666992187497],[45.36162109375002,36.015332031249955],[45.241113281249994,36.35595703125],[45.20654296874997,36.397167968749955],[45.15527343749997,36.407373046874994],[45.11240234375006,36.409277343750034],[45.03105468750002,36.52607421875001],[44.76513671875003,37.142431640625006],[44.56123046875004,37.74462890625003],[44.211328124999994,37.908056640625006],[44.43085937500004,38.356787109375034],[44.02324218750002,39.37744140625006],[44.81718750000002,39.65043945312496],[45.4796875000001,39.006249999999994],[46.1144531250001,38.877783203125034]]]},"properties":{"name":"Iran","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[47.14824218750002,30.0009765625],[46.905859375000006,29.537499999999994],[46.53144531250001,29.096240234374996],[46.3564453125,29.063671874999997],[44.69082031250002,29.202343749999997],[42.85771484375002,30.49521484375],[42.07441406250001,31.080371093749996],[40.36933593750001,31.93896484375],[40.02783203125,31.995019531249994],[39.7041015625,32.042529296874996],[39.14541015625002,32.12451171875],[38.773535156250006,33.372216796874994],[40.689453125,34.33203125],[40.98701171875001,34.429052734375],[41.19472656250002,34.768994140625],[41.354101562500006,35.640429687499996],[41.24560546875,36.073388671874994],[41.41679687500002,36.5146484375],[41.78857421875,36.59716796875],[42.358984375000006,37.10859375],[42.77460937500001,37.371874999999996],[43.51582031250001,37.244531249999994],[43.83642578125,37.223535156249994],[44.01318359375,37.313525390624996],[44.11445312500001,37.30185546875],[44.15625,37.282958984375],[44.19179687500002,37.249853515625],[44.20839843750002,37.20263671875],[44.20166015625,37.051806640624996],[44.281835937500006,36.97802734375],[44.32558593750002,37.0107421875],[44.401953125000006,37.058496093749994],[44.49599609375002,37.110546875],[44.566015625000006,37.158251953124996],[44.60595703125,37.176025390625],[44.66933593750002,37.173583984375],[44.73095703125,37.165283203125],[44.798437500000006,37.063867187499994],[44.880859375,36.79931640625],[45.03105468750002,36.52607421875],[45.112402343750006,36.40927734375],[45.1552734375,36.407373046874994],[45.20654296875,36.39716796875],[45.24111328125002,36.35595703125],[45.36162109375002,36.01533203125],[45.72343750000002,35.836669921875],[46.16748046875,35.820556640625],[46.2734375,35.773242187499996],[46.26250000000002,35.744140625],[46.18095703125002,35.711376953125],[46.03740234375002,35.673144531249996],[45.97109375000002,35.524169921875],[46.11210937500002,35.321679687499994],[46.15468750000002,35.196728515625],[46.1337890625,35.12763671875],[46.04179687500002,35.08017578125],[45.9208984375,35.028515625],[45.67812500000002,34.7984375],[45.437597656250006,34.41513671875],[45.397070312500006,33.970849609374994],[46.377050781250006,32.929248046874996],[46.569921875000006,32.833935546875],[47.12138671875002,32.466601562499996],[47.28515625,32.474023437499994],[47.32978515625001,32.455517578125],[47.37128906250001,32.423730468749994],[47.51191406250001,32.150830078125],[47.59150390625001,32.08798828125],[47.71455078125001,31.936425781249994],[47.82998046875002,31.79443359375],[47.75390625,31.601367187499996],[47.67949218750002,31.400585937499997],[47.67949218750002,31.002392578124997],[48.01064453125002,30.989794921874996],[48.01201171875002,30.823632812499994],[48.01347656250002,30.656445312499997],[48.01494140625002,30.465624999999996],[48.3310546875,30.285449218749996],[48.4013671875,30.188330078125],[48.4345703125,30.03759765625],[48.546484375000006,29.962353515624997],[48.454199218750006,29.9384765625],[48.141699218750006,30.040917968749994],[48.07275390625,30.043212890625],[47.982519531250006,30.011328125],[47.97871093750001,29.982812499999994],[47.67275390625002,30.095605468749994],[47.14824218750002,30.0009765625]]]},"properties":{"name":"Iraq","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[-15.543115234374994,66.228515625],[-14.740429687499983,66.050830078125],[-14.757519531249983,65.7556640625],[-13.616015624999989,65.487158203125],[-13.569677734374977,65.068115234375],[-14.547070312499983,64.445947265625],[-16.060449218749994,64.11123046875],[-16.640332031249983,63.865478515625],[-17.81572265624999,63.71298828125],[-18.65361328124999,63.406689453125],[-20.198144531249994,63.555810546874994],[-21.832763671875,64.205419921875],[-21.950341796874994,64.514990234375],[-22.683984374999994,65.0263671875],[-22.005761718749994,65.49345703125],[-22.902490234374994,65.58046875],[-24.223974609374977,65.48720703125],[-23.527929687499977,66.164404296875],[-22.426123046874977,66.430126953125],[-21.303466796875,65.87646484375],[-21.22998046875,65.42060546875],[-20.356640624999983,65.71904296875],[-20.356591796874994,66.033251953125],[-18.777539062499983,66.168798828125],[-16.748437499999994,66.131640625],[-15.985400390624989,66.5146484375],[-15.543115234374994,66.228515625]]]},"properties":{"name":"Iceland","childNum":1}},{"geometry":{"type":"Polygon","coordinates":[[[35.78730468750001,32.734912109374996],[35.572851562500006,32.640869140625],[35.56904296875001,32.619873046875],[35.55146484375001,32.3955078125],[35.484375,32.401660156249996],[35.40263671875002,32.450634765625],[35.38671875,32.493017578125],[35.303808593750006,32.512939453125],[35.19326171875002,32.534423828125],[35.065039062500006,32.46044921875],[35.01054687500002,32.338183593749996],[34.95595703125002,32.160937499999996],[34.98974609375,31.913281249999997],[34.880468750000006,31.3681640625],[35.45058593750002,31.479296874999996],[35.43925781250002,31.132421875],[35.17402343750001,30.52392578125],[34.97343750000002,29.555029296875],[34.904296875,29.477343749999996],[34.24531250000001,31.208300781249996],[34.52558593750001,31.525634765625],[35.10859375000001,33.08369140625],[35.411230468750006,33.07568359375],[35.869140625,33.43173828125],[35.78730468750001,32.734912109374996]]]},"properties":{"name":"Israel","childNum":1}},{"geometry":{"type":"MultiPolygon","coordinates":[[[[15.576562500000051,38.220312500000034],[15.099511718750023,37.458593750000006],[15.294531250000063,37.01328125000006],[15.112597656250017,36.687841796875006],[14.501855468750023,36.798681640625034],[12.435546874999972,37.819775390624955],[13.351660156250006,38.180517578125006],[13.68154296875008,38.00073242187497],[14.505957031250063,38.045507812500034],[14.84589843750004,38.17167968749999],[15.576562500000051,38.220312500000034]]],[[[9.632031250000011,40.88203124999998],[9.805273437500063,40.499560546875045],[9.562500000000057,39.16601562500006],[9.056347656250068,39.23916015625002],[8.881347656250028,38.91289062499999],[8.418164062500068,39.205712890624966],[8.471289062500063,40.29267578124998],[8.189941406250028,40.651611328125],[9.283007812500045,41.20166015624997],[9.632031250000011,40.88203124999998]]],[[[13.420996093750006,46.212304687499994],[13.663476562500023,45.7919921875],[13.831152343750006,45.680419921875],[13.206347656250074,45.771386718749966],[12.27431640625008,45.44604492187503],[12.523437500000028,44.96796874999998],[12.248339843750045,44.72250976562498],[12.396289062500074,44.223876953125],[13.56416015625004,43.57128906250003],[14.010449218750011,42.68955078125006],[14.86611328125008,42.05253906249996],[15.168750000000017,41.93403320312498],[15.96406250000004,41.939453125],[16.01259765625005,41.435400390625006],[17.10341