<?php
if(Auth::user()->user_type == 'organization')
{
    $layout = 'fcviews.layouts.org';
}
elseif(Auth::user()->user_type == 'organization_user')
{
    $layout = 'fcviews.layouts.user';
}
?>

<?php $__env->startSection('content'); ?>

<style>
.dropdown-menu a:hover{ background:#f27200;color:#fff;}
</style>


<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Schedule SMS</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Schedule</a>
                                    </li>
                                </ul>
                        </div></div>
                      
                      
                      
                      
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>


                            <div class="btn-group dropdown">
                                <button class="btn btn-white btn-round dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="true">
                                   <i class="fas fa-plus"></i> Add Scheduled SMS
                                </button>
                                
                                
                                
                                
                                <ul class="dropdown-menu" role="menu">
                                <li>

                                <a href="#" data-toggle="modal" data-target="#importClient" id="show-modal" class="dropdown-item"><i class="fas fa-coins"></i> To Imports</a>
                                <!--<a href="#" data-toggle="modal" data-target="#importClient" id="show-modal" class="dropdown-item"><i class="fas fa-file-import"></i> To Import</a>-->
                                  
                                <a href="#" data-toggle="modal" data-target="#contact" id="show-modal" class="dropdown-item"><i class="fa fa-plus"></i> To Contact</a>
                                <a href="#" data-toggle="modal" data-target="#group" id="show-modal" class="dropdown-item" href="#"><i class="fa fa-plus"></i> To Group</a>
                                </li> 
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Schedules</div>
                                        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <!-- check if exist -->
                                        <?php if(!$schedules->count()): ?>
                                        <?php echo $__env->make('layouts.nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php else: ?>
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Message</th>
                                                <th>Number</th>
                                            
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Message</th>
                                                <th>Number</th>
                                            
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            <?php $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                            <td><?php echo e($schedule->bulk_sms_id); ?></td>
                                            <td><?php echo e($schedule->message); ?></td>
                                            <td><?php echo e($schedule->recipients); ?></td>
                                           
                                           
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            <a href="#" data-target="#edit-<?php echo e($schedule->bulk_sms_id); ?>" data-toggle="modal" id="show-modal"> <button class="btn btn-success btn-sm" data-toggle="tooltip"  data-original-title="View"><i class="far fa-eye"></i> </button>  </a>
                                            <a href="#" data-target="#view-<?php echo e($schedule->bulk_sms_id); ?>" data-toggle="modal" id="show-modal"> <button class="btn btn-primary btn-sm" data-toggle="tooltip"  data-original-title="Edit"><i class="fa fa-edit"></i> </button></a>
                                            <button  @click.prevent="deleteItem('scheduleDeletepath',<?php echo e($schedule->bulk_sms_id); ?>)" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>
                                            
                                            </form>
                                            </div>
                                            </td>
                                            </tr>
                                            
                                            
                                                        
                                            
                                            <!-- edit modal -->
                                            <div class="modal fade" id="edit-<?php echo e($schedule->bulk_sms_id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">View Contact </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <contactview_component :scheduledata="<?php echo e(json_encode($schedule)); ?>"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end edit modal -->
                                            <!-- view modal -->
                                            <div class="modal fade" id="view-<?php echo e($schedule->bulk_sms_id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Contact </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         
                                                         <contactsedit_component :scheduledata="<?php echo e(json_encode($schedule)); ?>"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end view modal -->
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                         
                                        <?php endif; ?> 
                                    </div>
                                    
                                    
                                     <!-- contact modal -->
                                    <div class="modal fade" id="contact" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Schedule SMS To Contact </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <schedulesms_component />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end contact modal -->
                                            
                                                      <!-- view modal -->
                                            <div class="modal fade" id="group" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Schedule SMS To Group </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         
                                                         <schedulesmsgroup_component />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end view modal -->
                                    
                                    
                                    
                                    
                                    <!-- Create modal -->
                                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Contact </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <contactcreate_component/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                                            <!--  import -->              
                                        <div class="modal fade" id="importClient" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Import SMS Contacts</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('scheduleImport')); ?>" method="post" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body bg-light">
                                                            <div class="alert alert-info shadow-sm">
                                                                <p class="mb-0">Download <a href="<?php echo e(url('/sample/Imports.xlsx')); ?>">sample file</a></p>
                                                            </div>
                                                            <div class="col form-group">
                                                                <label for="import-file">Select excel file to import* <div style="color:red;">(Can Only send to ) 
                                                               </div> <?php $__currentLoopData = $mycountries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $object): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                              <?php echo e($object->rateCountry->name); ?>

                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></label>
                                                                <input name="file" id="import-file" type="file" class="form-control">
                                                            </div>
                                                            <div class="col form-group">
                                                                <label for="time">Schedule Date:</label>
                                                                <input name="date" type="date" class="form-control" required>
                                                            </div>
                                                            <div class="col form-group">
                                                                <label for="time">Schedule Time:</label>
                                                                <input name="time" type="time" class="form-control" required>
                                                            </div>
                                                        
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-success btn-round btn-md"><i class="fa fa-check"></i> Schedule</button>
                                                            <button type="button" class="btn btn-danger btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- / import -->
                                </div>
                            </div>
                        </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    
    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
    
<?php $__env->stopSection(); ?>

    
<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/Accounts/resources/views/fcviews/schedule/index.blade.php ENDPATH**/ ?>