<?php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
}
?>

<?php $__env->startSection('content'); ?>
<div id="vue-admin-user">
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                        <h4 class="page-title text-white">Group Contacts</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="<?php echo e(route($dashboard)); ?>">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Contact Groups</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                        <?php if(Auth::user()->user_type != 'organization'): ?>
                            <button data-toggle="modal" data-target="#group" id="show-modal" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Contact to Group</button>
                        <?php else: ?>
                            <a href="<?php echo e(route($fdashboard)); ?>" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                        <?php endif; ?>
                        </div>
                      </div>
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Contact Groupings</div>
                                        <!-- Group clients modal -->
                                        <div class="modal fade" id="group" tabindex="-1" role="dialog" aria-labelledby="topup" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Add contact to group </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <add_client_group></add_client_group>
                                                        </div>
                                                    </div>
                                                </div>
                                        </div>
                                        <!-- end group clients modal -->
                                        <?php if(!$groupings): ?>
                                        <?php echo $__env->make('layouts.nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php else: ?>
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Group</th>
                                                    <th>Contact</th>
                                                    <?php if(Auth::guard('web')->check()): ?>
                                                    <th>Group Status</th>
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                    <?php endif; ?>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                    <th>Group</th>
                                                    <th>Contact</th>
                                                    <?php if(Auth::guard('web')->check()): ?>
                                                    <th>Group Status</th>
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                    <?php endif; ?>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            <?php $__currentLoopData = $groupings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grouping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>                                            
                                            <td><?php echo e($grouping->ClientGroupGroup->cust_group_name); ?></td>
                                            <td><?php echo e($grouping->ClientGroupClient['cust_client_fullname']); ?></td>
                                            
                                            <td><?php if($grouping->ClientGroupGroup['cust_group_status'] == 1): ?>
                                                <span class="badge badge-success">Active</span>
                                                <?php elseif($grouping->ClientGroupGroup['cust_group_status'] == 0): ?>
                                                <span class="badge badge-danger">Inactive</span>
                                                <?php endif; ?>
                                                </td>
                                            <td>
                                            <div class="btn-group form-actions" role="group" aria-label="Actions">
                                            <?php if(Auth::user()->user_type == 'organization_user'): ?>
                                            <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#editGrouping-<?php echo e($grouping->client_grp_id); ?>" id="show-modal"><i class="fas fa-edit"></i> Edit </button>
                                            <button type="submit" data-toggle="tooltip" @click="deleteItem('clientgrppath', <?php echo e($grouping->client_grp_id); ?> )" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                 <i class="fa fa-trash-alt"></i>
                                            </button>
                                            <?php endif; ?>
                                            </div>
                                            
                                            <!-- Edit Group clients modal -->
                                            <div class="modal fade" id="editGrouping-<?php echo e($grouping->client_grp_id); ?>" tabindex="-1" role="dialog" aria-labelledby="topup" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit grouped contact</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <edit_client_group :cgdata="<?php echo e(json_encode($grouping)); ?>"></edit_client_group>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <!-- end edit group clients modal -->
                                         </td>
                                         
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                         </div>
                                        <?php endif; ?>

                                        
                                        
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>

            </div>
            </div>
        </div>
    </div>
</div>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/Accounts/resources/views/bmviews/client-groups/index.blade.php ENDPATH**/ ?>