@php
if(Auth::guard('organization')->check())
{
    $layout = 'layouts.org';
}
elseif(Auth::guard('web')->check())
{
    $layout = 'layouts.user';
}
@endphp
@extends($layout)
@section('content')

<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Participants for survey <small>{{ $survey['name'] }}</small></h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Participants</a>
                                    </li>
                                </ul>
                        </div></div>
                      
                        <div class="ml-md-auto py-2 py-md-0">
                            
                         
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Participant Requirements
                                        
                                    
     
                                        </div>
                                        
                                        
                                        
                                        <!-- check if exist -->
                                            @if ($errors->any())
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                <strong>Error! </strong>There were some errors with inputs.
                                                <ul>
                                                @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                                @endforeach
                                                </ul>
                                                </div>
                                            @endif
                                        @include('layouts.messages')
                                        @if(empty($participants))
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                       
                                                          
                                       
                                       
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                            @foreach($tablecolumns as $tablecolumn)
                                                <th>{{ucfirst($tablecolumn)}}</th>
                                            @endforeach
                                            <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                            <tr>
                                            @foreach($tablecolumns as $tablecolumn)
                                                <th>{{ucfirst($tablecolumn)}}</th>
                                            @endforeach
                                            </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($participants as $participant)
                                            <tr>
                                            @foreach($tablecolumns as $tablecolumn)
                                                <td>{{$participant->$tablecolumn}}</td>
                                            @endforeach
                                                <td> 
                                                    
                  <!--<a href="{{ route('responses_participant_help',$participant->survey_id) }}" class="btn btn-primary"><i class="fa fa-eye"></i> Participants Responses</a>     -->
                         
                                                    
   <a href="#" class="btn btn-primary" data-target="#edit-{{ $participant->survey_id }}" data-toggle="modal" id="show-modal"><i class="fa fa-eye"></i> Participants Responses</a>                                                  
   <!--<a href="#" data-target="#edit-{{ $participant->survey_id }}" data-toggle="modal" id="show-modal"> <button class="dropdown-item" data-toggle="tooltip"  data-original-title="Reply"><i class="fa fa-edit">Reply</i> </button></a>-->
                                                  
                                                    
                                              </td>
                                            </tr>
                                            <!-- edit participant modal -->
                                           
                                            
                                            @endforeach
                                            
                                            
                                                
                       
                        </div>
                    </div>
                    
                    
                                                 <!-- Create modal -->
                                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editbookmarkercompany">Create Requirements </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                           
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                    
                    
                    <!-- edit modal -->
                                            <div class="modal fade" id="edit-{{ $participant->survey_id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header"> 
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Reply To Survey Response</h5>
                                                            
                <a href="{{ route('viewsuveyresponse',$participant->survey_id) }}" class="btn btn-primary"><i class="fa fa-eye"></i> View Responses</a>     

                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                          
                                             <data-survey :data="{{json_encode($participant)}}"/>          
                                                            
                                                  <!--<reply-survey :data="{{json_encode($participant)}}"/>-->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end edit modal -->
                    
                    
                                            
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                    <!-- Create modal -->
                                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Requirements </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                          
                                          
                                          
                                           
                                          
                                          
                                          
                                          
                                          
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
@endsection