@php
if(Auth::user()->user_type == 'organization')
{
    $layout = 'atviews.layouts.customer';
}
elseif(Auth::user()->user_type == 'organization_user')
{
    $layout = 'atviews.layouts.user';
}
@endphp
@extends($layout)
@section('content')

<style>
.dropdown-menu a:hover{ background:#f27200;color:#fff;}
</style>


<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Contacts</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Contacts</a>
                                    </li>
                                </ul>
                        </div></div>

                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>


                            <div class="btn-group dropdown">
                                <button class="btn btn-white btn-round dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="true">
                                   <i class="fas fa-plus"></i> Add Contacts
                                </button>
   
                                <ul class="dropdown-menu" role="menu">
                                <li>

                                <a href="#" data-toggle="modal" data-target="#addContacts" id="show-modal" class="dropdown-item"><i class="fas fa-coins"></i> Add contacts</a>
                                @if(Auth::user()->user_type == 'organization_user')
                                    <a href="#" data-toggle="modal" data-target="#importClient" id="show-modal" class="dropdown-item"><i class="fas fa-file-import"></i> Import contact</a>
                                @endif
                                </li>
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Contacts Details     
                                       
                                        </div>
                                        <fcdatacontactcreate_component></fcdatacontactcreate_component>
                                    </div>
                                    {{--{!! $contacts->links() !!}--}}
                                    <!-- Create modal -->
                                    <div class="modal fade" id="addContacts" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Contacts </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <fcdatacontactcreate_component/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end Create modal -->
                                    <!--  import -->              
                                    <div class="modal fade" id="importClient" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                <h4>Import Contacts</h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form action="{{ route('at.contacts.import')}}" method="post" enctype="multipart/form-data">
                                                    @csrf
                                                    <div class="modal-body bg-light">
                                                        <p class="mb-0">Prepare your contacts List in excel with columns: Name and Phone Number. Name Field can be blank but must be there. Save the excel file with .csv(Comma Delimited) extension.</p>
                                                        <l> Phone Number Must Start with 07... No International Numbers </l>
                                                        <div class="alert alert-info shadow-sm">
                                                            <p class="mb-0">Download <a href="{{ url('/sample/example.csv') }}">sample file</a></p>
                                                        </div>
                                                        <div class="col form-group">
                                                            <label for="import-file"> Select Group</label>
                                                            <select name="group" class="form-control select2">
                                                                <option value="">--Select Group--</option>
                                                                @foreach($groups as $group)
                                                                    <option value="{{$group->group_id}}">{{$group->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="col form-group">
                                                            <label for="import-file">Upload CSV/Excel File: </label>
                                                            <input name="file" id="import-file" type="file" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-success btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                        <button type="button" class="btn btn-danger btn-round btn-md" data-dismiss="modal">Close</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- / import -->
                                </div>
                            </div>
                        </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    
    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
    
    
    <script type="text/javascript">
    function selectAll() {
			var items = document.getElementsByName('contact[]');
			for (var i = 0; i < items.length; i++) {
				if (items[i].type == 'checkbox')
					if(items[i].checked == false)
					{
						items[i].checked = true;
					}
					else if(items[i].checked == true)
					{
						items[i].checked = false;
					}
			}
		}



</script>
    
    
    
@endsection

    