@php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
}
@endphp
@extends($layout)

@section('content')

<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Users</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                     
                                        <a class="text-white" href="{{ route($dashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                   
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Users</a>
                                    </li>
                                </ul>
                        </div></div>
                        
                        <div class="ml-md-auto py-2 py-md-0">
                                                        
                            @if(Auth::user()->user_type == 'organization' || Auth::user()->user_type == 'organization_user')
                            <a href="{{route($fdashboard)}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <a href="{{ route('user.create')}}" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add User</a>
                            @else
                            <a href="{{route('customers.index')}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <button type="button" class="btn btn-white btn-round" data-toggle="modal" data-target="#myModal">
                               <i class="fa fa-plus"></i> Add User
                            </button>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Customer User Details.</div>
                                        @if ($errors->any())
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                            <strong>Error! </strong>There were some errors with inputs.
                                            <ul>
                                                @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                            </ul>
                                            </div>

                                        @endif
                                        @include('layouts.messages')
                                     @if(1 != 1)
                                        @include('layouts.nodata')
                                        @else
                                        <div id="vue-admin-user">
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Sur Name</th>
                                                    <th>Username</th>
                                                    <th>Other Names</th>
                                                    <th>Contact</th>
                                                    <th>Status</th>
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>Sur Name</th>
                                                <th>Username</th>
                                                <th>Other Names</th>
                                                <th>Contact</th>
                                                <th>Status</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($customerUsers as $customerUser)
                                            <tr>
                                            <td>{{ ucfirst($customerUser->cust_user_surname)}}</td>
                                            <td>{{ ucfirst($customerUser->cust_user_username)}}</td>
                                            <td>{{ ucfirst($customerUser->cust_user_othername)}}</td>
                                            <td>+254 {{ $customerUser->cust_user_contact}}</td>
                                            <td>
                                            @if($customerUser->cust_user_status == 1)
                                            <span class="badge badge-success">Active</span>
                                            @elseif($customerUser->cust_user_status == 0)
                                            <span class="badge badge-danger">Inactive</span>
                                            @endif
                                            </td>
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            @if(Auth::check())
                                            <a href="{{route('user.show',$customerUser->cust_user_id)}}" class="btn btn-success btn-sm"><i class="far fa-eye"></i></a>
                                            @else
                                            <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#myModalView-{{$customerUser->cust_user_id}}"   data-original-title="View"><i class="far fa-eye"></i> </button>
                                            
                                            @endif
                                            <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#myModalEdit-{{$customerUser->cust_user_id}}" id="show-modal"><i class="fa fa-edit"></i> </button>
                                             <button  @click.prevent="deleteItem('userdeletepath', {{$customerUser->cust_user_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>
                                            
                                            </div><!-- modal -->
                                            <div id="myModalEdit-{{$customerUser->cust_user_id}}" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Edit Customer User [{{ucfirst($customerUser->cust_user_username)}}].<strong></strong></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        
                                                    <edit_user :usersdata="{{json_encode($customerUser)}}"></edit_user>
                                                     </div>   
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /end modal start of the view modal -->

                                            <div id="myModalView-{{$customerUser->cust_user_id}}" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Customer User [{{ucfirst($customerUser->cust_user_username)}}]<strong></strong></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        
                                                    <view_user :usersdata="{{json_encode($customerUser)}}"></view_user>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /end modal -->
                                            </td>
                                            
                                            </tr>
                                            @endforeach
                                            <!-- add user modal -->
                                            <div id="myModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Add Customer User <strong></strong></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        
                                                        <add_user :cust_id="{{json_encode($id)}}"></add_user>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            </div>
                                            <!-- /end modal -->
                                            
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
            </div>
            </div>
        
    </div>
    
    @endsection