@php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
}
@endphp
@extends($layout)
@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Tariffs</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{ route($dashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>Supervise
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">B2B Tariffs</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="{{ route($dashboard)}}" class="btn btn-white btn-border btn-round mr-2">Back</a>
                            
                        </div>
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">B2B Tariffs</div>
                                        @if(!$b2btariffs->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>ID#</th>
                                                    <th>Name</th>
                                                    <th>Status</th>
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>ID#</th>
                                                <th>Name</th>
                                                <th>Status</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($b2btariffs as $tariff)
                                            <tr>
                                            <td>{{ $tariff->tariff_id }}</td>
                                            <td>{{ $tariff->tariff_name }}</td>
                                            <td>
                                                @if( $tariff->tariff_status  == 1)
                                            <span class="badge badge-success">Active</span>
                                            @elseif( $tariff->tariff_status  == 0)
                                            <span class="badge badge-danger">Inactive</span>
                                            @endif
                                            </td>
                                            <td>
                                            
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            <div class="btn-group btn-group-sm"><a href="#" class="btn btn-sm btn-info">Edit</a>
                                            </div>
                                            </td>
                                            </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
            </div>
            </div>
        </div>
    </div>
    @endsection