/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');
//import Vue from 'vue'
window.Vue = require('vue').default;

//window.Vue = require('vue');

/**
 * The following block of code may be used to automatically register your
 * Vue components. It will recursively scan this directory for the Vue
 * components and automatically register them with their "basename".
 *
 * Eg. ./components/ExampleComponent.vue -> <example-component></example-component>
 */

// const files = require.context('./', true, /\.vue$/i)
// files.keys().map(key => Vue.component(key.split('/').pop().split('.')[0], files(key).default))

// Vue.component('example-component', require('./components/ExampleComponent.vue').default);
// ====================== FFFFFFFFFF    CCCCCCCCCCCC  ================================/////
// ====================== FFF           CCC               ================================/////
// ====================== FFFFFFFFFF    CCC               ================================/////
// ====================== FFF           CCC               ================================/////
// ====================== FFF           CCCCCCCCCCCC  ================================/////
Vue.component('example-component', require('./components/fc/ExampleComponent.vue').default);
Vue.component('admin_login_component', require('./components/fc/admin/AdminLoginComponent.vue').default);
Vue.component('admincreate_component', require('./components/fc/admin/AdminUserCreateComponent.vue').default);
Vue.component('fcadminedit_component', require('./components/fc/admin/AdminUserEditComponent.vue').default);

Vue.component('org_login_component', require('./components/fc/organization/OrganizationLoginComponent.vue').default);
Vue.component('addorganization_component', require('./components/fc/organization/AddOrganizationComponent.vue').default);
Vue.component('editorganization_component', require('./components/fc/organization/EditOrganizationComponent.vue').default);


Vue.component('orguser_login_component', require('./components/fc/organization-user/OrganizationUserLoginComponent.vue').default);
Vue.component('addorganizationuser_component', require('./components/fc/organization-user/AddOrganizationUserComponent.vue').default);
Vue.component('editorganizationuser_component', require('./components/fc/organization-user/EditOrganizationUserComponent.vue').default);

Vue.component('departmentcreate_component', require('./components/fc/Department/CreateDepartmentComponent.vue').default);

Vue.component('addrole_component', require('./components/fc/role/AddRoleComponent.vue').default);
Vue.component('editrole_component', require('./components/fc/role/EditRoleComponent.vue').default);
Vue.component('inboxtagcreate_component', require('./components/fc/inboxtag/CreateInboxtagComponent.vue').default);
Vue.component('groupcreate_component', require('./components/fc/group/CreateGroupComponent.vue').default);

Vue.component('fc_contact_good_table_component', require('./components/fc/contact/ContactIndexComponent.vue').default);


Vue.component('contactcreate_component', require('./components/fc/contact/CreateContactComponent.vue').default);
Vue.component('departmentedit_component', require('./components/fc/Department/DepartmentEditComponent.vue').default);
Vue.component('groupedit_component', require('./components/fc/group/GroupEditComponent.vue').default);
Vue.component('contactsedit_component', require('./components/fc/contact/ContactsEditComponent.vue').default);
Vue.component('contactview_component', require('./components/fc/contact/ContactsViewComponent.vue').default);
Vue.component('groupView_component', require('./components/fc/group/GroupViewComponent.vue').default);

Vue.component('grouptable_component', require('./components/fc/group/IndexGroupComponent.vue').default);





Vue.component('inboxtagedit_component', require('./components/fc/inboxtag/InboxtagEditComponent.vue').default);
Vue.component('inboxtagview_component', require('./components/fc/inboxtag/InboxtagViewComponent.vue').default);

Vue.component('sendsms_component', require('./components/fc/sms/SendSMSComponent.vue').default);
Vue.component('respond_component', require('./components/fc/sms/RespondSMSComponent.vue').default);
Vue.component('sendsmsgroup_component', require('./components/fc/sms/SendSMSGroupComponent.vue').default);
Vue.component('departmentview_component', require('./components/fc/Department/DepartmentViewComponent.vue').default);

Vue.component('sendivr_component', require('./components/fc/ivr/SendIVRComponent.vue').default);
Vue.component('sendivrgroup_component', require('./components/fc/ivr/SendIVRGroupComponent.vue').default);


Vue.component('importsedit_component', require('./components/fc/import/ImportsEditComponent.vue').default);
Vue.component('importsview_component', require('./components/fc/import/ImportsViewComponent.vue').default);
Vue.component('createimport_component', require('./components/fc/import/CreateImportComponent.vue').default);

Vue.component('editivr_component', require('./components/fc/ivr/EditivrComponent.vue').default);
Vue.component('disable-ivr', require('./components/fc/ivr/DisableComponent.vue').default);
Vue.component('smstemplatecreate_component', require('./components/fc/smstemplate/CreateSmsTemplatecreateComponent.vue').default);
Vue.component('sendsmstemplatecreate_component', require('./components/fc/smstemplate/SendSmsTemplateComponent.vue').default);
Vue.component('smstemplateedit_component', require('./components/fc/smstemplate/SmstemplateeditComponent.vue').default);
Vue.component('smstemplateview_component', require('./components/fc/smstemplate/smstemplateviewComponent.vue').default);

Vue.component('disable-survey', require('./components/fc/survey/DisableComponent.vue').default);
Vue.component('create-survey', require('./components/fc/survey/AddSurveyComponent.vue').default);
Vue.component('edit-survey', require('./components/fc/survey/EditSurveyComponent.vue').default);

Vue.component('create-question', require('./components/fc/question/AddQuestionComponent.vue').default);
Vue.component('edit-question', require('./components/fc/question/EditQuestionComponent.vue').default);

Vue.component('create-option', require('./components/fc/option/AddOptionComponent.vue').default);
Vue.component('edit-option', require('./components/fc/option/EditOptionComponent.vue').default);

Vue.component('create-table', require('./components/fc/participants/CreateTableComponent.vue').default);
Vue.component('create_participant', require('./components/fc/participants/CreateParticipantComponent.vue').default);

Vue.component('create-language', require('./components/fc/language/AddLanguageComponent.vue').default);
Vue.component('edit-language', require('./components/fc/language/EditLanguageComponent.vue').default);

//Shortcode
Vue.component('createshortcodecomponent', require('./components/fc/organizationshortcodes/CreateshortcodeComponent.vue').default);
Vue.component('shortcodeedit_component', require('./components/fc/organizationshortcodes/ShortcodeEditComponent.vue').default);
Vue.component('shortcodeview_component', require('./components/fc/organizationshortcodes/ShortcodeViewComponent.vue').default);

//Custom SMS
Vue.component('customsms_component_good_table_component', require('./components/fc/customsms/CustomsmsComponent.vue').default);

// Vue.component('messages_component', require('./components/fc/customsms/MessagesComponent.vue').default);

Vue.component('messages_component', require('./components/fc/customsms/MessagesComponent.vue').default);


//Schedule
Vue.component('schedulesms_component', require('./components/fc/sms/ScheduleSMSComponent.vue').default);
Vue.component('schedulesmsgroup_component', require('./components/fc/sms/ScheduleSMSGroupComponent.vue').default);

// ====================== BBBBBBBBBBB    MMM    MMM  ================================/////
// ====================== BBB     BBB    MM M  M MM           ================================/////
// ====================== BBBBBBBBBB     MM  M   MM         ================================/////
// ====================== BBB     BBB    MM      MM         ================================/////
// ====================== BBBBBBBBBBB    MM      MM  ================================/////
Vue.component('admin_login_component', require('./components/bm/admin/AdminLoginComponent.vue').default);
Vue.component('admin_component', require('./components/bm/admin/AdminUserCreateComponent.vue').default);
Vue.component('adminedit_component', require('./components/bm/admin/AdminUserEditComponent.vue').default);
Vue.component('adminstats_component', require('./components/bm/admin/AdminStatisticsComponent.vue').default);
Vue.component('custstats_component', require('./components/bm/customer/CustomerStatisticsComponent.vue').default);
Vue.component('wallet_topup', require('./components/bm/wallet/WalletTopupComponent.vue').default);
Vue.component('add_customer', require('./components/bm/customer/AddCustomerComponent.vue').default);
Vue.component('edit_customer', require('./components/bm/customer/EditCustomerComponent.vue').default);
Vue.component('edit_client', require('./components/bm/client/ClientEditComponent.vue').default);
Vue.component('client_component', require('./components/bm/client/ClientUserCreateComponent.vue').default);
Vue.component('import_client', require('./components/bm/client/ClientImportComponent.vue').default);
Vue.component('add_client_group', require('./components/bm/clientgroup/AddClientGroupComponent.vue').default);
Vue.component('edit_client_group', require('./components/bm/clientgroup/EditClientGroupComponent.vue').default);
Vue.component('pay_client', require('./components/bm/payment/PayClientComponent.vue').default);
Vue.component('pay_business', require('./components/bm/payment/PayBusinessComponent.vue').default);
Vue.component('edit_pay_client', require('./components/bm/payment/EditPayClientComponent.vue').default);
Vue.component('pay_group', require('./components/bm/payment/PayGroupComponent.vue').default);
Vue.component('edit_batch', require('./components/bm/payment/EditBatchComponent.vue').default);
Vue.component('add_batch', require('./components/bm/payment/AddBatchComponent.vue').default);
Vue.component('add_group', require('./components/bm/group/AddGroupComponent.vue').default);
Vue.component('edit_group', require('./components/bm/group/EditGroupComponent.vue').default);
Vue.component('add_user', require('./components/bm/shared/AddUserComponent.vue').default);
Vue.component('edit_user', require('./components/bm/shared/EditUserComponent.vue').default);
Vue.component('edit_user_profile', require('./components/bm/shared/EditUserProfileComponent.vue').default);

Vue.component('view_user', require('./components/bm/shared/ViewUserComponent.vue').default);
Vue.component('customer_login_component', require('./components/bm/customer/CustomerLoginComponent.vue').default);
Vue.component('customer_otp_component', require('./components/bm/customer/CustomerOtpComponent.vue').default);
Vue.component('customer_user_login_component', require('./components/bm/customer_user/CustomerUserLoginComponent.vue').default);
Vue.component('userotpcomponent', require('./components/bm/customer_user/CustomerUserOtpComponent.vue').default);



// ====================== BBBBBBBBBBB    MMM    MMM  ================================/////
// ====================== BBB     BBB    MM M  M MM           ================================/////
// ====================== BBBBBBBBBB     MM  M   MM         ================================/////
// ====================== BBB     BBB    MM      MM         ================================/////
// ====================== BBBBBBBBBBB    MM      MM  ================================/////

Vue.component('customerusercreate_component', require('./components/at/customer_user/CustomerUserComponent.vue').default);
Vue.component('customeruseredit_component', require('./components/at/customer_user/CustomerUserEditComponent.vue').default);
Vue.component('customeruserview_component', require('./components/at/customer_user/CustomerUserViewComponent.vue').default);


// ======================   BBBBB      MMMMMMMMM    ==============================/////
// ======================  BBB  BBB    MMMMMMMMM           ================================/////
// ====================== BBBBBBBBBB      MM          ================================/////
// ===================== BBB      BBB     MM          ================================/////
// ==================== BBB        BBB    MM          ================================/////
Vue.component('atgroupcreate_component', require('./components/at/group/CreateGroupComponent.vue').default);
Vue.component('atgroupedit_component', require('./components/at/group/GroupEditComponent.vue').default);

Vue.component('atcontactcreate_component', require('./components/at/contact/CreateContactComponent.vue').default);
Vue.component('atcontactsedit_component', require('./components/at/contact/ContactsEditComponent.vue').default);

Vue.component('topupgroupbundles_component', require('./components/at/topupbandles/TopupGroupBundlesComponent.vue').default);
Vue.component('topupallcontact_bundles_component', require('./components/at/topupbandles/TopupAllContactBundlesComponent.vue').default);
Vue.component('topupcontact_bundles_component', require('./components/at/topupbandles/TopupContactBundlesComponent.vue').default);
Vue.component('topupmyline_budles_component', require('./components/at/topupbandles/TopupMyLineBudlesComponent.vue').default);

Vue.component('topupgroup_component', require('./components/at/topup/TopupGroupComponent.vue').default);
Vue.component('topupcontact_component', require('./components/at/topup/TopupContactComponent.vue').default);
Vue.component('topupallcontact_component', require('./components/at/topup/TopupAllContactComponent.vue').default);
Vue.component('topupmyline_component', require('./components/at/topup/TopupMyLineComponent.vue').default);
Vue.component('customeruserchangepassword_component', require('./components/at/customer_user/CustomerUserChangePasswordComponent.vue').default);




//test component
Vue.component('good_table_component', require('./components/at/contact/ContactIndexComponent.vue').default);
Vue.component('groups_good_table_component', require('./components/at/group/GroupsIndexComponent.vue').default);

Vue.component('pagination', require('laravel-vue-pagination'));


/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */
import DeleteMixin from './components/fc/shared/DeleteMixin';
import DeleteMixin2 from './components/bm/shared/DeleteMixin';
import DeleteMixin3 from './components/at/shared/DeleteMixin';

new Vue({
    el: '#app',
    mixins: [ DeleteMixin, DeleteMixin3 ],
});


new Vue({
    el: '#vue-admin-user',
    mixins: [ DeleteMixin2 ],
});
