<?php

namespace App\Models\bmmodels;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Notifications\UserResetPasswordNotification;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerUser extends Authenticatable
{
    
    use Notifiable;
    use SoftDeletes;
    protected $connection = 'mysql_bmp';
    //
    protected $table = 'customer_users';
    protected $primaryKey = 'cust_user_id';
    protected $fillable = [
        'cust_user_id',
        'cust_user_surname',
        'cust_user_othername',
        'cust_user_contact',
        'email',
        'cust_user_username',
        'password',
        'cust_user_status',
        'cust_user_first_time',
        'customer_cust_id',
        'cust_otp_status',
        'role_id',
        'get_sms',
        'get_email',
    ];
   
   
    protected $hidden = [
        'password', 'remember_token',
    ];
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new UserResetPasswordNotification($token));
    }
    //user customer relationship
    public function UserCustomer()
    {
        return $this->belongsTo(Customer::class, 'customer_cust_id','cust_id');
    }
    //user Auth relationship
    public function UserAuths()
    {
        return $this->hasMany(CustomerAuth::class, 'customer_user_cust_user_id');
    }
}
