<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'username','password','cust_id','user_type','shop_id','email','api_account','bulk_cust_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    ///add atgtributes to Auth
    public function getApiAccountAttribute() 
    {
        // Check if api_account exists in session
        if(session()->has('api_account')) {
            // If so return api_account
            return session('api_account');
        }
    
        // If session did not have the api_account
        $api_account = $this->shop_id;
        if($api_account == '')
        {
            if($this->cust_id)
            {
                $api_account=$this->userOrg->api_account;
            }
        }
    
        // Save it to session
        session(['api_account' => $api_account]);
    
        // Return first name
        return $api_account;
    }
    //add namee atrib
    public function getNameAttribute() 
    {
        // Check if api_account exists in session
        if(session()->has('name')) {
            // If so return api_account
            return session('name');
        }
    
        // If session did not have the name
    
        // Get the name from related model
        $name = $this->userOrg->name;
    
        // Save it to session
        session(['name' => $name]);
    
        // Return name
        return $name;
    }
    //org id
    public function getOrganizationIdAttribute() 
    {
        // Check if api_account exists in session
        if(session()->has('organization_id')) {
            // If so return api_account
            return session('organization_id');
        }
    
        // If session did not have the name
    
        // Get the name from related model
        $organization_id = $this->cust_id;
    
        // Save it to session
        session(['organization_id' => $organization_id]);
    
        // Return name
        return $organization_id;
    }
    //user id
    public function getUserIdAttribute() 
    {
        // Check if api_account exists in session
        if(session()->has('user_id')) {
            // If so return api_account
            return session('user_id');
        }
    
        // If session did not have the name
    
        // Get the name from related model
        $user_id = $this->userOrgUser->user_id;
    
        // Save it to session
        session(['user_id' => $user_id]);
    
        // Return name
        return $user_id;
    }
    
    //get user role
    public function getUserRoleAttribute() 
    {
        // Check if api_account exists in session
        if(session()->has('userRole')) {
            // If so return api_account
            return session('userRole');
        }
    
        // If session did not have the name
    
        // Get the name from related model
        $userRole = $this->userOrgUser->userRole;
    
        // Save it to session
        session(['userRole' => $userRole]);
    
        // Return name
        return $userRole;
    }
    /////////////////FC Relations///////////////
    public function userOrg()
    {
        return $this->belongsTo(fcmodels\Organization::class,'cust_id','organization_id');
    }
    public function userOrgUser()
    {
        // return fcmodels\OrganizationUser::where('email',$this->email)->where('organization_id',$this->cust_id)->get();
        return $this->belongsTo(fcmodels\OrganizationUser::class, 'email','email')->where('organization_id',$this->cust_id);
    }
    ///////BMBMBMBMBMBMBMBMB////////
    //add cust_name atrib
    public function getCustNameAttribute() 
    {
        // Check if cust_name exists in session
        if(session()->has('cust_name')) {
            // If so return cust_name
            return session('cust_name');
        }
    
        // If session did not have the name
        if($this->bulk_cust_id) {
            // Get the name from related model
            $cust_name = $this->userCustomer->cust_name;
        
            // Save it to session
            session(['cust_name' => $cust_name]);
        
            // Return name
            return $cust_name;
        }
    }
    
        //add cust_status atrib
    public function getCustStatusAttribute() 
    {
        // Check if cust_status exists in session
        if(session()->has('cust_status')) {
            // If so return cust_status
            return session('cust_status');
        }
    
        if($this->bulk_cust_id) {
            // If session did not have the cust_status
        
            // Get the name from related model
            $cust_status = $this->userCustomer->cust_status;
        
            // Save it to session
            session(['cust_status' => $cust_status]);
        
            // Return name
            return $cust_status;
        }
    }
    // add cust_otp_status
    public function getCustOtpStatusAttribute() 
    {
        // Check if cust_otp_status exists in session
        // if(session()->has('cust_otp_status')) {
        //     // If so return cust_otp_status
        //     return session('cust_otp_status');
        // }
        if($this->bulk_cust_id) {
            // If session did not have the cust_otp_status
        
            // Get the cust_otp_status from related model
            if($this->user_type == 'organization')
            {
                $cust_otp_status = $this->userCustomer->cust_otp_status;
            } else if($this->user_type == 'organization_user') {
            $cust_otp_status = $this->userBmUser->cust_otp_status;
            }
        
            // Save it to session
            session(['cust_otp_status' => $cust_otp_status]);
        
            // Return name
            return $cust_otp_status;
        }
    }
        // add cust_first_time
    public function getCustFirstTimeAttribute() 
    {
        // Check if cust_first_time exists in session
        if(session()->has('cust_first_time')) {
            // If so return cust_first_time
            return session('cust_first_time');
        }
    
        if($this->bulk_cust_id) {
            // If session did not have the cust_first_time
        
            // Get the cust_first_time from related model
            $cust_first_time = $this->userCustomer->cust_first_time;
        
            // Save it to session
            session(['cust_first_time' => $cust_first_time]);
        
            // Return name
            return $cust_first_time;
        }
    }
    // add cust_user_id
    public function getCustUserIdAttribute() 
    {
        // Check if cust_user_id exists in session
        if(session()->has('cust_user_id')) {
            // If so return cust_user_id
            return session('cust_user_id');
        }
        if($this->bulk_cust_id) {
    
            // If session did not have the cust_user_id
        
            // Get the cust_first_time from related model
            $cust_user_id = $this->userBmUser->cust_user_id;
        
            // Save it to session
            session(['cust_user_id' => $cust_user_id]);
        
            // Return name
            return $cust_user_id;
        }
    }
    //    // add cust_user_surname
    public function getCustUserSurnameAttribute() 
    {
        // Check if cust_user_surname exists in session
        if(session()->has('cust_user_surname')) {
            // If so return cust_user_surname
            return session('cust_user_surname');
        }
        if($this->bulk_cust_id) {
            // If session did not have the cust_user_surname
        
            // Get the cust_first_time from related model
            $cust_user_surname = $this->userBmUser->cust_user_surname;
        
            // Save it to session
            session(['cust_user_surname' => $cust_user_surname]);
        
            // Return name
            return $cust_user_surname;
        }
    }
    //    // add cust_user_username
    public function getCustUserUsernameAttribute() 
    {
        // Check if cust_user_username exists in session
        if(session()->has('cust_user_username')) {
            // If so return cust_user_username
            return session('cust_user_username');
        }
        if($this->bulk_cust_id) {
            // If session did not have the cust_user_username
        
            // Get the cust_first_time from related model
            $cust_user_username = $this->userBmUser->cust_user_username;
        
            // Save it to session
            session(['cust_user_username' => $cust_user_username]);
        
            // Return name
            return $cust_user_username;
        }
    }
        //    // add cust_user_contact
    public function getCustUserContactAttribute() 
    {
        // Check if cust_user_contact exists in session
        if(session()->has('cust_user_contact')) {
            // If so return cust_user_contact
            return session('cust_user_contact');
        }
    
        // If session did not have the cust_user_contact
        if($this->bulk_cust_id) {
            // Get the cust_user_contact from related model
            $cust_user_contact = $this->userBmUser->cust_user_contact;
        
            // Save it to session
            session(['cust_user_contact' => $cust_user_contact]);
        
            // Return name
            return $cust_user_contact;
        }
    }
    //    // add cust_primary_contact_type
    public function getCustPrimaryContactTypeAttribute() 
    {
        // Check if cust_primary_contact_type exists in session
        if(session()->has('cust_primary_contact_type')) {
            // If so return cust_primary_contact_type
            return session('cust_primary_contact_type');
        }
    
        // If session did not have the cust_primary_contact_type
        if($this->bulk_cust_id) {
            // Get the cust_user_contact from related model
            $cust_primary_contact_type = $this->userCustomer->cust_primary_contact_type;
        
            // Save it to session
            session(['cust_primary_contact_type' => $cust_primary_contact_type]);
        
            // Return name
            return $cust_primary_contact_type;
        }
    }
    //    // add get_sms 
    public function getGetSmsAttribute() 
    {
        // Check if get_sms exists in session
        if(session()->has('get_sms')) {
            // If so return get_sms
            return session('get_sms');
        }
    
        // If session did not have the get_sms
        if($this->bulk_cust_id) {
            // Get the get_sms from related model
            
            if($this->user_type == 'organization_user')
            {
                $get_sms = $this->userBmUser->get_sms;
            }
            elseif($this->user_type == 'organization')
            {
                $get_sms = $this->userCustomer->get_sms;
            }
        
        
            // Save it to session
            session(['get_sms' => $get_sms]);
        
            // Return name
            return $get_sms;
        }
    }
    //    // add get_email 
    public function getGetEmailAttribute() 
    {
        // Check if get_email exists in session
        if(session()->has('get_email')) {
            // If so return get_email
            return session('get_email');
        }
    
        // If session did not have the get_email
        if($this->bulk_cust_id) {
            // Get the get_email from related model
            if($this->user_type == 'organization_user')
            {
                $get_email = $this->userBmUser->get_email;
            }
            elseif($this->user_type == 'organization')
            {
                $get_email = $this->userCustomer->get_email;
            }
        
            // Save it to session
            session(['get_email' => $get_email]);
        
            // Return name
            return $get_email;
        }
    }
    // add cust_user_status
    public function getCustUserStatusAttribute() 
    {
        // Check if cust_user_status exists in session
        if(session()->has('cust_user_status')) {
            // If so return cust_user_status
            return session('cust_user_status');
        }
    
        // If session did not have the cust_user_status
        if($this->bulk_cust_id) {
            // Get the cust_first_time from related model
            $cust_user_status = $this->userBmUser->cust_user_status;
        
            // Save it to session
            session(['cust_user_status' => $cust_user_status]);
        
            // Return name
            return $cust_user_status;
        }
    }
    //add customer_cust_id
    public function getCustomerCustIdAttribute() 
    {
        // Check if customer_cust_id exists in session
        if(session()->has('customer_cust_id')) {
            // If so return customer_cust_id
            return session('customer_cust_id');
        }
        // If session did not have the customer_cust_id chack bulk_cust_id
        if($this->bulk_cust_id) {
            // Get the customer_cust_id from bulk_cust_id
            $customer_cust_id = $this->bulk_cust_id;
        
            // Save it to session
            session(['customer_cust_id' => $customer_cust_id]);
        
            // Return name
            return $customer_cust_id;
        }
        // return $this->bulk_cust_id;
    }
    public function getShopNameAttribute() 
    {
        // Check if shop_name exists in session
        if(session()->has('shop_name')) {
            // If so return shop_name
            return session('shop_name');
        }
        // If session did not have the shop_name chack bulk_cust_id
        if($this->shop_id) {
            // Get the shop_name from bulk_cust_id
            $shop_name = $this->userShopCustomer['Name'];
        
            // Save it to session
            session(['shop_name' => $shop_name]);
        
            // Return name
            return $shop_name;
        }
        // return $this->bulk_cust_id;
    }
    
    //account BM relations
    public function userCustomer()
    {
        return $this->belongsTo(bmmodels\Customer::class, 'bulk_cust_id','cust_id');
        
    }
    public function userBmUser()
    {
        return $this->belongsTo(bmmodels\CustomerUser::class, 'email','email')->where('customer_cust_id',$this->bulk_cust_id);
    }
    //account Temp relations
    public function userShopCustomer()
    {
        return $this->belongsTo(atmodels\Shop::class, 'shop_id','ShopID');
        
    }
    public function userShopUser()
    {
        return $this->belongsTo(atmodels\Airtime_customer::class, 'email','email');
    }
}
