<?php

namespace App\Libs;
use Log;

use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Client;

class Mobisky{

    protected $username;
    protected $password;
    protected $uri='http://www.mobisky.biz/api/sendsms2a.php?'; 
    protected $client;
    protected $response;


    public function __construct($username_, $password_)
    {
    $this->username = $username_;
    $this->password  = $password_;
    $this->client=null;
    $this->response=null;

    }
    /**
         * Use this function to initiate send sms.
         * @param $phone | string
         * @param $message | string
         * @return mixed|string
         */

    public function sendMessage($phone,$message){
        $parameters=[
            'username'=>$this->username,
            'password'=>$this->password,
            'destination'=>$phone,
            'message'=>$message,
        ];
        //create a guzzleclient
        $this->client=new Client();
        //send the message
        $this->response=$this->client->request('GET',$this->uri.http_build_query($parameters));
        $body= $this->response->getBody();
        if (strpos($body, 'Success') !== false) {
            return response()->json("sms_sent");
        }
        else{
            Log::info("failed body:".$body);
            return response()->json("sms_failed");
        }


    }
    public function codeGenerator($length)
    {
        $code = '';
        $codes = array_merge(range(0, 9), range('A', 'Z'));

        for ($i = 0; $i < $length; $i++) {
            $code .= $codes[array_rand($codes)];
            //hash the array code and substring of the first 6 characters
        }
        return $code;
    }

}