<?php

namespace App\Imports\FCImports;

use App\Models\fcmodels\Contact;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
//batch inserts do not rollback all but the batch that failed 
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithValidation;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Log;
use DB;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class Participant implements ToCollection
{
    use Importable;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    //get cust id
    protected $id;
   

    public function __construct($dbtable) {
        $this->dbtable = $dbtable;
    }
    
    public function collection(Collection $rows)
    {
          Validator::make($rows->toArray(), [
             '*.0' => 'required',
         ])->validate();
         
        try
        {
            $dbtable = $this->dbtable;
            //get excel columns
            $tablecolumns=$rows[0];
            
            $cols=$tablecolumns->toArray();            
            
            //other excel data
            $exceldata=array_slice($rows->toArray(),1);
            
            $item = [];
            //generate ID
            $getvars = explode('_',$dbtable);
            $survey_id=$getvars[2];
            $org_id=$getvars[1];
            $finalID=DB::select("SELECT MAX(id) AS participant_id from $dbtable");
                            
            $finalid=$finalID[0]->participant_id;
            if($finalid == null)
            {
                $addone = 0;
            }
            else
            {
                $pid = explode('_',$finalid);
                $addone = $pid[2];
                
            }
            foreach($exceldata as $data){
              $id = $org_id.'_'.$survey_id.'_'.++$addone;
              $myid = ['id' => $id ];
              $combine = array_merge($myid,array_combine($cols,$data));
              array_push($item,$combine);
              
            }
              $insert = DB::table($this->dbtable)->insert($item);
              return redirect()->back()->with('success', 'Participants Uploaded succesfully!');   
        
            
        }
        catch (\Maatwebsite\Excel\Validators\ValidationException $e) {
            $failures = $e->failures();
            
            foreach ($failures as $failure) {
                $failure->row(); // row that went wrong
                $failure->attribute(); // heading row
                $failure->errors(); // Actual error messages from Laravel validator
                $failure->values(); // The values of the row that has failed.
            }
        }
        
        
    }
    
   
}
    