<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use Auth;
use Hash;
use App\Models\fcmodels\Shop;
use App\Models\fcmodels\ApiTopup;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\AuditLog;
use Exception;
use EloquentBuilder;

class TransactionController extends Controller
{
   
    public function index()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
      $wallet = Wallet::where('shopid',$api_account)->pluck('amount');   

        //fetch all trans
        $account=Shop::where('ShopID',$api_account)->pluck('mpesa_account_name');
        //$trans = ApiTopup::where('BillRefNumber',$account)->get();
        
        $query =ApiTopup::where('BillRefNumber',$account);
        $trans=EloquentBuilder::to($query,request()->all())->get();
        
        
        return view('fcviews.transactions.index', compact('trans','wallet'));


    }
    public function topup()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
      $wallet = Wallet::where('shopid',$api_account)->pluck('amount');

        //fetch all trans
        $account=Shop::where('ShopID',$api_account)->pluck('mpesa_account_name');
        // $trans = ApiTopup::where('BillRefNumber',$account)->get();
        return view('fcviews.transactions.topup', compact('account','wallet'));


    }

}

